/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.core.fileIndex.DependencyDescription;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.SourceRootFileIndexContributor;
import com.intellij.workspaceModel.ide.VirtualFileUrls;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.SourceRootTypeRegistry;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ExtensionsKt;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaResourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaSourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R \u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/SourceRootFileIndexContributor;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/SourceRootEntity;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PlatformInternalWorkspaceFileIndexContributor;", "()V", "dependenciesOnOtherEntities", "", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription;", "getDependenciesOnOtherEntities", "()Ljava/util/List;", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "registerFileSets", "", "entity", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "intellij.platform.projectModel.impl"})
public final class SourceRootFileIndexContributor
implements WorkspaceFileIndexContributor<SourceRootEntity>,
PlatformInternalWorkspaceFileIndexContributor {
    @Override
    @NotNull
    public Class<SourceRootEntity> getEntityClass() {
        return SourceRootEntity.class;
    }

    @Override
    public void registerFileSets(@NotNull SourceRootEntity entity, @NotNull WorkspaceFileSetRegistrar registrar, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        ModuleBridge module2 = ModuleEntityUtils.findModule(entity.getContentRoot().getModule(), storage);
        if (module2 != null) {
            VirtualFile contentRoot = VirtualFileUrls.getVirtualFile(entity.getContentRoot().getUrl());
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = SourceRootTypeRegistry.Companion.getInstance().findTypeById(entity.getRootType());
            WorkspaceFileKind kind = (jpsModuleSourceRootType != null ? jpsModuleSourceRootType.isForTests() : false) ? WorkspaceFileKind.TEST_CONTENT : WorkspaceFileKind.CONTENT;
            JavaSourceRootPropertiesEntity javaProperties = ExtensionsKt.asJavaSourceRoot((SourceRootEntity)entity);
            JavaResourceRootPropertiesEntity resourceProperties = ExtensionsKt.asJavaResourceRoot((SourceRootEntity)entity);
            Object object = javaProperties;
            if (object == null || (object = object.getPackagePrefix()) == null) {
                Object object2 = resourceProperties;
                object = object2 != null && (object2 = object2.getRelativeOutputPath()) != null ? StringsKt.replace$default((String)object2, (char)'/', (char)'.', (boolean)false, (int)4, null) : "";
            }
            Object packagePrefix = object;
            boolean forGeneratedSources = javaProperties != null && javaProperties.getGenerated() || resourceProperties != null && resourceProperties.getGenerated();
            registrar.registerFileSet(entity.getUrl(), kind, (WorkspaceEntity)entity, (WorkspaceFileSetData)new ModuleSourceRootData(module2, contentRoot, entity.getRootType(), (String)packagePrefix, forGeneratedSources));
            registrar.registerExclusionPatterns(entity.getUrl(), entity.getContentRoot().getExcludedPatterns(), (WorkspaceEntity)entity);
        }
    }

    @Override
    @NotNull
    public List<DependencyDescription<SourceRootEntity>> getDependenciesOnOtherEntities() {
        Object[] objectArray = new DependencyDescription[]{new DependencyDescription.OnParent(ContentRootEntity.class, dependenciesOnOtherEntities.1.INSTANCE), new DependencyDescription.OnChild(JavaSourceRootPropertiesEntity.class, dependenciesOnOtherEntities.2.INSTANCE), new DependencyDescription.OnChild(JavaResourceRootPropertiesEntity.class, dependenciesOnOtherEntities.3.INSTANCE)};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

