/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.core.fileIndex.impl.EntityChangeStorage;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistry;
import com.intellij.workspaceModel.core.fileIndex.impl.VfsChangeApplier;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexData;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.GlobalLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.GlobalLibraryTableBridge;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplierImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplier;", "entityChanges", "Lcom/intellij/workspaceModel/core/fileIndex/impl/EntityChangeStorage;", "indexData", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "nonExistingRootsRegistry", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/workspaceModel/core/fileIndex/impl/EntityChangeStorage;Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;Lcom/intellij/openapi/project/Project;)V", "entitiesToReindex", "", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "getEntitiesToReindex", "()Ljava/util/List;", "afterVfsChange", "", "beforeVfsChange", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nNonExistingWorkspaceRootsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonExistingWorkspaceRootsRegistry.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplierImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n1855#2,2:287\n1855#2,2:289\n*S KotlinDebug\n*F\n+ 1 NonExistingWorkspaceRootsRegistry.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplierImpl\n*L\n188#1:287,2\n198#1:289,2\n*E\n"})
final class VfsChangeApplierImpl
implements VfsChangeApplier {
    @NotNull
    private final EntityChangeStorage entityChanges;
    @NotNull
    private final WorkspaceFileIndexData indexData;
    @NotNull
    private final NonExistingWorkspaceRootsRegistry nonExistingRootsRegistry;
    @NotNull
    private final Project project;

    public VfsChangeApplierImpl(@NotNull EntityChangeStorage entityChanges, @NotNull WorkspaceFileIndexData indexData, @NotNull NonExistingWorkspaceRootsRegistry nonExistingRootsRegistry, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)entityChanges, (String)"entityChanges");
        Intrinsics.checkNotNullParameter((Object)indexData, (String)"indexData");
        Intrinsics.checkNotNullParameter((Object)nonExistingRootsRegistry, (String)"nonExistingRootsRegistry");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.entityChanges = entityChanges;
        this.indexData = indexData;
        this.nonExistingRootsRegistry = nonExistingRootsRegistry;
        this.project = project2;
    }

    @Override
    public void beforeVfsChange() {
        this.indexData.markDirty((Collection<? extends EntityReference<? extends WorkspaceEntity>>)this.entityChanges.getAffectedEntities(), (Collection<? extends VirtualFile>)this.entityChanges.getFilesToInvalidate());
    }

    @Override
    public void afterVfsChange() {
        Set<EntityReference<WorkspaceEntity>> affectedEntities = this.entityChanges.getAffectedEntities();
        this.indexData.markDirty((Collection<? extends EntityReference<? extends WorkspaceEntity>>)affectedEntities, (Collection<? extends VirtualFile>)this.entityChanges.getFilesToInvalidate());
        Iterable $this$forEach$iv = this.entityChanges.getUrlsToCleanUp();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFileUrl it = (VirtualFileUrl)element$iv;
            boolean bl = false;
            this.nonExistingRootsRegistry.removeUrl(it);
        }
        this.indexData.updateDirtyEntities();
        if (GlobalLibraryTableBridge.Companion.isEnabled() && !((Collection)affectedEntities).isEmpty()) {
            EntityStorageSnapshot entityStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
            GlobalLibraryTableBridge globalLibraryTableBridge = GlobalLibraryTableBridge.Companion.getInstance();
            Intrinsics.checkNotNull((Object)globalLibraryTableBridge, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.library.GlobalLibraryTableBridgeImpl");
            GlobalLibraryTableBridgeImpl globalLibraryTableBridge2 = (GlobalLibraryTableBridgeImpl)globalLibraryTableBridge;
            Iterable $this$forEach$iv2 = affectedEntities;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                LibraryEntity libraryEntity;
                EntityReference entityRef = (EntityReference)element$iv;
                boolean bl = false;
                WorkspaceEntity workspaceEntity = entityRef.resolve((EntityStorage)entityStorage);
                LibraryEntity libraryEntity2 = workspaceEntity instanceof LibraryEntity ? (LibraryEntity)workspaceEntity : null;
                if (libraryEntity2 == null || !Intrinsics.areEqual((Object)(libraryEntity = libraryEntity2).getTableId().getLevel(), (Object)"application")) continue;
                globalLibraryTableBridge2.fireRootSetChanged(libraryEntity, (EntityStorage)entityStorage);
            }
        }
    }

    @Override
    @NotNull
    public List<EntityReference<WorkspaceEntity>> getEntitiesToReindex() {
        return this.entityChanges.getEntitiesToReindex();
    }
}

