/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PackageDirectoryCacheImpl;
import com.intellij.openapi.roots.impl.RootFileSupplier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.workspaceModel.core.fileIndex.DependencyDescription;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.DummyWorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ExcludedFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.JvmPackageRootDataInternal;
import com.intellij.workspaceModel.core.fileIndex.impl.LibrariesAndSdkContributors;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleWorkspaceFileSetsImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistry;
import com.intellij.workspaceModel.core.fileIndex.impl.NonIncrementalContributors;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.VfsChangeApplier;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl$collectEntitiesWithChangedParent$;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImplKt;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetVisitor;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetsKt;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002{|B'\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u00100\u001a\u0004\u0018\u0001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0003H\u0016J\b\u00104\u001a\u000205H\u0016Jh\u00106\u001a\u000205\"\b\b\u0000\u00107*\u00020\r\"\b\b\u0001\u00108*\u00020\r2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u0002H80:2\u0006\u0010;\u001a\u00020<2\u0016\u0010=\u001a\u0012\u0012\u0004\u0012\u0002H70>j\b\u0012\u0004\u0012\u0002H7`?2\u0016\u0010@\u001a\u0012\u0012\u0004\u0012\u0002H70>j\b\u0012\u0004\u0012\u0002H7`?H\u0002JT\u0010A\u001a\u000205\"\b\b\u0000\u00107*\u00020\r\"\b\b\u0001\u0010B*\u00020\r2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u0002HB0C2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H70D2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H70DH\u0002J\b\u0010E\u001a\u000205H\u0002J \u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020\u001f2\u000e\u0010H\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160IH\u0002J6\u0010J\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H70\u00040\u0003\"\b\b\u0000\u00107*\u00020\r2\u000e\u0010K\u001a\n\u0012\u0006\b\u0001\u0012\u0002H70\u000f2\u0006\u0010L\u001a\u00020MH\u0002J\u001e\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00160O2\u0006\u0010G\u001a\u00020\u001f2\u0006\u0010P\u001a\u00020'H\u0016J0\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u00162\u0006\u0010T\u001a\u00020'2\u0006\u0010U\u001a\u00020'2\u0006\u0010V\u001a\u00020'2\u0006\u0010W\u001a\u00020'H\u0016J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\u0006\u0010[\u001a\u00020\\H\u0016J\u0012\u0010]\u001a\u0004\u0018\u00010\u001f2\u0006\u0010^\u001a\u00020\u0016H\u0016J\u0018\u0010_\u001a\u00020'2\u0006\u0010^\u001a\u00020\u00162\u0006\u0010G\u001a\u00020\u001fH\u0002J*\u0010`\u001a\u0002052\u0012\u0010a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00130b2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00160bH\u0016J\u0018\u0010d\u001a\u0002052\u0006\u0010;\u001a\u00020<2\u0006\u0010L\u001a\u00020MH\u0016J\b\u0010e\u001a\u000205H\u0016J0\u0010f\u001a\u000205\"\b\b\u0000\u00107*\u00020\r2\f\u0010g\u001a\b\u0012\u0004\u0012\u0002H70\u00042\u0006\u0010L\u001a\u00020M2\u0006\u0010;\u001a\u00020<H\u0002J\"\u0010h\u001a\u0002052\u0006\u0010i\u001a\u00020\u00162\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020l\u0012\u0004\u0012\u0002050kJ\u0010\u0010m\u001a\u0002052\u0006\u0010L\u001a\u00020MH\u0002JG\u0010n\u001a\u000205\"\b\b\u0000\u00107*\u00020\r2\u0006\u0010o\u001a\u0002H72\u000e\u0010K\u001a\n\u0012\u0006\b\u0001\u0012\u0002H70\u000f2\u0006\u0010p\u001a\u00020q2\u0006\u0010L\u001a\u00020M2\u0006\u0010r\u001a\u00020sH\u0002\u00a2\u0006\u0002\u0010tJ\b\u0010u\u001a\u000205H\u0016J\b\u0010v\u001a\u000205H\u0016J\b\u0010w\u001a\u000205H\u0016J\u0010\u0010x\u001a\u0002052\u0006\u0010y\u001a\u00020zH\u0016R,\u0010\n\u001a \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000e\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0010\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00130\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0012j\b\u0012\u0004\u0012\u00020\u0016`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u001bj\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001e\u001a$\u0012\u0004\u0012\u00020\u001f\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0013\u0012\u0004\u0012\u00020!0 0\u001bj\u0002`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "contributorList", "", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "project", "Lcom/intellij/openapi/project/Project;", "rootFileSupplier", "Lcom/intellij/openapi/roots/impl/RootFileSupplier;", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/impl/RootFileSupplier;)V", "contributorDependencies", "", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "contributors", "Ljava/lang/Class;", "contributorsForUnloaded", "dirtyEntities", "Ljava/util/HashSet;", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lkotlin/collections/HashSet;", "dirtyFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileIdWithoutFileSets", "Lcom/intellij/util/containers/ConcurrentBitSet;", "Lorg/jetbrains/annotations/NotNull;", "fileSets", "Ljava/util/HashMap;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "Lkotlin/collections/HashMap;", "fileSetsByPackagePrefix", "", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PackagePrefixStorage;", "fileTypeRegistry", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry;", "kotlin.jvm.PlatformType", "hasDirtyEntities", "", "librariesAndSdkContributors", "Lcom/intellij/workspaceModel/core/fileIndex/impl/LibrariesAndSdkContributors;", "nonExistingFilesRegistry", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "nonIncrementalContributors", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors;", "packageDirectoryCache", "Lcom/intellij/openapi/roots/impl/PackageDirectoryCacheImpl;", "analyzeVfsChanges", "Lcom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplier;", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "clearPackageDirectoryCache", "", "collectEntitiesWithChangedChild", "E", "C", "dependency", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription$OnChild;", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "removedEntities", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "addedEntities", "collectEntitiesWithChangedParent", "P", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription$OnParent;", "", "ensureIsUpToDate", "fillPackageDirectories", "packageName", "result", "", "getContributors", "entityClass", "storageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "getDirectoriesByPackageName", "Lcom/intellij/util/Query;", "includeLibrarySources", "getFileInfo", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileInternalInfo;", "file", "honorExclusion", "includeContentSets", "includeExternalSets", "includeExternalSourceSets", "getNonExistentFileSetKinds", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingFileSetKind;", "url", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "getPackageName", "dir", "isPackageDirectory", "markDirty", "entityReferences", "", "filesToInvalidate", "onEntitiesChanged", "onLowMemory", "processChangesByContributor", "contributor", "processFileSets", "virtualFile", "action", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSet;", "registerAllEntities", "registerFileSets", "entity", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Ljava/lang/Class;Lcom/intellij/workspaceModel/storage/EntityStorage;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;)V", "resetCustomContributors", "resetFileCache", "updateDirtyEntities", "visitFileSets", "visitor", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetVisitor;", "RemoveFileSetsRegistrarImpl", "StoreFileSetsRegistrarImpl", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFileIndexDataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFileIndexDataImpl.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,495:1\n766#2:496\n857#2,2:497\n1477#2:499\n1502#2,3:500\n1505#2,3:510\n766#2:513\n857#2,2:514\n1477#2:516\n1502#2,3:517\n1505#2,3:527\n1271#2,2:530\n1285#2,4:532\n1855#2:536\n1856#2:539\n1855#2,2:540\n766#2:548\n857#2,2:549\n1855#2,2:551\n1855#2,2:553\n361#3,7:503\n361#3,7:520\n1295#4,2:537\n473#4:543\n1295#4,2:544\n1295#4,2:546\n1#5:542\n*S KotlinDebug\n*F\n+ 1 WorkspaceFileIndexDataImpl.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl\n*L\n24#1:496\n24#1:497,2\n24#1:499\n24#1:500,3\n24#1:510,3\n25#1:513\n25#1:514,2\n25#1:516\n25#1:517,3\n25#1:527,3\n26#1:530,2\n26#1:532,4\n57#1:536\n57#1:539\n161#1:540,2\n234#1:548\n234#1:549,2\n234#1:551,2\n268#1:553,2\n24#1:503,7\n25#1:520,7\n58#1:537,2\n199#1:543\n199#1:544,2\n209#1:546,2\n*E\n"})
public final class WorkspaceFileIndexDataImpl
implements WorkspaceFileIndexData {
    @NotNull
    private final List<WorkspaceFileIndexContributor<?>> contributorList;
    @NotNull
    private final Project project;
    @NotNull
    private final RootFileSupplier rootFileSupplier;
    @NotNull
    private final Map<Class<? extends WorkspaceEntity>, List<WorkspaceFileIndexContributor<?>>> contributors;
    @NotNull
    private final Map<Class<? extends WorkspaceEntity>, List<WorkspaceFileIndexContributor<?>>> contributorsForUnloaded;
    @NotNull
    private final Map<WorkspaceFileIndexContributor<?>, List<DependencyDescription<? extends WorkspaceEntity>>> contributorDependencies;
    @NotNull
    private final HashMap<VirtualFile, StoredFileSetCollection> fileSets;
    @NotNull
    private final HashMap<String, MultiMap<EntityReference<WorkspaceEntity>, WorkspaceFileSetImpl>> fileSetsByPackagePrefix;
    @NotNull
    private final NonExistingWorkspaceRootsRegistry nonExistingFilesRegistry;
    @NotNull
    private final PackageDirectoryCacheImpl packageDirectoryCache;
    @NotNull
    private final NonIncrementalContributors nonIncrementalContributors;
    @NotNull
    private final LibrariesAndSdkContributors librariesAndSdkContributors;
    @NotNull
    private final ConcurrentBitSet fileIdWithoutFileSets;
    private final FileTypeRegistry fileTypeRegistry;
    @NotNull
    private final HashSet<EntityReference<WorkspaceEntity>> dirtyEntities;
    @NotNull
    private final HashSet<VirtualFile> dirtyFiles;
    private volatile boolean hasDirtyEntities;

    /*
     * WARNING - void declaration
     */
    public WorkspaceFileIndexDataImpl(@NotNull List<? extends WorkspaceFileIndexContributor<?>> contributorList, @NotNull Project project2, @NotNull RootFileSupplier rootFileSupplier) {
        void $this$associateWith$iv;
        Object list$iv$iv;
        List answer$iv$iv$iv;
        Object value$iv$iv$iv;
        boolean $i$f$getOrPut;
        Object $this$getOrPut$iv$iv$iv;
        Class key$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        WorkspaceFileIndexContributor it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(contributorList, (String)"contributorList");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootFileSupplier, (String)"rootFileSupplier");
        this.contributorList = contributorList;
        this.project = project2;
        this.rootFileSupplier = rootFileSupplier;
        Iterable iterable = this.contributorList;
        WorkspaceFileIndexDataImpl workspaceFileIndexDataImpl = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WorkspaceFileIndexContributor)element$iv$iv;
            boolean bl = false;
            if (!(it.getStorageKind() == EntityStorageKind.MAIN)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (WorkspaceFileIndexContributor)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getEntityClass();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        workspaceFileIndexDataImpl.contributors = destination$iv$iv;
        $this$groupBy$iv = this.contributorList;
        workspaceFileIndexDataImpl = this;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WorkspaceFileIndexContributor)element$iv$iv;
            boolean bl = false;
            if (!(it.getStorageKind() == EntityStorageKind.UNLOADED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (WorkspaceFileIndexContributor)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getEntityClass();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        workspaceFileIndexDataImpl.contributorsForUnloaded = destination$iv$iv;
        $this$groupBy$iv = this.contributorList;
        workspaceFileIndexDataImpl = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            list$iv$iv = (WorkspaceFileIndexContributor)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list2 = it.getDependenciesOnOtherEntities();
            map2.put(t, list2);
        }
        workspaceFileIndexDataImpl.contributorDependencies = result$iv;
        this.fileSets = new HashMap();
        this.fileSetsByPackagePrefix = new HashMap();
        this.nonExistingFilesRegistry = new NonExistingWorkspaceRootsRegistry(this.project, this);
        this.nonIncrementalContributors = new NonIncrementalContributors(this.project, this.rootFileSupplier);
        this.librariesAndSdkContributors = new LibrariesAndSdkContributors(this.project, this.rootFileSupplier, (Map<VirtualFile, StoredFileSetCollection>)this.fileSets, this.fileSetsByPackagePrefix);
        ConcurrentBitSet concurrentBitSet = ConcurrentBitSet.create();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentBitSet, (String)"create()");
        this.fileIdWithoutFileSets = concurrentBitSet;
        this.fileTypeRegistry = FileTypeRegistry.getInstance();
        this.dirtyEntities = new HashSet();
        this.dirtyFiles = new HashSet();
        this.packageDirectoryCache = new PackageDirectoryCacheImpl((arg_0, arg_1) -> WorkspaceFileIndexDataImpl._init_$lambda$5((Function2)new Function2<String, List<? super VirtualFile>, Unit>((Object)this){

            public final void invoke(@NotNull String p0, @NotNull List<? super VirtualFile> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((WorkspaceFileIndexDataImpl)this.receiver).fillPackageDirectories(p0, p1);
            }
        }, arg_0, arg_1), (arg_0, arg_1) -> WorkspaceFileIndexDataImpl._init_$lambda$6((Function2)new Function2<VirtualFile, String, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile p0, @NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((WorkspaceFileIndexDataImpl)this.receiver).isPackageDirectory(p0, p1);
            }
        }, arg_0, arg_1));
        this.registerAllEntities(EntityStorageKind.MAIN);
        this.registerAllEntities(EntityStorageKind.UNLOADED);
        this.librariesAndSdkContributors.registerFileSets();
    }

    private final void registerAllEntities(EntityStorageKind storageKind) {
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[storageKind.ordinal()]) {
            case 1 -> TuplesKt.to((Object)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot(), this.contributors);
            case 2 -> TuplesKt.to((Object)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshotOfUnloadedEntities(), this.contributorsForUnloaded);
            default -> throw new NoWhenBranchMatchedException();
        };
        EntityStorageSnapshot storage = (EntityStorageSnapshot)pair.component1();
        Map contributors = (Map)pair.component2();
        StoreFileSetsRegistrarImpl registrar = new StoreFileSetsRegistrarImpl(storageKind);
        Iterable $this$forEach$iv = contributors.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class entityClass = (Class)element$iv;
            boolean bl = false;
            Sequence $this$forEach$iv2 = storage.entities(entityClass);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                WorkspaceEntity it = (WorkspaceEntity)element$iv2;
                boolean bl2 = false;
                this.registerFileSets(it, entityClass, (EntityStorage)storage, storageKind, registrar);
            }
        }
    }

    @Override
    @NotNull
    public WorkspaceFileInternalInfo getFileInfo(@NotNull VirtualFile file2, boolean honorExclusion, boolean includeContentSets, boolean includeExternalSets, boolean includeExternalSourceSets) {
        int originalAcceptedKindMask;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isValid()) {
            return WorkspaceFileInternalInfo.NonWorkspace.INVALID;
        }
        this.ensureIsUpToDate();
        int acceptedKindsMask = originalAcceptedKindMask = (includeContentSets ? 1 : 0) | (includeExternalSets ? 2 : 0) | (includeExternalSourceSets ? 4 : 0);
        for (VirtualFile current = file2; current != null; current = current.getParent()) {
            boolean mayHaveFileSets;
            VirtualFile virtualFile2 = current;
            VirtualFileWithId virtualFileWithId = virtualFile2 instanceof VirtualFileWithId ? (VirtualFileWithId)((Object)virtualFile2) : null;
            int fileId = virtualFileWithId != null ? virtualFileWithId.getId() : -1;
            boolean bl = mayHaveFileSets = fileId < 0 || !this.fileIdWithoutFileSets.get(fileId);
            if (!mayHaveFileSets) continue;
            StoredFileSetCollection storedFileSets = this.fileSets.get(current);
            if (storedFileSets != null) {
                int masks = storedFileSets.computeMasks(acceptedKindsMask << 2, this.project, honorExclusion, file2);
                int storedKindMask = masks & 3;
                acceptedKindsMask = masks >> 2 & 7;
                if (acceptedKindsMask == 0) {
                    return WorkspaceFileInternalInfo.NonWorkspace.EXCLUDED;
                }
                if ((storedKindMask & 1) != 0) {
                    if (storedKindMask == 1) {
                        return (WorkspaceFileInternalInfo)((Object)storedFileSets);
                    }
                    ArrayList<WorkspaceFileSetImpl> acceptedFileSets = new ArrayList<WorkspaceFileSetImpl>();
                    int currentKindMask = acceptedKindsMask;
                    storedFileSets.forEach((Function1<? super StoredFileSet, Unit>)((Function1)new Function1<StoredFileSet, Unit>(currentKindMask, this, acceptedFileSets){
                        final /* synthetic */ int $currentKindMask;
                        final /* synthetic */ WorkspaceFileIndexDataImpl this$0;
                        final /* synthetic */ ArrayList<WorkspaceFileSetImpl> $acceptedFileSets;
                        {
                            this.$currentKindMask = $currentKindMask;
                            this.this$0 = $receiver;
                            this.$acceptedFileSets = $acceptedFileSets;
                            super(1);
                        }

                        public final void invoke(@NotNull StoredFileSet fileSet) {
                            Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
                            if (fileSet instanceof WorkspaceFileSetImpl && (WorkspaceFileIndexDataImplKt.toMask(((WorkspaceFileSetImpl)fileSet).getKind()) & this.$currentKindMask) != 0 && !((WorkspaceFileSetImpl)fileSet).isUnloaded(WorkspaceFileIndexDataImpl.access$getProject$p(this.this$0))) {
                                this.$acceptedFileSets.add((WorkspaceFileSetImpl)fileSet);
                            }
                        }
                    }));
                    return acceptedFileSets.size() > 1 ? (WorkspaceFileInternalInfo)new MultipleWorkspaceFileSetsImpl((List<WorkspaceFileSetImpl>)acceptedFileSets) : (WorkspaceFileInternalInfo)CollectionsKt.first((List)acceptedFileSets);
                }
            }
            if (this.fileTypeRegistry.isFileIgnored(current)) {
                return WorkspaceFileInternalInfo.NonWorkspace.IGNORED;
            }
            if (fileId < 0 || storedFileSets != null) continue;
            this.fileIdWithoutFileSets.set(fileId);
        }
        if (originalAcceptedKindMask != acceptedKindsMask) {
            return WorkspaceFileInternalInfo.NonWorkspace.EXCLUDED;
        }
        return WorkspaceFileInternalInfo.NonWorkspace.NOT_UNDER_ROOTS;
    }

    private final void ensureIsUpToDate() {
        if (this.hasDirtyEntities && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.updateDirtyEntities();
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.nonIncrementalContributors.updateIfNeeded((Map<VirtualFile, StoredFileSetCollection>)this.fileSets, this.fileSetsByPackagePrefix, this.nonExistingFilesRegistry);
    }

    @Override
    public void visitFileSets(@NotNull WorkspaceFileSetVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        this.ensureIsUpToDate();
        for (StoredFileSetCollection value : this.fileSets.values()) {
            value.forEach((Function1<? super StoredFileSet, Unit>)((Function1)new Function1<StoredFileSet, Unit>(visitor2){
                final /* synthetic */ WorkspaceFileSetVisitor $visitor;
                {
                    this.$visitor = $visitor;
                    super(1);
                }

                public final void invoke(@NotNull StoredFileSet storedFileSet) {
                    Intrinsics.checkNotNullParameter((Object)storedFileSet, (String)"storedFileSet");
                    StoredFileSet storedFileSet2 = storedFileSet;
                    if (storedFileSet2 instanceof WorkspaceFileSetImpl) {
                        this.$visitor.visitIncludedRoot((WorkspaceFileSet)((Object)storedFileSet));
                    } else if (storedFileSet2 instanceof ExcludedFileSet) {
                        // empty if block
                    }
                }
            }));
        }
    }

    public final void processFileSets(@NotNull VirtualFile virtualFile2, @NotNull Function1<? super StoredFileSet, Unit> action2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            StoredFileSetCollection storedFileSetCollection = this.fileSets.get(virtualFile2);
            if (storedFileSetCollection == null) break block0;
            storedFileSetCollection.forEach(action2);
        }
    }

    private final <E extends WorkspaceEntity> List<WorkspaceFileIndexContributor<E>> getContributors(Class<? extends E> entityClass, EntityStorageKind storageKind) {
        Map<Class<WorkspaceEntity>, List<WorkspaceFileIndexContributor<?>>> map2 = switch (WhenMappings.$EnumSwitchMapping$0[storageKind.ordinal()]) {
            case 1 -> this.contributors;
            case 2 -> this.contributorsForUnloaded;
            default -> throw new NoWhenBranchMatchedException();
        };
        List list2 = map2.get(entityClass);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List value = list2;
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.List<com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor<E of com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl.getContributors>>");
        return value;
    }

    private final <E extends WorkspaceEntity> void registerFileSets(E entity, Class<? extends E> entityClass, EntityStorage storage, EntityStorageKind storageKind, WorkspaceFileSetRegistrar registrar) {
        Iterable $this$forEach$iv = this.getContributors(entityClass, storageKind);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceFileIndexContributor contributor = (WorkspaceFileIndexContributor)element$iv;
            boolean bl = false;
            contributor.registerFileSets(entity, registrar, storage);
        }
    }

    private final <E extends WorkspaceEntity> void processChangesByContributor(WorkspaceFileIndexContributor<E> contributor, EntityStorageKind storageKind, VersionedStorageChange event) {
        LinkedHashSet<WorkspaceEntity> removedEntities = new LinkedHashSet<WorkspaceEntity>();
        LinkedHashSet<WorkspaceEntity> addedEntities = new LinkedHashSet<WorkspaceEntity>();
        for (EntityChange change2 : event.getChanges(contributor.getEntityClass())) {
            WorkspaceEntity it;
            if (change2.getOldEntity() != null) {
                boolean bl = false;
                removedEntities.add(it);
            }
            if (change2.getNewEntity() == null) continue;
            boolean bl = false;
            addedEntities.add(it);
        }
        for (Object dependency : (List)MapsKt.getValue(this.contributorDependencies, contributor)) {
            Object object = dependency;
            if (object instanceof DependencyDescription.OnParent) {
                Intrinsics.checkNotNull((Object)dependency, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.DependencyDescription.OnParent<E of com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl.processChangesByContributor, *>");
                this.collectEntitiesWithChangedParent((DependencyDescription.OnParent)dependency, event, removedEntities, addedEntities);
                continue;
            }
            if (!(object instanceof DependencyDescription.OnChild)) continue;
            Intrinsics.checkNotNull((Object)dependency, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.DependencyDescription.OnChild<E of com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl.processChangesByContributor, *>");
            this.collectEntitiesWithChangedChild((DependencyDescription.OnChild)dependency, event, removedEntities, addedEntities);
        }
        RemoveFileSetsRegistrarImpl removeRegistrar = new RemoveFileSetsRegistrarImpl(storageKind);
        for (WorkspaceEntity removed : removedEntities) {
            Intrinsics.checkNotNullExpressionValue((Object)removed, (String)"removed");
            contributor.registerFileSets(removed, removeRegistrar, (EntityStorage)event.getStorageBefore());
        }
        StoreFileSetsRegistrarImpl storeRegistrar = new StoreFileSetsRegistrarImpl(storageKind);
        for (WorkspaceEntity added : addedEntities) {
            Intrinsics.checkNotNullExpressionValue((Object)added, (String)"added");
            contributor.registerFileSets(added, storeRegistrar, (EntityStorage)event.getStorageAfter());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends WorkspaceEntity, P extends WorkspaceEntity> void collectEntitiesWithChangedParent(DependencyDescription.OnParent<E, P> dependency, VersionedStorageChange event, Set<E> removedEntities, Set<E> addedEntities) {
        void $this$forEach$iv;
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)event.getChanges(dependency.getParentClass()));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)collectEntitiesWithChangedParent$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        $this$filterIsInstance$iv = sequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange.Replaced change2 = (EntityChange.Replaced)element$iv;
            boolean bl = false;
            SequencesKt.toCollection((Sequence)((Sequence)dependency.getChildrenGetter().invoke((Object)change2.getOldEntity())), (Collection)removedEntities);
            SequencesKt.toCollection((Sequence)((Sequence)dependency.getChildrenGetter().invoke((Object)change2.getNewEntity())), (Collection)addedEntities);
        }
    }

    private final <E extends WorkspaceEntity, C extends WorkspaceEntity> void collectEntitiesWithChangedChild(DependencyDescription.OnChild<E, C> dependency, VersionedStorageChange event, LinkedHashSet<E> removedEntities, LinkedHashSet<E> addedEntities) {
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)event.getChanges(dependency.getChildClass()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntity it;
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            if (change2.getOldEntity() != null) {
                boolean bl2 = false;
                removedEntities.add(dependency.getParentGetter().invoke((Object)it));
            }
            if (change2.getNewEntity() == null) continue;
            boolean bl3 = false;
            addedEntities.add(dependency.getParentGetter().invoke((Object)it));
        }
    }

    @Override
    public void resetCustomContributors() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.nonIncrementalContributors.resetCache();
        this.resetFileCache();
    }

    @Override
    public void markDirty(@NotNull Collection<? extends EntityReference<? extends WorkspaceEntity>> entityReferences, @NotNull Collection<? extends VirtualFile> filesToInvalidate) {
        Intrinsics.checkNotNullParameter(entityReferences, (String)"entityReferences");
        Intrinsics.checkNotNullParameter(filesToInvalidate, (String)"filesToInvalidate");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.dirtyEntities.addAll(entityReferences);
        this.dirtyFiles.addAll(filesToInvalidate);
        this.hasDirtyEntities = !((Collection)this.dirtyEntities).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEntitiesChanged(@NotNull VersionedStorageChange event, @NotNull EntityStorageKind storageKind) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Iterable $this$filter$iv = this.contributorList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WorkspaceFileIndexContributor it = (WorkspaceFileIndexContributor)element$iv$iv;
            boolean bl = false;
            if (!(it.getStorageKind() == storageKind)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceFileIndexContributor it = (WorkspaceFileIndexContributor)element$iv;
            boolean bl = false;
            this.processChangesByContributor(it, storageKind, event);
        }
        this.resetFileCache();
    }

    @Override
    public void updateDirtyEntities() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (VirtualFile file2 : this.dirtyFiles) {
            this.fileSets.remove(file2);
        }
        EntityStorageSnapshot storage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        RemoveFileSetsRegistrarImpl removeRegistrar = new RemoveFileSetsRegistrarImpl(EntityStorageKind.MAIN);
        StoreFileSetsRegistrarImpl storeRegistrar = new StoreFileSetsRegistrarImpl(EntityStorageKind.MAIN);
        for (EntityReference<WorkspaceEntity> reference2 : this.dirtyEntities) {
            WorkspaceEntity entity;
            if (reference2.resolve((EntityStorage)storage) == null) continue;
            this.registerFileSets(entity, entity.getEntityInterface(), (EntityStorage)storage, EntityStorageKind.MAIN, removeRegistrar);
            this.registerFileSets(entity, entity.getEntityInterface(), (EntityStorage)storage, EntityStorageKind.MAIN, storeRegistrar);
        }
        this.dirtyFiles.clear();
        this.dirtyEntities.clear();
        this.resetFileCache();
        this.hasDirtyEntities = false;
    }

    @Override
    public void resetFileCache() {
        this.fileIdWithoutFileSets.clear();
        this.packageDirectoryCache.clear();
    }

    private final boolean isPackageDirectory(VirtualFile dir, String packageName) {
        return Intrinsics.areEqual((Object)this.getPackageName(dir), (Object)packageName);
    }

    private final void fillPackageDirectories(String packageName, List<? super VirtualFile> result2) {
        block1: {
            HashSet<VirtualFile> addedRoots = new HashSet<VirtualFile>();
            MultiMap<EntityReference<WorkspaceEntity>, WorkspaceFileSetImpl> multiMap = this.fileSetsByPackagePrefix.get(packageName);
            if (multiMap == null || (multiMap = multiMap.values()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)((Object)multiMap);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceFileSetImpl fileSet = (WorkspaceFileSetImpl)element$iv;
                boolean bl = false;
                VirtualFile root = fileSet.getRoot();
                if (!root.isDirectory() || !root.isValid() || !addedRoots.add(root)) continue;
                result2.add(root);
            }
        }
    }

    @Override
    @Nullable
    public String getPackageName(@NotNull VirtualFile dir) {
        WorkspaceFileSetWithCustomData workspaceFileSetWithCustomData;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.isDirectory()) {
            return null;
        }
        WorkspaceFileInternalInfo info2 = this.getFileInfo(dir, true, true, true, true);
        if (info2 instanceof WorkspaceFileSetWithCustomData) {
            WorkspaceFileInternalInfo workspaceFileInternalInfo;
            WorkspaceFileInternalInfo it = workspaceFileInternalInfo = info2;
            boolean bl = false;
            workspaceFileSetWithCustomData = (WorkspaceFileSetWithCustomData)((Object)(((WorkspaceFileSetWithCustomData)((Object)it)).getData() instanceof JvmPackageRootDataInternal ? workspaceFileInternalInfo : null));
        } else {
            workspaceFileSetWithCustomData = info2 instanceof MultipleWorkspaceFileSets ? ((MultipleWorkspaceFileSets)info2).find(JvmPackageRootDataInternal.class) : null;
        }
        if (workspaceFileSetWithCustomData == null) {
            return null;
        }
        WorkspaceFileSetWithCustomData fileSet = workspaceFileSetWithCustomData;
        Object obj = fileSet.getData();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.impl.JvmPackageRootDataInternal");
        String packagePrefix = ((JvmPackageRootDataInternal)obj).getPackagePrefix();
        String string2 = VfsUtilCore.getRelativePath(dir, fileSet.getRoot(), '.');
        if (string2 == null) {
            throw new IllegalStateException((dir.getPresentableUrl() + " is not under " + fileSet.getRoot().getPresentableUrl()).toString());
        }
        String packageName = string2;
        return ((CharSequence)packagePrefix).length() == 0 ? packageName : (((CharSequence)packageName).length() == 0 ? packagePrefix : packagePrefix + "." + packageName);
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        CollectionQuery query2 = new CollectionQuery((Collection)this.packageDirectoryCache.getDirectoriesByPackageName(packageName));
        if (includeLibrarySources) {
            return query2;
        }
        Query<Object> query3 = query2.filtering(arg_0 -> WorkspaceFileIndexDataImpl.getDirectoriesByPackageName$lambda$20((Function1)new Function1<VirtualFile, Boolean>(this){
            final /* synthetic */ WorkspaceFileIndexDataImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(VirtualFile it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return !(this.this$0.getFileInfo(it, true, true, true, false) instanceof WorkspaceFileInternalInfo.NonWorkspace);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(query3, (String)"override fun getDirector\u2026fo.NonWorkspace\n    }\n  }");
        return query3;
    }

    @Override
    public void onLowMemory() {
        this.packageDirectoryCache.onLowMemory();
    }

    @Override
    public void clearPackageDirectoryCache() {
        this.packageDirectoryCache.clear();
    }

    @Override
    @NotNull
    public Set<NonExistingFileSetKind> getNonExistentFileSetKinds(@NotNull VirtualFileUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.nonExistingFilesRegistry.getFileSetKindsFor(url);
    }

    @Override
    @Nullable
    public VfsChangeApplier analyzeVfsChanges(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        return this.nonExistingFilesRegistry.analyzeVfsChanges(events);
    }

    private static final void _init_$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final boolean _init_$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final boolean getDirectoriesByPackageName$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(WorkspaceFileIndexDataImpl $this) {
        return $this.project;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EntityStorageKind.values().length];
            try {
                nArray[EntityStorageKind.MAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityStorageKind.UNLOADED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J*\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl$StoreFileSetsRegistrarImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "(Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;)V", "registerExcludedRoot", "", "excludedRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "excludedFrom", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "entity", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "registerExclusionCondition", "root", "condition", "Lkotlin/Function1;", "", "registerExclusionPatterns", "patterns", "", "", "registerFileSet", "kind", "customData", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "intellij.platform.projectModel.impl"})
    private final class StoreFileSetsRegistrarImpl
    implements WorkspaceFileSetRegistrar {
        @NotNull
        private final EntityStorageKind storageKind;

        public StoreFileSetsRegistrarImpl(EntityStorageKind storageKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
            this.storageKind = storageKind;
        }

        @Override
        public void registerFileSet(@NotNull VirtualFileUrl root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile rootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(root);
            if (rootFile != null) {
                this.registerFileSet(rootFile, kind, entity, customData);
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.registerUrl(root, entity, this.storageKind, kind.isContent() ? NonExistingFileSetKind.INCLUDED_CONTENT : NonExistingFileSetKind.INCLUDED_OTHER);
            }
        }

        @Override
        public void registerFileSet(@NotNull VirtualFile root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            EntityReference entityReference = entity.createReference();
            WorkspaceFileSetData workspaceFileSetData = customData;
            if (workspaceFileSetData == null) {
                workspaceFileSetData = DummyWorkspaceFileSetData.INSTANCE;
            }
            WorkspaceFileSetImpl fileSet = new WorkspaceFileSetImpl(root, kind, (EntityReference<? extends WorkspaceEntity>)entityReference, this.storageKind, workspaceFileSetData);
            WorkspaceFileSetsKt.putValue(WorkspaceFileIndexDataImpl.this.fileSets, root, fileSet);
            if (customData instanceof JvmPackageRootDataInternal) {
                WorkspaceFileSetsKt.addFileSet(WorkspaceFileIndexDataImpl.this.fileSetsByPackagePrefix, ((JvmPackageRootDataInternal)customData).getPackagePrefix(), fileSet);
            }
        }

        @Override
        public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)excludedRoot, (String)"excludedRoot");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile excludedRootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(excludedRoot);
            if (excludedRootFile != null) {
                WorkspaceFileSetsKt.putValue(WorkspaceFileIndexDataImpl.this.fileSets, excludedRootFile, new ExcludedFileSet.ByFileKind(7, (EntityReference<? extends WorkspaceEntity>)entity.createReference(), this.storageKind));
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.registerUrl(excludedRoot, entity, this.storageKind, NonExistingFileSetKind.EXCLUDED_FROM_CONTENT);
            }
        }

        @Override
        public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceFileKind excludedFrom, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)excludedRoot, (String)"excludedRoot");
            Intrinsics.checkNotNullParameter((Object)((Object)excludedFrom), (String)"excludedFrom");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile file2 = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(excludedRoot);
            if (file2 != null) {
                this.registerExcludedRoot(file2, excludedFrom, entity);
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.registerUrl(excludedRoot, entity, this.storageKind, excludedFrom.isContent() ? NonExistingFileSetKind.EXCLUDED_FROM_CONTENT : NonExistingFileSetKind.EXCLUDED_OTHER);
            }
        }

        @Override
        public void registerExcludedRoot(@NotNull VirtualFile excludedRoot, @NotNull WorkspaceFileKind excludedFrom, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)excludedRoot, (String)"excludedRoot");
            Intrinsics.checkNotNullParameter((Object)((Object)excludedFrom), (String)"excludedFrom");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            int mask = excludedFrom == WorkspaceFileKind.EXTERNAL ? 6 : WorkspaceFileIndexDataImplKt.toMask(excludedFrom);
            WorkspaceFileSetsKt.putValue(WorkspaceFileIndexDataImpl.this.fileSets, excludedRoot, new ExcludedFileSet.ByFileKind(mask, (EntityReference<? extends WorkspaceEntity>)entity.createReference(), this.storageKind));
        }

        @Override
        public void registerExclusionPatterns(@NotNull VirtualFileUrl root, @NotNull List<String> patterns, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile rootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(root);
            if (!patterns.isEmpty()) {
                if (rootFile != null) {
                    WorkspaceFileSetsKt.putValue(WorkspaceFileIndexDataImpl.this.fileSets, rootFile, new ExcludedFileSet.ByPattern(rootFile, patterns, (EntityReference<? extends WorkspaceEntity>)entity.createReference(), this.storageKind));
                } else {
                    WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.registerUrl(root, entity, this.storageKind, NonExistingFileSetKind.EXCLUDED_OTHER);
                }
            }
        }

        @Override
        public void registerExclusionCondition(@NotNull VirtualFileUrl root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile rootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(root);
            if (rootFile != null) {
                this.registerExclusionCondition(rootFile, condition, entity);
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.registerUrl(root, entity, this.storageKind, NonExistingFileSetKind.EXCLUDED_OTHER);
            }
        }

        @Override
        public void registerExclusionCondition(@NotNull VirtualFile root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            WorkspaceFileSetsKt.putValue(WorkspaceFileIndexDataImpl.this.fileSets, root, new ExcludedFileSet.ByCondition(root, condition, (EntityReference<? extends WorkspaceEntity>)entity.createReference(), this.storageKind));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J*\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl$RemoveFileSetsRegistrarImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "(Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;)V", "isOriginatedFrom", "", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSet;", "entity", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "registerExcludedRoot", "", "excludedRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "excludedFrom", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "registerExclusionCondition", "root", "condition", "Lkotlin/Function1;", "registerExclusionPatterns", "patterns", "", "", "registerFileSet", "kind", "customData", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "intellij.platform.projectModel.impl"})
    private final class RemoveFileSetsRegistrarImpl
    implements WorkspaceFileSetRegistrar {
        @NotNull
        private final EntityStorageKind storageKind;

        public RemoveFileSetsRegistrarImpl(EntityStorageKind storageKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
            this.storageKind = storageKind;
        }

        @Override
        public void registerFileSet(@NotNull VirtualFileUrl root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile rootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(root);
            if (rootFile != null) {
                this.registerFileSet(rootFile, kind, entity, customData);
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.unregisterUrl(root, entity, this.storageKind);
            }
        }

        @Override
        public void registerFileSet(@NotNull VirtualFile root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            WorkspaceFileSetsKt.removeValueIf(WorkspaceFileIndexDataImpl.this.fileSets, root, (Function1<? super StoredFileSet, Boolean>)((Function1)new Function1<StoredFileSet, Boolean>(this, entity){
                final /* synthetic */ RemoveFileSetsRegistrarImpl this$0;
                final /* synthetic */ WorkspaceEntity $entity;
                {
                    this.this$0 = $receiver;
                    this.$entity = $entity;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull StoredFileSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it instanceof WorkspaceFileSetImpl && RemoveFileSetsRegistrarImpl.access$isOriginatedFrom(this.this$0, it, this.$entity);
                }
            }));
            if (customData instanceof JvmPackageRootDataInternal) {
                WorkspaceFileSetsKt.removeByPrefixAndReference(WorkspaceFileIndexDataImpl.this.fileSetsByPackagePrefix, ((JvmPackageRootDataInternal)customData).getPackagePrefix(), (EntityReference<? extends WorkspaceEntity>)entity.createReference());
            }
        }

        private final boolean isOriginatedFrom(StoredFileSet fileSet, WorkspaceEntity entity) {
            return fileSet.getEntityStorageKind() == this.storageKind && fileSet.getEntityReference().isReferenceTo(entity);
        }

        @Override
        public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)excludedRoot, (String)"excludedRoot");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile excludedRootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(excludedRoot);
            if (excludedRootFile != null) {
                WorkspaceFileSetsKt.removeValueIf(WorkspaceFileIndexDataImpl.this.fileSets, excludedRootFile, (Function1<? super StoredFileSet, Boolean>)((Function1)new Function1<StoredFileSet, Boolean>(entity){
                    final /* synthetic */ WorkspaceEntity $entity;
                    {
                        this.$entity = $entity;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull StoredFileSet it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it instanceof ExcludedFileSet && it.getEntityReference().isReferenceTo(this.$entity);
                    }
                }));
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.unregisterUrl(excludedRoot, entity, this.storageKind);
            }
        }

        @Override
        public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceFileKind excludedFrom, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)excludedRoot, (String)"excludedRoot");
            Intrinsics.checkNotNullParameter((Object)((Object)excludedFrom), (String)"excludedFrom");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile excludedRootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(excludedRoot);
            if (excludedRootFile != null) {
                this.registerExcludedRoot(excludedRootFile, excludedFrom, entity);
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.unregisterUrl(excludedRoot, entity, this.storageKind);
            }
        }

        @Override
        public void registerExcludedRoot(@NotNull VirtualFile excludedRoot, @NotNull WorkspaceFileKind excludedFrom, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)excludedRoot, (String)"excludedRoot");
            Intrinsics.checkNotNullParameter((Object)((Object)excludedFrom), (String)"excludedFrom");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            WorkspaceFileSetsKt.removeValueIf(WorkspaceFileIndexDataImpl.this.fileSets, excludedRoot, (Function1<? super StoredFileSet, Boolean>)((Function1)new Function1<StoredFileSet, Boolean>(entity){
                final /* synthetic */ WorkspaceEntity $entity;
                {
                    this.$entity = $entity;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull StoredFileSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it instanceof ExcludedFileSet && it.getEntityReference().isReferenceTo(this.$entity);
                }
            }));
        }

        @Override
        public void registerExclusionPatterns(@NotNull VirtualFileUrl root, @NotNull List<String> patterns, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile rootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(root);
            if (rootFile != null) {
                WorkspaceFileSetsKt.removeValueIf(WorkspaceFileIndexDataImpl.this.fileSets, rootFile, (Function1<? super StoredFileSet, Boolean>)((Function1)new Function1<StoredFileSet, Boolean>(entity){
                    final /* synthetic */ WorkspaceEntity $entity;
                    {
                        this.$entity = $entity;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull StoredFileSet it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it instanceof ExcludedFileSet.ByPattern && it.getEntityReference().isReferenceTo(this.$entity);
                    }
                }));
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.unregisterUrl(root, entity, this.storageKind);
            }
        }

        @Override
        public void registerExclusionCondition(@NotNull VirtualFileUrl root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            VirtualFile rootFile = WorkspaceFileIndexDataImpl.this.rootFileSupplier.findFile(root);
            if (rootFile != null) {
                this.registerExclusionCondition(rootFile, condition, entity);
            } else {
                WorkspaceFileIndexDataImpl.this.nonExistingFilesRegistry.unregisterUrl(root, entity, this.storageKind);
            }
        }

        @Override
        public void registerExclusionCondition(@NotNull VirtualFile root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull WorkspaceEntity entity) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            WorkspaceFileSetsKt.removeValueIf(WorkspaceFileIndexDataImpl.this.fileSets, root, (Function1<? super StoredFileSet, Boolean>)((Function1)new Function1<StoredFileSet, Boolean>(entity){
                final /* synthetic */ WorkspaceEntity $entity;
                {
                    this.$entity = $entity;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull StoredFileSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it instanceof ExcludedFileSet.ByCondition && it.getEntityReference().isReferenceTo(this.$entity);
                }
            }));
        }

        public static final /* synthetic */ boolean access$isOriginatedFrom(RemoveFileSetsRegistrarImpl $this, StoredFileSet fileSet, WorkspaceEntity entity) {
            return $this.isOriginatedFrom(fileSet, entity);
        }
    }
}

