/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.ModelBranch;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.impl.CustomEntityProjectModelInfoProvider;
import com.intellij.openapi.roots.impl.DirectoryIndexImpl;
import com.intellij.openapi.roots.impl.RootFileSupplier;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CollectionQuery;
import com.intellij.util.PathUtil;
import com.intellij.util.Query;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.CustomEntityProjectModelInfoProviderBridge;
import com.intellij.workspaceModel.core.fileIndex.impl.EmptyWorkspaceFileIndexData;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetVisitor;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.VirtualFileUrls;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0001JB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J2\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0016JR\u0010\u001a\u001a\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u001b\"\b\b\u0000\u0010\u001c*\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001c0\u001fH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0016H\u0016J0\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010*\u001a\u00020\fH\u0002J\u0010\u0010+\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010-\u001a\u00020\u0014H\u0016J\u0011\u0010.\u001a\u00020/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020/H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00103\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020$H\u0016J\u0010\u00107\u001a\u00020\f2\u0006\u00108\u001a\u000209H\u0002J:\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?2\u0016\u0010@\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u00160AH\u0016JB\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00142\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?2\u0016\u0010@\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u00160A2\u0006\u0010E\u001a\u00020\u0014H\u0002J\b\u0010F\u001a\u00020/H\u0016J\u0010\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020IH\u0016R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexEx;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "contributors", "", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "getContributors", "()Ljava/util/List;", "indexData", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "getIndexData", "()Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "setIndexData", "(Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;)V", "findFileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "honorExclusion", "", "includeContentSets", "includeExternalSets", "includeExternalSourceSets", "findFileSetWithCustomData", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetWithCustomData;", "D", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "customDataClass", "Ljava/lang/Class;", "getContentFileSetRoot", "getDirectoriesByPackageName", "Lcom/intellij/util/Query;", "packageName", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "includeLibrarySources", "getFileInfo", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileInternalInfo;", "getMainIndexData", "getOrCreateIndexData", "getPackageName", "directory", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeBlocking", "isInContent", "isInWorkspace", "isUrlInContent", "Lcom/intellij/util/ThreeState;", "url", "obtainBranchIndexData", "branch", "Lcom/intellij/model/ModelBranch;", "processContentFilesRecursively", "fileOrDir", "processor", "Lcom/intellij/openapi/roots/ContentIteratorEx;", "customFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "fileSetFilter", "Lkotlin/Function1;", "processContentFilesUnderExcludedDirectory", "Lcom/intellij/openapi/vfs/VirtualFileVisitor$Result;", "dir", "rootDir", "reset", "visitFileSets", "visitor", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetVisitor;", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFileIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFileIndexImpl.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,293:1\n1#2:294\n1620#3,3:295\n1549#3:300\n1620#3,3:301\n8#4:298\n8#4:299\n*S KotlinDebug\n*F\n+ 1 WorkspaceFileIndexImpl.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl\n*L\n241#1:295,3\n276#1:300\n276#1:301,3\n261#1:298\n264#1:299\n*E\n"})
public final class WorkspaceFileIndexImpl
implements WorkspaceFileIndexEx,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private volatile WorkspaceFileIndexData indexData;
    @NotNull
    private static final ExtensionPointName<WorkspaceFileIndexContributor<?>> EP_NAME = new ExtensionPointName("com.intellij.workspaceModel.fileIndexContributor");
    @NotNull
    private static final Key<Pair<Long, WorkspaceFileIndexData>> BRANCH_INDEX_DATA_KEY;

    public WorkspaceFileIndexImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.indexData = EmptyWorkspaceFileIndexData.Companion.getNOT_INITIALIZED();
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().simpleConnect();
        Topic<BulkFileListener> topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"VFS_CHANGES");
        simpleMessageBusConnection.subscribe(topic, new BulkFileListener(){

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (DirectoryIndexImpl.shouldResetOnEvents(events)) {
                    boolean bl;
                    block5: {
                        this.getIndexData().clearPackageDirectoryCache();
                        Iterable $this$any$iv = events;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                VFileEvent p0 = (VFileEvent)element$iv;
                                boolean bl2 = false;
                                if (!DirectoryIndexImpl.isIgnoredFileCreated(p0)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.getIndexData().resetFileCache();
                    }
                }
            }
        });
        LowMemoryWatcher.register(() -> WorkspaceFileIndexImpl._init_$lambda$0(this), this.project);
        Runnable clearData = () -> WorkspaceFileIndexImpl._init_$lambda$1(this);
        EP_NAME.addChangeListener(clearData, this);
        CustomEntityProjectModelInfoProvider.EP.addChangeListener(clearData, this);
    }

    @Override
    @NotNull
    public WorkspaceFileIndexData getIndexData() {
        return this.indexData;
    }

    public void setIndexData(@NotNull WorkspaceFileIndexData workspaceFileIndexData) {
        Intrinsics.checkNotNullParameter((Object)workspaceFileIndexData, (String)"<set-?>");
        this.indexData = workspaceFileIndexData;
    }

    @Override
    public boolean isInWorkspace(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.findFileSet(file2, true, true, true, true) != null;
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.findFileSet(file2, true, true, false, false) != null;
    }

    @Override
    @Nullable
    public VirtualFile getContentFileSetRoot(@NotNull VirtualFile file2, boolean honorExclusion) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        WorkspaceFileSet workspaceFileSet = this.findFileSet(file2, honorExclusion, true, false, false);
        return workspaceFileSet != null ? workspaceFileSet.getRoot() : null;
    }

    @Override
    @NotNull
    public ThreeState isUrlInContent(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String currentUrl = url;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        VirtualFileUrlManager urlManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        while (((CharSequence)currentUrl).length() > 0) {
            VirtualFile file2 = fileManager.findFileByUrl(currentUrl);
            if (file2 != null) {
                ThreeState threeState = ThreeState.fromBoolean(this.isInContent(file2));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)threeState), (String)"fromBoolean(isInContent(file))");
                return threeState;
            }
            VirtualFileUrl virtualFileUrl = urlManager.findByUrl(currentUrl);
            if (virtualFileUrl != null) {
                Set<NonExistingFileSetKind> kinds = this.getMainIndexData().getNonExistentFileSetKinds(virtualFileUrl);
                if (kinds.contains((Object)NonExistingFileSetKind.EXCLUDED_FROM_CONTENT)) {
                    return ThreeState.NO;
                }
                if (kinds.contains((Object)NonExistingFileSetKind.EXCLUDED_OTHER)) {
                    return ThreeState.UNSURE;
                }
                if (kinds.contains((Object)NonExistingFileSetKind.INCLUDED_CONTENT)) {
                    return ThreeState.YES;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath(currentUrl), (String)"getParentPath(currentUrl)");
        }
        return ThreeState.NO;
    }

    @Override
    public boolean processContentFilesRecursively(@NotNull VirtualFile fileOrDir, @NotNull ContentIteratorEx processor, @Nullable VirtualFileFilter customFilter, @NotNull Function1<? super WorkspaceFileSetWithCustomData<?>, Boolean> fileSetFilter) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter(fileSetFilter, (String)"fileSetFilter");
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VirtualFileVisitor<Void> visitor2 = new VirtualFileVisitor<Void>(this, processor, customFilter, fileSetFilter, fileOrDir, optionArray){
            final /* synthetic */ WorkspaceFileIndexImpl this$0;
            final /* synthetic */ ContentIteratorEx $processor;
            final /* synthetic */ VirtualFileFilter $customFilter;
            final /* synthetic */ Function1<WorkspaceFileSetWithCustomData<?>, Boolean> $fileSetFilter;
            final /* synthetic */ VirtualFile $fileOrDir;
            {
                this.this$0 = $receiver;
                this.$processor = $processor;
                this.$customFilter = $customFilter;
                this.$fileSetFilter = $fileSetFilter;
                this.$fileOrDir = $fileOrDir;
                super($super_call_param$1);
            }

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                VirtualFileVisitor.Result result2;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                WorkspaceFileInternalInfo fileInfo2 = (WorkspaceFileInternalInfo)ActionsKt.runReadAction((Function0)new Function0<WorkspaceFileInternalInfo>(this.this$0, file2){
                    final /* synthetic */ WorkspaceFileIndexImpl this$0;
                    final /* synthetic */ VirtualFile $file;
                    {
                        this.this$0 = $receiver;
                        this.$file = $file;
                        super(0);
                    }

                    @NotNull
                    public final WorkspaceFileInternalInfo invoke() {
                        return this.this$0.getFileInfo(this.$file, true, true, false, false);
                    }
                });
                if (file2.isDirectory() && fileInfo2 instanceof WorkspaceFileInternalInfo.NonWorkspace) {
                    VirtualFileVisitor.Result result3;
                    switch (processContentFilesRecursively.visitor.WhenMappings.$EnumSwitchMapping$0[((WorkspaceFileInternalInfo.NonWorkspace)fileInfo2).ordinal()]) {
                        case 1: 
                        case 2: {
                            result3 = WorkspaceFileIndexImpl.access$processContentFilesUnderExcludedDirectory(this.this$0, file2, this.$processor, this.$customFilter, this.$fileSetFilter, this.$fileOrDir);
                            break;
                        }
                        case 3: 
                        case 4: {
                            VirtualFileVisitor.Result result4 = VirtualFileVisitor.SKIP_CHILDREN;
                            result3 = result4;
                            Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"{\n              SKIP_CHILDREN\n            }");
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return result3;
                }
                boolean accepted2 = (Boolean)ActionsKt.runReadAction((Function0)new Function0<Boolean>(fileInfo2, this.$fileSetFilter, this.$customFilter, file2){
                    final /* synthetic */ WorkspaceFileInternalInfo $fileInfo;
                    final /* synthetic */ Function1<WorkspaceFileSetWithCustomData<?>, Boolean> $fileSetFilter;
                    final /* synthetic */ VirtualFileFilter $customFilter;
                    final /* synthetic */ VirtualFile $file;
                    {
                        this.$fileInfo = $fileInfo;
                        this.$fileSetFilter = $fileSetFilter;
                        this.$customFilter = $customFilter;
                        this.$file = $file;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.$fileInfo.findFileSet(this.$fileSetFilter) != null && (this.$customFilter == null || this.$customFilter.accept(this.$file));
                    }
                });
                TreeNodeProcessingResult treeNodeProcessingResult = accepted2 ? this.$processor.processFileEx(file2) : TreeNodeProcessingResult.CONTINUE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)treeNodeProcessingResult), (String)"if (accepted) processor.\u2026ProcessingResult.CONTINUE");
                TreeNodeProcessingResult status = treeNodeProcessingResult;
                switch (processContentFilesRecursively.visitor.WhenMappings.$EnumSwitchMapping$1[status.ordinal()]) {
                    case 1: {
                        VirtualFileVisitor.Result result5 = VirtualFileVisitor.CONTINUE;
                        result2 = result5;
                        Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"CONTINUE");
                        break;
                    }
                    case 2: {
                        VirtualFileVisitor.Result result6 = VirtualFileVisitor.SKIP_CHILDREN;
                        result2 = result6;
                        Intrinsics.checkNotNullExpressionValue((Object)result6, (String)"SKIP_CHILDREN");
                        break;
                    }
                    case 3: {
                        VirtualFileVisitor.Result result7 = VirtualFileVisitor.skipTo(file2.getParent());
                        result2 = result7;
                        Intrinsics.checkNotNullExpressionValue((Object)result7, (String)"skipTo(file.parent)");
                        break;
                    }
                    case 4: {
                        VirtualFileVisitor.Result result8 = VirtualFileVisitor.skipTo(this.$fileOrDir);
                        result2 = result8;
                        Intrinsics.checkNotNullExpressionValue((Object)result8, (String)"skipTo(fileOrDir)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return result2;
            }
        };
        VirtualFileVisitor.Result result2 = VfsUtilCore.visitChildrenRecursively(fileOrDir, visitor2);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"visitChildrenRecursively(fileOrDir, visitor)");
        VirtualFileVisitor.Result result3 = result2;
        return !Intrinsics.areEqual((Object)result3.skipToParent, (Object)fileOrDir);
    }

    private final VirtualFileVisitor.Result processContentFilesUnderExcludedDirectory(VirtualFile dir, ContentIteratorEx processor, VirtualFileFilter customFilter, Function1<? super WorkspaceFileSetWithCustomData<?>, Boolean> fileSetFilter, VirtualFile rootDir) {
        VirtualFileVisitor.Result result2;
        VirtualFileUrlManager virtualFileUrlManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        String string2 = dir.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dir.url");
        VirtualFileUrl virtualFileUrl = virtualFileUrlManager.findByUrl(string2);
        if (virtualFileUrl == null) {
            VirtualFileVisitor.Result result3 = VirtualFileVisitor.SKIP_CHILDREN;
            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"SKIP_CHILDREN");
            return result3;
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        boolean processed2 = virtualFileUrlManager.processChildrenRecursively(virtualFileUrl2, (Function1)new Function1<VirtualFileUrl, TreeNodeProcessingResult>(this, processor, customFilter, fileSetFilter){
            final /* synthetic */ WorkspaceFileIndexImpl this$0;
            final /* synthetic */ ContentIteratorEx $processor;
            final /* synthetic */ VirtualFileFilter $customFilter;
            final /* synthetic */ Function1<WorkspaceFileSetWithCustomData<?>, Boolean> $fileSetFilter;
            {
                this.this$0 = $receiver;
                this.$processor = $processor;
                this.$customFilter = $customFilter;
                this.$fileSetFilter = $fileSetFilter;
                super(1);
            }

            @NotNull
            public final TreeNodeProcessingResult invoke(@NotNull VirtualFileUrl childUrl) {
                Intrinsics.checkNotNullParameter((Object)childUrl, (String)"childUrl");
                VirtualFile virtualFile2 = VirtualFileUrls.getVirtualFile(childUrl);
                if (virtualFile2 == null) {
                    return TreeNodeProcessingResult.SKIP_CHILDREN;
                }
                VirtualFile childFile = virtualFile2;
                return ((Boolean)ActionsKt.runReadAction((Function0)new Function0<Boolean>(this.this$0, childFile){
                    final /* synthetic */ WorkspaceFileIndexImpl this$0;
                    final /* synthetic */ VirtualFile $childFile;
                    {
                        this.this$0 = $receiver;
                        this.$childFile = $childFile;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.this$0.isInContent(this.$childFile);
                    }
                })).booleanValue() ? (this.this$0.processContentFilesRecursively(childFile, this.$processor, this.$customFilter, this.$fileSetFilter) ? TreeNodeProcessingResult.SKIP_CHILDREN : TreeNodeProcessingResult.STOP) : TreeNodeProcessingResult.CONTINUE;
            }
        });
        if (!processed2) {
            VirtualFileVisitor.Result result4 = VirtualFileVisitor.skipTo(rootDir);
            result2 = result4;
            Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"{\n      VirtualFileVisitor.skipTo(rootDir)\n    }");
        } else {
            VirtualFileVisitor.Result result5 = VirtualFileVisitor.SKIP_CHILDREN;
            result2 = result5;
            Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"SKIP_CHILDREN");
        }
        return result2;
    }

    @Override
    @Nullable
    public WorkspaceFileSet findFileSet(@NotNull VirtualFile file2, boolean honorExclusion, boolean includeContentSets, boolean includeExternalSets, boolean includeExternalSourceSets) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        WorkspaceFileInternalInfo info2 = this.getFileInfo(file2, honorExclusion, includeContentSets, includeExternalSets, includeExternalSourceSets);
        return info2 instanceof WorkspaceFileSetImpl ? (WorkspaceFileSet)((Object)info2) : (info2 instanceof MultipleWorkspaceFileSets ? (WorkspaceFileSet)((MultipleWorkspaceFileSets)info2).find(null) : null);
    }

    @Override
    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.readAction((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkspaceFileIndexImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.initializeBlocking();
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void initializeBlocking() {
        if (this.getIndexData() instanceof EmptyWorkspaceFileIndexData) {
            List<WorkspaceFileIndexContributor<?>> list2 = this.getContributors();
            RootFileSupplier rootFileSupplier = RootFileSupplier.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)rootFileSupplier, (String)"INSTANCE");
            this.setIndexData(new WorkspaceFileIndexDataImpl(list2, this.project, rootFileSupplier));
        }
    }

    @Override
    @Nullable
    public <D extends WorkspaceFileSetData> WorkspaceFileSetWithCustomData<D> findFileSetWithCustomData(@NotNull VirtualFile file2, boolean honorExclusion, boolean includeContentSets, boolean includeExternalSets, boolean includeExternalSourceSets, @NotNull Class<? extends D> customDataClass) {
        WorkspaceFileSetWithCustomData result2;
        WorkspaceFileSetWithCustomData workspaceFileSetWithCustomData;
        WorkspaceFileSetWithCustomData workspaceFileSetWithCustomData2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(customDataClass, (String)"customDataClass");
        WorkspaceFileInternalInfo info2 = this.getFileInfo(file2, honorExclusion, includeContentSets, includeExternalSets, includeExternalSourceSets);
        if (info2 instanceof WorkspaceFileSetWithCustomData) {
            WorkspaceFileInternalInfo workspaceFileInternalInfo;
            WorkspaceFileInternalInfo it = workspaceFileInternalInfo = info2;
            boolean bl = false;
            workspaceFileSetWithCustomData2 = (WorkspaceFileSetWithCustomData)((Object)(customDataClass.isInstance(((WorkspaceFileSetWithCustomData)((Object)it)).getData()) ? workspaceFileInternalInfo : null));
        } else {
            workspaceFileSetWithCustomData2 = info2 instanceof MultipleWorkspaceFileSets ? ((MultipleWorkspaceFileSets)info2).find(customDataClass) : null;
        }
        if ((workspaceFileSetWithCustomData = (result2 = workspaceFileSetWithCustomData2)) == null) {
            workspaceFileSetWithCustomData = null;
        }
        return workspaceFileSetWithCustomData;
    }

    @Override
    @NotNull
    public WorkspaceFileInternalInfo getFileInfo(@NotNull VirtualFile file2, boolean honorExclusion, boolean includeContentSets, boolean includeExternalSets, boolean includeExternalSourceSets) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = file2 instanceof VirtualFileWindow ? (VirtualFileWindow)((Object)file2) : null;
        if (object == null || (object = object.getDelegate()) == null) {
            object = file2;
        }
        VirtualFile virtualFile2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)object);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getOriginFileIfBacked((f\u2026indow)?.delegate ?: file)");
        VirtualFile unwrappedFile = virtualFile2;
        return this.getOrCreateIndexData(unwrappedFile).getFileInfo(unwrappedFile, honorExclusion, includeContentSets, includeExternalSets, includeExternalSourceSets);
    }

    @Override
    public void visitFileSets(@NotNull WorkspaceFileSetVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        this.getMainIndexData().visitFileSets(visitor2);
    }

    @Override
    @Nullable
    public String getPackageName(@NotNull VirtualFile directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.getOrCreateIndexData(directory).getPackageName(directory);
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.getMainIndexData().getDirectoriesByPackageName(packageName, includeLibrarySources);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Collection<ModelBranch> collection = scope.getModelBranchesAffectingScope();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"scope.modelBranchesAffectingScope");
        Collection<ModelBranch> branches = collection;
        if (branches.isEmpty()) {
            Query<Object> query2 = this.getDirectoriesByPackageName(packageName, true).filtering(arg_0 -> WorkspaceFileIndexImpl.getDirectoriesByPackageName$lambda$3((Function1)new Function1<VirtualFile, Boolean>(scope){
                final /* synthetic */ GlobalSearchScope $scope;
                {
                    this.$scope = $scope;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(VirtualFile it) {
                    return this.$scope.contains(it);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(query2, (String)"scope: GlobalSearchScope\u2026ng { scope.contains(it) }");
            return query2;
        }
        Object object = new WorkspaceFileIndexData[]{this.getMainIndexData()};
        Object it = object = CollectionsKt.mutableListOf((Object[])object);
        boolean bl = false;
        Iterable $this$mapTo$iv = branches;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            ModelBranch modelBranch = (ModelBranch)item$iv;
            Collection collection2 = (Collection)it;
            boolean bl2 = false;
            collection2.add(this.obtainBranchIndexData((ModelBranch)p0));
        }
        Collection cfr_ignored_0 = (Collection)it;
        Object indexDataList = object;
        Query<Object> query3 = new CollectionQuery((Collection)indexDataList).flatMapping(arg_0 -> WorkspaceFileIndexImpl.getDirectoriesByPackageName$lambda$5((Function1)new Function1<WorkspaceFileIndexData, Query<? extends VirtualFile>>(packageName){
            final /* synthetic */ String $packageName;
            {
                this.$packageName = $packageName;
                super(1);
            }

            public final Query<? extends VirtualFile> invoke(WorkspaceFileIndexData it) {
                return it.getDirectoriesByPackageName(this.$packageName, true);
            }
        }, arg_0)).filtering(arg_0 -> WorkspaceFileIndexImpl.getDirectoriesByPackageName$lambda$6((Function1)new Function1<VirtualFile, Boolean>(scope){
            final /* synthetic */ GlobalSearchScope $scope;
            {
                this.$scope = $scope;
                super(1);
            }

            @NotNull
            public final Boolean invoke(VirtualFile it) {
                return this.$scope.contains(it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(query3, (String)"packageName: String, sco\u2026ng { scope.contains(it) }");
        return query3;
    }

    private final WorkspaceFileIndexData getOrCreateIndexData(VirtualFile file2) {
        ModelBranch branch = ModelBranch.getFileBranch(file2);
        if (branch != null) {
            return this.obtainBranchIndexData(branch);
        }
        return this.getMainIndexData();
    }

    private final WorkspaceFileIndexData getMainIndexData() {
        WorkspaceFileIndexData data2 = this.getIndexData();
        WorkspaceFileIndexData workspaceFileIndexData = data2;
        if (Intrinsics.areEqual((Object)workspaceFileIndexData, (Object)EmptyWorkspaceFileIndexData.Companion.getNOT_INITIALIZED())) {
            if (!this.project.isDefault()) {
                WorkspaceFileIndexImpl $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(WorkspaceFileIndexImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error("WorkspaceFileIndex is not initialized yet, empty data is returned. Activities which use the project configuration must be postponed until the project is fully loaded.");
            } else {
                WorkspaceFileIndexImpl $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(WorkspaceFileIndexImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.warn("WorkspaceFileIndex must not be queried for the default project");
            }
        } else if (Intrinsics.areEqual((Object)workspaceFileIndexData, (Object)EmptyWorkspaceFileIndexData.Companion.getRESET())) {
            List<WorkspaceFileIndexContributor<?>> list2 = this.getContributors();
            RootFileSupplier rootFileSupplier = RootFileSupplier.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)rootFileSupplier, (String)"INSTANCE");
            data2 = new WorkspaceFileIndexDataImpl(list2, this.project, rootFileSupplier);
            this.setIndexData(data2);
        }
        return data2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WorkspaceFileIndexContributor<?>> getContributors() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CustomEntityProjectModelInfoProvider.EP.getExtensionList();
        Collection collection = EP_NAME.getExtensionList();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CustomEntityProjectModelInfoProvider customEntityProjectModelInfoProvider = (CustomEntityProjectModelInfoProvider)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection2.add(new CustomEntityProjectModelInfoProviderBridge(it));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private final WorkspaceFileIndexData obtainBranchIndexData(ModelBranch branch) {
        Pair<Long, WorkspaceFileIndexData> pair;
        block3: {
            long modCount;
            block2: {
                pair = branch.getUserData(BRANCH_INDEX_DATA_KEY);
                modCount = branch.getBranchedVfsStructureModificationCount();
                if (pair == null) break block2;
                Long l = (Long)pair.first;
                long l2 = modCount;
                if (l != null && l == l2) break block3;
            }
            Long l = modCount;
            List<WorkspaceFileIndexContributor<?>> list2 = this.getContributors();
            Project project2 = branch.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"branch.project");
            RootFileSupplier rootFileSupplier = RootFileSupplier.forBranch(branch);
            Intrinsics.checkNotNullExpressionValue((Object)rootFileSupplier, (String)"forBranch(branch)");
            pair = new Pair<Long, WorkspaceFileIndexDataImpl>(l, new WorkspaceFileIndexDataImpl(list2, project2, rootFileSupplier));
            branch.putUserData(BRANCH_INDEX_DATA_KEY, pair);
        }
        Object b = pair.second;
        Intrinsics.checkNotNullExpressionValue(b, (String)"pair.second");
        return (WorkspaceFileIndexData)b;
    }

    @Override
    public void reset() {
        this.setIndexData(EmptyWorkspaceFileIndexData.Companion.getRESET());
    }

    private static final void _init_$lambda$0(WorkspaceFileIndexImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getIndexData().onLowMemory();
    }

    private static final void _init_$lambda$1(WorkspaceFileIndexImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setIndexData(EmptyWorkspaceFileIndexData.Companion.getRESET());
    }

    private static final boolean getDirectoriesByPackageName$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Query getDirectoriesByPackageName$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Query)$tmp0.invoke(p0);
    }

    private static final boolean getDirectoriesByPackageName$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ VirtualFileVisitor.Result access$processContentFilesUnderExcludedDirectory(WorkspaceFileIndexImpl $this, VirtualFile dir, ContentIteratorEx processor, VirtualFileFilter customFilter, Function1 fileSetFilter, VirtualFile rootDir) {
        return $this.processContentFilesUnderExcludedDirectory(dir, processor, customFilter, fileSetFilter, rootDir);
    }

    static {
        Key key = Key.create("BRANCH_WORKSPACE_FILE_INDEX");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create<Pair<Long, Worksp\u2026CH_WORKSPACE_FILE_INDEX\")");
        BRANCH_INDEX_DATA_KEY = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R9\u0010\u0003\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl$Companion;", "", "()V", "BRANCH_INDEX_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/util/Pair;", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<WorkspaceFileIndexContributor<?>> getEP_NAME() {
            return EP_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

