/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleStoredWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.TwoWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.UnloadableFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImplKt;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0016J&\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0016\u0010&\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0001\u0012\u0004\u0012\u00020#0'H\u0016J\u000e\u0010(\u001a\u00020#2\u0006\u0010 \u001a\u00020!R\u0014\u0010\u000e\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetWithCustomData;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSet;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileInternalInfo;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "entityReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityStorageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "data", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;Lcom/intellij/workspaceModel/storage/EntityReference;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;)V", "getData", "()Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "getEntityReference", "()Lcom/intellij/workspaceModel/storage/EntityReference;", "getEntityStorageKind", "()Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "getKind", "()Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "add", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "fileSet", "computeMasks", "", "currentMasks", "project", "Lcom/intellij/openapi/project/Project;", "honorExclusion", "", "file", "findFileSet", "condition", "Lkotlin/Function1;", "isUnloaded", "intellij.platform.projectModel.impl"})
public final class WorkspaceFileSetImpl
implements WorkspaceFileSetWithCustomData<WorkspaceFileSetData>,
StoredFileSet,
WorkspaceFileInternalInfo {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final WorkspaceFileKind kind;
    @NotNull
    private final EntityReference<WorkspaceEntity> entityReference;
    @NotNull
    private final EntityStorageKind entityStorageKind;
    @NotNull
    private final WorkspaceFileSetData data;

    public WorkspaceFileSetImpl(@NotNull VirtualFile root, @NotNull WorkspaceFileKind kind, @NotNull EntityReference<? extends WorkspaceEntity> entityReference, @NotNull EntityStorageKind entityStorageKind, @NotNull WorkspaceFileSetData data2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(entityReference, (String)"entityReference");
        Intrinsics.checkNotNullParameter((Object)((Object)entityStorageKind), (String)"entityStorageKind");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.root = root;
        this.kind = kind;
        this.entityReference = entityReference;
        this.entityStorageKind = entityStorageKind;
        this.data = data2;
    }

    @Override
    @NotNull
    public VirtualFile getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public WorkspaceFileKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public EntityReference<WorkspaceEntity> getEntityReference() {
        return this.entityReference;
    }

    @Override
    @NotNull
    public EntityStorageKind getEntityStorageKind() {
        return this.entityStorageKind;
    }

    @Override
    @NotNull
    public WorkspaceFileSetData getData() {
        return this.data;
    }

    public final boolean isUnloaded(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WorkspaceFileSetData workspaceFileSetData = this.getData();
        UnloadableFileSetData unloadableFileSetData = workspaceFileSetData instanceof UnloadableFileSetData ? (UnloadableFileSetData)workspaceFileSetData : null;
        return unloadableFileSetData != null ? unloadableFileSetData.isUnloaded(project2) : false;
    }

    @Override
    @NotNull
    public StoredFileSetCollection add(@NotNull StoredFileSet fileSet) {
        StoredFileSetCollection storedFileSetCollection;
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        if (fileSet instanceof WorkspaceFileSetImpl) {
            storedFileSetCollection = new TwoWorkspaceFileSets(this, (WorkspaceFileSetImpl)fileSet);
        } else {
            Object[] objectArray = new StoredFileSet[]{fileSet, this};
            storedFileSetCollection = new MultipleStoredWorkspaceFileSets(CollectionsKt.mutableListOf((Object[])objectArray));
        }
        return storedFileSetCollection;
    }

    @Override
    public int computeMasks(int currentMasks, @NotNull Project project2, boolean honorExclusion, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        int acceptedKindMask = currentMasks >> 2 & 7;
        int update2 = (acceptedKindMask & WorkspaceFileIndexDataImplKt.toMask(this.getKind())) != 0 && !this.isUnloaded(project2) ? 1 : 2;
        return currentMasks | update2;
    }

    @Override
    @Nullable
    public WorkspaceFileSetWithCustomData<?> findFileSet(@NotNull Function1<? super WorkspaceFileSetWithCustomData<?>, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        WorkspaceFileSetImpl workspaceFileSetImpl = this;
        return (Boolean)condition.invoke((Object)workspaceFileSetImpl) != false ? workspaceFileSetImpl : null;
    }
}

