/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.LibrariesAndSdkContributors;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleContentOrSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.NonIncrementalContributors;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetRecognizer;", "", "()V", "getEntityReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "getLibraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "getModuleForContent", "Lcom/intellij/openapi/module/Module;", "getSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isFromAdditionalLibraryRootsProvider", "", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFileSetRecognizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFileSetRecognizer.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetRecognizer\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n10#2:62\n10#2:63\n8#3:64\n*S KotlinDebug\n*F\n+ 1 WorkspaceFileSetRecognizer.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetRecognizer\n*L\n18#1:62\n22#1:63\n48#1:64\n*E\n"})
public final class WorkspaceFileSetRecognizer {
    @NotNull
    public static final WorkspaceFileSetRecognizer INSTANCE = new WorkspaceFileSetRecognizer();

    private WorkspaceFileSetRecognizer() {
    }

    @Nullable
    public final Module getModuleForContent(@NotNull WorkspaceFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        if (fileSet.getKind() != WorkspaceFileKind.CONTENT) {
            return null;
        }
        WorkspaceFileSet $this$asSafely$iv = fileSet;
        boolean $i$f$asSafely = false;
        WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
        if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
            workspaceFileSet = null;
        }
        WorkspaceFileSetImpl workspaceFileSetImpl = (WorkspaceFileSetImpl)workspaceFileSet;
        WorkspaceFileSetData $this$asSafely$iv2 = workspaceFileSetImpl != null ? workspaceFileSetImpl.getData() : null;
        boolean $i$f$asSafely2 = false;
        WorkspaceFileSetData workspaceFileSetData = $this$asSafely$iv2;
        if (!(workspaceFileSetData instanceof ModuleContentOrSourceRootData)) {
            workspaceFileSetData = null;
        }
        ModuleContentOrSourceRootData moduleContentOrSourceRootData = (ModuleContentOrSourceRootData)workspaceFileSetData;
        return moduleContentOrSourceRootData != null ? moduleContentOrSourceRootData.getModule() : null;
    }

    @Nullable
    public final EntityReference<?> getEntityReference(@NotNull WorkspaceFileSet fileSet) {
        EntityReference<WorkspaceEntity> entityReference;
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        WorkspaceFileSet $this$asSafely$iv = fileSet;
        boolean $i$f$asSafely = false;
        WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
        if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
            workspaceFileSet = null;
        }
        WorkspaceFileSetImpl workspaceFileSetImpl = (WorkspaceFileSetImpl)workspaceFileSet;
        Object object = entityReference = workspaceFileSetImpl != null ? workspaceFileSetImpl.getEntityReference() : null;
        if (entityReference == null) {
            return null;
        }
        if (LibrariesAndSdkContributors.Companion.isPlaceholderReference(entityReference)) {
            return null;
        }
        if (NonIncrementalContributors.Companion.isPlaceholderReference(entityReference)) {
            return null;
        }
        return entityReference;
    }

    @Nullable
    public final LibraryId getLibraryId(@NotNull WorkspaceFileSet fileSet, @NotNull EntityStorage storage) {
        LibraryRootFileSetData libraryRootFileSetData;
        WorkspaceFileSetImpl fileSetImpl;
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        WorkspaceFileSetImpl workspaceFileSetImpl = fileSetImpl = fileSet instanceof WorkspaceFileSetImpl ? (WorkspaceFileSetImpl)fileSet : null;
        if (fileSetImpl == null) {
            return null;
        }
        WorkspaceFileSetData workspaceFileSetData = fileSetImpl.getData();
        LibraryRootFileSetData libraryRootFileSetData2 = libraryRootFileSetData = workspaceFileSetData instanceof LibraryRootFileSetData ? (LibraryRootFileSetData)workspaceFileSetData : null;
        if (libraryRootFileSetData == null) {
            return null;
        }
        if (this.getSdk(fileSet) != null) {
            return null;
        }
        LibraryId globalLibraryId = LibrariesAndSdkContributors.Companion.getGlobalLibraryId$intellij_platform_projectModel_impl(fileSetImpl);
        if (globalLibraryId != null) {
            return globalLibraryId;
        }
        LibraryId projectLibraryId = LibraryRootFileIndexContributor.Companion.getProjectLibraryId$intellij_platform_projectModel_impl(fileSetImpl.getData());
        if (projectLibraryId != null) {
            return projectLibraryId;
        }
        LibraryId moduleLibraryId = LibraryRootFileIndexContributor.Companion.getModuleLibraryId(fileSetImpl, storage);
        WorkspaceFileSetRecognizer $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WorkspaceFileSetRecognizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        logger.assertTrue(moduleLibraryId != null, new Function0<String>(fileSet){
            final /* synthetic */ WorkspaceFileSet $fileSet;
            {
                this.$fileSet = $fileSet;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Failed to find libraryId for " + this.$fileSet;
            }
        });
        return moduleLibraryId;
    }

    @Nullable
    public final Sdk getSdk(@NotNull WorkspaceFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        return LibrariesAndSdkContributors.Companion.getSdk$intellij_platform_projectModel_impl(fileSet);
    }

    public final boolean isFromAdditionalLibraryRootsProvider(@NotNull WorkspaceFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        return NonIncrementalContributors.Companion.isFromAdditionalLibraryRootsProvider$intellij_platform_projectModel_impl(fileSet);
    }
}

