/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide;

import com.intellij.openapi.project.Project;
import com.intellij.platform.workspaceModel.jps.JpsProjectConfigLocation;
import com.intellij.project.ProjectKt;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getJpsProjectConfigLocation", "Lcom/intellij/platform/workspaceModel/jps/JpsProjectConfigLocation;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.projectModel.impl"})
public final class JpsProjectConfigLocationUtilKt {
    @Nullable
    public static final JpsProjectConfigLocation getJpsProjectConfigLocation(@NotNull Project project2) {
        JpsProjectConfigLocation jpsProjectConfigLocation;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (ProjectKt.isDirectoryBased(project2)) {
            JpsProjectConfigLocation.DirectoryBased directoryBased;
            String string2 = project2.getBasePath();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                VirtualFileUrlManager virtualFileUrlManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, project2);
                Path path2 = ProjectKt.getStateStore(project2).getDirectoryStorePath();
                Intrinsics.checkNotNull((Object)path2);
                VirtualFileUrl ideaFolder = VirtualFileUrlImplKt.toVirtualFileUrl((Path)path2, (VirtualFileUrlManager)virtualFileUrlManager);
                directoryBased = new JpsProjectConfigLocation.DirectoryBased(virtualFileUrlManager.fromPath(it), ideaFolder);
            } else {
                directoryBased = null;
            }
            jpsProjectConfigLocation = (JpsProjectConfigLocation)directoryBased;
        } else {
            JpsProjectConfigLocation.FileBased fileBased;
            String string3 = project2.getProjectFilePath();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                VirtualFileUrlManager virtualFileUrlManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, project2);
                VirtualFileUrl iprFile = virtualFileUrlManager.fromPath(it);
                VirtualFileUrl virtualFileUrl = virtualFileUrlManager.getParentVirtualUrl(iprFile);
                Intrinsics.checkNotNull((Object)virtualFileUrl);
                fileBased = new JpsProjectConfigLocation.FileBased(iprFile, virtualFileUrl);
            } else {
                fileBased = null;
            }
            jpsProjectConfigLocation = (JpsProjectConfigLocation)fileBased;
        }
        return jpsProjectConfigLocation;
    }
}

