/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\b\u00a8\u0006\f"}, d2={"getGlobalInstance", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager$Companion;", "getInstance", "project", "Lcom/intellij/openapi/project/Project;", "isEqualOrParentOf", "", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "other", "toPath", "Ljava/nio/file/Path;", "intellij.platform.projectModel.impl"})
@JvmName(name="VirtualFileUrlManagerUtil")
@SourceDebugExtension(value={"SMAP\nVirtualFileUrlManagerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUrlManagerUtil.kt\ncom/intellij/workspaceModel/ide/VirtualFileUrlManagerUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,26:1\n29#2,3:27\n29#2,3:30\n*S KotlinDebug\n*F\n+ 1 VirtualFileUrlManagerUtil.kt\ncom/intellij/workspaceModel/ide/VirtualFileUrlManagerUtil\n*L\n20#1:27,3\n22#1:30,3\n*E\n"})
public final class VirtualFileUrlManagerUtil {
    @NotNull
    public static final VirtualFileUrlManager getInstance(@NotNull VirtualFileUrlManager.Companion $this$getInstance, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$getInstance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ComponentManager $this$service$iv = project2;
        boolean $i$f$service = false;
        Class<VirtualFileUrlManager> serviceClass$iv = VirtualFileUrlManager.class;
        VirtualFileUrlManager virtualFileUrlManager = $this$service$iv.getService(serviceClass$iv);
        if (virtualFileUrlManager == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return virtualFileUrlManager;
    }

    @NotNull
    public static final VirtualFileUrlManager getGlobalInstance(@NotNull VirtualFileUrlManager.Companion $this$getGlobalInstance) {
        Intrinsics.checkNotNullParameter((Object)$this$getGlobalInstance, (String)"<this>");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        ComponentManager $this$service$iv = application;
        boolean $i$f$service = false;
        Class<VirtualFileUrlManager> serviceClass$iv = VirtualFileUrlManager.class;
        VirtualFileUrlManager virtualFileUrlManager = $this$service$iv.getService(serviceClass$iv);
        if (virtualFileUrlManager == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return virtualFileUrlManager;
    }

    public static final boolean isEqualOrParentOf(@NotNull VirtualFileUrl $this$isEqualOrParentOf, @NotNull VirtualFileUrl other) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualOrParentOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string2 = other.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"other.url");
        String string3 = StringsKt.removeSuffix((String)string2, (CharSequence)"/");
        String string4 = $this$isEqualOrParentOf.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"url");
        return FileUtil.startsWith(string3, StringsKt.removeSuffix((String)string4, (CharSequence)"/"));
    }

    @NotNull
    public static final Path toPath(@NotNull VirtualFileUrl $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        Path path2 = Path.of(JpsPathUtil.urlToPath((String)$this$toPath.getUrl()), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath");
        return path2;
    }
}

