/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.ExampleWorkspaceModelEventsHandler;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.CustomSourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.DependenciesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.ExcludeUrlEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaModuleSettingsEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaResourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaSourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleCustomImlDataEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleGroupPathEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Jt\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u001f\u0010\r\u001a\u001b\u0012\u0017\u0012\u0015\u0012\u0004\u0012\u0002H\t\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f\u00a2\u0006\u0002\b\u00110\u000e2%\b\u0002\u0010\u0012\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u0002H\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000e0\u000f\u00a2\u0006\u0002\b\u00110\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J4\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u0006\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010)\u001a\u00020\u0014H\u0002J$\u0010)\u001a\u00020\u00142\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/workspaceModel/ide/impl/ExampleWorkspaceModelEventsHandler;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "calculateChangedUrls", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/ide/impl/ExampleWorkspaceModelEventsHandler$Added;", "Lcom/intellij/workspaceModel/ide/impl/ExampleWorkspaceModelEventsHandler$Removed;", "T", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "change", "Lcom/intellij/workspaceModel/storage/EntityChange;", "vfuAssessors", "", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "Lkotlin/ExtensionFunctionType;", "vfuListAssessors", "dispose", "", "getEntityAndStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "handleContentRootChanged", "handleCustomSourceRootPropertiesChanged", "handleExcludesChanged", "handleJavaModuleSettingsChanged", "handleJavaResourceRootChanged", "handleJavaSourceRootChanged", "handleLibraryChanged", "handleLibraryPropertiesChanged", "handleModuleChanged", "handleModuleCustomImlDataChanged", "handleModuleGroupPathChanged", "handleSourceRootChanged", "libraryIsDependency", "", "library", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "updateCache", "addedVirtualFileUrls", "", "removedVirtualFileUrls", "Added", "Removed", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nExampleWorkspaceModelEventsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExampleWorkspaceModelEventsHandler.kt\ncom/intellij/workspaceModel/ide/impl/ExampleWorkspaceModelEventsHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1855#2,2:209\n1855#2:211\n1856#2:213\n1855#2,2:214\n1855#2,2:216\n1855#2,2:218\n1855#2,2:220\n1855#2,2:222\n1855#2,2:224\n1855#2,2:226\n1855#2,2:228\n1855#2,2:230\n1855#2,2:232\n1855#2,2:234\n1855#2,2:236\n1#3:212\n*S KotlinDebug\n*F\n+ 1 ExampleWorkspaceModelEventsHandler.kt\ncom/intellij/workspaceModel/ide/impl/ExampleWorkspaceModelEventsHandler\n*L\n45#1:209,2\n56#1:211\n56#1:213\n70#1:214,2\n78#1:216,2\n86#1:218,2\n93#1:220,2\n100#1:222,2\n106#1:224,2\n112#1:226,2\n118#1:228,2\n128#1:230,2\n134#1:232,2\n155#1:234,2\n170#1:236,2\n*E\n"})
public final class ExampleWorkspaceModelEventsHandler
implements Disposable {
    @NotNull
    private final Project project;

    public ExampleWorkspaceModelEventsHandler(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.project.getMessageBus().connect(this).subscribe(WorkspaceModelTopics.CHANGED, new WorkspaceModelChangeListener(){

            @Override
            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.handleLibraryChanged(event);
                this.handleContentRootChanged(event);
                this.handleSourceRootChanged(event);
                this.handleExcludesChanged(event);
                this.handleJavaSourceRootChanged(event);
                this.handleJavaResourceRootChanged(event);
                this.handleCustomSourceRootPropertiesChanged(event);
                this.handleModuleChanged(event);
                this.handleJavaModuleSettingsChanged(event);
                this.handleLibraryPropertiesChanged(event);
                this.handleModuleGroupPathChanged(event);
                this.handleModuleCustomImlDataChanged(event);
            }
        });
    }

    private final void handleLibraryChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(LibraryEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            LibraryEntity entity = (LibraryEntity)this.getEntityAndStorage(event, change2).component1();
            if (!this.libraryIsDependency(entity, this.project)) continue;
            Object[] objectArray = new Function1[]{handleLibraryChanged.1.1.INSTANCE, handleLibraryChanged.1.2.INSTANCE};
            Pair<Added, Removed> pair = this.calculateChangedUrls(change2, CollectionsKt.emptyList(), CollectionsKt.listOf((Object[])objectArray));
            Added addedUrls = (Added)pair.component1();
            Removed removedUrls = (Removed)pair.component2();
            this.updateCache(addedUrls.getUrls(), removedUrls.getUrls());
        }
    }

    private final void handleExcludesChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(ExcludeUrlEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            ExcludeUrlEntity entity = (ExcludeUrlEntity)this.getEntityAndStorage(event, change2).component1();
            if (DependenciesKt.getLibrary((ExcludeUrlEntity)entity) != null) {
                LibraryEntity library;
                boolean bl2 = false;
                if (!this.libraryIsDependency(library, this.project)) {
                    continue;
                }
            }
            Pair pair = ExampleWorkspaceModelEventsHandler.calculateChangedUrls$default(this, change2, CollectionsKt.listOf((Object)((Object)handleExcludesChanged.1.2.INSTANCE)), null, 4, null);
            Added addedUrls = (Added)pair.component1();
            Removed removedUrls = (Removed)pair.component2();
            this.updateCache(addedUrls.getUrls(), removedUrls.getUrls());
        }
    }

    private final void handleLibraryPropertiesChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(LibraryPropertiesEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            LibraryPropertiesEntity entity = (LibraryPropertiesEntity)this.getEntityAndStorage(event, change2).component1();
            if (!this.libraryIsDependency(entity.getLibrary(), this.project)) continue;
            this.updateCache();
        }
    }

    private final void handleContentRootChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(ContentRootEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            Pair<Added, Removed> pair = this.calculateChangedUrls(change2, CollectionsKt.listOf((Object)((Object)handleContentRootChanged.1.1.INSTANCE)), CollectionsKt.listOf((Object)((Object)handleContentRootChanged.1.2.INSTANCE)));
            Added addedUrls = (Added)pair.component1();
            Removed removedUrls = (Removed)pair.component2();
            this.updateCache(addedUrls.getUrls(), removedUrls.getUrls());
        }
    }

    private final void handleSourceRootChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(SourceRootEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            Pair pair = ExampleWorkspaceModelEventsHandler.calculateChangedUrls$default(this, change2, CollectionsKt.listOf((Object)((Object)handleSourceRootChanged.1.1.INSTANCE)), null, 4, null);
            Added addedUrls = (Added)pair.component1();
            Removed removedUrls = (Removed)pair.component2();
            this.updateCache(addedUrls.getUrls(), removedUrls.getUrls());
        }
    }

    private final void handleJavaModuleSettingsChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(JavaModuleSettingsEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            Object[] objectArray = new Function1[]{handleJavaModuleSettingsChanged.1.1.INSTANCE, handleJavaModuleSettingsChanged.1.2.INSTANCE};
            Pair pair = ExampleWorkspaceModelEventsHandler.calculateChangedUrls$default(this, change2, CollectionsKt.listOf((Object[])objectArray), null, 4, null);
            Added addedUrls = (Added)pair.component1();
            Removed removedUrls = (Removed)pair.component2();
            this.updateCache(addedUrls.getUrls(), removedUrls.getUrls());
        }
    }

    private final void handleModuleChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(ModuleEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            this.updateCache();
        }
    }

    private final void handleModuleGroupPathChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(ModuleGroupPathEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            this.updateCache();
        }
    }

    private final void handleModuleCustomImlDataChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(ModuleCustomImlDataEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            this.updateCache();
        }
    }

    private final void handleJavaSourceRootChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(JavaSourceRootPropertiesEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            this.updateCache();
        }
    }

    private final void handleJavaResourceRootChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(JavaResourceRootPropertiesEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            this.updateCache();
        }
    }

    private final void handleCustomSourceRootPropertiesChanged(VersionedStorageChange event) {
        Iterable $this$forEach$iv = event.getChanges(CustomSourceRootPropertiesEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange change2 = (EntityChange)element$iv;
            boolean bl = false;
            this.updateCache();
        }
    }

    private final <T extends WorkspaceEntity> Pair<T, EntityStorage> getEntityAndStorage(VersionedStorageChange event, EntityChange<T> change2) {
        Pair pair;
        EntityChange<T> entityChange = change2;
        if (entityChange instanceof EntityChange.Added) {
            pair = TuplesKt.to((Object)((EntityChange.Added)change2).getEntity(), (Object)event.getStorageAfter());
        } else if (entityChange instanceof EntityChange.Removed) {
            pair = TuplesKt.to((Object)((EntityChange.Removed)change2).getEntity(), (Object)event.getStorageBefore());
        } else if (entityChange instanceof EntityChange.Replaced) {
            pair = TuplesKt.to((Object)((EntityChange.Replaced)change2).getNewEntity(), (Object)event.getStorageAfter());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    private final <T extends WorkspaceEntity> Pair<Added, Removed> calculateChangedUrls(EntityChange<T> change2, List<? extends Function1<? super T, ? extends VirtualFileUrl>> vfuAssessors, List<? extends Function1<? super T, ? extends List<? extends VirtualFileUrl>>> vfuListAssessors) {
        EntityChange<T> entityChange;
        Function1 fieldAssessor;
        Set addedVirtualFileUrls = new LinkedHashSet();
        Set removedVirtualFileUrls = new LinkedHashSet();
        Iterable $this$forEach$iv = vfuAssessors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFileUrl oldVirtualFileUrl;
            VirtualFileUrl newVirtualFileUrl;
            VirtualFileUrl it;
            VirtualFileUrl virtualFileUrl;
            fieldAssessor = (Function1)element$iv;
            boolean bl = false;
            entityChange = change2;
            if (entityChange instanceof EntityChange.Added) {
                if ((VirtualFileUrl)fieldAssessor.invoke((Object)((EntityChange.Added)change2).getEntity()) != null) {
                    it = virtualFileUrl;
                    boolean bl2 = false;
                    addedVirtualFileUrls.add(it);
                }
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                if ((VirtualFileUrl)fieldAssessor.invoke((Object)((EntityChange.Removed)change2).getEntity()) != null) {
                    it = virtualFileUrl;
                    boolean bl3 = false;
                    removedVirtualFileUrls.add(it);
                }
                continue;
            }
            if (!(entityChange instanceof EntityChange.Replaced) || Intrinsics.areEqual((Object)(newVirtualFileUrl = (VirtualFileUrl)fieldAssessor.invoke((Object)((EntityChange.Replaced)change2).getNewEntity())), (Object)(oldVirtualFileUrl = (VirtualFileUrl)fieldAssessor.invoke((Object)((EntityChange.Replaced)change2).getOldEntity())))) continue;
            if (newVirtualFileUrl != null) {
                VirtualFileUrl it2 = it;
                boolean bl4 = false;
                addedVirtualFileUrls.add(it2);
            }
            if (oldVirtualFileUrl == null) continue;
            VirtualFileUrl it3 = it;
            boolean bl5 = false;
            removedVirtualFileUrls.add(it3);
        }
        $this$forEach$iv = vfuListAssessors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List virtualFileUrls;
            fieldAssessor = (Function1)element$iv;
            boolean bl = false;
            entityChange = change2;
            if (entityChange instanceof EntityChange.Added) {
                virtualFileUrls = (List)fieldAssessor.invoke((Object)((EntityChange.Added)change2).getEntity());
                if (!(!((Collection)virtualFileUrls).isEmpty())) continue;
                addedVirtualFileUrls.addAll(virtualFileUrls);
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                virtualFileUrls = (List)fieldAssessor.invoke((Object)((EntityChange.Removed)change2).getEntity());
                if (!(!((Collection)virtualFileUrls).isEmpty())) continue;
                removedVirtualFileUrls.addAll(virtualFileUrls);
                continue;
            }
            if (!(entityChange instanceof EntityChange.Replaced)) continue;
            Set newVirtualFileUrls = CollectionsKt.toSet((Iterable)((Iterable)fieldAssessor.invoke((Object)((EntityChange.Replaced)change2).getNewEntity())));
            Set oldVirtualFileUrls = CollectionsKt.toSet((Iterable)((Iterable)fieldAssessor.invoke((Object)((EntityChange.Replaced)change2).getOldEntity())));
            addedVirtualFileUrls.addAll(CollectionsKt.subtract((Iterable)newVirtualFileUrls, (Iterable)oldVirtualFileUrls));
            removedVirtualFileUrls.addAll(CollectionsKt.subtract((Iterable)oldVirtualFileUrls, (Iterable)newVirtualFileUrls));
        }
        return TuplesKt.to((Object)new Added(addedVirtualFileUrls), (Object)new Removed(removedVirtualFileUrls));
    }

    static /* synthetic */ Pair calculateChangedUrls$default(ExampleWorkspaceModelEventsHandler exampleWorkspaceModelEventsHandler, EntityChange entityChange, List list2, List list3, int n, Object object) {
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        return exampleWorkspaceModelEventsHandler.calculateChangedUrls(entityChange, list2, list3);
    }

    private final boolean libraryIsDependency(LibraryEntity library, Project project2) {
        return ModuleDependencyIndex.Companion.getInstance(project2).hasDependencyOn(library.getSymbolicId());
    }

    private final void updateCache() {
    }

    private final void updateCache(Set<VirtualFileUrl> addedVirtualFileUrls, Set<VirtualFileUrl> removedVirtualFileUrls) {
    }

    @Override
    public void dispose() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspaceModel/ide/impl/ExampleWorkspaceModelEventsHandler$Added;", "", "urls", "", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "(Ljava/util/Set;)V", "getUrls", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.projectModel.impl"})
    private static final class Added {
        @NotNull
        private final Set<VirtualFileUrl> urls;

        public Added(@NotNull Set<VirtualFileUrl> urls) {
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            this.urls = urls;
        }

        @NotNull
        public final Set<VirtualFileUrl> getUrls() {
            return this.urls;
        }

        @NotNull
        public final Set<VirtualFileUrl> component1() {
            return this.urls;
        }

        @NotNull
        public final Added copy(@NotNull Set<VirtualFileUrl> urls) {
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            return new Added(urls);
        }

        public static /* synthetic */ Added copy$default(Added added, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                set2 = added.urls;
            }
            return added.copy(set2);
        }

        @NotNull
        public String toString() {
            return "Added(urls=" + this.urls + ")";
        }

        public int hashCode() {
            return ((Object)this.urls).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Added)) {
                return false;
            }
            Added added = (Added)other;
            return Intrinsics.areEqual(this.urls, added.urls);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspaceModel/ide/impl/ExampleWorkspaceModelEventsHandler$Removed;", "", "urls", "", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "(Ljava/util/Set;)V", "getUrls", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.projectModel.impl"})
    private static final class Removed {
        @NotNull
        private final Set<VirtualFileUrl> urls;

        public Removed(@NotNull Set<VirtualFileUrl> urls) {
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            this.urls = urls;
        }

        @NotNull
        public final Set<VirtualFileUrl> getUrls() {
            return this.urls;
        }

        @NotNull
        public final Set<VirtualFileUrl> component1() {
            return this.urls;
        }

        @NotNull
        public final Removed copy(@NotNull Set<VirtualFileUrl> urls) {
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            return new Removed(urls);
        }

        public static /* synthetic */ Removed copy$default(Removed removed, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                set2 = removed.urls;
            }
            return removed.copy(set2);
        }

        @NotNull
        public String toString() {
            return "Removed(urls=" + this.urls + ")";
        }

        public int hashCode() {
            return ((Object)this.urls).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Removed)) {
                return false;
            }
            Removed removed = (Removed)other;
            return Intrinsics.areEqual(this.urls, removed.urls);
        }
    }
}

