/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.google.common.io.Files;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.workspaceModel.jps.serialization.impl.ModulePath;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistryKt;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.VirtualFileUrlWatcher;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u00a2\u0006\u0002\b\nJ@\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2.\u0010\u000f\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011`\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/FileReferenceInWorkspaceEntityUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "prepareChange$intellij_platform_lang_impl", "propertyChanged", "", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "changedModuleStorePaths", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lcom/intellij/openapi/module/Module;", "Ljava/nio/file/Path;", "Lkotlin/collections/ArrayList;", "updateModuleName", "oldUrl", "", "newUrl", "isImlFile", "", "intellij.platform.lang.impl"})
public final class FileReferenceInWorkspaceEntityUpdater {
    @NotNull
    private final Project project;

    public FileReferenceInWorkspaceEntityUpdater(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Nullable
    public final AsyncFileListener.ChangeApplier prepareChange$intellij_platform_lang_impl(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ArrayList<Pair<String, String>> changedUrlsList = new ArrayList<Pair<String, String>>();
        ArrayList<Pair<Module, Path>> changedModuleStorePaths = new ArrayList<Pair<Module, Path>>();
        for (VFileEvent vFileEvent : events) {
            String newUrl;
            Pair<String, String> pair;
            String oldUrl;
            VFileEvent vFileEvent2 = vFileEvent;
            if (!(vFileEvent2 instanceof VFilePropertyChangeEvent ? true : vFileEvent2 instanceof VFileMoveEvent)) continue;
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                this.propertyChanged((VFilePropertyChangeEvent)vFileEvent, changedModuleStorePaths);
            }
            if (Intrinsics.areEqual((Object)(oldUrl = (String)(pair = NonExistingWorkspaceRootsRegistryKt.getOldAndNewUrls(vFileEvent)).component1()), (Object)(newUrl = (String)pair.component2()))) continue;
            changedUrlsList.add((Pair<String, String>)new Pair((Object)oldUrl, (Object)newUrl));
        }
        if (changedUrlsList.isEmpty() && changedModuleStorePaths.isEmpty()) {
            return null;
        }
        return new AsyncFileListener.ChangeApplier(this, changedUrlsList, changedModuleStorePaths){
            final /* synthetic */ FileReferenceInWorkspaceEntityUpdater this$0;
            final /* synthetic */ ArrayList<Pair<String, String>> $changedUrlsList;
            final /* synthetic */ ArrayList<Pair<Module, Path>> $changedModuleStorePaths;
            {
                this.this$0 = $receiver;
                this.$changedUrlsList = $changedUrlsList;
                this.$changedModuleStorePaths = $changedModuleStorePaths;
            }

            public void beforeVfsChange() {
                VirtualFileUrlWatcher virtualFileUrlWatcher = VirtualFileUrlWatcher.Companion.getInstance(FileReferenceInWorkspaceEntityUpdater.access$getProject$p(this.this$0));
                Iterable $this$forEach$iv = this.$changedUrlsList;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    String oldUrl = (String)pair.component1();
                    String newUrl = (String)pair.component2();
                    virtualFileUrlWatcher.onVfsChange(oldUrl, newUrl);
                }
            }

            public void afterVfsChange() {
                Iterable $this$forEach$iv;
                Iterable iterable = this.$changedUrlsList;
                FileReferenceInWorkspaceEntityUpdater fileReferenceInWorkspaceEntityUpdater = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    String oldUrl = (String)pair.component1();
                    String newUrl = (String)pair.component2();
                    FileReferenceInWorkspaceEntityUpdater.access$updateModuleName(fileReferenceInWorkspaceEntityUpdater, oldUrl, newUrl);
                }
                $this$forEach$iv = this.$changedModuleStorePaths;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    Module module2 = (Module)pair.component1();
                    Path path2 = (Path)pair.component2();
                    ServiceKt.getStateStore(module2).setPath(path2);
                    ClasspathStorage.modulePathChanged(module2);
                }
                if (!((Collection)this.$changedModuleStorePaths).isEmpty()) {
                    ModuleManager.Companion.getInstance(FileReferenceInWorkspaceEntityUpdater.access$getProject$p(this.this$0)).incModificationCount();
                }
            }
        };
    }

    private final void updateModuleName(String oldUrl, String newUrl) {
        ModuleEntity unloadedModule;
        String newModuleName;
        if (!this.isImlFile(oldUrl) || !this.isImlFile(newUrl)) {
            return;
        }
        String oldModuleName = ModulePath.Companion.getModuleNameByFilePath(oldUrl);
        if (Intrinsics.areEqual((Object)oldModuleName, (Object)(newModuleName = ModulePath.Companion.getModuleNameByFilePath(newUrl)))) {
            return;
        }
        ModuleId oldModuleId = new ModuleId(oldModuleName);
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        ModuleEntity moduleEntity = (ModuleEntity)workspaceModel.getCurrentSnapshot().resolve((SymbolicEntityId)oldModuleId);
        String description = "Update module name when iml file is renamed";
        if (moduleEntity != null) {
            workspaceModel.updateProjectModel(description, (Function1<? super MutableEntityStorage, Unit>)((Function1)new Function1<MutableEntityStorage, Unit>(moduleEntity, newModuleName){
                final /* synthetic */ ModuleEntity $moduleEntity;
                final /* synthetic */ String $newModuleName;
                {
                    this.$moduleEntity = $moduleEntity;
                    this.$newModuleName = $newModuleName;
                    super(1);
                }

                public final void invoke(@NotNull MutableEntityStorage diff) {
                    Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
                    ModuleKt.modifyEntity((MutableEntityStorage)diff, (ModuleEntity)this.$moduleEntity, (Function1)((Function1)new Function1<ModuleEntity.Builder, Unit>(this.$newModuleName){
                        final /* synthetic */ String $newModuleName;
                        {
                            this.$newModuleName = $newModuleName;
                            super(1);
                        }

                        public final void invoke(@NotNull ModuleEntity.Builder $this$modifyEntity) {
                            Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                            $this$modifyEntity.setName(this.$newModuleName);
                        }
                    }));
                }
            }));
        }
        if ((unloadedModule = (ModuleEntity)workspaceModel.getCurrentSnapshotOfUnloadedEntities().resolve((SymbolicEntityId)oldModuleId)) != null) {
            workspaceModel.updateUnloadedEntities(description, (Function1<? super MutableEntityStorage, Unit>)((Function1)new Function1<MutableEntityStorage, Unit>(unloadedModule, newModuleName){
                final /* synthetic */ ModuleEntity $unloadedModule;
                final /* synthetic */ String $newModuleName;
                {
                    this.$unloadedModule = $unloadedModule;
                    this.$newModuleName = $newModuleName;
                    super(1);
                }

                public final void invoke(@NotNull MutableEntityStorage diff) {
                    Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
                    ModuleKt.modifyEntity((MutableEntityStorage)diff, (ModuleEntity)this.$unloadedModule, (Function1)((Function1)new Function1<ModuleEntity.Builder, Unit>(this.$newModuleName){
                        final /* synthetic */ String $newModuleName;
                        {
                            this.$newModuleName = $newModuleName;
                            super(1);
                        }

                        public final void invoke(@NotNull ModuleEntity.Builder $this$modifyEntity) {
                            Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                            $this$modifyEntity.setName(this.$newModuleName);
                        }
                    }));
                }
            }));
        }
    }

    private final void propertyChanged(VFilePropertyChangeEvent event, ArrayList<Pair<Module, Path>> changedModuleStorePaths) {
        if (!event.getFile().isDirectory() || event.getRequestor() instanceof StateStorage || !Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
            return;
        }
        Object object = event.getFile().getParent();
        if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
            return;
        }
        Object parentPath = object;
        String newAncestorPath = (String)parentPath + "/" + event.getNewValue();
        String oldAncestorPath = (String)parentPath + "/" + event.getOldValue();
        for (Module module2 : ModuleManager.Companion.getInstance(this.project).getModules()) {
            String moduleFilePath;
            if (!module2.isLoaded() || module2.isDisposed()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)module2.getModuleFilePath(), (String)"module.moduleFilePath");
            if (!FileUtil.isAncestor(oldAncestorPath, moduleFilePath, true)) continue;
            String[] stringArray = new String[]{FileUtil.getRelativePath(oldAncestorPath, moduleFilePath, '/')};
            changedModuleStorePaths.add((Pair<Module, Path>)new Pair((Object)module2, (Object)Paths.get(newAncestorPath, stringArray)));
        }
    }

    private final boolean isImlFile(String $this$isImlFile) {
        return Intrinsics.areEqual((Object)Files.getFileExtension((String)$this$isImlFile), (Object)"iml");
    }

    public static final /* synthetic */ Project access$getProject$p(FileReferenceInWorkspaceEntityUpdater $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$updateModuleName(FileReferenceInWorkspaceEntityUpdater $this, String oldUrl, String newUrl) {
        $this.updateModuleName(oldUrl, newUrl);
    }
}

