/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.workspaceModel.jps.JpsGlobalFileEntitySource;
import com.intellij.workspaceModel.ide.GlobalWorkspaceModelCache;
import com.intellij.workspaceModel.ide.JpsGlobalModelSynchronizer;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModel;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModelKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.GlobalLibraryTableBridge;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageKt;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ExcludeUrlEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRoot;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckerKt;
import com.intellij.workspaceModel.storage.impl.VersionedEntityStorageImpl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u0016\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u001eH\u0016J2\u0010*\u001a\u00020\u001e2 \u0010+\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.0,2\u0006\u00100\u001a\u00020#H\u0002J\u0016\u00101\u001a\u00020\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001e03H\u0002J\u0010\u00104\u001a\u00020\u001e2\u0006\u0010+\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u001e2\u0006\u0010+\u001a\u000205H\u0002J\u000e\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\fJ'\u00109\u001a\u00020\u001e2\u000b\u0010:\u001a\u00070;\u00a2\u0006\u0002\b<2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001e0\u000eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModel;", "Lcom/intellij/openapi/Disposable;", "()V", "currentSnapshot", "Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "getCurrentSnapshot", "()Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "entityStorage", "Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "getEntityStorage", "()Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "filteredProject", "Lcom/intellij/openapi/project/Project;", "globalEntitiesFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "", "globalWorkspaceModelCache", "Lcom/intellij/workspaceModel/ide/GlobalWorkspaceModelCache;", "isFromGlobalWorkspaceModel", "isFromGlobalWorkspaceModel$intellij_platform_projectModel_impl", "()Z", "setFromGlobalWorkspaceModel$intellij_platform_projectModel_impl", "(Z)V", "<set-?>", "loadedFromCache", "getLoadedFromCache", "modelVersionUpdate", "Ljava/util/concurrent/atomic/AtomicLong;", "applyStateToProject", "", "targetProject", "applyStateToProjectBuilder", "project", "targetBuilder", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "copyEntitiesToEmptyStorage", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "vfuManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "dispose", "initializeBridges", "change", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "builder", "logErrorOnEventHandling", "action", "Lkotlin/Function0;", "onBeforeChanged", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "onChanged", "syncEntitiesWithProject", "sourceProject", "updateModel", "description", "", "Lorg/jetbrains/annotations/NonNls;", "updater", "Companion", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGlobalWorkspaceModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalWorkspaceModel.kt\ncom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n12#2,5:240\n12#2,5:281\n12#2,5:286\n10#2:303\n17#3,6:245\n17#3,5:251\n17#3,6:256\n17#3,6:262\n17#3,6:268\n17#3,6:274\n22#3:280\n13579#4,2:291\n1295#5:293\n1296#5:302\n1549#6:294\n1620#6,3:295\n1549#6:298\n1620#6,3:299\n*S KotlinDebug\n*F\n+ 1 GlobalWorkspaceModel.kt\ncom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModel\n*L\n54#1:240,5\n125#1:281,5\n126#1:286,5\n220#1:303\n61#1:245,6\n95#1:251,5\n98#1:256,6\n102#1:262,6\n105#1:268,6\n110#1:274,6\n95#1:280\n151#1:291,2\n190#1:293\n190#1:302\n192#1:294\n192#1:295,3\n197#1:298\n197#1:299,3\n*E\n"})
public final class GlobalWorkspaceModel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Project filteredProject;
    private boolean isFromGlobalWorkspaceModel;
    @Nullable
    private final GlobalWorkspaceModelCache globalWorkspaceModelCache = GlobalWorkspaceModelCache.Companion.getInstance();
    @NotNull
    private final Function1<EntitySource, Boolean> globalEntitiesFilter = globalEntitiesFilter.1.INSTANCE;
    @NotNull
    private final VersionedEntityStorageImpl entityStorage;
    private boolean loadedFromCache;
    @NotNull
    private final AtomicLong modelVersionUpdate = new AtomicLong(-1L);
    @NotNull
    private static final Logger LOG;

    public GlobalWorkspaceModel() {
        MutableEntityStorage mutableEntityStorage;
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Loading global workspace model", e$iv);
        }
        GlobalWorkspaceModelCache cache2 = this.globalWorkspaceModelCache;
        if (cache2 != null) {
            MutableEntityStorage mutableEntityStorage2;
            Activity activity = StartUpMeasurer.startActivity("global cache loading");
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(\"global cache loading\")");
            Activity activity2 = activity;
            MutableEntityStorage previousStorage = null;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            EntityStorage entityStorage = cache2.loadCache();
            previousStorage = entityStorage != null ? EntityStorageKt.toBuilder((EntityStorage)entityStorage) : null;
            long loadingCacheTime = System.currentTimeMillis() - start$iv;
            if (previousStorage == null) {
                mutableEntityStorage2 = MutableEntityStorage.Companion.create();
            } else {
                LOG.info("Load global workspace model from cache in " + loadingCacheTime + " ms");
                this.loadedFromCache = true;
                mutableEntityStorage2 = previousStorage;
            }
            MutableEntityStorage storage = mutableEntityStorage2;
            activity2.end();
            mutableEntityStorage = storage;
        } else {
            mutableEntityStorage = MutableEntityStorage.Companion.create();
        }
        MutableEntityStorage mutableEntityStorage3 = mutableEntityStorage;
        this.entityStorage = new VersionedEntityStorageImpl(EntityStorageSnapshot.Companion.empty());
        Function0<Unit> callback = JpsGlobalModelSynchronizer.Companion.getInstance().loadInitialState(mutableEntityStorage3, (VersionedEntityStorage)this.entityStorage, this.loadedFromCache);
        this.entityStorage.replaceSilently(mutableEntityStorage3.toSnapshot());
        callback.invoke();
    }

    public final boolean isFromGlobalWorkspaceModel$intellij_platform_projectModel_impl() {
        return this.isFromGlobalWorkspaceModel;
    }

    public final void setFromGlobalWorkspaceModel$intellij_platform_projectModel_impl(boolean bl) {
        this.isFromGlobalWorkspaceModel = bl;
    }

    @NotNull
    public final VersionedEntityStorageImpl getEntityStorage() {
        return this.entityStorage;
    }

    @NotNull
    public final EntityStorageSnapshot getCurrentSnapshot() {
        return this.entityStorage.getCurrent();
    }

    public final boolean getLoadedFromCache() {
        return this.loadedFromCache;
    }

    public final void updateModel(@NotNull String description, @NotNull Function1<? super MutableEntityStorage, Unit> updater2) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(updater2, (String)"updater");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.modelVersionUpdate.get() == this.entityStorage.getPointer().getVersion()) {
            LOG.error("Trying to update global model twice from the same version. Maybe recursive call of 'updateModel'?");
        }
        this.modelVersionUpdate.set(this.entityStorage.getPointer().getVersion());
        Ref.LongRef updateTimeMillis = new Ref.LongRef();
        Ref.LongRef collectChangesTimeMillis = new Ref.LongRef();
        Ref.LongRef initializingTimeMillis = new Ref.LongRef();
        Ref.LongRef toSnapshotTimeMillis = new Ref.LongRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        EntityStorageSnapshot before = this.entityStorage.getCurrent();
        MutableEntityStorage builder2 = MutableEntityStorage.Companion.from((EntityStorage)before);
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        Ref.LongRef longRef = updateTimeMillis;
        boolean bl2 = false;
        updater2.invoke((Object)builder2);
        longRef.element = System.currentTimeMillis() - start$iv2;
        Map changes = null;
        boolean $i$f$measureTimeMillis3 = false;
        long start$iv3 = System.currentTimeMillis();
        longRef = collectChangesTimeMillis;
        boolean bl3 = false;
        changes = builder2.collectChanges((EntityStorage)before);
        longRef.element = System.currentTimeMillis() - start$iv3;
        $i$f$measureTimeMillis3 = false;
        start$iv3 = System.currentTimeMillis();
        longRef = initializingTimeMillis;
        boolean bl4 = false;
        this.initializeBridges(changes, builder2);
        longRef.element = System.currentTimeMillis() - start$iv3;
        EntityStorageSnapshot newStorage = null;
        boolean $i$f$measureTimeMillis4 = false;
        long start$iv4 = System.currentTimeMillis();
        longRef = toSnapshotTimeMillis;
        boolean bl5 = false;
        newStorage = builder2.toSnapshot();
        longRef.element = System.currentTimeMillis() - start$iv4;
        if (Registry.is("ide.workspace.model.assertions.on.update", false)) {
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)before));
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)newStorage));
        }
        this.entityStorage.replace(newStorage, changes, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(@NotNull VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                GlobalWorkspaceModel.access$onBeforeChanged((GlobalWorkspaceModel)this.receiver, p0);
            }
        }, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(@NotNull VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                GlobalWorkspaceModel.access$onChanged((GlobalWorkspaceModel)this.receiver, p0);
            }
        });
        long generalTime2 = System.currentTimeMillis() - start$iv;
        LOG.info("Global model updated to version " + this.entityStorage.getPointer().getVersion() + " in " + generalTime2 + " ms: " + description);
        if (generalTime2 > 1000L) {
            LOG.info("Global model update details: Updater code: " + updateTimeMillis.element + " ms, Collect changes: " + collectChangesTimeMillis.element + " ms");
            LOG.info("Bridge initialization: " + initializingTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " ms");
        } else {
            Logger logger;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl6 = false;
                logger.debug("Global model update details: Updater code: " + updateTimeMillis.element + " ms, Collect changes: " + collectChangesTimeMillis.element + " ms", e$iv);
            }
            $this$debug_u24default$iv = LOG;
            e$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl7 = false;
                logger.debug("Bridge initialization: " + initializingTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " ms", e$iv);
            }
        }
    }

    @Override
    public void dispose() {
    }

    private final void initializeBridges(Map<Class<?>, ? extends List<? extends EntityChange<?>>> change2, MutableEntityStorage builder2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(change2, builder2){
            final /* synthetic */ Map<Class<?>, List<EntityChange<?>>> $change;
            final /* synthetic */ MutableEntityStorage $builder;
            {
                this.$change = $change;
                this.$builder = $builder;
                super(0);
            }

            public final void invoke() {
                GlobalLibraryTableBridge.Companion.getInstance().initializeLibraryBridges(this.$change, this.$builder);
            }
        }));
    }

    private final void onBeforeChanged(VersionedStorageChange change2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GlobalLibraryTableBridge.Companion.getInstance().handleBeforeChangeEvents(change2);
    }

    private final void onChanged(VersionedStorageChange change2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GlobalLibraryTableBridge.Companion.getInstance().handleChangedEvents(change2);
        GlobalWorkspaceModelCache globalWorkspaceModelCache = this.globalWorkspaceModelCache;
        if (globalWorkspaceModelCache != null) {
            globalWorkspaceModelCache.scheduleCacheSave();
        }
        this.isFromGlobalWorkspaceModel = true;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project2 = (Project)element$iv;
            boolean bl = false;
            if (project2.isDisposed()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            this.applyStateToProject(project2);
        }
        this.isFromGlobalWorkspaceModel = false;
    }

    public final void applyStateToProject(@NotNull Project targetProject) {
        Intrinsics.checkNotNullParameter((Object)targetProject, (String)"targetProject");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (targetProject == this.filteredProject) {
            return;
        }
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(targetProject);
        MutableEntityStorage entitiesCopyAtBuilder = this.copyEntitiesToEmptyStorage((EntityStorage)this.entityStorage.getCurrent(), VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, targetProject));
        workspaceModel.updateProjectModel("Sync global entities with project: " + targetProject.getName(), (Function1<? super MutableEntityStorage, Unit>)((Function1)new Function1<MutableEntityStorage, Unit>(this, entitiesCopyAtBuilder){
            final /* synthetic */ GlobalWorkspaceModel this$0;
            final /* synthetic */ MutableEntityStorage $entitiesCopyAtBuilder;
            {
                this.this$0 = $receiver;
                this.$entitiesCopyAtBuilder = $entitiesCopyAtBuilder;
                super(1);
            }

            public final void invoke(@NotNull MutableEntityStorage builder2) {
                Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                builder2.replaceBySource(GlobalWorkspaceModel.access$getGlobalEntitiesFilter$p(this.this$0), (EntityStorage)this.$entitiesCopyAtBuilder);
            }
        }));
    }

    public final void applyStateToProjectBuilder(@NotNull Project project2, @NotNull MutableEntityStorage targetBuilder) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetBuilder, (String)"targetBuilder");
        LOG.info("Sync global entities with mutable entity storage");
        targetBuilder.replaceBySource(this.globalEntitiesFilter, (EntityStorage)this.copyEntitiesToEmptyStorage((EntityStorage)this.entityStorage.getCurrent(), VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, project2)));
    }

    public final void syncEntitiesWithProject(@NotNull Project sourceProject) {
        Intrinsics.checkNotNullParameter((Object)sourceProject, (String)"sourceProject");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.filteredProject = sourceProject;
        MutableEntityStorage entitiesCopyAtBuilder = this.copyEntitiesToEmptyStorage((EntityStorage)WorkspaceModel.Companion.getInstance(sourceProject).getCurrentSnapshot(), VirtualFileUrlManagerUtil.getGlobalInstance(VirtualFileUrlManager.Companion));
        this.updateModel("Sync entities from project " + sourceProject.getName() + " with global storage", (Function1<? super MutableEntityStorage, Unit>)((Function1)new Function1<MutableEntityStorage, Unit>(this, entitiesCopyAtBuilder){
            final /* synthetic */ GlobalWorkspaceModel this$0;
            final /* synthetic */ MutableEntityStorage $entitiesCopyAtBuilder;
            {
                this.this$0 = $receiver;
                this.$entitiesCopyAtBuilder = $entitiesCopyAtBuilder;
                super(1);
            }

            public final void invoke(@NotNull MutableEntityStorage builder2) {
                Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                builder2.replaceBySource(GlobalWorkspaceModel.access$getGlobalEntitiesFilter$p(this.this$0), (EntityStorage)this.$entitiesCopyAtBuilder);
            }
        }));
        this.filteredProject = null;
    }

    /*
     * WARNING - void declaration
     */
    private final MutableEntityStorage copyEntitiesToEmptyStorage(EntityStorage storage, VirtualFileUrlManager vfuManager) {
        MutableEntityStorage mutableEntityStorage = MutableEntityStorage.Companion.create();
        Sequence $this$forEach$iv = storage.entities(LibraryEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            LibraryEntity libraryEntity = (LibraryEntity)element$iv;
            boolean bl = false;
            if (!((Boolean)this.globalEntitiesFilter.invoke((Object)libraryEntity.getEntitySource())).booleanValue()) continue;
            Iterable $this$map$iv = libraryEntity.getRoots();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void root;
                LibraryRoot libraryRoot = (LibraryRoot)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new LibraryRoot(GlobalWorkspaceModelKt.access$createCopyAtManager(root.getUrl(), vfuManager), root.getType(), root.getInclusionOptions()));
            }
            List libraryRootsCopy = (List)destination$iv$iv;
            EntitySource entitySource = libraryEntity.getEntitySource();
            Intrinsics.checkNotNull((Object)entitySource, (String)"null cannot be cast to non-null type com.intellij.platform.workspaceModel.jps.JpsGlobalFileEntitySource");
            JpsGlobalFileEntitySource entitySourceCopy = GlobalWorkspaceModelKt.access$copy((JpsGlobalFileEntitySource)entitySource, vfuManager);
            Iterable $this$map$iv2 = libraryEntity.getExcludedRoots();
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExcludeUrlEntity excludeUrlEntity = (ExcludeUrlEntity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(GlobalWorkspaceModelKt.access$copy((ExcludeUrlEntity)it, (EntitySource)entitySourceCopy, vfuManager));
            }
            List excludedRootsCopy = (List)destination$iv$iv2;
            LibraryPropertiesEntity libraryPropertiesEntity = libraryEntity.getLibraryProperties();
            LibraryPropertiesEntity libraryPropertiesCopy = libraryPropertiesEntity != null ? GlobalWorkspaceModelKt.access$copy(libraryPropertiesEntity, (EntitySource)entitySourceCopy) : null;
            LibraryEntity libraryEntityCopy2 = LibraryEntity.Companion.create(libraryEntity.getName(), libraryEntity.getTableId(), libraryRootsCopy, (EntitySource)entitySourceCopy, (Function1)new Function1<LibraryEntity.Builder, Unit>((List<? extends ExcludeUrlEntity>)excludedRootsCopy, libraryPropertiesCopy){
                final /* synthetic */ List<ExcludeUrlEntity> $excludedRootsCopy;
                final /* synthetic */ LibraryPropertiesEntity $libraryPropertiesCopy;
                {
                    this.$excludedRootsCopy = $excludedRootsCopy;
                    this.$libraryPropertiesCopy = $libraryPropertiesCopy;
                    super(1);
                }

                public final void invoke(@NotNull LibraryEntity.Builder $this$invoke) {
                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                    $this$invoke.setExcludedRoots(this.$excludedRootsCopy);
                    $this$invoke.setLibraryProperties(this.$libraryPropertiesCopy);
                }
            });
            mutableEntityStorage.addEntity((WorkspaceEntity)libraryEntityCopy2);
            LibraryBridge libraryBridge = (LibraryBridge)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap(storage).getDataByEntity((WorkspaceEntity)libraryEntity);
            if (libraryBridge == null) continue;
            ProjectLibraryTableBridgeImpl.Companion.getMutableLibraryMap(mutableEntityStorage).addIfAbsent((WorkspaceEntity)libraryEntityCopy2, (Object)libraryBridge);
        }
        return mutableEntityStorage;
    }

    private final void logErrorOnEventHandling(Function0<Unit> action2) {
        try {
            action2.invoke();
        }
        catch (Throwable e) {
            String message = "Exception at Workspace Model event handling";
            LOG.error(message, e);
        }
    }

    public static final /* synthetic */ Function1 access$getGlobalEntitiesFilter$p(GlobalWorkspaceModel $this) {
        return $this.globalEntitiesFilter;
    }

    public static final /* synthetic */ void access$onBeforeChanged(GlobalWorkspaceModel $this, VersionedStorageChange change2) {
        $this.onBeforeChanged(change2);
    }

    public static final /* synthetic */ void access$onChanged(GlobalWorkspaceModel $this, VersionedStorageChange change2) {
        $this.onChanged(change2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GlobalWorkspaceModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModel;", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nGlobalWorkspaceModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalWorkspaceModel.kt\ncom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModel$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,239:1\n29#2,3:240\n*S KotlinDebug\n*F\n+ 1 GlobalWorkspaceModel.kt\ncom/intellij/workspaceModel/ide/impl/GlobalWorkspaceModel$Companion\n*L\n221#1:240,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GlobalWorkspaceModel getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
            ComponentManager $this$service$iv = application;
            boolean $i$f$service = false;
            Class<GlobalWorkspaceModel> serviceClass$iv = GlobalWorkspaceModel.class;
            GlobalWorkspaceModel globalWorkspaceModel = $this$service$iv.getService(serviceClass$iv);
            if (globalWorkspaceModel == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return globalWorkspaceModel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

