/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.platform.workspaceModel.jps.JpsEntitySourceFactory;
import com.intellij.platform.workspaceModel.jps.JpsFileEntitySource;
import com.intellij.platform.workspaceModel.jps.JpsGlobalFileEntitySource;
import com.intellij.platform.workspaceModel.jps.JpsImportedEntitySource;
import com.intellij.platform.workspaceModel.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspaceModel.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspaceModel.jps.serialization.impl.FileInDirectorySourceNames;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocationUtilKt;
import com.intellij.workspaceModel.ide.NonPersistentEntitySource;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0006\u0010\t\u001a\u00020\u0004J8\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J0\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0010J$\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/workspaceModel/ide/impl/LegacyBridgeJpsEntitySourceFactory;", "", "()V", "createEntitySourceForArtifact", "Lcom/intellij/workspaceModel/storage/EntitySource;", "project", "Lcom/intellij/openapi/project/Project;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "createEntitySourceForGlobalLibrary", "createEntitySourceForModule", "baseModuleDir", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "fileInDirectoryNames", "Lcom/intellij/platform/workspaceModel/jps/serialization/impl/FileInDirectorySourceNames;", "moduleFileName", "", "createEntitySourceForProjectLibrary", "fileName", "createImportedEntitySource", "internalSource", "Lcom/intellij/platform/workspaceModel/jps/JpsFileEntitySource;", "createInternalEntitySourceForModule", "createInternalEntitySourceForProjectLibrary", "intellij.platform.projectModel.impl"})
public final class LegacyBridgeJpsEntitySourceFactory {
    @NotNull
    public static final LegacyBridgeJpsEntitySourceFactory INSTANCE = new LegacyBridgeJpsEntitySourceFactory();

    private LegacyBridgeJpsEntitySourceFactory() {
    }

    @NotNull
    public final EntitySource createEntitySourceForModule(@NotNull Project project2, @NotNull VirtualFileUrl baseModuleDir, @Nullable ProjectModelExternalSource externalSource, @Nullable FileInDirectorySourceNames fileInDirectoryNames, @Nullable String moduleFileName) {
        JpsFileEntitySource jpsFileEntitySource;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseModuleDir, (String)"baseModuleDir");
        if (fileInDirectoryNames != null && moduleFileName != null) {
            JpsProjectFileEntitySource.FileInDirectory fileInDirectory = fileInDirectoryNames.findSource(ModuleEntity.class, moduleFileName);
            jpsFileEntitySource = fileInDirectory != null ? (JpsFileEntitySource)fileInDirectory : this.createInternalEntitySourceForModule(project2, baseModuleDir);
        } else {
            jpsFileEntitySource = this.createInternalEntitySourceForModule(project2, baseModuleDir);
        }
        JpsFileEntitySource internalSource = jpsFileEntitySource;
        return this.createImportedEntitySource(project2, externalSource, internalSource);
    }

    public static /* synthetic */ EntitySource createEntitySourceForModule$default(LegacyBridgeJpsEntitySourceFactory legacyBridgeJpsEntitySourceFactory, Project project2, VirtualFileUrl virtualFileUrl, ProjectModelExternalSource projectModelExternalSource, FileInDirectorySourceNames fileInDirectorySourceNames, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            fileInDirectorySourceNames = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return legacyBridgeJpsEntitySourceFactory.createEntitySourceForModule(project2, virtualFileUrl, projectModelExternalSource, fileInDirectorySourceNames, string2);
    }

    private final EntitySource createImportedEntitySource(Project project2, ProjectModelExternalSource externalSource, JpsFileEntitySource internalSource) {
        JpsFileEntitySource jpsFileEntitySource = internalSource;
        if (jpsFileEntitySource == null) {
            return NonPersistentEntitySource.INSTANCE;
        }
        JpsFileEntitySource internalFile = jpsFileEntitySource;
        if (externalSource == null) {
            return (EntitySource)internalFile;
        }
        String string2 = externalSource.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalSource.id");
        return (EntitySource)new JpsImportedEntitySource(internalFile, string2, ProjectUtilCore.isExternalStorageEnabled(project2));
    }

    private final JpsFileEntitySource createInternalEntitySourceForModule(Project project2, VirtualFileUrl baseModuleDir) {
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation(project2);
        if (jpsProjectConfigLocation == null) {
            return null;
        }
        JpsProjectConfigLocation location2 = jpsProjectConfigLocation;
        return (JpsFileEntitySource)new JpsProjectFileEntitySource.FileInDirectory(baseModuleDir, location2);
    }

    @NotNull
    public final EntitySource createEntitySourceForProjectLibrary(@NotNull Project project2, @Nullable ProjectModelExternalSource externalSource, @Nullable FileInDirectorySourceNames fileInDirectoryNames, @Nullable String fileName) {
        JpsFileEntitySource jpsFileEntitySource;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (fileInDirectoryNames != null && fileName != null) {
            JpsProjectFileEntitySource.FileInDirectory fileInDirectory = fileInDirectoryNames.findSource(LibraryEntity.class, fileName);
            jpsFileEntitySource = fileInDirectory != null ? (JpsFileEntitySource)fileInDirectory : this.createInternalEntitySourceForProjectLibrary(project2);
        } else {
            jpsFileEntitySource = this.createInternalEntitySourceForProjectLibrary(project2);
        }
        JpsFileEntitySource internalEntitySource = jpsFileEntitySource;
        return this.createImportedEntitySource(project2, externalSource, internalEntitySource);
    }

    public static /* synthetic */ EntitySource createEntitySourceForProjectLibrary$default(LegacyBridgeJpsEntitySourceFactory legacyBridgeJpsEntitySourceFactory, Project project2, ProjectModelExternalSource projectModelExternalSource, FileInDirectorySourceNames fileInDirectorySourceNames, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            fileInDirectorySourceNames = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return legacyBridgeJpsEntitySourceFactory.createEntitySourceForProjectLibrary(project2, projectModelExternalSource, fileInDirectorySourceNames, string2);
    }

    @NotNull
    public final EntitySource createEntitySourceForGlobalLibrary() {
        VirtualFileUrlManager virtualFileUrlManager = VirtualFileUrlManagerUtil.getGlobalInstance(VirtualFileUrlManager.Companion);
        String string2 = PathManager.getOptionsFile("applicationLibraries").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOptionsFile(JpsGlobal\u2026S_FILE_NAME).absolutePath");
        VirtualFileUrl globalLibrariesFile = virtualFileUrlManager.fromUrl(string2);
        return (EntitySource)new JpsGlobalFileEntitySource(globalLibrariesFile);
    }

    private final JpsFileEntitySource createInternalEntitySourceForProjectLibrary(Project project2) {
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation(project2);
        if (jpsProjectConfigLocation == null) {
            return null;
        }
        JpsProjectConfigLocation location2 = jpsProjectConfigLocation;
        return JpsEntitySourceFactory.INSTANCE.createJpsEntitySourceForProjectLibrary(location2);
    }

    @NotNull
    public final EntitySource createEntitySourceForArtifact(@NotNull Project project2, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation(project2);
        if (jpsProjectConfigLocation == null) {
            return NonPersistentEntitySource.INSTANCE;
        }
        JpsProjectConfigLocation location2 = jpsProjectConfigLocation;
        JpsFileEntitySource internalFile = JpsEntitySourceFactory.INSTANCE.createJpsEntitySourceForArtifact(location2);
        if (externalSource == null) {
            return (EntitySource)internalFile;
        }
        String string2 = externalSource.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalSource.id");
        return (EntitySource)new JpsImportedEntitySource(internalFile, string2, ProjectUtilCore.isExternalStorageEnabled(project2));
    }
}

