/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlImpl;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlManagerImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/workspaceModel/ide/impl/VirtualFileUrlBridge;", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlImpl;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "id", "", "manager", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;", "(ILcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "timestampOfCachedFiles", "", "equals", "", "other", "", "findVirtualFile", "getFile", "hashCode", "isValid", "toString", "", "intellij.platform.projectModel.impl"})
public final class VirtualFileUrlBridge
extends VirtualFileUrlImpl
implements VirtualFilePointer {
    @Nullable
    private volatile VirtualFile file;
    private volatile long timestampOfCachedFiles;

    public VirtualFileUrlBridge(int id, @NotNull VirtualFileUrlManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(id, manager);
        this.timestampOfCachedFiles = -1L;
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        return this.findVirtualFile();
    }

    @Override
    public boolean isValid() {
        return this.findVirtualFile() != null;
    }

    @NotNull
    public String toString() {
        return this.getUrl();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.VirtualFileUrlBridge");
        VirtualFileUrlBridge cfr_ignored_0 = (VirtualFileUrlBridge)other;
        return this.getId() == ((VirtualFileUrlBridge)other).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    private final VirtualFile findVirtualFile() {
        VirtualFile virtualFile2;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        long timestamp = this.timestampOfCachedFiles;
        VirtualFile cachedResults = this.file;
        if (timestamp == fileManager.getModificationCount()) {
            virtualFile2 = cachedResults;
        } else {
            this.file = fileManager.findFileByUrl(this.getUrl());
            this.timestampOfCachedFiles = fileManager.getModificationCount();
            virtualFile2 = this.file;
        }
        return virtualFile2;
    }
}

