/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl;
import com.intellij.workspaceModel.ide.BuilderSnapshot;
import com.intellij.workspaceModel.ide.StorageReplacement;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelCache;
import com.intellij.workspaceModel.ide.WorkspaceModelPreUpdateHandler;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.EntityTracingLogger;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelInitialTestContent;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.GlobalLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.GlobalLibraryTableBridge;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageKt;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckerKt;
import com.intellij.workspaceModel.storage.impl.VersionedEntityStorageImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0001HB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020$J2\u0010)\u001a\u00020$2 \u0010*\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030,\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.0-0+2\u0006\u0010/\u001a\u000200H\u0002J\u0016\u00101\u001a\u00020$2\f\u00102\u001a\b\u0012\u0004\u0012\u00020$03H\u0002J\u0010\u00104\u001a\u00020$2\u0006\u0010*\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020$2\u0006\u0010*\u001a\u000205H\u0002J\u0010\u00107\u001a\u00020$2\u0006\u0010*\u001a\u000205H\u0002J\u0010\u00108\u001a\u00020$2\u0006\u0010*\u001a\u000205H\u0002J\u0018\u00109\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010:\u001a\u000200H\u0017J\u000e\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=J\u0018\u0010>\u001a\u00020$2\u0006\u0010?\u001a\u00020@2\u0006\u0010/\u001a\u000200H\u0002J'\u0010A\u001a\u00020$2\u000b\u0010B\u001a\u00070\u001c\u00a2\u0006\u0002\bC2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020$0EJ'\u0010F\u001a\u00020$2\u000b\u0010B\u001a\u00070\u001c\u00a2\u0006\u0002\bC2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020$0EJ)\u0010G\u001a\u00020$2\u000b\u0010B\u001a\u00070\u001c\u00a2\u0006\u0002\bC2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020$0EH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0018\"\u0004\b\"\u0010\u001a\u00a8\u0006I"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl;", "Lcom/intellij/workspaceModel/ide/WorkspaceModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentSnapshot", "Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "getCurrentSnapshot", "()Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "currentSnapshotOfUnloadedEntities", "getCurrentSnapshotOfUnloadedEntities", "entityStorage", "Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "getEntityStorage", "()Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "entityTracer", "Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger;", "getEntityTracer", "()Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger;", "<set-?>", "", "loadedFromCache", "getLoadedFromCache", "()Z", "setLoadedFromCache", "(Z)V", "onChangedMethodName", "", "unloadedEntitiesStorage", "updateModelMethodName", "updateModelSilentMethodName", "userWarningLoggingLevel", "getUserWarningLoggingLevel", "setUserWarningLoggingLevel", "checkRecursiveUpdate", "", "dispose", "getBuilderSnapshot", "Lcom/intellij/workspaceModel/ide/BuilderSnapshot;", "ignoreCache", "initializeBridges", "change", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "builder", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "logErrorOnEventHandling", "action", "Lkotlin/Function0;", "onBeforeChanged", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "onBeforeUnloadedEntitiesChanged", "onChanged", "onUnloadedEntitiesChanged", "prepareModel", "storage", "replaceProjectModel", "replacement", "Lcom/intellij/workspaceModel/ide/StorageReplacement;", "startPreUpdateHandlers", "before", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "updateProjectModel", "description", "Lorg/jetbrains/annotations/NonNls;", "updater", "Lkotlin/Function1;", "updateProjectModelSilent", "updateUnloadedEntities", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nWorkspaceModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceModelImpl.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,335:1\n12#2,5:336\n12#2,5:383\n12#2,5:388\n12#2,5:411\n10#2:425\n17#3,6:341\n17#3,5:347\n17#3,6:352\n17#3,6:358\n17#3,6:364\n17#3,6:370\n17#3,6:376\n22#3:382\n17#3,5:393\n17#3,6:398\n17#3,6:404\n22#3:410\n17#3,6:417\n1#4:416\n1855#5,2:423\n*S KotlinDebug\n*F\n+ 1 WorkspaceModelImpl.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl\n*L\n53#1:336,5\n150#1:383,5\n153#1:388,5\n189#1:411,5\n330#1:425\n66#1:341,6\n115#1:347,5\n118#1:352,6\n121#1:358,6\n126#1:364,6\n129#1:370,6\n134#1:376,6\n115#1:382\n169#1:393,5\n172#1:398,6\n175#1:404,6\n169#1:410\n213#1:417,6\n307#1:423,2\n*E\n"})
public class WorkspaceModelImpl
implements WorkspaceModel,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private volatile boolean loadedFromCache;
    @NotNull
    private final VersionedEntityStorageImpl entityStorage;
    @NotNull
    private final VersionedEntityStorageImpl unloadedEntitiesStorage;
    @NotNull
    private final EntityTracingLogger entityTracer;
    private boolean userWarningLoggingLevel;
    @NotNull
    private final String updateModelMethodName;
    @NotNull
    private final String updateModelSilentMethodName;
    @NotNull
    private final String onChangedMethodName;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final ExtensionPointName<WorkspaceModelPreUpdateHandler> PRE_UPDATE_HANDLERS;
    private static final int PRE_UPDATE_LOOP_BLOCK = 100;

    public WorkspaceModelImpl(@NotNull Project project2) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.entityTracer = new EntityTracingLogger();
        this.updateModelMethodName = "updateProjectModel";
        this.updateModelSilentMethodName = "updateProjectModelSilent";
        this.onChangedMethodName = "onChanged";
        Logger $this$debug_u24default$iv = log;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Loading workspace model", e$iv);
        }
        EntityStorageSnapshot initialContent = WorkspaceModelInitialTestContent.INSTANCE.pop$intellij_platform_projectModel_impl();
        WorkspaceModelCache cache2 = WorkspaceModelCache.Companion.getInstance(this.project);
        if (initialContent != null) {
            this.loadedFromCache = initialContent != EntityStorageSnapshot.Companion.empty();
            pair = TuplesKt.to((Object)EntityStorageKt.toBuilder((EntityStorage)((EntityStorage)initialContent)), (Object)EntityStorageSnapshot.Companion.empty());
        } else if (cache2 != null) {
            MutableEntityStorage mutableEntityStorage;
            Activity activity = StartUpMeasurer.startActivity("cache loading");
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(\"cache loading\")");
            Activity activity2 = activity;
            MutableEntityStorage previousStorage = null;
            EntityStorage previousStorageForUnloaded = null;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            EntityStorage entityStorage = cache2.loadCache();
            previousStorage = entityStorage != null ? EntityStorageKt.toBuilder((EntityStorage)entityStorage) : null;
            EntityStorage entityStorage2 = cache2.loadUnloadedEntitiesCache();
            if (entityStorage2 == null || (entityStorage2 = entityStorage2.toSnapshot()) == null) {
                entityStorage2 = EntityStorageSnapshot.Companion.empty();
            }
            previousStorageForUnloaded = entityStorage2;
            long loadingCacheTime = System.currentTimeMillis() - start$iv;
            if (previousStorage == null) {
                mutableEntityStorage = MutableEntityStorage.Companion.create();
            } else {
                log.info("Load workspace model from cache in " + loadingCacheTime + " ms");
                this.loadedFromCache = true;
                this.entityTracer.printInfoAboutTracedEntity((EntityStorage)previousStorage, "cache");
                mutableEntityStorage = previousStorage;
            }
            MutableEntityStorage storage = mutableEntityStorage;
            activity2.end();
            pair = TuplesKt.to((Object)storage, (Object)previousStorageForUnloaded);
        } else {
            pair = TuplesKt.to((Object)MutableEntityStorage.Companion.create(), (Object)EntityStorageSnapshot.Companion.empty());
        }
        Pair pair2 = pair;
        MutableEntityStorage projectEntities = (MutableEntityStorage)pair2.component1();
        EntityStorageSnapshot unloadedEntities = (EntityStorageSnapshot)pair2.component2();
        this.prepareModel(this.project, projectEntities);
        this.entityStorage = new VersionedEntityStorageImpl(projectEntities.toSnapshot());
        this.unloadedEntitiesStorage = new VersionedEntityStorageImpl(unloadedEntities);
        this.entityTracer.subscribe(this.project);
    }

    public final boolean getLoadedFromCache() {
        return this.loadedFromCache;
    }

    protected final void setLoadedFromCache(boolean bl) {
        this.loadedFromCache = bl;
    }

    @NotNull
    public final VersionedEntityStorageImpl getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    @NotNull
    public EntityStorageSnapshot getCurrentSnapshot() {
        return this.entityStorage.getCurrent();
    }

    @NotNull
    public final EntityTracingLogger getEntityTracer() {
        return this.entityTracer;
    }

    public final boolean getUserWarningLoggingLevel() {
        return this.userWarningLoggingLevel;
    }

    @TestOnly
    public final void setUserWarningLoggingLevel(boolean bl) {
        this.userWarningLoggingLevel = bl;
    }

    @Override
    @NotNull
    public EntityStorageSnapshot getCurrentSnapshotOfUnloadedEntities() {
        return this.unloadedEntitiesStorage.getCurrent();
    }

    @ApiStatus.Internal
    public void prepareModel(@NotNull Project project2, @NotNull MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
    }

    public final void ignoreCache() {
        this.loadedFromCache = false;
    }

    @Override
    public final void updateProjectModel(@NotNull String description, @NotNull Function1<? super MutableEntityStorage, Unit> updater2) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(updater2, (String)"updater");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.checkRecursiveUpdate();
        Ref.LongRef updateTimeMillis = new Ref.LongRef();
        Ref.LongRef preHandlersTimeMillis = new Ref.LongRef();
        Ref.LongRef collectChangesTimeMillis = new Ref.LongRef();
        Ref.LongRef initializingTimeMillis = new Ref.LongRef();
        Ref.LongRef toSnapshotTimeMillis = new Ref.LongRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        EntityStorageSnapshot before = this.entityStorage.getCurrent();
        MutableEntityStorage builder2 = MutableEntityStorage.Companion.from((EntityStorage)before);
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        Ref.LongRef longRef = updateTimeMillis;
        boolean bl2 = false;
        updater2.invoke((Object)builder2);
        longRef.element = System.currentTimeMillis() - start$iv2;
        $i$f$measureTimeMillis2 = false;
        start$iv2 = System.currentTimeMillis();
        longRef = preHandlersTimeMillis;
        boolean bl3 = false;
        this.startPreUpdateHandlers((EntityStorage)before, builder2);
        longRef.element = System.currentTimeMillis() - start$iv2;
        Map changes = null;
        boolean $i$f$measureTimeMillis3 = false;
        long start$iv3 = System.currentTimeMillis();
        longRef = collectChangesTimeMillis;
        boolean bl4 = false;
        changes = builder2.collectChanges((EntityStorage)before);
        longRef.element = System.currentTimeMillis() - start$iv3;
        $i$f$measureTimeMillis3 = false;
        start$iv3 = System.currentTimeMillis();
        longRef = initializingTimeMillis;
        boolean bl5 = false;
        this.initializeBridges(changes, builder2);
        longRef.element = System.currentTimeMillis() - start$iv3;
        EntityStorageSnapshot newStorage = null;
        boolean $i$f$measureTimeMillis4 = false;
        long start$iv4 = System.currentTimeMillis();
        longRef = toSnapshotTimeMillis;
        boolean bl6 = false;
        newStorage = builder2.toSnapshot();
        longRef.element = System.currentTimeMillis() - start$iv4;
        if (Registry.is("ide.workspace.model.assertions.on.update", false)) {
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)before));
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)newStorage));
        }
        this.entityStorage.replace(newStorage, changes, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(@NotNull VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onBeforeChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        }, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(@NotNull VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        });
        long generalTime2 = System.currentTimeMillis() - start$iv;
        log.info("Project model updated to version " + this.entityStorage.getPointer().getVersion() + " in " + generalTime2 + " ms: " + description);
        if (generalTime2 > 1000L) {
            log.info("Project model update details: Updater code: " + updateTimeMillis.element + " ms, Pre handlers: " + preHandlersTimeMillis.element + " ms, Collect changes: " + collectChangesTimeMillis.element + " ms");
            log.info("Bridge initialization: " + initializingTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " ms");
        } else {
            Logger logger;
            Logger $this$debug_u24default$iv = log;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl7 = false;
                logger.debug("Project model update details: Updater code: " + updateTimeMillis.element + " ms, Pre handlers: " + preHandlersTimeMillis.element + " ms, Collect changes: " + collectChangesTimeMillis.element + " ms", e$iv);
            }
            $this$debug_u24default$iv = log;
            e$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl8 = false;
                logger.debug("Bridge initialization: " + initializingTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " ms", e$iv);
            }
        }
    }

    public final synchronized void updateProjectModelSilent(@NotNull String description, @NotNull Function1<? super MutableEntityStorage, Unit> updater2) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(updater2, (String)"updater");
        this.checkRecursiveUpdate();
        EntityStorageSnapshot newStorage = null;
        Ref.LongRef updateTimeMillis = new Ref.LongRef();
        Ref.LongRef toSnapshotTimeMillis = new Ref.LongRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        EntityStorageSnapshot before = this.entityStorage.getCurrent();
        MutableEntityStorage builder2 = MutableEntityStorage.Companion.from((EntityStorage)this.entityStorage.getCurrent());
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        Ref.LongRef longRef = updateTimeMillis;
        boolean bl2 = false;
        updater2.invoke((Object)builder2);
        longRef.element = System.currentTimeMillis() - start$iv2;
        $i$f$measureTimeMillis2 = false;
        start$iv2 = System.currentTimeMillis();
        longRef = toSnapshotTimeMillis;
        boolean bl3 = false;
        newStorage = builder2.toSnapshot();
        longRef.element = System.currentTimeMillis() - start$iv2;
        if (Registry.is("ide.workspace.model.assertions.on.update", false)) {
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)before));
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)newStorage));
        }
        this.entityStorage.replaceSilently(newStorage);
        long generalTime2 = System.currentTimeMillis() - start$iv;
        log.info("Project model updated silently to version " + this.entityStorage.getPointer().getVersion() + " in " + generalTime2 + " ms: " + description);
        if (generalTime2 > 1000L) {
            log.info("Project model update details: Updater code: " + updateTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " m");
        } else {
            Logger $this$debug_u24default$iv = log;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl4 = false;
                logger.debug("Project model update details: Updater code: " + updateTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " m", e$iv);
            }
        }
    }

    private final void checkRecursiveUpdate() {
        Iterator stackStraceIterator = ArrayIteratorKt.iterator((Object[])new RuntimeException().getStackTrace());
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            stackStraceIterator.next();
        }
        while (stackStraceIterator.hasNext()) {
            StackTraceElement frame = (StackTraceElement)stackStraceIterator.next();
            if ((Intrinsics.areEqual((Object)frame.getMethodName(), (Object)this.updateModelMethodName) || Intrinsics.areEqual((Object)frame.getMethodName(), (Object)this.updateModelSilentMethodName)) && Intrinsics.areEqual((Object)frame.getClassName(), (Object)Reflection.getOrCreateKotlinClass(WorkspaceModelImpl.class).getQualifiedName())) {
                log.error("Trying to update project model twice from the same version. Maybe recursive call of 'updateProjectModel'?");
                continue;
            }
            if (!Intrinsics.areEqual((Object)frame.getMethodName(), (Object)this.onChangedMethodName) || !Intrinsics.areEqual((Object)frame.getClassName(), (Object)Reflection.getOrCreateKotlinClass(WorkspaceModelImpl.class).getQualifiedName())) continue;
            return;
        }
    }

    @Override
    public void updateUnloadedEntities(@NotNull String description, @NotNull Function1<? super MutableEntityStorage, Unit> updater2) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(updater2, (String)"updater");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        EntityStorageSnapshot before = this.getCurrentSnapshotOfUnloadedEntities();
        MutableEntityStorage builder2 = MutableEntityStorage.Companion.from((EntityStorage)before);
        updater2.invoke((Object)builder2);
        this.startPreUpdateHandlers((EntityStorage)before, builder2);
        Map changes = builder2.collectChanges((EntityStorage)before);
        EntityStorageSnapshot newStorage = builder2.toSnapshot();
        this.unloadedEntitiesStorage.replace(newStorage, changes, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(@NotNull VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onBeforeUnloadedEntitiesChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        }, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(@NotNull VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onUnloadedEntitiesChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        });
        long time2 = System.currentTimeMillis() - start$iv;
        log.info("Unloaded entity storage updated in " + time2 + " ms: " + description);
    }

    @Override
    @NotNull
    public final BuilderSnapshot getBuilderSnapshot() {
        VersionedEntityStorageImpl.Current current = this.entityStorage.getPointer();
        return new BuilderSnapshot(current.getVersion(), current.getStorage());
    }

    @Override
    public final boolean replaceProjectModel(@NotNull StorageReplacement replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.entityStorage.getVersion() != replacement.getVersion()) {
            return false;
        }
        MutableEntityStorage builder2 = replacement.getBuilder();
        this.initializeBridges(replacement.getChanges(), builder2);
        this.entityStorage.replace(builder2.toSnapshot(), replacement.getChanges(), (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(@NotNull VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onBeforeChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        }, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(@NotNull VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        });
        return true;
    }

    @Override
    public final void dispose() {
    }

    private final void initializeBridges(Map<Class<?>, ? extends List<? extends EntityChange<?>>> change2, MutableEntityStorage builder2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(change2, builder2){
            final /* synthetic */ Map<Class<?>, List<EntityChange<?>>> $change;
            final /* synthetic */ MutableEntityStorage $builder;
            {
                this.$change = $change;
                this.$builder = $builder;
                super(0);
            }

            public final void invoke() {
                if (!GlobalLibraryTableBridge.Companion.isEnabled()) {
                    return;
                }
                GlobalLibraryTableBridge globalLibraryTableBridge = GlobalLibraryTableBridge.Companion.getInstance();
                Intrinsics.checkNotNull((Object)globalLibraryTableBridge, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.library.GlobalLibraryTableBridgeImpl");
                ((GlobalLibraryTableBridgeImpl)globalLibraryTableBridge).initializeLibraryBridges(this.$change, this.$builder);
            }
        }));
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(this, change2, builder2){
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ Map<Class<?>, List<EntityChange<?>>> $change;
            final /* synthetic */ MutableEntityStorage $builder;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                this.$builder = $builder;
                super(0);
            }

            public final void invoke() {
                block0: {
                    ComponentManager $this$serviceOrNull$iv = WorkspaceModelImpl.access$getProject$p(this.this$0);
                    boolean $i$f$serviceOrNull = false;
                    ProjectLibraryTable projectLibraryTable = $this$serviceOrNull$iv.getService(ProjectLibraryTable.class);
                    ProjectLibraryTableBridgeImpl projectLibraryTableBridgeImpl = projectLibraryTable instanceof ProjectLibraryTableBridgeImpl ? (ProjectLibraryTableBridgeImpl)projectLibraryTable : null;
                    if (projectLibraryTableBridgeImpl == null) break block0;
                    projectLibraryTableBridgeImpl.initializeLibraryBridges$intellij_platform_projectModel_impl(this.$change, this.$builder);
                }
            }
        }));
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(this, change2, builder2){
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ Map<Class<?>, List<EntityChange<?>>> $change;
            final /* synthetic */ MutableEntityStorage $builder;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                this.$builder = $builder;
                super(0);
            }

            public final void invoke() {
                block0: {
                    ComponentManager $this$serviceOrNull$iv = WorkspaceModelImpl.access$getProject$p(this.this$0);
                    boolean $i$f$serviceOrNull = false;
                    ModuleManager moduleManager = $this$serviceOrNull$iv.getService(ModuleManager.class);
                    ModuleManagerBridgeImpl moduleManagerBridgeImpl = moduleManager instanceof ModuleManagerBridgeImpl ? (ModuleManagerBridgeImpl)moduleManager : null;
                    if (moduleManagerBridgeImpl == null) break block0;
                    moduleManagerBridgeImpl.initializeBridges(this.$change, this.$builder);
                }
            }
        }));
    }

    private final void onBeforeChanged(VersionedStorageChange change2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(this, change2){
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ VersionedStorageChange $change;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                super(0);
            }

            public final void invoke() {
                WorkspaceModelImpl.access$getProject$p(this.this$0).getMessageBus().syncPublisher(WorkspaceModelTopics.CHANGED).beforeChanged(this.$change);
            }
        }));
    }

    private final void onChanged(VersionedStorageChange change2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(this, change2){
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ VersionedStorageChange $change;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                super(0);
            }

            public final void invoke() {
                block0: {
                    ComponentManager $this$serviceIfCreated$iv = WorkspaceModelImpl.access$getProject$p(this.this$0);
                    boolean $i$f$serviceIfCreated = false;
                    WorkspaceFileIndex workspaceFileIndex = $this$serviceIfCreated$iv.getServiceIfCreated(WorkspaceFileIndex.class);
                    Object object = workspaceFileIndex instanceof WorkspaceFileIndexImpl ? (WorkspaceFileIndexImpl)workspaceFileIndex : null;
                    if (object == null || (object = ((WorkspaceFileIndexImpl)object).getIndexData()) == null) break block0;
                    object.onEntitiesChanged(this.$change, EntityStorageKind.MAIN);
                }
            }
        }));
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(this, change2){
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ VersionedStorageChange $change;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                super(0);
            }

            public final void invoke() {
                WorkspaceModelImpl.access$getProject$p(this.this$0).getMessageBus().syncPublisher(WorkspaceModelTopics.CHANGED).changed(this.$change);
            }
        }));
    }

    private final void onBeforeUnloadedEntitiesChanged(VersionedStorageChange change2) {
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(this, change2){
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ VersionedStorageChange $change;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                super(0);
            }

            public final void invoke() {
                WorkspaceModelImpl.access$getProject$p(this.this$0).getMessageBus().syncPublisher(WorkspaceModelTopics.UNLOADED_ENTITIES_CHANGED).beforeChanged(this.$change);
            }
        }));
    }

    private final void onUnloadedEntitiesChanged(VersionedStorageChange change2) {
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(this, change2){
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ VersionedStorageChange $change;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                super(0);
            }

            public final void invoke() {
                block0: {
                    ComponentManager $this$serviceIfCreated$iv = WorkspaceModelImpl.access$getProject$p(this.this$0);
                    boolean $i$f$serviceIfCreated = false;
                    WorkspaceFileIndex workspaceFileIndex = $this$serviceIfCreated$iv.getServiceIfCreated(WorkspaceFileIndex.class);
                    Object object = workspaceFileIndex instanceof WorkspaceFileIndexImpl ? (WorkspaceFileIndexImpl)workspaceFileIndex : null;
                    if (object == null || (object = ((WorkspaceFileIndexImpl)object).getIndexData()) == null) break block0;
                    object.onEntitiesChanged(this.$change, EntityStorageKind.UNLOADED);
                }
            }
        }));
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)new Function0<Unit>(this, change2){
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ VersionedStorageChange $change;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                super(0);
            }

            public final void invoke() {
                WorkspaceModelImpl.access$getProject$p(this.this$0).getMessageBus().syncPublisher(WorkspaceModelTopics.UNLOADED_ENTITIES_CHANGED).changed(this.$change);
            }
        }));
    }

    private final void startPreUpdateHandlers(EntityStorage before, MutableEntityStorage builder2) {
        boolean startUpdateLoop = false;
        startUpdateLoop = true;
        int updatesStarted = 0;
        while (startUpdateLoop && updatesStarted < 100) {
            ++updatesStarted;
            startUpdateLoop = false;
            Iterable $this$forEach$iv = PRE_UPDATE_HANDLERS.getExtensionsIfPointIsRegistered();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceModelPreUpdateHandler it = (WorkspaceModelPreUpdateHandler)element$iv;
                boolean bl = false;
                startUpdateLoop |= it.update(before, builder2);
            }
        }
        if (updatesStarted >= 100) {
            log.error("Loop workspace model updating");
        }
    }

    private final void logErrorOnEventHandling(Function0<Unit> action2) {
        try {
            action2.invoke();
        }
        catch (Throwable e) {
            String message = "Exception at Workspace Model event handling";
            if (this.userWarningLoggingLevel) {
                log.warn(message, e);
            }
            log.error(message, e);
        }
    }

    public static final /* synthetic */ void access$onBeforeChanged(WorkspaceModelImpl $this, VersionedStorageChange change2) {
        $this.onBeforeChanged(change2);
    }

    public static final /* synthetic */ void access$onChanged(WorkspaceModelImpl $this, VersionedStorageChange change2) {
        $this.onChanged(change2);
    }

    public static final /* synthetic */ Project access$getProject$p(WorkspaceModelImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$onBeforeUnloadedEntitiesChanged(WorkspaceModelImpl $this, VersionedStorageChange change2) {
        $this.onBeforeUnloadedEntitiesChanged(change2);
    }

    public static final /* synthetic */ void access$onUnloadedEntitiesChanged(WorkspaceModelImpl $this, VersionedStorageChange change2) {
        $this.onUnloadedEntitiesChanged(change2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        log = logger;
        PRE_UPDATE_HANDLERS = ExtensionPointName.Companion.create("com.intellij.workspaceModel.preUpdateHandler");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl$Companion;", "", "()V", "PRE_UPDATE_HANDLERS", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelPreUpdateHandler;", "PRE_UPDATE_LOOP_BLOCK", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

