/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.library;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.platform.workspaceModel.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"findLibraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "findLibraryBridge", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "snapshot", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.projectModel.impl"})
@JvmName(name="LibraryEntityUtils")
public final class LibraryEntityUtils {
    @Nullable
    public static final Library findLibraryBridge(@NotNull LibraryEntity $this$findLibraryBridge, @NotNull EntityStorage snapshot) {
        Intrinsics.checkNotNullParameter((Object)$this$findLibraryBridge, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        return (Library)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap(snapshot).getDataByEntity((WorkspaceEntity)$this$findLibraryBridge);
    }

    @Nullable
    public static final Library findLibraryBridge(@NotNull LibraryId $this$findLibraryBridge, @NotNull EntityStorage snapshot, @NotNull Project project2) {
        Library library;
        Intrinsics.checkNotNullParameter((Object)$this$findLibraryBridge, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if ($this$findLibraryBridge.getTableId() instanceof LibraryTableId.GlobalLibraryTableId) {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel($this$findLibraryBridge.getTableId().getLevel(), project2);
            library = libraryTable != null ? libraryTable.getLibraryByName($this$findLibraryBridge.getName()) : null;
        } else {
            LibraryEntity libraryEntity = (LibraryEntity)snapshot.resolve((SymbolicEntityId)$this$findLibraryBridge);
            library = libraryEntity != null ? LibraryEntityUtils.findLibraryBridge(libraryEntity, snapshot) : null;
        }
        return library;
    }

    @NotNull
    public static final LibraryId findLibraryId(@NotNull Library library) {
        LibraryId libraryId;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library instanceof LibraryBridge) {
            libraryId = ((LibraryBridge)library).getLibraryId();
        } else {
            String string2 = library.getName();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = library.getTable().getTableLevel();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"library.table.tableLevel");
            libraryId = new LibraryId(string2, LibraryNameGenerator.INSTANCE.getLibraryTableId(string3));
        }
        return libraryId;
    }
}

