/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspaceModel.jps.JpsFileEntitySource;
import com.intellij.platform.workspaceModel.jps.JpsImportedEntitySource;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeModifiableBase;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryModifiableModelBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryStateSnapshot;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryModifiableModelBridge;
import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.DependenciesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.ExcludeUrlEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRootTypeId;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 t2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001tB9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0016J \u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000eH\u0016J \u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001aH\u0016J\b\u0010+\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020\u001aH\u0016J\u0013\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0.H\u0016\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0.H\u0016\u00a2\u0006\u0002\u00101J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\u001b\u00104\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u00105J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u001c072\u0006\u00108\u001a\u00020\"H\u0016J\u000e\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u00010:H\u0016J\b\u0010;\u001a\u00020<H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H\u0016J\n\u0010?\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010@\u001a\u00020\u001cH\u0016J\u000e\u0010A\u001a\b\u0012\u0002\b\u0003\u0018\u00010BH\u0016J\b\u0010C\u001a\u00020\u0003H\u0016J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020GH\u0016J\u001b\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001c0.2\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020EH\u0016J\b\u0010L\u001a\u00020\u000eH\u0016J\b\u0010M\u001a\u00020\u000eH\u0016J\u0010\u0010N\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010N\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010O\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RH\u0002J\u0018\u0010T\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010U\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010V\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010W\u001a\u00020\u001aH\u0016J\u0012\u0010X\u001a\u00020%2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016J\u0010\u0010[\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\\\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010]\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010^\u001a\u00020\u001aH\u0016J\u0010\u0010_\u001a\u00020\u001a2\u0006\u0010`\u001a\u000203H\u0016J\u0014\u0010a\u001a\u00020\u001a2\n\u00108\u001a\u0006\u0012\u0002\b\u00030:H\u0016J\u0010\u0010b\u001a\u00020\u001a2\u0006\u0010c\u001a\u00020\u001cH\u0016J\u0016\u0010d\u001a\u00020\u001a2\f\u0010e\u001a\b\u0012\u0002\b\u0003\u0018\u00010BH\u0016J\b\u0010f\u001a\u00020\u001cH\u0016J!\u0010g\u001a\u00020\u001a2\u0017\u0010h\u001a\u0013\u0012\u0004\u0012\u00020j\u0012\u0004\u0012\u00020\u001a0i\u00a2\u0006\u0002\bkH\u0002J\u001c\u0010l\u001a\u00020\u001a2\u0006\u0010m\u001a\u00020\u001c2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010o\u001a\u00020%2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016J\u0014\u0010p\u001a\u00020\u000e*\u00020q2\u0006\u0010r\u001a\u00020qH\u0002J\u0014\u0010p\u001a\u00020\u000e*\u00020s2\u0006\u0010r\u001a\u00020sH\u0002R\u0014\u0010\u0010\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryModifiableModelBridgeImpl;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/LegacyBridgeModifiableBase;", "Lcom/intellij/workspaceModel/ide/legacyBridge/LibraryModifiableModelBridge;", "Lcom/intellij/openapi/roots/RootProvider;", "originalLibrary", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryBridgeImpl;", "originalLibrarySnapshot", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryStateSnapshot;", "diff", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "targetBuilder", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "cacheStorageResult", "", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryBridgeImpl;Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryStateSnapshot;Lcom/intellij/workspaceModel/storage/MutableEntityStorage;Lcom/intellij/workspaceModel/storage/MutableEntityStorage;Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;Z)V", "currentLibrary", "getCurrentLibrary", "()Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryStateSnapshot;", "currentLibraryValue", "Lcom/intellij/workspaceModel/storage/CachedValue;", "disposed", "entityId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "reloadKind", "addExcludedRoot", "", "url", "", "addJarDirectory", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "recursive", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "addRoot", "addRootSetChangedListener", "", "listener", "Lcom/intellij/openapi/roots/RootProvider$RootSetChangedListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "commit", "dispose", "forgetKind", "getExcludedRootUrls", "", "()[Ljava/lang/String;", "getExcludedRoots", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getExternalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getFiles", "(Lcom/intellij/openapi/roots/OrderRootType;)[Lcom/intellij/openapi/vfs/VirtualFile;", "getInvalidRootUrls", "", "type", "getKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getModifiableModel", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "getModule", "Lcom/intellij/openapi/module/Module;", "getName", "getPresentableName", "getProperties", "Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "getRootProvider", "getSource", "Lcom/intellij/openapi/roots/libraries/Library;", "getTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "getUrls", "(Lcom/intellij/openapi/roots/OrderRootType;)[Ljava/lang/String;", "hasSameContent", "library", "isChanged", "isDisposed", "isJarDirectory", "isUnderRoots", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "roots", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryRoot;", "isValid", "moveRootDown", "moveRootUp", "prepareForCommit", "readExternal", "element", "Lorg/jdom/Element;", "removeExcludedRoot", "removeRoot", "removeRootSetChangedListener", "restoreKind", "setExternalSource", "externalSource", "setKind", "setName", "name", "setProperties", "properties", "toString", "update", "updater", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity$Builder;", "Lkotlin/ExtensionFunctionType;", "updateProperties", "libraryType", "propertiesXmlTag", "writeExternal", "hasEqualProperties", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "another", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryPropertiesEntity;", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nLibraryModifiableModelBridgeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryModifiableModelBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryModifiableModelBridgeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,413:1\n1549#2:414\n1620#2,3:415\n819#2:418\n847#2,2:419\n1855#2,2:421\n1#3:423\n10#4:424\n*S KotlinDebug\n*F\n+ 1 LibraryModifiableModelBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryModifiableModelBridgeImpl\n*L\n330#1:414\n330#1:415,3\n344#1:418\n344#1:419,2\n344#1:421,2\n410#1:424\n*E\n"})
public final class LibraryModifiableModelBridgeImpl
extends LegacyBridgeModifiableBase
implements LibraryModifiableModelBridge,
RootProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LibraryBridgeImpl originalLibrary;
    @NotNull
    private final LibraryStateSnapshot originalLibrarySnapshot;
    @Nullable
    private final MutableEntityStorage targetBuilder;
    @NotNull
    private final VirtualFileUrlManager virtualFileManager;
    @NotNull
    private LibraryId entityId;
    private boolean reloadKind;
    @NotNull
    private final CachedValue<LibraryStateSnapshot> currentLibraryValue;
    private boolean disposed;
    @NotNull
    private static final Logger LOG;

    public LibraryModifiableModelBridgeImpl(@NotNull LibraryBridgeImpl originalLibrary, @NotNull LibraryStateSnapshot originalLibrarySnapshot, @NotNull MutableEntityStorage diff, @Nullable MutableEntityStorage targetBuilder, @NotNull VirtualFileUrlManager virtualFileManager, boolean cacheStorageResult) {
        Intrinsics.checkNotNullParameter((Object)originalLibrary, (String)"originalLibrary");
        Intrinsics.checkNotNullParameter((Object)originalLibrarySnapshot, (String)"originalLibrarySnapshot");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        super(diff, cacheStorageResult);
        this.originalLibrary = originalLibrary;
        this.originalLibrarySnapshot = originalLibrarySnapshot;
        this.targetBuilder = targetBuilder;
        this.virtualFileManager = virtualFileManager;
        this.entityId = this.originalLibrarySnapshot.getLibraryEntity().getSymbolicId();
        this.currentLibraryValue = new CachedValue((Function1)new Function1<EntityStorage, LibraryStateSnapshot>(this){
            final /* synthetic */ LibraryModifiableModelBridgeImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final LibraryStateSnapshot invoke(@NotNull EntityStorage storage) {
                Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
                LibraryEntity libraryEntity = (LibraryEntity)storage.resolve((SymbolicEntityId)LibraryModifiableModelBridgeImpl.access$getEntityId$p(this.this$0));
                if (libraryEntity == null) {
                    throw new IllegalStateException(("Can't resolve library via " + LibraryModifiableModelBridgeImpl.access$getEntityId$p(this.this$0)).toString());
                }
                LibraryStateSnapshot newLibrary = new LibraryStateSnapshot(libraryEntity, storage, LibraryModifiableModelBridgeImpl.access$getOriginalLibrarySnapshot$p(this.this$0).getLibraryTable(), LibraryModifiableModelBridgeImpl.access$getOriginalLibrary$p(this.this$0));
                return newLibrary;
            }
        });
    }

    public /* synthetic */ LibraryModifiableModelBridgeImpl(LibraryBridgeImpl libraryBridgeImpl, LibraryStateSnapshot libraryStateSnapshot, MutableEntityStorage mutableEntityStorage, MutableEntityStorage mutableEntityStorage2, VirtualFileUrlManager virtualFileUrlManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(libraryBridgeImpl, libraryStateSnapshot, mutableEntityStorage, mutableEntityStorage2, virtualFileUrlManager, bl);
    }

    private final LibraryStateSnapshot getCurrentLibrary() {
        return (LibraryStateSnapshot)this.getEntityStorageOnDiff().cachedValue(this.currentLibraryValue);
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        return this.getCurrentLibrary().getFiles(rootType);
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getKind() {
        return this.getCurrentLibrary().getKind();
    }

    @Override
    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        return this.getCurrentLibrary().getUrls(rootType);
    }

    @Override
    @Nullable
    public String getName() {
        return this.getCurrentLibrary().getName();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string2 = LibraryImpl.getPresentableName(this);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(this)");
        return string2;
    }

    @Override
    @Nullable
    public LibraryProperties<?> getProperties() {
        return this.getCurrentLibrary().getProperties();
    }

    @Override
    @NotNull
    public String[] getExcludedRootUrls() {
        return this.getCurrentLibrary().getExcludedRootUrls();
    }

    @Override
    public boolean isJarDirectory(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getCurrentLibrary().isJarDirectory(url);
    }

    @Override
    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        return this.getCurrentLibrary().isJarDirectory(url, rootType);
    }

    @Override
    public void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.assertModelIsLive();
        LibraryEntity entity = this.getCurrentLibrary().getLibraryEntity();
        if (Intrinsics.areEqual((Object)entity.getName(), (Object)name)) {
            return;
        }
        if (this.getCurrentLibrary().getLibraryTable().getLibraryByName(name) != null) {
            throw new IllegalStateException(("Library named " + name + " already exists").toString());
        }
        this.entityId = LibraryId.copy$default((LibraryId)entity.getSymbolicId(), (String)name, null, (int)2, null);
        DependenciesKt.modifyEntity((MutableEntityStorage)this.getDiff(), (LibraryEntity)entity, (Function1)((Function1)new Function1<LibraryEntity.Builder, Unit>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            public final void invoke(@NotNull LibraryEntity.Builder $this$modifyEntity) {
                Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                $this$modifyEntity.setName(this.$name);
            }
        }));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && !Intrinsics.areEqual((Object)this.getCurrentLibrary().getName(), (Object)name)) {
            throw new IllegalStateException(("setName: expected library name " + name + ", but got " + this.getCurrentLibrary().getName() + ". Original name: " + this.originalLibrarySnapshot.getName()).toString());
        }
    }

    @Override
    public void commit() {
        this.assertModelIsLive();
        this.setModelIsCommittedOrDisposed(true);
        if (this.reloadKind) {
            this.originalLibrary.cleanCachedValue$intellij_platform_projectModel_impl();
        }
        if (this.isChanged()) {
            if (this.targetBuilder != null) {
                if (this.targetBuilder != this.getDiff()) {
                    this.targetBuilder.addDiff(this.getDiff());
                }
            } else if (this.originalLibrary.getProject() != null) {
                WorkspaceModel.Companion.getInstance(this.originalLibrary.getProject()).updateProjectModel("Library model commit", (Function1<? super MutableEntityStorage, Unit>)((Function1)new Function1<MutableEntityStorage, Unit>(this){
                    final /* synthetic */ LibraryModifiableModelBridgeImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull MutableEntityStorage it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.addDiff(this.this$0.getDiff());
                    }
                }));
            } else {
                GlobalWorkspaceModel.Companion.getInstance().updateModel("Library model commit", (Function1<? super MutableEntityStorage, Unit>)((Function1)new Function1<MutableEntityStorage, Unit>(this){
                    final /* synthetic */ LibraryModifiableModelBridgeImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull MutableEntityStorage it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.addDiff(this.this$0.getDiff());
                    }
                }));
            }
            this.originalLibrary.setEntityId(this.entityId);
            this.originalLibrary.fireRootSetChanged$intellij_platform_projectModel_impl();
        }
    }

    @Override
    public void prepareForCommit() {
        this.assertModelIsLive();
        this.setModelIsCommittedOrDisposed(true);
        if (this.reloadKind) {
            this.originalLibrary.cleanCachedValue$intellij_platform_projectModel_impl();
        }
        if (this.isChanged()) {
            this.originalLibrary.setEntityId(this.entityId);
        }
    }

    private final void update(Function1<? super LibraryEntity.Builder, Unit> updater2) {
        DependenciesKt.modifyEntity((MutableEntityStorage)this.getDiff(), (LibraryEntity)this.getCurrentLibrary().getLibraryEntity(), updater2);
    }

    @Override
    public void setExternalSource(@NotNull ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)externalSource, (String)"externalSource");
        this.update((Function1<? super LibraryEntity.Builder, Unit>)((Function1)new Function1<LibraryEntity.Builder, Unit>(externalSource, this){
            final /* synthetic */ ProjectModelExternalSource $externalSource;
            final /* synthetic */ LibraryModifiableModelBridgeImpl this$0;
            {
                this.$externalSource = $externalSource;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull LibraryEntity.Builder $this$update) {
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                EntitySource currentEntitySource = $this$update.getEntitySource();
                if (currentEntitySource instanceof JpsFileEntitySource) {
                    JpsFileEntitySource jpsFileEntitySource = (JpsFileEntitySource)currentEntitySource;
                    String string2 = this.$externalSource.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalSource.id");
                    Project project2 = LibraryModifiableModelBridgeImpl.access$getOriginalLibrary$p(this.this$0).getProject();
                    Intrinsics.checkNotNull((Object)project2);
                    $this$update.setEntitySource((EntitySource)new JpsImportedEntitySource(jpsFileEntitySource, string2, ProjectUtilCore.isExternalStorageEnabled(project2)));
                }
            }
        }));
    }

    private final void updateProperties(String libraryType, String propertiesXmlTag) {
        LibraryEntity entity = this.getCurrentLibrary().getLibraryEntity();
        LibraryPropertiesEntity properties = entity.getLibraryProperties();
        if (properties == null) {
            this.getDiff().addEntity((WorkspaceEntity)LibraryPropertiesEntity.Companion.create(libraryType, entity.getEntitySource(), (Function1)new Function1<LibraryPropertiesEntity.Builder, Unit>(entity, propertiesXmlTag){
                final /* synthetic */ LibraryEntity $entity;
                final /* synthetic */ String $propertiesXmlTag;
                {
                    this.$entity = $entity;
                    this.$propertiesXmlTag = $propertiesXmlTag;
                    super(1);
                }

                public final void invoke(@NotNull LibraryPropertiesEntity.Builder $this$invoke) {
                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                    $this$invoke.setLibrary(this.$entity);
                    if (this.$propertiesXmlTag != null) {
                        $this$invoke.setPropertiesXmlTag(this.$propertiesXmlTag);
                    }
                }
            }));
        } else {
            DependenciesKt.modifyEntity((MutableEntityStorage)this.getDiff(), (LibraryPropertiesEntity)properties, (Function1)((Function1)new Function1<LibraryPropertiesEntity.Builder, Unit>(libraryType, propertiesXmlTag){
                final /* synthetic */ String $libraryType;
                final /* synthetic */ String $propertiesXmlTag;
                {
                    this.$libraryType = $libraryType;
                    this.$propertiesXmlTag = $propertiesXmlTag;
                    super(1);
                }

                public final void invoke(@NotNull LibraryPropertiesEntity.Builder $this$modifyEntity) {
                    Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                    $this$modifyEntity.setLibraryType(this.$libraryType);
                    if (this.$propertiesXmlTag != null) {
                        $this$modifyEntity.setPropertiesXmlTag(this.$propertiesXmlTag);
                    }
                }
            }));
        }
    }

    static /* synthetic */ void updateProperties$default(LibraryModifiableModelBridgeImpl libraryModifiableModelBridgeImpl, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        libraryModifiableModelBridgeImpl.updateProperties(string2, string3);
    }

    @Override
    public boolean isChanged() {
        if (!this.hasEqualProperties(this.originalLibrarySnapshot.getLibraryEntity(), this.getCurrentLibrary().getLibraryEntity())) {
            return true;
        }
        LibraryPropertiesEntity p1 = this.originalLibrarySnapshot.getLibraryEntity().getLibraryProperties();
        LibraryPropertiesEntity p2 = this.getCurrentLibrary().getLibraryEntity().getLibraryProperties();
        return !(p1 == null && p2 == null || p1 != null && p2 != null && this.hasEqualProperties(p1, p2));
    }

    private final boolean hasEqualProperties(LibraryEntity $this$hasEqualProperties, LibraryEntity another) {
        if (!Intrinsics.areEqual((Object)$this$hasEqualProperties.getTableId(), (Object)another.getTableId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$hasEqualProperties.getName(), (Object)another.getName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$hasEqualProperties.getRoots(), (Object)another.getRoots())) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$hasEqualProperties.getExcludedRoots(), (Object)another.getExcludedRoots());
    }

    private final boolean hasEqualProperties(LibraryPropertiesEntity $this$hasEqualProperties, LibraryPropertiesEntity another) {
        if (!Intrinsics.areEqual((Object)$this$hasEqualProperties.getLibraryType(), (Object)another.getLibraryType())) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$hasEqualProperties.getPropertiesXmlTag(), (Object)another.getPropertiesXmlTag());
    }

    @Override
    public void addJarDirectory(@NotNull String url, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"CLASSES");
        this.addJarDirectory(url, recursive, orderRootType);
    }

    @Override
    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        LibraryRootTypeId rootTypeId = LibraryBridgeImpl.Companion.toLibraryRootType$intellij_platform_projectModel_impl(rootType);
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(url);
        LibraryRoot.InclusionOptions inclusionOptions = recursive ? LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY : LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT;
        this.update((Function1<? super LibraryEntity.Builder, Unit>)((Function1)new Function1<LibraryEntity.Builder, Unit>(virtualFileUrl, rootTypeId, inclusionOptions){
            final /* synthetic */ VirtualFileUrl $virtualFileUrl;
            final /* synthetic */ LibraryRootTypeId $rootTypeId;
            final /* synthetic */ LibraryRoot.InclusionOptions $inclusionOptions;
            {
                this.$virtualFileUrl = $virtualFileUrl;
                this.$rootTypeId = $rootTypeId;
                this.$inclusionOptions = $inclusionOptions;
                super(1);
            }

            public final void invoke(@NotNull LibraryEntity.Builder $this$update) {
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                $this$update.getRoots().add(new LibraryRoot(this.$virtualFileUrl, this.$rootTypeId, this.$inclusionOptions));
            }
        }));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied()) {
            LibraryStateSnapshot libraryStateSnapshot = this.getCurrentLibrary();
            String string2 = virtualFileUrl.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"virtualFileUrl.url");
            if (!libraryStateSnapshot.isJarDirectory(string2, rootType)) {
                throw new IllegalStateException(("addJarDirectory: expected jarDirectory exists for url '" + virtualFileUrl.getUrl() + "'").toString());
            }
        }
    }

    @Override
    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string2 = file2.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.url");
        this.addJarDirectory(string2, recursive);
    }

    @Override
    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        String string2 = file2.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.url");
        this.addJarDirectory(string2, recursive, rootType);
    }

    @Override
    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(url);
        this.update((Function1<? super LibraryEntity.Builder, Unit>)((Function1)new Function1<LibraryEntity.Builder, Unit>(virtualFileUrl, rootType){
            final /* synthetic */ VirtualFileUrl $virtualFileUrl;
            final /* synthetic */ OrderRootType $rootType;
            {
                this.$virtualFileUrl = $virtualFileUrl;
                this.$rootType = $rootType;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull LibraryEntity.Builder $this$update) {
                int prevRootIndex;
                int index2;
                block6: {
                    int n;
                    void $this$indexOfLast$iv;
                    Object object;
                    block5: {
                        int n2;
                        void $this$indexOfFirst$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                        List list2 = $this$update.getRoots();
                        object = this.$virtualFileUrl;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (E item$iv : $this$indexOfFirst$iv) {
                            LibraryRoot it = (LibraryRoot)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getUrl(), (Object)object)) {
                                n2 = index$iv;
                                break block5;
                            }
                            ++index$iv;
                        }
                        n2 = index2 = -1;
                    }
                    if (index2 <= 0) {
                        return;
                    }
                    object = $this$update.getRoots().subList(0, index2);
                    OrderRootType orderRootType = this.$rootType;
                    boolean $i$f$indexOfLast = false;
                    ListIterator<E> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        LibraryRoot it = (LibraryRoot)iterator$iv.previous();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)orderRootType.name())) continue;
                        n = iterator$iv.nextIndex();
                        break block6;
                    }
                    n = prevRootIndex = -1;
                }
                if (prevRootIndex < 0) {
                    return;
                }
                List mutable = CollectionsKt.toMutableList((Collection)$this$update.getRoots());
                ContainerUtil.swapElements(mutable, prevRootIndex, index2);
                $this$update.setRoots(mutable);
            }
        }));
    }

    @Override
    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(url);
        this.update((Function1<? super LibraryEntity.Builder, Unit>)((Function1)new Function1<LibraryEntity.Builder, Unit>(virtualFileUrl, rootType){
            final /* synthetic */ VirtualFileUrl $virtualFileUrl;
            final /* synthetic */ OrderRootType $rootType;
            {
                this.$virtualFileUrl = $virtualFileUrl;
                this.$rootType = $rootType;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull LibraryEntity.Builder $this$update) {
                int nextRootOffset;
                int index2;
                block7: {
                    int n;
                    void $this$indexOfFirst$iv;
                    Object object;
                    block6: {
                        int n2;
                        void $this$indexOfFirst$iv2;
                        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                        List list2 = $this$update.getRoots();
                        object = this.$virtualFileUrl;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (E item$iv : $this$indexOfFirst$iv2) {
                            LibraryRoot it = (LibraryRoot)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getUrl(), (Object)object)) {
                                n2 = index$iv;
                                break block6;
                            }
                            ++index$iv;
                        }
                        n2 = index2 = -1;
                    }
                    if (index2 < 0 || index2 + 1 >= $this$update.getRoots().size()) {
                        return;
                    }
                    object = $this$update.getRoots().subList(index2 + 1, $this$update.getRoots().size());
                    OrderRootType orderRootType = this.$rootType;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (E item$iv : $this$indexOfFirst$iv) {
                        LibraryRoot it = (LibraryRoot)item$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)it.getType().getName(), (Object)orderRootType.name())) {
                            n = index$iv;
                            break block7;
                        }
                        ++index$iv;
                    }
                    n = nextRootOffset = -1;
                }
                if (nextRootOffset < 0) {
                    return;
                }
                List mutable = CollectionsKt.toMutableList((Collection)$this$update.getRoots());
                ContainerUtil.swapElements(mutable, index2 + nextRootOffset + 1, index2);
                $this$update.setRoots(mutable);
            }
        }));
    }

    @Override
    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        return this.getCurrentLibrary().isValid(url, rootType);
    }

    @Override
    public boolean hasSameContent(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (this == library) {
            return true;
        }
        if (!(library instanceof LibraryBridgeImpl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)((LibraryBridgeImpl)library).getName())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getKind(), ((LibraryBridgeImpl)library).getKind())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getProperties(), ((LibraryBridgeImpl)library).getProperties())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getCurrentLibrary().getLibraryEntity().getRoots(), (Object)((LibraryBridgeImpl)library).getLibrarySnapshot().getLibraryEntity().getRoots())) {
            return false;
        }
        return Arrays.equals(this.getExcludedRoots(), ((LibraryBridgeImpl)library).getExcludedRoots());
    }

    @Override
    public void addExcludedRoot(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(url);
        this.update((Function1<? super LibraryEntity.Builder, Unit>)((Function1)new Function1<LibraryEntity.Builder, Unit>(virtualFileUrl){
            final /* synthetic */ VirtualFileUrl $virtualFileUrl;
            {
                this.$virtualFileUrl = $virtualFileUrl;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull LibraryEntity.Builder $this$update) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                Iterable $this$map$iv = $this$update.getExcludedRoots();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ExcludeUrlEntity excludeUrlEntity = (ExcludeUrlEntity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getUrl());
                }
                if (!((List)destination$iv$iv).contains(this.$virtualFileUrl)) {
                    $this$update.setExcludedRoots(CollectionsKt.plus((Collection)$this$update.getExcludedRoots(), (Object)ExcludeUrlEntity.Companion.create$default((ExcludeUrlEntity.Companion)ExcludeUrlEntity.Companion, (VirtualFileUrl)this.$virtualFileUrl, (EntitySource)$this$update.getEntitySource(), null, (int)4, null)));
                }
            }
        }));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && !ArraysKt.contains((Object[])this.getCurrentLibrary().getExcludedRootUrls(), (Object)virtualFileUrl.getUrl())) {
            throw new IllegalStateException(("addExcludedRoot: expected excluded urls contain url '" + virtualFileUrl.getUrl() + "'").toString());
        }
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(url);
        LibraryRoot root = new LibraryRoot(virtualFileUrl, LibraryBridgeImpl.Companion.toLibraryRootType$intellij_platform_projectModel_impl(rootType), null, 4, null);
        this.update((Function1<? super LibraryEntity.Builder, Unit>)((Function1)new Function1<LibraryEntity.Builder, Unit>(root){
            final /* synthetic */ LibraryRoot $root;
            {
                this.$root = $root;
                super(1);
            }

            public final void invoke(@NotNull LibraryEntity.Builder $this$update) {
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                $this$update.getRoots().add(this.$root);
            }
        }));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && !ArraysKt.contains((Object[])this.getCurrentLibrary().getUrls(rootType), (Object)virtualFileUrl.getUrl())) {
            throw new IllegalStateException(("addRoot: expected urls for root type '" + rootType.name() + "' contain url '" + virtualFileUrl.getUrl() + "'").toString());
        }
    }

    @Override
    public void addRoot(@NotNull VirtualFile file2, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        String string2 = file2.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.url");
        this.addRoot(string2, rootType);
    }

    public void setProperties(@Nullable LibraryProperties<?> properties) {
        this.assertModelIsLive();
        if (Intrinsics.areEqual(this.getCurrentLibrary().getProperties(), properties)) {
            return;
        }
        PersistentLibraryKind<?> kind = this.getCurrentLibrary().getKind();
        if (kind == null) {
            if (properties != null && !(properties instanceof DummyLibraryProperties)) {
                LOG.error("Setting properties with null kind is unsupported");
            }
            return;
        }
        String string2 = kind.getKindId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kind.kindId");
        this.updateProperties(string2, LegacyBridgeModifiableBase.Companion.serializeComponentAsString("properties", (PersistentStateComponent)properties));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && !Intrinsics.areEqual(this.getCurrentLibrary().getProperties(), properties)) {
            throw new IllegalStateException("setProperties: properties are not equal after changing".toString());
        }
    }

    @Override
    public void setKind(@NotNull PersistentLibraryKind<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.assertModelIsLive();
        if (Intrinsics.areEqual(this.getKind(), type)) {
            return;
        }
        String string2 = type.getKindId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.kindId");
        LibraryModifiableModelBridgeImpl.updateProperties$default(this, string2, null, 2, null);
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied()) {
            PersistentLibraryKind<?> persistentLibraryKind = this.getCurrentLibrary().getKind();
            if (!Intrinsics.areEqual((Object)(persistentLibraryKind != null ? persistentLibraryKind.getKindId() : null), (Object)type.getKindId())) {
                PersistentLibraryKind<?> persistentLibraryKind2 = this.getCurrentLibrary().getKind();
                PersistentLibraryKind<?> persistentLibraryKind3 = this.originalLibrarySnapshot.getKind();
                String string3 = "setKind: expected kindId " + type.getKindId() + ", but got " + (persistentLibraryKind2 != null ? persistentLibraryKind2.getKindId() : null) + ". Original kind: " + (persistentLibraryKind3 != null ? persistentLibraryKind3.getKindId() : null);
                throw new IllegalStateException(string3.toString());
            }
        }
    }

    @Override
    public void forgetKind() {
        this.reloadKind = true;
    }

    @Override
    public void restoreKind() {
        this.reloadKind = true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUnderRoots(VirtualFileUrl url, Collection<LibraryRoot> roots2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = roots2;
        String string2 = url.getUrl();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LibraryRoot libraryRoot = (LibraryRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl().getUrl());
        }
        return VfsUtilCore.isUnder(string2, (List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(url);
        if (!ArraysKt.contains((Object[])this.getCurrentLibrary().getUrls(rootType), (Object)virtualFileUrl.getUrl())) {
            return false;
        }
        this.update((Function1<? super LibraryEntity.Builder, Unit>)((Function1)new Function1<LibraryEntity.Builder, Unit>(virtualFileUrl, rootType){
            final /* synthetic */ VirtualFileUrl $virtualFileUrl;
            final /* synthetic */ OrderRootType $rootType;
            {
                this.$virtualFileUrl = $virtualFileUrl;
                this.$rootType = $rootType;
                super(1);
            }

            public final void invoke(@NotNull LibraryEntity.Builder $this$update) {
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                $this$update.getRoots().removeIf(arg_0 -> removeRoot.1.invoke$lambda$0((Function1)new Function1<LibraryRoot, Boolean>(this.$virtualFileUrl, this.$rootType){
                    final /* synthetic */ VirtualFileUrl $virtualFileUrl;
                    final /* synthetic */ OrderRootType $rootType;
                    {
                        this.$virtualFileUrl = $virtualFileUrl;
                        this.$rootType = $rootType;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull LibraryRoot it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getUrl(), (Object)this.$virtualFileUrl) && Intrinsics.areEqual((Object)it.getType().getName(), (Object)this.$rootType.name());
                    }
                }, arg_0));
            }

            private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }));
        LibraryEntity libraryEntity = this.getCurrentLibrary().getLibraryEntity();
        Iterable $this$filterNot$iv = libraryEntity.getExcludedRoots();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ExcludeUrlEntity it = (ExcludeUrlEntity)element$iv$iv;
            boolean bl = false;
            if (this.isUnderRoots(it.getUrl(), libraryEntity.getRoots())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExcludeUrlEntity it = (ExcludeUrlEntity)element$iv;
            boolean bl = false;
            this.getDiff().removeEntity((WorkspaceEntity)it);
        }
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && ArraysKt.contains((Object[])this.getCurrentLibrary().getUrls(rootType), (Object)virtualFileUrl.getUrl())) {
            throw new IllegalStateException(("removeRoot: removed url '" + virtualFileUrl.getUrl() + "' type '" + rootType.name() + "' still exists after removing").toString());
        }
        return true;
    }

    @Override
    public boolean removeExcludedRoot(@NotNull String url) {
        Object v0;
        VirtualFileUrl virtualFileUrl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.assertModelIsLive();
            virtualFileUrl = this.virtualFileManager.fromUrl(url);
            Iterable iterable = this.getCurrentLibrary().getLibraryEntity().getExcludedRoots();
            for (Object t : iterable) {
                ExcludeUrlEntity it = (ExcludeUrlEntity)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)virtualFileUrl)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ExcludeUrlEntity excludeUrlEntity = v0;
        if (excludeUrlEntity == null) {
            return false;
        }
        this.getDiff().removeEntity((WorkspaceEntity)excludeUrlEntity);
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && ArraysKt.contains((Object[])this.getCurrentLibrary().getExcludedRootUrls(), (Object)virtualFileUrl.getUrl())) {
            throw new IllegalStateException(("removeRoot: removed excluded url '" + virtualFileUrl.getUrl() + "' still exists after removing").toString());
        }
        return true;
    }

    @Override
    public void dispose() {
        this.setModelIsCommittedOrDisposed(true);
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @NotNull
    public String toString() {
        return "Library '" + this.getName() + "', roots: " + this.getCurrentLibrary().getLibraryEntity().getRoots();
    }

    @Override
    @NotNull
    public List<String> getInvalidRootUrls(@NotNull OrderRootType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.getCurrentLibrary().getInvalidRootUrls(type);
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludedRoots() {
        return this.getCurrentLibrary().getExcludedRoots();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.getCurrentLibrary().getModule();
    }

    @NotNull
    public Void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.originalLibrarySnapshot.getExternalSource();
    }

    @Override
    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Library getSource() {
        return this.originalLibrary;
    }

    @Override
    @NotNull
    public LibraryTable getTable() {
        return this.originalLibrarySnapshot.getLibraryTable();
    }

    @Override
    @NotNull
    public RootProvider getRootProvider() {
        return this;
    }

    @NotNull
    public Void readExternal(@Nullable Element element) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void writeExternal(@Nullable Element element) {
        throw new UnsupportedOperationException();
    }

    public static final /* synthetic */ LibraryBridgeImpl access$getOriginalLibrary$p(LibraryModifiableModelBridgeImpl $this) {
        return $this.originalLibrary;
    }

    public static final /* synthetic */ LibraryId access$getEntityId$p(LibraryModifiableModelBridgeImpl $this) {
        return $this.entityId;
    }

    public static final /* synthetic */ LibraryStateSnapshot access$getOriginalLibrarySnapshot$p(LibraryModifiableModelBridgeImpl $this) {
        return $this.originalLibrarySnapshot;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LibraryModifiableModelBridgeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryModifiableModelBridgeImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

