/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.platform.workspaceModel.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableRootModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyListener;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0004'()*B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016J\b\u0010#\u001a\u00020\u0012H\u0016J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyIndex;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "jdkChangeListener", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$JdkChangeListener;", "libraryTablesListener", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$LibraryTablesListener;", "rootSetChangeListener", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$ReferencedRootSetChangeListener;", "addListener", "", "listener", "addTrackedLibraryAndJdkFromEntity", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "dispose", "hasDependencyOn", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "hasProjectSdkDependency", "removeTrackedLibrariesAndJdkFromEntity", "reset", "setupTrackedLibrariesAndJdks", "workspaceModelChanged", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "Companion", "JdkChangeListener", "LibraryTablesListener", "ReferencedRootSetChangeListener", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nModuleDependencyIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n1#2:407\n12#3,5:408\n12#3,5:415\n10#3:422\n1855#4,2:413\n1855#4,2:420\n*S KotlinDebug\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl\n*L\n89#1:408,5\n108#1:415,5\n33#1:422\n91#1:413,2\n110#1:420,2\n*E\n"})
public final class ModuleDependencyIndexImpl
implements ModuleDependencyIndex,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EventDispatcher<ModuleDependencyListener> eventDispatcher;
    @NotNull
    private final LibraryTablesListener libraryTablesListener;
    @NotNull
    private final JdkChangeListener jdkChangeListener;
    @NotNull
    private final ReferencedRootSetChangeListener rootSetChangeListener;
    @NotNull
    private static final String LIBRARY_NAME_DELIMITER = ":";
    @NotNull
    private static final Logger LOG;

    public ModuleDependencyIndexImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        EventDispatcher<ModuleDependencyListener> eventDispatcher = EventDispatcher.create(ModuleDependencyListener.class);
        Intrinsics.checkNotNullExpressionValue(eventDispatcher, (String)"create(ModuleDependencyListener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.libraryTablesListener = new LibraryTablesListener();
        this.jdkChangeListener = new JdkChangeListener();
        this.rootSetChangeListener = new ReferencedRootSetChangeListener();
        if (!this.project.isDefault()) {
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this);
            Topic<ProjectJdkTable.Listener> topic = ProjectJdkTable.JDK_TABLE_TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"JDK_TABLE_TOPIC");
            messageBusConnection.subscribe(topic, this.jdkChangeListener);
        }
    }

    @Override
    public void addListener(@NotNull ModuleDependencyListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventDispatcher.addListener((ModuleDependencyListener)((EventListener)listener2));
    }

    @Override
    public void setupTrackedLibrariesAndJdks() {
        EntityStorageSnapshot currentStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        for (ModuleEntity moduleEntity : currentStorage.entities(ModuleEntity.class)) {
            this.addTrackedLibraryAndJdkFromEntity(moduleEntity);
        }
    }

    @Override
    public boolean hasProjectSdkDependency() {
        return this.jdkChangeListener.hasProjectSdkDependency();
    }

    @Override
    public boolean hasDependencyOn(@NotNull LibraryId libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return libraryId.getTableId() instanceof LibraryTableId.ModuleLibraryTableId || this.libraryTablesListener.hasDependencyOn(libraryId);
    }

    @Override
    public boolean hasDependencyOn(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return library.getTable() == null || this.libraryTablesListener.hasDependencyOn(library);
    }

    @Override
    public boolean hasDependencyOn(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return this.jdkChangeListener.hasDependencyOn(sdk2);
    }

    public final void workspaceModelChanged(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.project.isDisposed()) {
            return;
        }
        List moduleChanges = event.getChanges(ModuleEntity.class);
        for (EntityChange change2 : moduleChanges) {
            ModuleEntity it;
            if ((ModuleEntity)change2.getOldEntity() != null) {
                boolean bl = false;
                this.removeTrackedLibrariesAndJdkFromEntity(it);
            }
            if ((ModuleEntity)change2.getNewEntity() == null) continue;
            boolean bl = false;
            this.addTrackedLibraryAndJdkFromEntity(it);
        }
    }

    private final void addTrackedLibraryAndJdkFromEntity(ModuleEntity moduleEntity) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Add tracked global libraries and JDK from " + moduleEntity.getName(), e$iv);
        }
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Iterable $this$forEach$iv = moduleEntity.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem it = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            if (it instanceof ModuleDependencyItem.Exportable.LibraryDependency && !(((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId() instanceof LibraryTableId.ModuleLibraryTableId)) {
                LibraryTable libraryTable;
                String libraryName = ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getName();
                String libraryLevel = ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId().getLevel();
                if (libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.project) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"libraryTablesRegistrar.g\u2026roject) ?: return@forEach");
                if (this.libraryTablesListener.isEmpty(libraryLevel)) {
                    libraryTable.addListener(this.libraryTablesListener);
                }
                this.libraryTablesListener.addTrackedLibrary(moduleEntity, libraryTable, libraryName);
                continue;
            }
            if (!(it instanceof ModuleDependencyItem.SdkDependency) && !(it instanceof ModuleDependencyItem.InheritedSdkDependency)) continue;
            this.jdkChangeListener.addTrackedJdk(it, moduleEntity);
        }
    }

    private final void removeTrackedLibrariesAndJdkFromEntity(ModuleEntity moduleEntity) {
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Removed tracked global libraries and JDK from " + moduleEntity.getName(), e$iv);
        }
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Iterable $this$forEach$iv = moduleEntity.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem it = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            if (it instanceof ModuleDependencyItem.Exportable.LibraryDependency && !(((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId() instanceof LibraryTableId.ModuleLibraryTableId)) {
                LibraryTable libraryTable;
                String libraryName = ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getName();
                String libraryLevel = ((ModuleDependencyItem.Exportable.LibraryDependency)it).getLibrary().getTableId().getLevel();
                if (libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.project) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"libraryTablesRegistrar.g\u2026roject) ?: return@forEach");
                this.libraryTablesListener.unTrackLibrary(moduleEntity, libraryTable, libraryName);
                if (!this.libraryTablesListener.isEmpty(libraryLevel)) continue;
                libraryTable.removeListener(this.libraryTablesListener);
                continue;
            }
            if (!(it instanceof ModuleDependencyItem.SdkDependency) && !(it instanceof ModuleDependencyItem.InheritedSdkDependency)) continue;
            this.jdkChangeListener.removeTrackedJdk(it, moduleEntity);
        }
    }

    @Override
    public void dispose() {
        if (this.project.isDefault()) {
            return;
        }
        this.libraryTablesListener.unsubscribe(false);
        this.jdkChangeListener.unsubscribe(false);
    }

    @Override
    public void reset() {
        this.libraryTablesListener.unsubscribe(true);
        this.jdkChangeListener.unsubscribe(true);
        this.setupTrackedLibrariesAndJdks();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ModuleDependencyIndexImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u001a\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0019j\b\u0012\u0004\u0012\u00020\u0006`\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0006J\u001e\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u001cR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$LibraryTablesListener;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl;)V", "librariesPerModuleMap", "Lcom/intellij/util/containers/BidirectionalMultiMap;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleId;", "", "addTrackedLibrary", "", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "libraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "libraryName", "afterLibraryAdded", "newLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "afterLibraryRemoved", "library", "afterLibraryRenamed", "oldName", "getLibraryIdentifier", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "getLibraryLevels", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "hasDependencyOn", "", "isEmpty", "libraryLevel", "unTrackLibrary", "unsubscribe", "fireEvents", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nModuleDependencyIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$LibraryTablesListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,406:1\n2624#2,3:407\n1620#2,3:410\n1855#2,2:413\n1855#2:415\n1856#2:418\n32#3,2:416\n32#3,2:419\n*S KotlinDebug\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$LibraryTablesListener\n*L\n171#1:407,3\n173#1:410,3\n203#1:413,2\n233#1:415\n233#1:418\n235#1:416,2\n244#1:419,2\n*E\n"})
    private final class LibraryTablesListener
    implements LibraryTable.Listener {
        @NotNull
        private final BidirectionalMultiMap<ModuleId, String> librariesPerModuleMap = new BidirectionalMultiMap();

        public final void addTrackedLibrary(@NotNull ModuleEntity moduleEntity, @NotNull LibraryTable libraryTable, @NotNull String libraryName) {
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            Library library = libraryTable.getLibraryByName(libraryName);
            String libraryIdentifier = this.getLibraryIdentifier(libraryTable, libraryName);
            if (!this.librariesPerModuleMap.containsValue(libraryIdentifier) && library != null) {
                library.getRootProvider().addRootSetChangedListener(ModuleDependencyIndexImpl.this.rootSetChangeListener);
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).addedDependencyOn(library);
            }
            this.librariesPerModuleMap.put(moduleEntity.getSymbolicId(), libraryIdentifier);
        }

        public final void unTrackLibrary(@NotNull ModuleEntity moduleEntity, @NotNull LibraryTable libraryTable, @NotNull String libraryName) {
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            Library library = libraryTable.getLibraryByName(libraryName);
            String libraryIdentifier = this.getLibraryIdentifier(libraryTable, libraryName);
            this.librariesPerModuleMap.remove(moduleEntity.getSymbolicId(), libraryIdentifier);
            if (!this.librariesPerModuleMap.containsValue(libraryIdentifier) && library != null) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).removedDependencyOn(library);
                library.getRootProvider().removeRootSetChangedListener(ModuleDependencyIndexImpl.this.rootSetChangeListener);
            }
        }

        public final boolean isEmpty(@NotNull String libraryLevel) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)libraryLevel, (String)"libraryLevel");
                Set<String> set2 = this.librariesPerModuleMap.getValues();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"librariesPerModuleMap.values");
                Iterable $this$none$iv = set2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!StringsKt.startsWith$default((String)it, (String)(libraryLevel + ModuleDependencyIndexImpl.LIBRARY_NAME_DELIMITER), (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HashSet<String> getLibraryLevels() {
            void var2_2;
            void $this$mapTo$iv;
            Set<String> set2 = this.librariesPerModuleMap.getValues();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"librariesPerModuleMap.values");
            Iterable iterable = set2;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string2 = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(StringsKt.substringBefore$default((String)it, (String)ModuleDependencyIndexImpl.LIBRARY_NAME_DELIMITER, null, (int)2, null));
            }
            return (HashSet)var2_2;
        }

        @Override
        public void afterLibraryAdded(@NotNull Library newLibrary) {
            Intrinsics.checkNotNullParameter((Object)newLibrary, (String)"newLibrary");
            if (this.hasDependencyOn(newLibrary)) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedLibraryAdded(newLibrary);
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).addedDependencyOn(newLibrary);
                newLibrary.getRootProvider().addRootSetChangedListener(ModuleDependencyIndexImpl.this.rootSetChangeListener);
            }
        }

        @Override
        public void afterLibraryRemoved(@NotNull Library library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            if (this.hasDependencyOn(library)) {
                library.getRootProvider().removeRootSetChangedListener(ModuleDependencyIndexImpl.this.rootSetChangeListener);
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).removedDependencyOn(library);
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedLibraryRemoved(library);
            }
        }

        public final boolean hasDependencyOn(@NotNull Library library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            return this.librariesPerModuleMap.containsValue(this.getLibraryIdentifier(library));
        }

        public final boolean hasDependencyOn(@NotNull LibraryId libraryId) {
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            return this.librariesPerModuleMap.containsValue(this.getLibraryIdentifier(libraryId));
        }

        @Override
        public void afterLibraryRenamed(@NotNull Library library, @Nullable String oldName) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            LibraryTable libraryTable = library.getTable();
            String newName2 = library.getName();
            if (libraryTable != null && oldName != null && newName2 != null) {
                String oldLibraryIdentifier = this.getLibraryIdentifier(libraryTable, oldName);
                Set<ModuleId> set2 = this.librariesPerModuleMap.getKeys(oldLibraryIdentifier);
                Intrinsics.checkNotNullExpressionValue(set2, (String)"librariesPerModuleMap.ge\u2026eys(oldLibraryIdentifier)");
                Set<ModuleId> affectedModules = set2;
                if (!((Collection)affectedModules).isEmpty()) {
                    String newLibraryIdentifier = this.getLibraryIdentifier(libraryTable, newName2);
                    Iterable $this$forEach$iv = affectedModules;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ModuleId affectedModule = (ModuleId)element$iv;
                        boolean bl = false;
                        this.librariesPerModuleMap.put(affectedModule, newLibraryIdentifier);
                    }
                    this.librariesPerModuleMap.removeValue(oldLibraryIdentifier);
                    String string2 = libraryTable.getTableLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"libraryTable.tableLevel");
                    LibraryTableId libraryTableId = LibraryNameGenerator.INSTANCE.getLibraryTableId(string2);
                    WorkspaceModel.Companion.getInstance(ModuleDependencyIndexImpl.this.project).updateProjectModel("Module dependency index: after library renamed", (Function1<? super MutableEntityStorage, Unit>)((Function1)new Function1<MutableEntityStorage, Unit>(affectedModules, libraryTableId, oldName, newName2){
                        final /* synthetic */ Set<ModuleId> $affectedModules;
                        final /* synthetic */ LibraryTableId $libraryTableId;
                        final /* synthetic */ String $oldName;
                        final /* synthetic */ String $newName;
                        {
                            this.$affectedModules = $affectedModules;
                            this.$libraryTableId = $libraryTableId;
                            this.$oldName = $oldName;
                            this.$newName = $newName;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull MutableEntityStorage builder2) {
                            void $this$forEach$iv;
                            Object it;
                            void $this$mapNotNullTo$iv$iv;
                            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                            Iterable $this$mapNotNull$iv = this.$affectedModules;
                            boolean $i$f$mapNotNull = false;
                            Object object = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                ModuleEntity it$iv$iv;
                                T element$iv$iv$iv;
                                T element$iv$iv = element$iv$iv$iv = iterator2.next();
                                boolean bl = false;
                                it = (ModuleId)element$iv$iv;
                                boolean bl2 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                if ((ModuleEntity)builder2.resolve((SymbolicEntityId)it) == null) continue;
                                boolean bl3 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            $this$mapNotNull$iv = (List)destination$iv$iv;
                            LibraryTableId libraryTableId = this.$libraryTableId;
                            object = this.$oldName;
                            String string2 = this.$newName;
                            boolean $i$f$forEach2 = false;
                            for (T element$iv : $this$forEach$iv) {
                                void $this$mapTo$iv$iv;
                                ModuleEntity module2 = (ModuleEntity)element$iv;
                                boolean bl = false;
                                Iterable $this$map$iv = module2.getDependencies();
                                boolean $i$f$map = false;
                                it = $this$map$iv;
                                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it2;
                                    ModuleDependencyItem moduleDependencyItem = (ModuleDependencyItem)item$iv$iv;
                                    Collection collection = destination$iv$iv2;
                                    boolean bl4 = false;
                                    collection.add(it2 instanceof ModuleDependencyItem.Exportable.LibraryDependency && Intrinsics.areEqual((Object)((ModuleDependencyItem.Exportable.LibraryDependency)it2).getLibrary().getTableId(), (Object)libraryTableId) && Intrinsics.areEqual((Object)((ModuleDependencyItem.Exportable.LibraryDependency)it2).getLibrary().getName(), (Object)object) ? (ModuleDependencyItem)ModuleDependencyItem.Exportable.LibraryDependency.copy$default((ModuleDependencyItem.Exportable.LibraryDependency)((ModuleDependencyItem.Exportable.LibraryDependency)it2), (LibraryId)new LibraryId(string2, libraryTableId), (boolean)false, null, (int)6, null) : it2);
                                }
                                List updated = TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv2));
                                ModuleKt.modifyEntity((MutableEntityStorage)builder2, (ModuleEntity)module2, (Function1)((Function1)new Function1<ModuleEntity.Builder, Unit>((List<ModuleDependencyItem>)updated){
                                    final /* synthetic */ List<ModuleDependencyItem> $updated;
                                    {
                                        this.$updated = $updated;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ModuleEntity.Builder $this$modifyEntity) {
                                        Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                                        $this$modifyEntity.setDependencies(this.$updated);
                                    }
                                }));
                            }
                        }
                    }));
                }
            }
        }

        private final String getLibraryIdentifier(Library library) {
            return library.getTable().getTableLevel() + ModuleDependencyIndexImpl.LIBRARY_NAME_DELIMITER + library.getName();
        }

        private final String getLibraryIdentifier(LibraryId libraryId) {
            return libraryId.getTableId().getLevel() + ModuleDependencyIndexImpl.LIBRARY_NAME_DELIMITER + libraryId.getName();
        }

        private final String getLibraryIdentifier(LibraryTable libraryTable, String libraryName) {
            return libraryTable.getTableLevel() + ModuleDependencyIndexImpl.LIBRARY_NAME_DELIMITER + libraryName;
        }

        public final void unsubscribe(boolean fireEvents) {
            Object element$iv;
            Iterator<Library> $this$forEach$iv;
            LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
            Iterable iterable = ModuleDependencyIndexImpl.this.libraryTablesListener.getLibraryLevels();
            ModuleDependencyIndexImpl moduleDependencyIndexImpl = ModuleDependencyIndexImpl.this;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Iterator<Library> iterator3;
                element$iv = iterator2.next();
                String libraryLevel = (String)element$iv;
                boolean bl = false;
                LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, moduleDependencyIndexImpl.project);
                Object object = libraryTable;
                if (object != null && (object = (iterator3 = object.getLibraryIterator())) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"libraryIterator");
                    Iterator<Library> $this$forEach$iv2 = iterator3;
                    boolean $i$f$forEach2 = false;
                    Iterator<Library> iterator4 = $this$forEach$iv2;
                    while (iterator4.hasNext()) {
                        Library element$iv2;
                        Library it = element$iv2 = iterator4.next();
                        boolean bl2 = false;
                        if (fireEvents) {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (this.hasDependencyOn(it)) {
                                ((ModuleDependencyListener)moduleDependencyIndexImpl.eventDispatcher.getMulticaster()).removedDependencyOn(it);
                            }
                        }
                        it.getRootProvider().removeRootSetChangedListener(moduleDependencyIndexImpl.rootSetChangeListener);
                    }
                }
                LibraryTable libraryTable2 = libraryTable;
                if (libraryTable2 == null) continue;
                libraryTable2.removeListener(moduleDependencyIndexImpl.libraryTablesListener);
            }
            if (fireEvents) {
                Iterator<Library> iterator5 = libraryTablesRegistrar.getLibraryTable().getLibraryIterator();
                Intrinsics.checkNotNullExpressionValue(iterator5, (String)"libraryTablesRegistrar.l\u2026raryTable.libraryIterator");
                $this$forEach$iv = iterator5;
                moduleDependencyIndexImpl = ModuleDependencyIndexImpl.this;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv;
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    Library it = (Library)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.hasDependencyOn(it)) continue;
                    ((ModuleDependencyListener)moduleDependencyIndexImpl.eventDispatcher.getMulticaster()).removedDependencyOn(it);
                }
            }
            this.librariesPerModuleMap.clear();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0013J\u0006\u0010!\u001a\u00020\u0005J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0013H\u0016J\u0018\u0010$\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0013H\u0016J\b\u0010(\u001a\u00020\u0019H\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR/\u0010\r\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00100\u00100\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$JdkChangeListener;", "Lcom/intellij/openapi/projectRoots/ProjectJdkTable$Listener;", "Lcom/intellij/openapi/roots/ex/ProjectRootManagerEx$ProjectJdkListener;", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl;)V", "projectJdkListenerAdded", "", "projectRootManager", "Lcom/intellij/openapi/roots/ProjectRootManager;", "kotlin.jvm.PlatformType", "getProjectRootManager", "()Lcom/intellij/openapi/roots/ProjectRootManager;", "projectRootManager$delegate", "Lkotlin/Lazy;", "sdkDependencies", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleId;", "Lorg/jetbrains/annotations/NotNull;", "watchedProjectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "watchedSdks", "Ljava/util/HashSet;", "Lcom/intellij/openapi/roots/RootProvider;", "Lkotlin/collections/HashSet;", "addTrackedJdk", "", "sdk", "sdkDependency", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "findSdk", "hasDependencyOn", "jdk", "hasProjectSdkDependency", "isProjectSdk", "jdkAdded", "jdkNameChanged", "previousName", "", "jdkRemoved", "projectJdkChanged", "removeTrackedJdk", "unsubscribe", "fireEvents", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nModuleDependencyIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$JdkChangeListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n1#2:407\n1855#3,2:408\n*S KotlinDebug\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$JdkChangeListener\n*L\n388#1:408,2\n*E\n"})
    private final class JdkChangeListener
    implements ProjectJdkTable.Listener,
    ProjectRootManagerEx.ProjectJdkListener {
        @NotNull
        private final MultiMap<ModuleDependencyItem, ModuleId> sdkDependencies;
        @NotNull
        private final HashSet<RootProvider> watchedSdks;
        @Nullable
        private Sdk watchedProjectSdk;
        private boolean projectJdkListenerAdded;
        @NotNull
        private final Lazy projectRootManager$delegate;

        public JdkChangeListener() {
            MultiMap multiMap = MultiMap.createSet();
            Intrinsics.checkNotNullExpressionValue(multiMap, (String)"createSet<ModuleDependencyItem, ModuleId>()");
            this.sdkDependencies = multiMap;
            this.watchedSdks = new HashSet();
            this.projectRootManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProjectRootManager>(ModuleDependencyIndexImpl.this){
                final /* synthetic */ ModuleDependencyIndexImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final ProjectRootManager invoke() {
                    return ProjectRootManager.getInstance(ModuleDependencyIndexImpl.access$getProject$p(this.this$0));
                }
            }));
        }

        @Override
        public void jdkAdded(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            if (this.hasDependencyOn(jdk)) {
                if (this.watchedSdks.isEmpty()) {
                    ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).firstDependencyOnSdkAdded();
                }
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedSdkAdded(jdk);
                if (this.hasProjectSdkDependency() && this.isProjectSdk(jdk)) {
                    this.watchedProjectSdk = jdk;
                }
                if (this.watchedSdks.add(jdk.getRootProvider())) {
                    ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).addedDependencyOn(jdk);
                    jdk.getRootProvider().addRootSetChangedListener(ModuleDependencyIndexImpl.this.rootSetChangeListener);
                }
            }
        }

        @Override
        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
            String string2 = jdk.getSdkType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jdk.sdkType.name");
            ModuleDependencyItem.SdkDependency sdkDependency = new ModuleDependencyItem.SdkDependency(previousName, string2);
            Collection<ModuleId> collection = this.sdkDependencies.get((ModuleDependencyItem)sdkDependency);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"sdkDependencies.get(sdkDependency)");
            Collection<ModuleId> affectedModules = collection;
            if (!affectedModules.isEmpty()) {
                WorkspaceModel.Companion.getInstance(ModuleDependencyIndexImpl.this.project).updateProjectModel("Module dependency index: jdk name changed", (Function1<? super MutableEntityStorage, Unit>)((Function1)new Function1<MutableEntityStorage, Unit>(affectedModules, jdk){
                    final /* synthetic */ Collection<ModuleId> $affectedModules;
                    final /* synthetic */ Sdk $jdk;
                    {
                        this.$affectedModules = $affectedModules;
                        this.$jdk = $jdk;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull MutableEntityStorage builder2) {
                        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                        for (ModuleId moduleId : this.$affectedModules) {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            ModuleEntity module2;
                            if ((ModuleEntity)moduleId.resolve((EntityStorage)builder2) == null) continue;
                            Iterable iterable = module2.getDependencies();
                            Sdk sdk2 = this.$jdk;
                            boolean $i$f$map = false;
                            void var9_9 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                ModuleDependencyItem moduleDependencyItem;
                                void it;
                                ModuleDependencyItem moduleDependencyItem2 = (ModuleDependencyItem)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                if (it instanceof ModuleDependencyItem.SdkDependency) {
                                    String string2 = sdk2.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jdk.name");
                                    String string3 = sdk2.getSdkType().getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jdk.sdkType.name");
                                    moduleDependencyItem = (ModuleDependencyItem)new ModuleDependencyItem.SdkDependency(string2, string3);
                                } else {
                                    moduleDependencyItem = it;
                                }
                                collection.add(moduleDependencyItem);
                            }
                            List updated = TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
                            ModuleKt.modifyEntity((MutableEntityStorage)builder2, (ModuleEntity)module2, (Function1)((Function1)new Function1<ModuleEntity.Builder, Unit>((List<ModuleDependencyItem>)updated){
                                final /* synthetic */ List<ModuleDependencyItem> $updated;
                                {
                                    this.$updated = $updated;
                                    super(1);
                                }

                                public final void invoke(@NotNull ModuleEntity.Builder $this$modifyEntity) {
                                    Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                                    $this$modifyEntity.setDependencies(this.$updated);
                                }
                            }));
                        }
                    }
                }));
            }
        }

        @Override
        public void jdkRemoved(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            if (this.hasProjectSdkDependency() && this.isProjectSdk(jdk)) {
                this.watchedProjectSdk = null;
            }
            if (this.watchedSdks.remove(jdk.getRootProvider())) {
                jdk.getRootProvider().removeRootSetChangedListener(ModuleDependencyIndexImpl.this.rootSetChangeListener);
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).removedDependencyOn(jdk);
            }
            if (this.hasDependencyOn(jdk)) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedSdkRemoved(jdk);
            }
            if (this.watchedSdks.isEmpty()) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).lastDependencyOnSdkRemoved();
            }
        }

        public final void addTrackedJdk(@NotNull ModuleDependencyItem sdkDependency, @NotNull ModuleEntity moduleEntity) {
            Sdk sdk2;
            Intrinsics.checkNotNullParameter((Object)sdkDependency, (String)"sdkDependency");
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            if (Intrinsics.areEqual((Object)sdkDependency, (Object)ModuleDependencyItem.InheritedSdkDependency.INSTANCE) && !this.projectJdkListenerAdded) {
                ProjectRootManager projectRootManager2 = this.getProjectRootManager();
                Intrinsics.checkNotNull((Object)projectRootManager2, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.ex.ProjectRootManagerEx");
                ((ProjectRootManagerEx)projectRootManager2).addProjectJdkListener(this);
                this.projectJdkListenerAdded = true;
            }
            if ((sdk2 = this.findSdk(sdkDependency)) != null) {
                if (Intrinsics.areEqual((Object)sdkDependency, (Object)ModuleDependencyItem.InheritedSdkDependency.INSTANCE)) {
                    this.watchedProjectSdk = sdk2;
                }
                this.addTrackedJdk(sdk2);
            }
            this.sdkDependencies.putValue(sdkDependency, moduleEntity.getSymbolicId());
        }

        private final void addTrackedJdk(Sdk sdk2) {
            if (this.watchedSdks.isEmpty()) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).firstDependencyOnSdkAdded();
            }
            if (this.watchedSdks.add(sdk2.getRootProvider())) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).addedDependencyOn(sdk2);
                sdk2.getRootProvider().addRootSetChangedListener(ModuleDependencyIndexImpl.this.rootSetChangeListener);
            }
        }

        public final void removeTrackedJdk(@NotNull ModuleDependencyItem sdkDependency, @NotNull ModuleEntity moduleEntity) {
            Intrinsics.checkNotNullParameter((Object)sdkDependency, (String)"sdkDependency");
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            this.sdkDependencies.remove(sdkDependency, moduleEntity.getSymbolicId());
            Sdk sdk2 = this.findSdk(sdkDependency);
            if (Intrinsics.areEqual((Object)sdkDependency, (Object)ModuleDependencyItem.InheritedSdkDependency.INSTANCE) && !this.hasProjectSdkDependency()) {
                this.watchedProjectSdk = null;
            }
            if (sdk2 != null) {
                this.removeTrackedJdk(sdk2);
            }
        }

        private final void removeTrackedJdk(Sdk sdk2) {
            if (!this.hasDependencyOn(sdk2) && this.watchedSdks.remove(sdk2.getRootProvider())) {
                sdk2.getRootProvider().removeRootSetChangedListener(ModuleDependencyIndexImpl.this.rootSetChangeListener);
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).removedDependencyOn(sdk2);
                if (this.watchedSdks.isEmpty()) {
                    ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).lastDependencyOnSdkRemoved();
                }
            }
        }

        @Override
        public void projectJdkChanged() {
            block2: {
                Sdk it;
                if (!this.hasProjectSdkDependency()) break block2;
                Sdk sdk2 = this.watchedProjectSdk;
                if (sdk2 != null) {
                    it = sdk2;
                    boolean bl = false;
                    this.removeTrackedJdk(it);
                }
                Sdk sdk3 = this.watchedProjectSdk = this.getProjectRootManager().getProjectSdk();
                if (sdk3 != null) {
                    it = sdk3;
                    boolean bl = false;
                    this.addTrackedJdk(it);
                }
            }
        }

        public final boolean hasProjectSdkDependency() {
            Collection<ModuleId> collection = this.sdkDependencies.get((ModuleDependencyItem)ModuleDependencyItem.InheritedSdkDependency.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"sdkDependencies.get(Modu\u2026m.InheritedSdkDependency)");
            return !collection.isEmpty();
        }

        private final ProjectRootManager getProjectRootManager() {
            Lazy lazy = this.projectRootManager$delegate;
            return (ProjectRootManager)lazy.getValue();
        }

        private final Sdk findSdk(ModuleDependencyItem sdkDependency) {
            ModuleDependencyItem moduleDependencyItem = sdkDependency;
            return moduleDependencyItem instanceof ModuleDependencyItem.InheritedSdkDependency ? this.getProjectRootManager().getProjectSdk() : (moduleDependencyItem instanceof ModuleDependencyItem.SdkDependency ? ModifiableRootModelBridge.Companion.findSdk(((ModuleDependencyItem.SdkDependency)sdkDependency).getSdkName(), ((ModuleDependencyItem.SdkDependency)sdkDependency).getSdkType()) : null);
        }

        public final boolean hasDependencyOn(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            String string2 = jdk.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jdk.name");
            String string3 = jdk.getSdkType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jdk.sdkType.name");
            Collection<ModuleId> collection = this.sdkDependencies.get((ModuleDependencyItem)new ModuleDependencyItem.SdkDependency(string2, string3));
            Intrinsics.checkNotNullExpressionValue(collection, (String)"sdkDependencies.get(Modu\u2026.name, jdk.sdkType.name))");
            return !collection.isEmpty() || this.isProjectSdk(jdk) && this.hasProjectSdkDependency();
        }

        private final boolean isProjectSdk(Sdk jdk) {
            return Intrinsics.areEqual((Object)jdk.getName(), (Object)this.getProjectRootManager().getProjectSdkName()) && Intrinsics.areEqual((Object)jdk.getSdkType().getName(), (Object)this.getProjectRootManager().getProjectSdkTypeName());
        }

        /*
         * WARNING - void declaration
         */
        public final void unsubscribe(boolean fireEvents) {
            void $this$forEach$iv;
            Iterable iterable = this.watchedSdks;
            ModuleDependencyIndexImpl moduleDependencyIndexImpl = ModuleDependencyIndexImpl.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RootProvider it = (RootProvider)element$iv;
                boolean bl = false;
                if (fireEvents) {
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.util.function.Supplier<com.intellij.openapi.projectRoots.Sdk>");
                    Object t = ((Supplier)((Object)it)).get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"it as Supplier<Sdk>).get()");
                    Sdk sdk2 = (Sdk)t;
                    if (this.hasDependencyOn(sdk2)) {
                        ((ModuleDependencyListener)moduleDependencyIndexImpl.eventDispatcher.getMulticaster()).removedDependencyOn(sdk2);
                    }
                }
                it.removeRootSetChangedListener(moduleDependencyIndexImpl.rootSetChangeListener);
            }
            this.watchedSdks.clear();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$ReferencedRootSetChangeListener;", "Lcom/intellij/openapi/roots/RootProvider$RootSetChangedListener;", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl;)V", "rootSetChanged", "", "wrapper", "Lcom/intellij/openapi/roots/RootProvider;", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nModuleDependencyIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$ReferencedRootSetChangeListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n1#2:407\n*E\n"})
    private final class ReferencedRootSetChangeListener
    implements RootProvider.RootSetChangedListener {
        @Override
        public void rootSetChanged(@NotNull RootProvider wrapper2) {
            Intrinsics.checkNotNullParameter((Object)wrapper2, (String)"wrapper");
            if (wrapper2 instanceof Library) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedLibraryChanged((Library)((Object)wrapper2));
            } else {
                if (!(wrapper2 instanceof Supplier)) {
                    boolean bl = false;
                    String string2 = "Unexpected root provider " + wrapper2 + " does not implement Supplier<Sdk>";
                    throw new IllegalArgumentException(string2.toString());
                }
                Object value = ((Supplier)((Object)wrapper2)).get();
                if (!(value instanceof Sdk)) {
                    boolean bl = false;
                    String string3 = "Unexpected root provider " + wrapper2 + " does not implement Supplier<Sdk>";
                    throw new IllegalArgumentException(string3.toString());
                }
                ModuleDependencyListener moduleDependencyListener = (ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster();
                Intrinsics.checkNotNullExpressionValue(value, (String)"value");
                moduleDependencyListener.referencedSdkChanged((Sdk)value);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$Companion;", "", "()V", "LIBRARY_NAME_DELIMITER", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

