/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.impl.VirtualFileUrlBridge;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010\u0019\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\f0\u001b0\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016J9\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010\u001e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\f0\u001b0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001fJ9\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010\u001e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\f0\u001b0\u001aH\u0016\u00a2\u0006\u0002\u0010!R&\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/OrderRootsCacheBridge;", "Lcom/intellij/openapi/roots/impl/OrderRootsCache;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "myRootUrls", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/roots/impl/OrderRootsCache$CacheKey;", "", "", "myRootVirtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "virtualFileUrlManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "cacheRootsIfNeeded", "", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "flags", "", "rootUrlsComputer", "Ljava/util/function/Supplier;", "", "clearCache", "getOrComputeRoots", "computer", "(Lcom/intellij/openapi/roots/OrderRootType;ILjava/util/function/Supplier;)[Lcom/intellij/openapi/vfs/VirtualFile;", "getOrComputeUrls", "(Lcom/intellij/openapi/roots/OrderRootType;ILjava/util/function/Supplier;)[Ljava/lang/String;", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nOrderRootsCacheBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderRootsCacheBridge.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/OrderRootsCacheBridge\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n26#2:55\n26#2:56\n1549#3:57\n1620#3,3:58\n1549#3:61\n1620#3,3:62\n*S KotlinDebug\n*F\n+ 1 OrderRootsCacheBridge.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/OrderRootsCacheBridge\n*L\n26#1:55\n31#1:56\n44#1:57\n44#1:58,3\n49#1:61\n49#1:62,3\n*E\n"})
public final class OrderRootsCacheBridge
extends OrderRootsCache {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFileUrlManager virtualFileUrlManager;
    @NotNull
    private final AtomicReference<ConcurrentMap<OrderRootsCache.CacheKey, String[]>> myRootUrls;
    @NotNull
    private final AtomicReference<ConcurrentMap<OrderRootsCache.CacheKey, VirtualFile[]>> myRootVirtualFiles;

    public OrderRootsCacheBridge(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(parentDisposable);
        this.project = project2;
        this.virtualFileUrlManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        this.myRootUrls = new AtomicReference();
        this.myRootVirtualFiles = new AtomicReference();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public VirtualFile[] getOrComputeRoots(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        Intrinsics.checkNotNullParameter(computer, (String)"computer");
        this.cacheRootsIfNeeded(rootType, flags, computer);
        VirtualFile[] virtualFileArray = (VirtualFile[])this.myRootVirtualFiles.get().get(new OrderRootsCache.CacheKey(rootType, flags));
        if (virtualFileArray == null) {
            boolean $i$f$emptyArray = false;
            virtualFileArray = new VirtualFile[]{};
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getOrComputeUrls(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        Intrinsics.checkNotNullParameter(computer, (String)"computer");
        this.cacheRootsIfNeeded(rootType, flags, computer);
        String[] stringArray = (String[])this.myRootUrls.get().get(new OrderRootsCache.CacheKey(rootType, flags));
        if (stringArray == null) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public void clearCache() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        this.myRootUrls.set(null);
        this.myRootVirtualFiles.set(null);
    }

    private final void cacheRootsIfNeeded(OrderRootType rootType, int flags, Supplier<? extends Collection<String>> rootUrlsComputer) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Ref.ObjectRef objectRef;
        OrderRootsCache.CacheKey key = new OrderRootsCache.CacheKey(rootType, flags);
        Ref.ObjectRef virtualFileUrls = new Ref.ObjectRef();
        ConcurrentMap<OrderRootsCache.CacheKey, String[]> concurrentMap = this.myRootUrls.get();
        if ((concurrentMap != null ? (String[])concurrentMap.get(key) : null) == null) {
            Iterable iterable = rootUrlsComputer.get();
            objectRef = virtualFileUrls;
            $i$f$map = false;
            void var8_9 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                VirtualFileUrl virtualFileUrl = this.virtualFileUrlManager.fromUrl(it);
                Intrinsics.checkNotNull((Object)virtualFileUrl, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.VirtualFileUrlBridge");
                collection.add((VirtualFileUrlBridge)virtualFileUrl);
            }
            objectRef.element = (List)destination$iv$iv;
            ((ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myRootUrls, new ConcurrentHashMap())).computeIfAbsent(key, arg_0 -> OrderRootsCacheBridge.cacheRootsIfNeeded$lambda$1((Function1)new Function1<OrderRootsCache.CacheKey, String[]>((Ref.ObjectRef<List<VirtualFileUrlBridge>>)virtualFileUrls){
                final /* synthetic */ Ref.ObjectRef<List<VirtualFileUrlBridge>> $virtualFileUrls;
                {
                    this.$virtualFileUrls = $virtualFileUrls;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final String[] invoke(OrderRootsCache.CacheKey it) {
                    void $this$mapTo$iv$iv;
                    Object object = this.$virtualFileUrls.element;
                    Intrinsics.checkNotNull((Object)object);
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        VirtualFileUrlBridge virtualFileUrlBridge = (VirtualFileUrlBridge)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it2.getUrl());
                    }
                    Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new String[0]);
                }
            }, arg_0));
        }
        ConcurrentMap<OrderRootsCache.CacheKey, VirtualFile[]> concurrentMap2 = this.myRootVirtualFiles.get();
        if ((concurrentMap2 != null ? (VirtualFile[])concurrentMap2.get(key) : null) == null) {
            if (virtualFileUrls.element == null) {
                $this$map$iv = rootUrlsComputer.get();
                objectRef = virtualFileUrls;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    VirtualFileUrl virtualFileUrl = this.virtualFileUrlManager.fromUrl(it);
                    Intrinsics.checkNotNull((Object)virtualFileUrl, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.VirtualFileUrlBridge");
                    collection.add((VirtualFileUrlBridge)virtualFileUrl);
                }
                objectRef.element = (List)destination$iv$iv;
            }
            ((ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myRootVirtualFiles, new ConcurrentHashMap())).computeIfAbsent(key, arg_0 -> OrderRootsCacheBridge.cacheRootsIfNeeded$lambda$3((Function1)new Function1<OrderRootsCache.CacheKey, VirtualFile[]>((Ref.ObjectRef<List<VirtualFileUrlBridge>>)virtualFileUrls){
                final /* synthetic */ Ref.ObjectRef<List<VirtualFileUrlBridge>> $virtualFileUrls;
                {
                    this.$virtualFileUrls = $virtualFileUrls;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final VirtualFile[] invoke(OrderRootsCache.CacheKey it) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)this.$virtualFileUrls.element;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        VirtualFile it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        VirtualFileUrlBridge it2 = (VirtualFileUrlBridge)element$iv$iv;
                        boolean bl2 = false;
                        if (it2.getFile() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new VirtualFile[0]);
                }
            }, arg_0));
        }
    }

    private static final String[] cacheRootsIfNeeded$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String[])$tmp0.invoke(p0);
    }

    private static final VirtualFile[] cacheRootsIfNeeded$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile[])$tmp0.invoke(p0);
    }
}

