/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.indexing.BuildableRootsChangeRescanningInfo;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.OrderRootsCacheBridge;
import com.intellij.workspaceModel.ide.legacyBridge.GlobalLibraryTableBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\nR\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge;", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleDependencyIndex", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyIndex;", "getModuleDependencyIndex", "()Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyIndex;", "fireRootsChanged", "", "info", "Lcom/intellij/openapi/project/RootsChangeRescanningInfo;", "getActionToRunWhenProjectJdkChanges", "Ljava/lang/Runnable;", "getOrderRootsCache", "Lcom/intellij/openapi/roots/impl/OrderRootsCache;", "isFiringEvent", "", "setupTrackedLibrariesAndJdks", "ModuleDependencyListenerImpl", "intellij.platform.lang.impl"})
public final class ProjectRootManagerBridge
extends ProjectRootManagerComponent {
    public ProjectRootManagerBridge(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        if (!project2.isDefault()) {
            this.getModuleDependencyIndex().addListener(new ModuleDependencyListenerImpl());
        }
    }

    private final ModuleDependencyIndex getModuleDependencyIndex() {
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return ModuleDependencyIndex.Companion.getInstance(project2);
    }

    @Override
    @NotNull
    protected Runnable getActionToRunWhenProjectJdkChanges() {
        return () -> ProjectRootManagerBridge.getActionToRunWhenProjectJdkChanges$lambda$0(this);
    }

    @Override
    @NotNull
    protected OrderRootsCache getOrderRootsCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new OrderRootsCacheBridge(project2, project2);
    }

    public final boolean isFiringEvent() {
        return this.isFiringEvent;
    }

    public final void setupTrackedLibrariesAndJdks() {
        this.getModuleDependencyIndex().setupTrackedLibrariesAndJdks();
    }

    private final void fireRootsChanged(RootsChangeRescanningInfo info2) {
        if (this.myProject.isOpen()) {
            this.makeRootsChange(EmptyRunnable.INSTANCE, info2);
        }
    }

    private static final void getActionToRunWhenProjectJdkChanges$lambda$0(ProjectRootManagerBridge this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        super.getActionToRunWhenProjectJdkChanges().run();
        if (this$0.getModuleDependencyIndex().hasProjectSdkDependency()) {
            BuildableRootsChangeRescanningInfo buildableRootsChangeRescanningInfo = BuildableRootsChangeRescanningInfo.newInstance().addInheritedSdk();
            Intrinsics.checkNotNullExpressionValue((Object)buildableRootsChangeRescanningInfo, (String)"newInstance().addInheritedSdk()");
            this$0.fireRootsChanged((RootsChangeRescanningInfo)buildableRootsChangeRescanningInfo);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge$ModuleDependencyListenerImpl;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyListener;", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootManagerBridge;)V", "insideRootsChange", "", "referencedLibraryAdded", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "referencedLibraryChanged", "referencedLibraryRemoved", "referencedSdkAdded", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "referencedSdkChanged", "referencedSdkRemoved", "shouldListen", "intellij.platform.lang.impl"})
    public final class ModuleDependencyListenerImpl
    implements ModuleDependencyListener {
        private boolean insideRootsChange;

        @Override
        public void referencedLibraryAdded(@NotNull Library library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            if (this.shouldListen(library)) {
                BuildableRootsChangeRescanningInfo buildableRootsChangeRescanningInfo = BuildableRootsChangeRescanningInfo.newInstance().addLibrary(library);
                Intrinsics.checkNotNullExpressionValue((Object)buildableRootsChangeRescanningInfo, (String)"newInstance().addLibrary(library)");
                ProjectRootManagerBridge.this.fireRootsChanged((RootsChangeRescanningInfo)buildableRootsChangeRescanningInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void referencedLibraryChanged(@NotNull Library library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            if (this.insideRootsChange || !this.shouldListen(library)) {
                return;
            }
            this.insideRootsChange = true;
            try {
                BuildableRootsChangeRescanningInfo buildableRootsChangeRescanningInfo = BuildableRootsChangeRescanningInfo.newInstance().addLibrary(library);
                Intrinsics.checkNotNullExpressionValue((Object)buildableRootsChangeRescanningInfo, (String)"newInstance().addLibrary(library)");
                ProjectRootManagerBridge.this.fireRootsChanged((RootsChangeRescanningInfo)buildableRootsChangeRescanningInfo);
            }
            finally {
                this.insideRootsChange = false;
            }
        }

        @Override
        public void referencedLibraryRemoved(@NotNull Library library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            if (this.shouldListen(library)) {
                RootsChangeRescanningInfo rootsChangeRescanningInfo = RootsChangeRescanningInfo.NO_RESCAN_NEEDED;
                Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"NO_RESCAN_NEEDED");
                ProjectRootManagerBridge.this.fireRootsChanged(rootsChangeRescanningInfo);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldListen(Library library) {
            if (GlobalLibraryTableBridge.Companion.isEnabled()) {
                LibraryTable libraryTable = library.getTable();
                if (Intrinsics.areEqual((Object)(libraryTable != null ? libraryTable.getTableLevel() : null), (Object)"project")) return false;
                LibraryTable libraryTable2 = library.getTable();
                if (Intrinsics.areEqual((Object)(libraryTable2 != null ? libraryTable2.getTableLevel() : null), (Object)"application")) return false;
                return true;
            }
            LibraryTable libraryTable = library.getTable();
            if (Intrinsics.areEqual((Object)(libraryTable != null ? libraryTable.getTableLevel() : null), (Object)"project")) return false;
            return true;
        }

        @Override
        public void referencedSdkAdded(@NotNull Sdk sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            BuildableRootsChangeRescanningInfo buildableRootsChangeRescanningInfo = BuildableRootsChangeRescanningInfo.newInstance().addSdk(sdk2);
            Intrinsics.checkNotNullExpressionValue((Object)buildableRootsChangeRescanningInfo, (String)"newInstance().addSdk(sdk)");
            ProjectRootManagerBridge.this.fireRootsChanged((RootsChangeRescanningInfo)buildableRootsChangeRescanningInfo);
        }

        @Override
        public void referencedSdkChanged(@NotNull Sdk sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            BuildableRootsChangeRescanningInfo buildableRootsChangeRescanningInfo = BuildableRootsChangeRescanningInfo.newInstance().addSdk(sdk2);
            Intrinsics.checkNotNullExpressionValue((Object)buildableRootsChangeRescanningInfo, (String)"newInstance().addSdk(sdk)");
            ProjectRootManagerBridge.this.fireRootsChanged((RootsChangeRescanningInfo)buildableRootsChangeRescanningInfo);
        }

        @Override
        public void referencedSdkRemoved(@NotNull Sdk sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            RootsChangeRescanningInfo rootsChangeRescanningInfo = RootsChangeRescanningInfo.NO_RESCAN_NEEDED;
            Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"NO_RESCAN_NEEDED");
            ProjectRootManagerBridge.this.fireRootsChanged(rootsChangeRescanningInfo);
        }
    }
}

