/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.util.indexing.EntityIndexingServiceEx;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleDependencyIndexImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "beforeChanged", "", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "changed", "shouldFireRootsChanged", "", "events", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nProjectRootsChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectRootsChangeListener.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,47:1\n1229#2,2:48\n*S KotlinDebug\n*F\n+ 1 ProjectRootsChangeListener.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener\n*L\n38#1:48,2\n*E\n"})
public final class ProjectRootsChangeListener {
    @NotNull
    private final Project project;

    public ProjectRootsChangeListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public final void beforeChanged(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        ProjectRootManager projectRootManager2 = ProjectRootManager.getInstance(this.project);
        if (!(projectRootManager2 instanceof ProjectRootManagerBridge)) {
            return;
        }
        boolean performUpdate = this.shouldFireRootsChanged(event, this.project);
        if (performUpdate) {
            ((ProjectRootManagerBridge)projectRootManager2).getRootsChanged().beforeRootsChanged();
        }
    }

    public final void changed(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        ModuleDependencyIndex moduleDependencyIndex = ModuleDependencyIndex.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)moduleDependencyIndex, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleDependencyIndexImpl");
        ((ModuleDependencyIndexImpl)moduleDependencyIndex).workspaceModelChanged(event);
        ProjectRootManager projectRootManager2 = ProjectRootManager.getInstance(this.project);
        if (!(projectRootManager2 instanceof ProjectRootManagerBridge)) {
            return;
        }
        boolean performUpdate = this.shouldFireRootsChanged(event, this.project);
        if (performUpdate) {
            RootsChangeRescanningInfo rootsChangeRescanningInfo = EntityIndexingServiceEx.getInstanceEx().createWorkspaceChangedEventInfo(SequencesKt.toList((Sequence)event.getAllChanges()));
            Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"getInstanceEx().createWo\u2026getAllChanges().toList())");
            RootsChangeRescanningInfo rootsChangeInfo = rootsChangeRescanningInfo;
            ((ProjectRootManagerBridge)projectRootManager2).getRootsChanged().rootsChanged(rootsChangeInfo);
        }
    }

    private final boolean shouldFireRootsChanged(VersionedStorageChange events, Project project2) {
        boolean bl;
        block7: {
            EntityIndexingServiceEx entityIndexingServiceEx = EntityIndexingServiceEx.getInstanceEx();
            Intrinsics.checkNotNullExpressionValue((Object)entityIndexingServiceEx, (String)"getInstanceEx()");
            EntityIndexingServiceEx indexingService = entityIndexingServiceEx;
            Sequence $this$any$iv = events.getAllChanges();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                WorkspaceEntity entity;
                WorkspaceEntity workspaceEntity;
                EntityChange it = (EntityChange)element$iv;
                boolean bl2 = false;
                EntityChange entityChange = it;
                if (entityChange instanceof EntityChange.Added) {
                    workspaceEntity = ((EntityChange.Added)it).getEntity();
                } else if (entityChange instanceof EntityChange.Removed) {
                    workspaceEntity = ((EntityChange.Removed)it).getEntity();
                } else if (entityChange instanceof EntityChange.Replaced) {
                    workspaceEntity = ((EntityChange.Replaced)it).getNewEntity();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!indexingService.shouldCauseRescan(entity = workspaceEntity, project2)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }
}

