/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.watcher;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.UtilKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.JarDirectoryDescription;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\rJ\u0011\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0003J\u0011\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\rR\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/FileContainerDescription;", "", "urls", "", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "jarDirectories", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/JarDirectoryDescription;", "(Ljava/util/List;Ljava/util/List;)V", "cachedFilesList", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "[Lcom/intellij/openapi/vfs/VirtualFile;", "cachedUrlsList", "", "[Ljava/lang/String;", "timestampOfCachedFiles", "", "getUrls", "()Ljava/util/List;", "virtualFilePointerManager", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerManager;", "kotlin.jvm.PlatformType", "virtualFilePointersList", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "cacheVirtualFilePointersData", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "findByUrl", "url", "getFiles", "getList", "()[Ljava/lang/String;", "isJarDirectory", "", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nFileContainerDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContainerDescription.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/FileContainerDescription\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1855#2,2:115\n1855#2,2:117\n1747#2,3:119\n1549#2:123\n1620#2,3:124\n1#3:122\n*S KotlinDebug\n*F\n+ 1 FileContainerDescription.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/FileContainerDescription\n*L\n32#1:115,2\n33#1:117,2\n36#1:119,3\n41#1:123\n41#1:124,3\n*E\n"})
public final class FileContainerDescription {
    @NotNull
    private final List<VirtualFileUrl> urls;
    @NotNull
    private final List<JarDirectoryDescription> jarDirectories;
    @NotNull
    private final Set<VirtualFilePointer> virtualFilePointersList;
    private final VirtualFilePointerManager virtualFilePointerManager;
    private volatile long timestampOfCachedFiles;
    @NotNull
    private volatile VirtualFile[] cachedFilesList;
    @Nullable
    private volatile String[] cachedUrlsList;

    public FileContainerDescription(@NotNull List<? extends VirtualFileUrl> urls, @NotNull List<JarDirectoryDescription> jarDirectories) {
        Object it;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter(jarDirectories, (String)"jarDirectories");
        this.urls = urls;
        this.jarDirectories = jarDirectories;
        this.virtualFilePointersList = new LinkedHashSet();
        this.virtualFilePointerManager = VirtualFilePointerManager.getInstance();
        this.timestampOfCachedFiles = -1L;
        this.cachedFilesList = new VirtualFile[0];
        Iterable $this$forEach$iv = this.urls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFileUrl)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.pointers.VirtualFilePointer");
            this.virtualFilePointersList.add((VirtualFilePointer)it);
        }
        $this$forEach$iv = this.jarDirectories;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JarDirectoryDescription)element$iv;
            boolean bl = false;
            VirtualFileUrl virtualFileUrl = ((JarDirectoryDescription)it).getDirectoryUrl();
            Intrinsics.checkNotNull((Object)virtualFileUrl, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.pointers.VirtualFilePointer");
            this.virtualFilePointersList.add((VirtualFilePointer)virtualFileUrl);
        }
    }

    @NotNull
    public final List<VirtualFileUrl> getUrls() {
        return this.urls;
    }

    public final boolean isJarDirectory(@NotNull String url) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Iterable $this$any$iv = this.jarDirectories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JarDirectoryDescription it = (JarDirectoryDescription)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getDirectoryUrl().getUrl(), (Object)url)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final VirtualFilePointer findByUrl(@NotNull String url) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Iterable iterable = this.virtualFilePointersList;
            for (Object t : iterable) {
                VirtualFilePointer it = (VirtualFilePointer)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final List<VirtualFilePointer> getList() {
        List<VirtualFilePointer> list2 = Collections.unmodifiableList(CollectionsKt.toList((Iterable)this.virtualFilePointersList));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(virtualFilePointersList.toList())");
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getUrls() {
        if (this.cachedUrlsList == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.virtualFilePointersList;
            FileContainerDescription fileContainerDescription = this;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFilePointer virtualFilePointer = (VirtualFilePointer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUrl());
            }
            Collection collection = (List)destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
            fileContainerDescription.cachedUrlsList = (String[])UtilKt.toArray(collection, (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
        }
        Intrinsics.checkNotNull((Object)this.cachedUrlsList);
        return this.cachedUrlsList;
    }

    @NotNull
    public final VirtualFile[] getFiles() {
        long timestamp = this.timestampOfCachedFiles;
        VirtualFile[] cachedResults = this.cachedFilesList;
        return timestamp == this.virtualFilePointerManager.getModificationCount() ? cachedResults : this.cacheVirtualFilePointersData();
    }

    private final VirtualFile[] cacheVirtualFilePointersData() {
        List cachedFiles = new ArrayList(this.virtualFilePointersList.size());
        List cachedDirectories = new ArrayList(this.virtualFilePointersList.size() / 3);
        boolean allFilesAreDirs = true;
        for (VirtualFilePointer pointer : this.virtualFilePointersList) {
            VirtualFile file2;
            if (!pointer.isValid() || (file2 = pointer.getFile()) == null) continue;
            cachedFiles.add(file2);
            if (file2.isDirectory()) {
                cachedDirectories.add(file2);
                continue;
            }
            allFilesAreDirs = false;
        }
        for (JarDirectoryDescription jarDirectory : this.jarDirectories) {
            VirtualFile directoryFile;
            VirtualFileUrl virtualFileUrl = jarDirectory.getDirectoryUrl();
            Intrinsics.checkNotNull((Object)virtualFileUrl, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.pointers.VirtualFilePointer");
            VirtualFilePointer virtualFilePointer = (VirtualFilePointer)virtualFileUrl;
            if (!virtualFilePointer.isValid() || (directoryFile = virtualFilePointer.getFile()) == null) continue;
            cachedDirectories.remove(directoryFile);
            if (jarDirectory.getRecursive()) {
                VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
                VfsUtilCore.visitChildrenRecursively(directoryFile, new VirtualFileVisitor<Void>((List<VirtualFile>)cachedFiles, (List<VirtualFile>)cachedDirectories, optionArray){
                    final /* synthetic */ List<VirtualFile> $cachedFiles;
                    final /* synthetic */ List<VirtualFile> $cachedDirectories;
                    {
                        this.$cachedFiles = $cachedFiles;
                        this.$cachedDirectories = $cachedDirectories;
                        super($super_call_param$1);
                    }

                    public boolean visitFile(@NotNull VirtualFile file2) {
                        VirtualFile jarRoot;
                        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                        if (!file2.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file2.getPath() + "!/")) != null) {
                            this.$cachedFiles.add(jarRoot);
                            this.$cachedDirectories.add(jarRoot);
                            return false;
                        }
                        return true;
                    }
                });
                continue;
            }
            if (!directoryFile.isValid()) continue;
            VirtualFile[] children2 = directoryFile.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)children2, (String)"children");
            for (VirtualFile file3 : children2) {
                VirtualFile jarRoot;
                if (file3.isDirectory() || FileTypeRegistry.getInstance().getFileTypeByFileName(file3.getNameSequence()) != ArchiveFileType.INSTANCE || (jarRoot = StandardFileSystems.jar().findFileByPath(file3.getPath() + "!/")) == null) continue;
                cachedFiles.add(jarRoot);
                cachedDirectories.add(jarRoot);
            }
        }
        VirtualFile[] virtualFileArray = allFilesAreDirs ? VfsUtilCore.toVirtualFileArray(cachedDirectories) : VfsUtilCore.toVirtualFileArray(cachedFiles);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"if (allFilesAreDirs) Vfs\u2026ualFileArray(cachedFiles)");
        VirtualFile[] files2 = virtualFileArray;
        this.cachedFilesList = files2;
        this.timestampOfCachedFiles = this.virtualFilePointerManager.getModificationCount();
        return files2;
    }
}

