/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.watcher;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.indexing.EntityIndexingServiceEx;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.VirtualFileUrls;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.GlobalLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.EntityChangeStorage;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.EntityWithVirtualFileUrl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.OldRootsChangeWatcher;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.OldRootsChangeWatcherKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.VirtualFileUrlWatcher;
import com.intellij.workspaceModel.ide.legacyBridge.GlobalLibraryTableBridge;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J6\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/OldRootsChangeWatcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "calculateEntityChangesIfNeeded", "", "entityChanges", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/EntityChangeStorage;", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "virtualFileUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "allRootsWereRemoved", "", "collectAffectedEntities", "url", "affectedEntities", "", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/EntityWithVirtualFileUrl;", "fireRootsChangeEvent", "beforeRootsChanged", "entityChangesStorage", "getIncludingJarDirectory", "isRootChangeForbidden", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "prepareChange$intellij_platform_lang_impl", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nOldRootsChangeWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OldRootsChangeWatcher.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/OldRootsChangeWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1855#2,2:212\n1747#2,3:214\n1549#2:217\n1620#2,3:218\n1855#2,2:221\n*S KotlinDebug\n*F\n+ 1 OldRootsChangeWatcher.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/OldRootsChangeWatcher\n*L\n116#1:212,2\n121#1:214,3\n122#1:217\n122#1:218,3\n159#1:221,2\n*E\n"})
public final class OldRootsChangeWatcher {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFileUrlManager virtualFileManager;

    public OldRootsChangeWatcher(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
    }

    @Nullable
    public final AsyncFileListener.ChangeApplier prepareChange$intellij_platform_lang_impl(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        EntityChangeStorage entityChanges = new EntityChangeStorage();
        EntityStorageSnapshot entityStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        for (VFileEvent vFileEvent : events) {
            String newUrl;
            Pair pair;
            String oldUrl;
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileDeleteEvent) {
                EntityStorage entityStorage2 = (EntityStorage)entityStorage;
                String string2 = ((VFileDeleteEvent)vFileEvent).getFile().getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.file.url");
                this.calculateEntityChangesIfNeeded(entityChanges, entityStorage2, this.virtualFileManager.fromUrl(string2), true);
                continue;
            }
            if (vFileEvent2 instanceof VFileCreateEvent) {
                Object object;
                String parentUrl;
                Intrinsics.checkNotNullExpressionValue((Object)((VFileCreateEvent)vFileEvent).getParent().getUrl(), (String)"event.parent.url");
                int protocolEnd = StringsKt.indexOf$default((CharSequence)parentUrl, (String)"://", (int)0, (boolean)false, (int)6, null);
                if (protocolEnd != -1) {
                    String string3 = parentUrl.substring(0, protocolEnd);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    object = string3 + "://" + ((VFileCreateEvent)vFileEvent).getPath();
                } else {
                    String string4 = VfsUtilCore.pathToUrl(((VFileCreateEvent)vFileEvent).getPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            VfsUtilCor\u2026l(event.path)\n          }");
                    object = string4;
                }
                String url = object;
                VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(url);
                this.calculateEntityChangesIfNeeded(entityChanges, (EntityStorage)entityStorage, virtualFileUrl, false);
                if (!StringsKt.startsWith$default((String)url, (String)"file", (boolean)false, (int)2, null)) continue;
                if (!((VFileCreateEvent)vFileEvent).isDirectory()) {
                    String string4 = ((VFileCreateEvent)vFileEvent).getChildName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"event.childName");
                    if (!StringsKt.endsWith$default((String)string4, (String)".jar", (boolean)false, (int)2, null)) continue;
                }
                String suffix = ((VFileCreateEvent)vFileEvent).isDirectory() ? "" : "!/";
                String jarFileUrl = "jar://" + VfsUtil.urlToPath(url) + suffix;
                VirtualFileUrl jarVirtualFileUrl = this.virtualFileManager.fromUrl(jarFileUrl);
                this.calculateEntityChangesIfNeeded(entityChanges, (EntityStorage)entityStorage, jarVirtualFileUrl, false);
                continue;
            }
            if (vFileEvent2 instanceof VFileCopyEvent) {
                EntityStorage entityStorage3 = (EntityStorage)entityStorage;
                String string5 = VfsUtilCore.pathToUrl(((VFileCopyEvent)vFileEvent).getPath());
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"pathToUrl(event.path)");
                this.calculateEntityChangesIfNeeded(entityChanges, entityStorage3, this.virtualFileManager.fromUrl(string5), false);
                continue;
            }
            if (!(vFileEvent2 instanceof VFilePropertyChangeEvent ? true : vFileEvent2 instanceof VFileMoveEvent) || Intrinsics.areEqual((Object)(oldUrl = (String)(pair = OldRootsChangeWatcherKt.access$getOldAndNewUrls(vFileEvent)).component1()), (Object)(newUrl = (String)pair.component2()))) continue;
            this.calculateEntityChangesIfNeeded(entityChanges, (EntityStorage)entityStorage, this.virtualFileManager.fromUrl(oldUrl), true);
            this.calculateEntityChangesIfNeeded(entityChanges, (EntityStorage)entityStorage, this.virtualFileManager.fromUrl(newUrl), false);
        }
        if (!entityChanges.hasChanges()) {
            return null;
        }
        return new AsyncFileListener.ChangeApplier(this, entityChanges){
            final /* synthetic */ OldRootsChangeWatcher this$0;
            final /* synthetic */ EntityChangeStorage $entityChanges;
            {
                this.this$0 = $receiver;
                this.$entityChanges = $entityChanges;
            }

            public void beforeVfsChange() {
                OldRootsChangeWatcher.access$fireRootsChangeEvent(this.this$0, true, this.$entityChanges);
            }

            public void afterVfsChange() {
                OldRootsChangeWatcher.fireRootsChangeEvent$default(this.this$0, false, this.$entityChanges, 1, null);
            }
        };
    }

    private final VirtualFileUrl getIncludingJarDirectory(EntityStorage storage, VirtualFileUrl virtualFileUrl) {
        VirtualFileUrlIndex virtualFileUrlIndex = storage.getVirtualFileUrlIndex();
        Intrinsics.checkNotNull((Object)virtualFileUrlIndex, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex");
        Set indexedJarDirectories = ((VirtualFileIndex)virtualFileUrlIndex).getIndexedJarDirectories();
        VirtualFileUrl parentVirtualFileUrl = virtualFileUrl;
        while (parentVirtualFileUrl != null && !indexedJarDirectories.contains(parentVirtualFileUrl)) {
            parentVirtualFileUrl = this.virtualFileManager.getParentVirtualUrl(parentVirtualFileUrl);
        }
        return parentVirtualFileUrl != null && indexedJarDirectories.contains(parentVirtualFileUrl) ? parentVirtualFileUrl : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateEntityChangesIfNeeded(EntityChangeStorage entityChanges, EntityStorage storage, VirtualFileUrl virtualFileUrl, boolean allRootsWereRemoved) {
        boolean bl;
        Iterable $this$any$iv;
        List affectedEntities;
        block7: {
            VirtualFileUrl includingJarDirectory = this.getIncludingJarDirectory(storage, virtualFileUrl);
            if (includingJarDirectory != null) {
                List entities2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)storage.getVirtualFileUrlIndex().findEntitiesByUrl(includingJarDirectory), (Function1)calculateEntityChangesIfNeeded.entities.1.INSTANCE));
                entityChanges.addAffectedEntities(entities2, allRootsWereRemoved);
                return;
            }
            affectedEntities = new ArrayList();
            this.collectAffectedEntities(virtualFileUrl, storage, affectedEntities, allRootsWereRemoved, entityChanges);
            List list2 = virtualFileUrl.getSubTreeFileUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"virtualFileUrl.subTreeFileUrls");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFileUrl fileUrl = (VirtualFileUrl)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)fileUrl, (String)"fileUrl");
                this.collectAffectedEntities(fileUrl, storage, affectedEntities, allRootsWereRemoved, entityChanges);
            }
            EntityIndexingServiceEx entityIndexingServiceEx = EntityIndexingServiceEx.getInstanceEx();
            Intrinsics.checkNotNullExpressionValue((Object)entityIndexingServiceEx, (String)"getInstanceEx()");
            EntityIndexingServiceEx indexingServiceEx = entityIndexingServiceEx;
            $this$any$iv = affectedEntities;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EntityWithVirtualFileUrl it = (EntityWithVirtualFileUrl)element$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getPropertyName(), (Object)"entitySource") && indexingServiceEx.shouldCauseRescan(it.getEntity(), this.project))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv;
            $this$any$iv = affectedEntities;
            EntityChangeStorage entityChangeStorage = entityChanges;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EntityWithVirtualFileUrl entityWithVirtualFileUrl = (EntityWithVirtualFileUrl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getEntity().createReference());
            }
            entityChangeStorage.addAffectedEntities((List)destination$iv$iv, allRootsWereRemoved);
        }
    }

    private final void collectAffectedEntities(VirtualFileUrl url, EntityStorage storage, List<EntityWithVirtualFileUrl> affectedEntities, boolean allRootsWereRemoved, EntityChangeStorage entityChanges) {
        boolean hasEntities = VirtualFileUrlWatcher.Companion.calculateAffectedEntities$intellij_platform_lang_impl(storage, url, affectedEntities);
        if (hasEntities && allRootsWereRemoved) {
            entityChanges.addFileToInvalidate(VirtualFileUrls.getVirtualFile(url));
        }
    }

    private final boolean isRootChangeForbidden() {
        if (this.project.isDisposed()) {
            return true;
        }
        ProjectRootManager projectRootManager2 = ProjectRootManager.getInstance(this.project);
        if (!(projectRootManager2 instanceof ProjectRootManagerBridge)) {
            return true;
        }
        return ((ProjectRootManagerBridge)projectRootManager2).isFiringEvent();
    }

    private final void fireRootsChangeEvent(boolean beforeRootsChanged, EntityChangeStorage entityChangesStorage) {
        RootsChangeRescanningInfo indexingInfo;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        HashSet<EntityReference<WorkspaceEntity>> affectedEntities = entityChangesStorage.getAffectedEntities();
        if (WorkspaceFileIndexEx.IS_ENABLED && !((Collection)affectedEntities).isEmpty()) {
            WorkspaceFileIndex workspaceFileIndex = WorkspaceFileIndex.Companion.getInstance(this.project);
            Intrinsics.checkNotNull((Object)workspaceFileIndex, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx");
            WorkspaceFileIndexEx workspaceFileIndex2 = (WorkspaceFileIndexEx)workspaceFileIndex;
            if (beforeRootsChanged) {
                workspaceFileIndex2.getIndexData().markDirty((Collection<? extends EntityReference<? extends WorkspaceEntity>>)affectedEntities, (Collection<? extends VirtualFile>)entityChangesStorage.getFilesToInvalidate());
            } else {
                workspaceFileIndex2.getIndexData().markDirty((Collection<? extends EntityReference<? extends WorkspaceEntity>>)affectedEntities, (Collection<? extends VirtualFile>)entityChangesStorage.getFilesToInvalidate());
                workspaceFileIndex2.getIndexData().updateDirtyEntities();
            }
        }
        if (GlobalLibraryTableBridge.Companion.isEnabled() && !((Collection)affectedEntities).isEmpty()) {
            EntityStorageSnapshot entityStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
            GlobalLibraryTableBridge globalLibraryTableBridge = GlobalLibraryTableBridge.Companion.getInstance();
            Intrinsics.checkNotNull((Object)globalLibraryTableBridge, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.library.GlobalLibraryTableBridgeImpl");
            GlobalLibraryTableBridgeImpl globalLibraryTableBridge2 = (GlobalLibraryTableBridgeImpl)globalLibraryTableBridge;
            Iterable $this$forEach$iv = affectedEntities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryEntity libraryEntity;
                EntityReference entityRef = (EntityReference)element$iv;
                boolean bl = false;
                WorkspaceEntity workspaceEntity = entityRef.resolve((EntityStorage)entityStorage);
                LibraryEntity libraryEntity2 = workspaceEntity instanceof LibraryEntity ? (LibraryEntity)workspaceEntity : null;
                if (libraryEntity2 == null || !Intrinsics.areEqual((Object)(libraryEntity = libraryEntity2).getTableId().getLevel(), (Object)"application")) continue;
                globalLibraryTableBridge2.fireRootSetChanged(libraryEntity, (EntityStorage)entityStorage);
            }
        }
        if ((indexingInfo = entityChangesStorage.createIndexingInfo()) != null && !this.isRootChangeForbidden()) {
            ProjectRootManager projectRootManager2 = ProjectRootManager.getInstance(this.project);
            Intrinsics.checkNotNull((Object)projectRootManager2, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge");
            ProjectRootManagerBridge projectRootManager3 = (ProjectRootManagerBridge)projectRootManager2;
            if (beforeRootsChanged) {
                projectRootManager3.getRootsChanged().beforeRootsChanged();
            } else {
                projectRootManager3.getRootsChanged().rootsChanged(indexingInfo);
            }
        }
    }

    static /* synthetic */ void fireRootsChangeEvent$default(OldRootsChangeWatcher oldRootsChangeWatcher, boolean bl, EntityChangeStorage entityChangeStorage, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        oldRootsChangeWatcher.fireRootsChangeEvent(bl, entityChangeStorage);
    }

    public static final /* synthetic */ void access$fireRootsChangeEvent(OldRootsChangeWatcher $this, boolean beforeRootsChanged, EntityChangeStorage entityChangesStorage) {
        $this.fireRootsChangeEvent(beforeRootsChanged, entityChangesStorage);
    }
}

