/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.WString;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class Pointer {
    public static final Pointer NULL = null;
    protected long peer;

    public static final Pointer createConstant(long peer) {
        return new Opaque(peer);
    }

    public static final Pointer createConstant(int peer) {
        return new Opaque((long)peer & 0xFFFFFFFFFFFFFFFFL);
    }

    Pointer() {
    }

    public Pointer(long peer) {
        this.peer = peer;
    }

    public Pointer share(long offset2) {
        return this.share(offset2, 0L);
    }

    public Pointer share(long offset2, long sz) {
        if (offset2 == 0L) {
            return this;
        }
        return new Pointer(this.peer + offset2);
    }

    public void clear(long size) {
        this.setMemory(0L, size, (byte)0);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof Pointer && ((Pointer)o).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFFFFFFFFFL));
    }

    public long indexOf(long offset2, byte value) {
        return Native.indexOf(this, this.peer, offset2, value);
    }

    public void read(long offset2, byte[] buf, int index2, int length) {
        Native.read(this, this.peer, offset2, buf, index2, length);
    }

    public void read(long offset2, short[] buf, int index2, int length) {
        Native.read(this, this.peer, offset2, buf, index2, length);
    }

    public void read(long offset2, char[] buf, int index2, int length) {
        Native.read(this, this.peer, offset2, buf, index2, length);
    }

    public void read(long offset2, int[] buf, int index2, int length) {
        Native.read(this, this.peer, offset2, buf, index2, length);
    }

    public void read(long offset2, long[] buf, int index2, int length) {
        Native.read(this, this.peer, offset2, buf, index2, length);
    }

    public void read(long offset2, float[] buf, int index2, int length) {
        Native.read(this, this.peer, offset2, buf, index2, length);
    }

    public void read(long offset2, double[] buf, int index2, int length) {
        Native.read(this, this.peer, offset2, buf, index2, length);
    }

    public void read(long offset2, Pointer[] buf, int index2, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            Pointer p = this.getPointer(offset2 + (long)(i2 * Native.POINTER_SIZE));
            Pointer oldp = buf[i2 + index2];
            if (oldp != null && p != null && p.peer == oldp.peer) continue;
            buf[i2 + index2] = p;
        }
    }

    public void write(long offset2, byte[] buf, int index2, int length) {
        Native.write(this, this.peer, offset2, buf, index2, length);
    }

    public void write(long offset2, short[] buf, int index2, int length) {
        Native.write(this, this.peer, offset2, buf, index2, length);
    }

    public void write(long offset2, char[] buf, int index2, int length) {
        Native.write(this, this.peer, offset2, buf, index2, length);
    }

    public void write(long offset2, int[] buf, int index2, int length) {
        Native.write(this, this.peer, offset2, buf, index2, length);
    }

    public void write(long offset2, long[] buf, int index2, int length) {
        Native.write(this, this.peer, offset2, buf, index2, length);
    }

    public void write(long offset2, float[] buf, int index2, int length) {
        Native.write(this, this.peer, offset2, buf, index2, length);
    }

    public void write(long offset2, double[] buf, int index2, int length) {
        Native.write(this, this.peer, offset2, buf, index2, length);
    }

    public void write(long bOff, Pointer[] buf, int index2, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            this.setPointer(bOff + (long)(i2 * Native.POINTER_SIZE), buf[index2 + i2]);
        }
    }

    Object getValue(long offset2, Class<?> type, Object currentValue) {
        Object result2 = null;
        if (Structure.class.isAssignableFrom(type)) {
            Structure s = (Structure)currentValue;
            if (Structure.ByReference.class.isAssignableFrom(type)) {
                s = Structure.updateStructureByReference(type, s, this.getPointer(offset2));
            } else {
                s.useMemory(this, (int)offset2, true);
                s.read();
            }
            result2 = s;
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            result2 = Function.valueOf(this.getInt(offset2) != 0);
        } else if (type == Byte.TYPE || type == Byte.class) {
            result2 = this.getByte(offset2);
        } else if (type == Short.TYPE || type == Short.class) {
            result2 = this.getShort(offset2);
        } else if (type == Character.TYPE || type == Character.class) {
            result2 = Character.valueOf(this.getChar(offset2));
        } else if (type == Integer.TYPE || type == Integer.class) {
            result2 = this.getInt(offset2);
        } else if (type == Long.TYPE || type == Long.class) {
            result2 = this.getLong(offset2);
        } else if (type == Float.TYPE || type == Float.class) {
            result2 = Float.valueOf(this.getFloat(offset2));
        } else if (type == Double.TYPE || type == Double.class) {
            result2 = this.getDouble(offset2);
        } else if (Pointer.class.isAssignableFrom(type)) {
            Pointer p = this.getPointer(offset2);
            if (p != null) {
                Pointer oldp;
                Pointer pointer = oldp = currentValue instanceof Pointer ? (Pointer)currentValue : null;
                result2 = oldp == null || p.peer != oldp.peer ? p : oldp;
            }
        } else if (type == String.class) {
            Pointer p = this.getPointer(offset2);
            result2 = p != null ? p.getString(0L) : null;
        } else if (type == WString.class) {
            Pointer p = this.getPointer(offset2);
            result2 = p != null ? new WString(p.getWideString(0L)) : null;
        } else if (Callback.class.isAssignableFrom(type)) {
            Pointer fp = this.getPointer(offset2);
            if (fp == null) {
                result2 = null;
            } else {
                Callback cb2 = (Callback)currentValue;
                Pointer oldfp = CallbackReference.getFunctionPointer(cb2);
                if (!fp.equals(oldfp)) {
                    cb2 = CallbackReference.getCallback(type, fp);
                }
                result2 = cb2;
            }
        } else if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type)) {
            Pointer bp = this.getPointer(offset2);
            if (bp == null) {
                result2 = null;
            } else {
                Pointer oldbp;
                Pointer pointer = oldbp = currentValue == null ? null : Native.getDirectBufferPointer((Buffer)currentValue);
                if (oldbp == null || !oldbp.equals(bp)) {
                    throw new IllegalStateException("Can't autogenerate a direct buffer on memory read");
                }
                result2 = currentValue;
            }
        } else if (NativeMapped.class.isAssignableFrom(type)) {
            NativeMapped nm = (NativeMapped)currentValue;
            if (nm != null) {
                Object value = this.getValue(offset2, nm.nativeType(), null);
                result2 = nm.fromNative(value, new FromNativeContext(type));
                if (nm.equals(result2)) {
                    result2 = nm;
                }
            } else {
                NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
                Object value = this.getValue(offset2, tc.nativeType(), null);
                result2 = tc.fromNative(value, new FromNativeContext(type));
            }
        } else if (type.isArray()) {
            result2 = currentValue;
            if (result2 == null) {
                throw new IllegalStateException("Need an initialized array");
            }
            this.readArray(offset2, result2, type.getComponentType());
        } else {
            throw new IllegalArgumentException("Reading \"" + type + "\" from memory is not supported");
        }
        return result2;
    }

    private void readArray(long offset2, Object o, Class<?> cls) {
        int length = 0;
        length = Array.getLength(o);
        Object result2 = o;
        if (cls == Byte.TYPE) {
            this.read(offset2, (byte[])result2, 0, length);
        } else if (cls == Short.TYPE) {
            this.read(offset2, (short[])result2, 0, length);
        } else if (cls == Character.TYPE) {
            this.read(offset2, (char[])result2, 0, length);
        } else if (cls == Integer.TYPE) {
            this.read(offset2, (int[])result2, 0, length);
        } else if (cls == Long.TYPE) {
            this.read(offset2, (long[])result2, 0, length);
        } else if (cls == Float.TYPE) {
            this.read(offset2, (float[])result2, 0, length);
        } else if (cls == Double.TYPE) {
            this.read(offset2, (double[])result2, 0, length);
        } else if (Pointer.class.isAssignableFrom(cls)) {
            this.read(offset2, (Pointer[])result2, 0, length);
        } else if (Structure.class.isAssignableFrom(cls)) {
            Structure[] sarray = (Structure[])result2;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] parray = this.getPointerArray(offset2, sarray.length);
                for (int i2 = 0; i2 < sarray.length; ++i2) {
                    sarray[i2] = Structure.updateStructureByReference(cls, sarray[i2], parray[i2]);
                }
            } else {
                Structure first2 = sarray[0];
                if (first2 == null) {
                    first2 = Structure.newInstance(cls, this.share(offset2));
                    first2.conditionalAutoRead();
                    sarray[0] = first2;
                } else {
                    first2.useMemory(this, (int)offset2, true);
                    first2.read();
                }
                Structure[] tmp = first2.toArray(sarray.length);
                for (int i3 = 1; i3 < sarray.length; ++i3) {
                    if (sarray[i3] == null) {
                        sarray[i3] = tmp[i3];
                        continue;
                    }
                    sarray[i3].useMemory(this, (int)(offset2 + (long)(i3 * sarray[i3].size())), true);
                    sarray[i3].read();
                }
            }
        } else if (NativeMapped.class.isAssignableFrom(cls)) {
            NativeMapped[] array = (NativeMapped[])result2;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            int size = Native.getNativeSize(result2.getClass(), result2) / array.length;
            for (int i4 = 0; i4 < array.length; ++i4) {
                Object value = this.getValue(offset2 + (long)(size * i4), tc.nativeType(), array[i4]);
                array[i4] = (NativeMapped)tc.fromNative(value, new FromNativeContext(cls));
            }
        } else {
            throw new IllegalArgumentException("Reading array of " + cls + " from memory not supported");
        }
    }

    public byte getByte(long offset2) {
        return Native.getByte(this, this.peer, offset2);
    }

    public char getChar(long offset2) {
        return Native.getChar(this, this.peer, offset2);
    }

    public short getShort(long offset2) {
        return Native.getShort(this, this.peer, offset2);
    }

    public int getInt(long offset2) {
        return Native.getInt(this, this.peer, offset2);
    }

    public long getLong(long offset2) {
        return Native.getLong(this, this.peer, offset2);
    }

    public NativeLong getNativeLong(long offset2) {
        return new NativeLong(NativeLong.SIZE == 8 ? this.getLong(offset2) : (long)this.getInt(offset2));
    }

    public float getFloat(long offset2) {
        return Native.getFloat(this, this.peer, offset2);
    }

    public double getDouble(long offset2) {
        return Native.getDouble(this, this.peer, offset2);
    }

    public Pointer getPointer(long offset2) {
        return Native.getPointer(this.peer + offset2);
    }

    public ByteBuffer getByteBuffer(long offset2, long length) {
        return Native.getDirectByteBuffer(this, this.peer, offset2, length).order(ByteOrder.nativeOrder());
    }

    public String getWideString(long offset2) {
        return Native.getWideString(this, this.peer, offset2);
    }

    public String getString(long offset2) {
        return this.getString(offset2, Native.getDefaultStringEncoding());
    }

    public String getString(long offset2, String encoding) {
        return Native.getString(this, offset2, encoding);
    }

    public byte[] getByteArray(long offset2, int arraySize) {
        byte[] buf = new byte[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public char[] getCharArray(long offset2, int arraySize) {
        char[] buf = new char[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public short[] getShortArray(long offset2, int arraySize) {
        short[] buf = new short[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public int[] getIntArray(long offset2, int arraySize) {
        int[] buf = new int[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public long[] getLongArray(long offset2, int arraySize) {
        long[] buf = new long[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public float[] getFloatArray(long offset2, int arraySize) {
        float[] buf = new float[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public double[] getDoubleArray(long offset2, int arraySize) {
        double[] buf = new double[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public Pointer[] getPointerArray(long offset2) {
        ArrayList<Pointer> array = new ArrayList<Pointer>();
        int addOffset = 0;
        Pointer p = this.getPointer(offset2);
        while (p != null) {
            array.add(p);
            p = this.getPointer(offset2 + (long)(addOffset += Native.POINTER_SIZE));
        }
        return array.toArray(new Pointer[0]);
    }

    public Pointer[] getPointerArray(long offset2, int arraySize) {
        Pointer[] buf = new Pointer[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public String[] getStringArray(long offset2) {
        return this.getStringArray(offset2, -1, Native.getDefaultStringEncoding());
    }

    public String[] getStringArray(long offset2, String encoding) {
        return this.getStringArray(offset2, -1, encoding);
    }

    public String[] getStringArray(long offset2, int length) {
        return this.getStringArray(offset2, length, Native.getDefaultStringEncoding());
    }

    public String[] getWideStringArray(long offset2) {
        return this.getWideStringArray(offset2, -1);
    }

    public String[] getWideStringArray(long offset2, int length) {
        return this.getStringArray(offset2, length, "--WIDE-STRING--");
    }

    public String[] getStringArray(long offset2, int length, String encoding) {
        ArrayList<String> strings2 = new ArrayList<String>();
        int addOffset = 0;
        if (length != -1) {
            Pointer p = this.getPointer(offset2 + (long)addOffset);
            int count2 = 0;
            while (count2++ < length) {
                String s = p == null ? null : ("--WIDE-STRING--".equals(encoding) ? p.getWideString(0L) : p.getString(0L, encoding));
                strings2.add(s);
                if (count2 >= length) continue;
                p = this.getPointer(offset2 + (long)(addOffset += Native.POINTER_SIZE));
            }
        } else {
            Pointer p;
            while ((p = this.getPointer(offset2 + (long)addOffset)) != null) {
                String s = "--WIDE-STRING--".equals(encoding) ? p.getWideString(0L) : p.getString(0L, encoding);
                strings2.add(s);
                addOffset += Native.POINTER_SIZE;
            }
        }
        return strings2.toArray(new String[0]);
    }

    void setValue(long offset2, Object value, Class<?> type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            this.setInt(offset2, Boolean.TRUE.equals(value) ? -1 : 0);
        } else if (type == Byte.TYPE || type == Byte.class) {
            this.setByte(offset2, value == null ? (byte)0 : (Byte)value);
        } else if (type == Short.TYPE || type == Short.class) {
            this.setShort(offset2, value == null ? (short)0 : (Short)value);
        } else if (type == Character.TYPE || type == Character.class) {
            this.setChar(offset2, value == null ? (char)'\u0000' : ((Character)value).charValue());
        } else if (type == Integer.TYPE || type == Integer.class) {
            this.setInt(offset2, value == null ? 0 : (Integer)value);
        } else if (type == Long.TYPE || type == Long.class) {
            this.setLong(offset2, value == null ? 0L : (Long)value);
        } else if (type == Float.TYPE || type == Float.class) {
            this.setFloat(offset2, value == null ? 0.0f : ((Float)value).floatValue());
        } else if (type == Double.TYPE || type == Double.class) {
            this.setDouble(offset2, value == null ? 0.0 : (Double)value);
        } else if (type == Pointer.class) {
            this.setPointer(offset2, (Pointer)value);
        } else if (type == String.class) {
            this.setPointer(offset2, (Pointer)value);
        } else if (type == WString.class) {
            this.setPointer(offset2, (Pointer)value);
        } else if (Structure.class.isAssignableFrom(type)) {
            Structure s = (Structure)value;
            if (Structure.ByReference.class.isAssignableFrom(type)) {
                this.setPointer(offset2, s == null ? null : s.getPointer());
                if (s != null) {
                    s.autoWrite();
                }
            } else {
                s.useMemory(this, (int)offset2, true);
                s.write();
            }
        } else if (Callback.class.isAssignableFrom(type)) {
            this.setPointer(offset2, CallbackReference.getFunctionPointer((Callback)value));
        } else if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type)) {
            Pointer p = value == null ? null : Native.getDirectBufferPointer((Buffer)value);
            this.setPointer(offset2, p);
        } else if (NativeMapped.class.isAssignableFrom(type)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
            Class<?> nativeType = tc.nativeType();
            this.setValue(offset2, tc.toNative(value, new ToNativeContext()), nativeType);
        } else if (type.isArray()) {
            this.writeArray(offset2, value, type.getComponentType());
        } else {
            throw new IllegalArgumentException("Writing " + type + " to memory is not supported");
        }
    }

    private void writeArray(long offset2, Object value, Class<?> cls) {
        if (cls == Byte.TYPE) {
            byte[] buf = (byte[])value;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Short.TYPE) {
            short[] buf = (short[])value;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Character.TYPE) {
            char[] buf = (char[])value;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Integer.TYPE) {
            int[] buf = (int[])value;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Long.TYPE) {
            long[] buf = (long[])value;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Float.TYPE) {
            float[] buf = (float[])value;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Double.TYPE) {
            double[] buf = (double[])value;
            this.write(offset2, buf, 0, buf.length);
        } else if (Pointer.class.isAssignableFrom(cls)) {
            Pointer[] buf = (Pointer[])value;
            this.write(offset2, buf, 0, buf.length);
        } else if (Structure.class.isAssignableFrom(cls)) {
            Structure[] sbuf = (Structure[])value;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] buf = new Pointer[sbuf.length];
                for (int i2 = 0; i2 < sbuf.length; ++i2) {
                    if (sbuf[i2] == null) {
                        buf[i2] = null;
                        continue;
                    }
                    buf[i2] = sbuf[i2].getPointer();
                    sbuf[i2].write();
                }
                this.write(offset2, buf, 0, buf.length);
            } else {
                Structure first2 = sbuf[0];
                if (first2 == null) {
                    sbuf[0] = first2 = Structure.newInstance(cls, this.share(offset2));
                } else {
                    first2.useMemory(this, (int)offset2, true);
                }
                first2.write();
                Structure[] tmp = first2.toArray(sbuf.length);
                for (int i3 = 1; i3 < sbuf.length; ++i3) {
                    if (sbuf[i3] == null) {
                        sbuf[i3] = tmp[i3];
                    } else {
                        sbuf[i3].useMemory(this, (int)(offset2 + (long)(i3 * sbuf[i3].size())), true);
                    }
                    sbuf[i3].write();
                }
            }
        } else if (NativeMapped.class.isAssignableFrom(cls)) {
            NativeMapped[] buf = (NativeMapped[])value;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            Class<?> nativeType = tc.nativeType();
            int size = Native.getNativeSize(value.getClass(), value) / buf.length;
            for (int i4 = 0; i4 < buf.length; ++i4) {
                Object element = tc.toNative(buf[i4], new ToNativeContext());
                this.setValue(offset2 + (long)(i4 * size), element, nativeType);
            }
        } else {
            throw new IllegalArgumentException("Writing array of " + cls + " to memory not supported");
        }
    }

    public void setMemory(long offset2, long length, byte value) {
        Native.setMemory(this, this.peer, offset2, length, value);
    }

    public void setByte(long offset2, byte value) {
        Native.setByte(this, this.peer, offset2, value);
    }

    public void setShort(long offset2, short value) {
        Native.setShort(this, this.peer, offset2, value);
    }

    public void setChar(long offset2, char value) {
        Native.setChar(this, this.peer, offset2, value);
    }

    public void setInt(long offset2, int value) {
        Native.setInt(this, this.peer, offset2, value);
    }

    public void setLong(long offset2, long value) {
        Native.setLong(this, this.peer, offset2, value);
    }

    public void setNativeLong(long offset2, NativeLong value) {
        if (NativeLong.SIZE == 8) {
            this.setLong(offset2, value.longValue());
        } else {
            this.setInt(offset2, value.intValue());
        }
    }

    public void setFloat(long offset2, float value) {
        Native.setFloat(this, this.peer, offset2, value);
    }

    public void setDouble(long offset2, double value) {
        Native.setDouble(this, this.peer, offset2, value);
    }

    public void setPointer(long offset2, Pointer value) {
        Native.setPointer(this, this.peer, offset2, value != null ? value.peer : 0L);
    }

    public void setWideString(long offset2, String value) {
        Native.setWideString(this, this.peer, offset2, value);
    }

    public void setString(long offset2, WString value) {
        this.setWideString(offset2, value == null ? null : value.toString());
    }

    public void setString(long offset2, String value) {
        this.setString(offset2, value, Native.getDefaultStringEncoding());
    }

    public void setString(long offset2, String value, String encoding) {
        byte[] data2 = Native.getBytes(value, encoding);
        this.write(offset2, data2, 0, data2.length);
        this.setByte(offset2 + (long)data2.length, (byte)0);
    }

    public String dump(long offset2, int size) {
        int BYTES_PER_ROW = 4;
        String TITLE = "memory dump";
        StringWriter sw = new StringWriter("memory dump".length() + 2 + size * 2 + size / 4 * 4);
        PrintWriter out = new PrintWriter(sw);
        out.println("memory dump");
        for (int i2 = 0; i2 < size; ++i2) {
            byte b = this.getByte(offset2 + (long)i2);
            if (i2 % 4 == 0) {
                out.print("[");
            }
            if (b >= 0 && b < 16) {
                out.print("0");
            }
            out.print(Integer.toHexString(b & 0xFF));
            if (i2 % 4 != 3 || i2 >= size - 1) continue;
            out.println("]");
        }
        if (sw.getBuffer().charAt(sw.getBuffer().length() - 2) != ']') {
            out.println("]");
        }
        return sw.toString();
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    public static long nativeValue(Pointer p) {
        return p == null ? 0L : p.peer;
    }

    public static void nativeValue(Pointer p, long value) {
        p.peer = value;
    }

    private static class Opaque
    extends Pointer {
        private final String MSG = "This pointer is opaque: " + this;

        private Opaque(long peer) {
            super(peer);
        }

        @Override
        public Pointer share(long offset2, long size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void clear(long size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public long indexOf(long offset2, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, byte[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, char[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, short[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, int[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, long[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, float[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, double[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, Pointer[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, byte[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, char[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, short[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, int[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, long[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, float[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, double[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, Pointer[] buf, int index2, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public ByteBuffer getByteBuffer(long offset2, long length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public byte getByte(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public char getChar(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public short getShort(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public int getInt(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public long getLong(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public float getFloat(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public double getDouble(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public Pointer getPointer(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String getString(long bOff, String encoding) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String getWideString(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setByte(long bOff, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setChar(long bOff, char value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setShort(long bOff, short value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setInt(long bOff, int value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setLong(long bOff, long value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setFloat(long bOff, float value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setDouble(long bOff, double value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setPointer(long offset2, Pointer value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setString(long offset2, String value, String encoding) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setWideString(long offset2, String value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setMemory(long offset2, long size, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String dump(long offset2, int size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String toString() {
            return "const@0x" + Long.toHexString(this.peer);
        }
    }
}

