/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.tlb.imp;

import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLibUtil;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbAbstractMethod;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbBase;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbFunctionStub;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbPropertyGetStub;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbPropertyPutStub;
import com.sun.jna.platform.win32.OaIdl;

public class TlbDispInterface
extends TlbBase {
    public TlbDispInterface(int index2, String packagename, TypeLibUtil typeLibUtil) {
        super(index2, typeLibUtil, null);
        TypeLibUtil.TypeLibDoc typeLibDoc = this.typeLibUtil.getDocumentation(index2);
        String docString = typeLibDoc.getDocString();
        if (typeLibDoc.getName().length() > 0) {
            this.name = typeLibDoc.getName();
        }
        this.logInfo("Type of kind 'DispInterface' found: " + this.name);
        this.createPackageName(packagename);
        this.createClassName(this.name);
        this.setFilename(this.name);
        TypeInfoUtil typeInfoUtil = typeLibUtil.getTypeInfoUtil(index2);
        OaIdl.TYPEATTR typeAttr = typeInfoUtil.getTypeAttr();
        this.createJavaDocHeader(typeAttr.guid.toGuidString(), docString);
        int cFuncs = typeAttr.cFuncs.intValue();
        for (int i2 = 0; i2 < cFuncs; ++i2) {
            OaIdl.FUNCDESC funcDesc = typeInfoUtil.getFuncDesc(i2);
            OaIdl.MEMBERID memberID = funcDesc.memid;
            TypeInfoUtil.TypeInfoDoc typeInfoDoc2 = typeInfoUtil.getDocumentation(memberID);
            String methodName = typeInfoDoc2.getName();
            TlbAbstractMethod method2 = null;
            if (!this.isReservedMethod(methodName)) {
                if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_FUNC.value) {
                    method2 = new TlbFunctionStub(index2, typeLibUtil, funcDesc, typeInfoUtil);
                } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYGET.value) {
                    method2 = new TlbPropertyGetStub(index2, typeLibUtil, funcDesc, typeInfoUtil);
                } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYPUT.value) {
                    method2 = new TlbPropertyPutStub(index2, typeLibUtil, funcDesc, typeInfoUtil);
                } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYPUTREF.value) {
                    method2 = new TlbPropertyPutStub(index2, typeLibUtil, funcDesc, typeInfoUtil);
                }
                this.content = this.content + method2.getClassBuffer();
                if (i2 < cFuncs - 1) {
                    this.content = this.content + "\n";
                }
            }
            typeInfoUtil.ReleaseFuncDesc(funcDesc);
        }
        this.createContent(this.content);
    }

    protected void createJavaDocHeader(String guid, String helpstring) {
        this.replaceVariable("uuid", guid);
        this.replaceVariable("helpstring", helpstring);
    }

    @Override
    protected String getClassTemplate() {
        return "com/sun/jna/platform/win32/COM/tlb/imp/TlbDispInterface.template";
    }
}

