/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectHash;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

abstract class THashIterator<V>
extends TIterator
implements Iterator<V> {
    protected final TObjectHash _hash;

    THashIterator(TObjectHash hash) {
        super(hash);
        this._hash = hash;
    }

    @Override
    public V next() {
        this.moveToNextIndex();
        return this.objectAtIndex(this._index);
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set2 = this._hash._set;
        int i2 = this._index;
        while (i2-- > 0 && (set2[i2] == null || set2[i2] == TObjectHash.REMOVED)) {
        }
        return i2;
    }

    protected abstract V objectAtIndex(int var1);
}

