/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@Deprecated
public class TLongIntHashMap
extends TLongHash {
    protected transient int[] _values;

    public TLongIntHashMap() {
    }

    public TLongIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TLongIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TLongIntHashMap(TLongHashingStrategy strategy) {
        super(strategy);
    }

    public TLongIntHashMap(int initialCapacity, TLongHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TLongIntHashMap(int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    @Override
    public Object clone() {
        TLongIntHashMap m = (TLongIntHashMap)super.clone();
        m._values = this._values == null ? null : (int[])this._values.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new int[capacity];
        return capacity;
    }

    public int put(long key, int value) {
        int previous = 0;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        long[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new long[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldStates[i2] != 1) continue;
            long o = oldKeys[i2];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i2];
            this._states[index2] = 1;
        }
    }

    public int get(long key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0 : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        long[] keys2 = this._set;
        int[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i2 = keys2.length;
        while (i2-- > 0) {
            keys2[i2] = 0L;
            vals[i2] = 0;
            states[i2] = 0;
        }
    }

    public int remove(long key) {
        int prev = 0;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongIntHashMap)) {
            return false;
        }
        TLongIntHashMap that = (TLongIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = 0;
        super.removeAt(index2);
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                vals[j++] = v[i2];
            }
        }
        return vals;
    }

    public long[] keys() {
        long[] keys2 = new long[this.size()];
        long[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                keys2[j++] = k[i2];
            }
        }
        return keys2;
    }

    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || val != vals[i2]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.contains(key);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TLongIntProcedure procedure) {
        byte[] states = this._states;
        long[] keys2 = this._set;
        int[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TLongIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        long[] keys2 = this._set;
        int[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                values2[i2] = function.execute(values2[i2]);
            }
        }
    }

    public boolean increment(long key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(long key, int amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = stream.readLong();
            int val = stream.readInt();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TLongIntProcedure(){

            @Override
            public boolean execute(long key, int value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TLongIntProcedure {
        private final TLongIntHashMap _otherMap;

        EqProcedure(TLongIntHashMap otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public boolean execute(long key, int value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TLongIntProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public boolean execute(long key, int value) {
            this.h += TLongIntHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

