/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.THash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TLongProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;

@Deprecated
public final class TLongObjectHashMap<V>
extends THash
implements TLongHashingStrategy {
    private transient V[] _values;
    private transient long[] _set;
    private final TLongHashingStrategy _hashingStrategy;

    public TLongObjectHashMap() {
        this._hashingStrategy = this;
    }

    public TLongObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TLongObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TLongObjectHashMap(TLongHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TLongObjectHashMap(int initialCapacity, TLongHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TLongObjectHashMap(int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TLongObjectHashMap<V> clone() {
        TLongObjectHashMap m = (TLongObjectHashMap)super.clone();
        m._values = this._values == EMPTY_OBJECT_ARRAY ? EMPTY_OBJECT_ARRAY : (Object[])this._values.clone();
        m._set = this._values == EMPTY_OBJECT_ARRAY ? null : (long[])this._set.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? EMPTY_OBJECT_ARRAY : new Object[capacity];
        this._set = initialCapacity == -1 ? null : new long[capacity];
        return capacity;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public boolean forEach(TLongProcedure procedure) {
        long[] set2 = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i2) || procedure.execute(set2[i2])) continue;
            return false;
        }
        return true;
    }

    public V put(long key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = TLongObjectHashMap.unwrapNull(this._values[index2]);
            isNewMapping = false;
        } else {
            wasFree = TLongObjectHashMap.isFree(this._values, index2);
        }
        this._set[index2] = key;
        this._values[index2] = TLongObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        long[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new long[newCapacity];
        this._values = new Object[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (!TLongObjectHashMap.isFull(oldVals, i2)) continue;
            long o = oldKeys[i2];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i2];
        }
    }

    public V get(long key) {
        int index2 = this.index(key);
        return index2 < 0 ? null : (V)TLongObjectHashMap.unwrapNull(this._values[index2]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        long[] keys2 = this._set;
        V[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            keys2[i2] = 0L;
            values2[i2] = null;
        }
    }

    public V remove(long key) {
        V prev = null;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = TLongObjectHashMap.unwrapNull(this._values[index2]);
            this.removeAt(index2);
        }
        return prev;
    }

    private int index(long val) {
        long[] set2 = this._set;
        Object[] values2 = this._values;
        if (values2 == EMPTY_OBJECT_ARRAY) {
            return -1;
        }
        int length = set2.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (!TLongObjectHashMap.isFree(values2, index2) && (TLongObjectHashMap.isRemoved(values2, index2) || set2[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (!TLongObjectHashMap.isFree(values2, index2) && (TLongObjectHashMap.isRemoved(values2, index2) || set2[index2] != val));
        }
        return TLongObjectHashMap.isFree(values2, index2) ? -1 : index2;
    }

    private int insertionIndex(long val) {
        int firstRemoved;
        if (this._values == EMPTY_OBJECT_ARRAY) {
            this.setUp(6);
        }
        Object[] values2 = this._values;
        long[] set2 = this._set;
        int length = set2.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (TLongObjectHashMap.isFree(values2, index2)) {
            return index2;
        }
        if (TLongObjectHashMap.isFull(values2, index2) && set2[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TLongObjectHashMap.isRemoved(values2, index2) ? index2 : -1;
        do {
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            if (firstRemoved != -1 || !TLongObjectHashMap.isRemoved(values2, index2)) continue;
            firstRemoved = index2;
        } while (TLongObjectHashMap.isFull(values2, index2) && set2[index2] != val);
        if (TLongObjectHashMap.isRemoved(values2, index2)) {
            while (!TLongObjectHashMap.isFree(values2, index2) && (TLongObjectHashMap.isRemoved(values2, index2) || set2[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
        }
        if (TLongObjectHashMap.isFull(values2, index2)) {
            return -index2 - 1;
        }
        return firstRemoved == -1 ? index2 : firstRemoved;
    }

    static boolean isFull(Object[] values2, int index2) {
        Object value = values2[index2];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values2, int index2) {
        return values2[index2] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values2, int index2) {
        return values2[index2] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongObjectHashMap)) {
            return false;
        }
        TLongObjectHashMap that = (TLongObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = TObjectHash.REMOVED;
        super.removeAt(index2);
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values2 = this._values;
        int i2 = values2.length;
        int j = 0;
        while (i2-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i2)) continue;
            vals[j++] = TLongObjectHashMap.unwrapNull(values2[i2]);
        }
        return vals;
    }

    public long[] keys() {
        long[] keys2 = new long[this.size()];
        long[] k = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        int j = 0;
        while (i2-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i2)) continue;
            keys2[j++] = k[i2];
        }
        return keys2;
    }

    public boolean containsValue(V val) {
        Object[] values2 = this._values;
        if (null == val) {
            int i2 = values2.length;
            while (i2-- > 0) {
                if (TObjectHash.NULL != values2[i2]) continue;
                return true;
            }
        } else {
            int i3 = values2.length;
            while (i3-- > 0) {
                V value = TLongObjectHashMap.unwrapNull(values2[i3]);
                if (!TLongObjectHashMap.isFull(values2, i3) || val != value && !val.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.contains(key);
    }

    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i2) || procedure.execute(TLongObjectHashMap.unwrapNull(values2[i2]))) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongObjectProcedure<V> procedure) {
        long[] keys2 = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i2) || procedure.execute(keys2[i2], TLongObjectHashMap.unwrapNull(values2[i2]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TLongObjectProcedure<V> procedure) {
        boolean modified = false;
        long[] keys2 = this._set;
        Object[] values2 = this._values;
        this.stopCompactingOnRemove();
        try {
            int i2 = values2.length;
            while (i2-- > 0) {
                if (!TLongObjectHashMap.isFull(values2, i2) || procedure.execute(keys2[i2], TLongObjectHashMap.unwrapNull(values2[i2]))) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i2)) continue;
            values2[i2] = TLongObjectHashMap.wrapNull(function.execute(TLongObjectHashMap.unwrapNull(values2[i2])));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = stream.readLong();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    @Override
    public int computeHashCode(long val) {
        return HashFunctions.hash(val);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TLongObjectProcedure<V>(){

            @Override
            public boolean execute(long key, V value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append((Object)(value == this ? "(this Map)" : value));
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure<V>
    implements TLongObjectProcedure<V> {
        private final TLongObjectHashMap<V> _otherMap;

        EqProcedure(TLongObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public boolean execute(long key, V value) {
            int index2 = ((TLongObjectHashMap)this._otherMap).index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return Objects.equals(o1, o2);
        }
    }

    private final class HashProcedure
    implements TLongObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public boolean execute(long key, V value) {
            this.h += TLongObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

