/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanIterators;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanSpliterator;
import it.unimi.dsi.fastutil.booleans.BooleanSpliterators;
import it.unimi.dsi.fastutil.booleans.BooleanStack;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public abstract class AbstractBooleanList
extends AbstractBooleanCollection
implements BooleanList,
BooleanStack {
    protected AbstractBooleanList() {
    }

    protected void ensureIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index2, boolean k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(boolean k) {
        this.add(this.size(), k);
        return true;
    }

    @Override
    public boolean removeBoolean(int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean set(int index2, boolean k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index2, Collection<? extends Boolean> c2) {
        if (c2 instanceof BooleanCollection) {
            return this.addAll(index2, (BooleanCollection)c2);
        }
        this.ensureIndex(index2);
        Iterator<? extends Boolean> i2 = c2.iterator();
        boolean retVal = i2.hasNext();
        while (i2.hasNext()) {
            this.add(index2++, (boolean)i2.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    public BooleanListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public BooleanListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public BooleanListIterator listIterator(int index2) {
        this.ensureIndex(index2);
        return new BooleanIterators.AbstractIndexBasedListIterator(0, index2){

            @Override
            protected final boolean get(int i2) {
                return AbstractBooleanList.this.getBoolean(i2);
            }

            @Override
            protected final void add(int i2, boolean k) {
                AbstractBooleanList.this.add(i2, k);
            }

            @Override
            protected final void set(int i2, boolean k) {
                AbstractBooleanList.this.set(i2, k);
            }

            @Override
            protected final void remove(int i2) {
                AbstractBooleanList.this.removeBoolean(i2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractBooleanList.this.size();
            }
        };
    }

    @Override
    public boolean contains(boolean k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public int indexOf(boolean k) {
        BooleanListIterator i2 = this.listIterator();
        while (i2.hasNext()) {
            boolean e = i2.nextBoolean();
            if (k != e) continue;
            return i2.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(boolean k) {
        BooleanListIterator i2 = this.listIterator(this.size());
        while (i2.hasPrevious()) {
            boolean e = i2.previousBoolean();
            if (k != e) continue;
            return i2.nextIndex();
        }
        return -1;
    }

    @Override
    public void size(int size) {
        int i2 = this.size();
        if (size > i2) {
            while (i2++ < size) {
                this.add(false);
            }
        } else {
            while (i2-- != size) {
                this.removeBoolean(i2);
            }
        }
    }

    @Override
    public BooleanList subList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return this instanceof RandomAccess ? new BooleanRandomAccessSubList(this, from, to) : new BooleanSubList(this, from, to);
    }

    @Override
    public void forEach(BooleanConsumer action2) {
        if (this instanceof RandomAccess) {
            int max = this.size();
            for (int i2 = 0; i2 < max; ++i2) {
                action2.accept(this.getBoolean(i2));
            }
        } else {
            BooleanList.super.forEach(action2);
        }
    }

    @Override
    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        BooleanListIterator i2 = this.listIterator(from);
        int n = to - from;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i2.nextBoolean();
            i2.remove();
        }
    }

    @Override
    public void addElements(int index2, boolean[] a, int offset2, int length) {
        this.ensureIndex(index2);
        BooleanArrays.ensureOffsetLength(a, offset2, length);
        if (this instanceof RandomAccess) {
            while (length-- != 0) {
                this.add(index2++, a[offset2++]);
            }
        } else {
            BooleanListIterator iter = this.listIterator(index2);
            while (length-- != 0) {
                iter.add(a[offset2++]);
            }
        }
    }

    @Override
    public void addElements(int index2, boolean[] a) {
        this.addElements(index2, a, 0, a.length);
    }

    @Override
    public void getElements(int from, boolean[] a, int offset2, int length) {
        this.ensureIndex(from);
        BooleanArrays.ensureOffsetLength(a, offset2, length);
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int current = from;
            while (length-- != 0) {
                a[offset2++] = this.getBoolean(current++);
            }
        } else {
            BooleanListIterator i2 = this.listIterator(from);
            while (length-- != 0) {
                a[offset2++] = i2.nextBoolean();
            }
        }
    }

    @Override
    public void setElements(int index2, boolean[] a, int offset2, int length) {
        this.ensureIndex(index2);
        BooleanArrays.ensureOffsetLength(a, offset2, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < length; ++i2) {
                this.set(i2 + index2, a[i2 + offset2]);
            }
        } else {
            BooleanListIterator iter = this.listIterator(index2);
            int i3 = 0;
            while (i3 < length) {
                iter.nextBoolean();
                iter.set(a[offset2 + i3++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        BooleanListIterator i2 = this.iterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            boolean k = i2.nextBoolean();
            h = 31 * h + (k ? 1231 : 1237);
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        if (l instanceof BooleanList) {
            BooleanListIterator i1 = this.listIterator();
            BooleanListIterator i2 = ((BooleanList)l).listIterator();
            while (s-- != 0) {
                if (i1.nextBoolean() == i2.nextBoolean()) continue;
                return false;
            }
            return true;
        }
        BooleanListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (Objects.equals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Boolean> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof BooleanList) {
            BooleanListIterator i1 = this.listIterator();
            BooleanListIterator i2 = ((BooleanList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                boolean e2;
                boolean e1 = i1.nextBoolean();
                int r = Boolean.compare(e1, e2 = i2.nextBoolean());
                if (r == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        BooleanListIterator i1 = this.listIterator();
        ListIterator<? extends Boolean> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public void push(boolean o) {
        this.add(o);
    }

    @Override
    public boolean popBoolean() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeBoolean(this.size() - 1);
    }

    @Override
    public boolean topBoolean() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getBoolean(this.size() - 1);
    }

    @Override
    public boolean peekBoolean(int i2) {
        return this.getBoolean(this.size() - 1 - i2);
    }

    @Override
    public boolean rem(boolean k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeBoolean(index2);
        return true;
    }

    @Override
    public boolean[] toBooleanArray() {
        int size = this.size();
        if (size == 0) {
            return BooleanArrays.EMPTY_ARRAY;
        }
        boolean[] ret = new boolean[size];
        this.getElements(0, ret, 0, size);
        return ret;
    }

    @Override
    public boolean[] toArray(boolean[] a) {
        int size = this.size();
        if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        this.getElements(0, a, 0, size);
        return a;
    }

    @Override
    public boolean addAll(int index2, BooleanCollection c2) {
        this.ensureIndex(index2);
        BooleanIterator i2 = c2.iterator();
        boolean retVal = i2.hasNext();
        while (i2.hasNext()) {
            this.add(index2++, i2.nextBoolean());
        }
        return retVal;
    }

    @Override
    public boolean addAll(BooleanCollection c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        BooleanListIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("[");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            boolean k = i2.nextBoolean();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class BooleanRandomAccessSubList
    extends BooleanSubList
    implements RandomAccess {
        private static final long serialVersionUID = -107070782945191929L;

        public BooleanRandomAccessSubList(BooleanList l, int from, int to) {
            super(l, from, to);
        }

        @Override
        public BooleanList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new BooleanRandomAccessSubList(this, from, to);
        }
    }

    public static class BooleanSubList
    extends AbstractBooleanList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final BooleanList l;
        protected final int from;
        protected int to;

        public BooleanSubList(BooleanList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(boolean k) {
            this.l.add(this.to, k);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int index2, boolean k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int index2, Collection<? extends Boolean> c2) {
            this.ensureIndex(index2);
            this.to += c2.size();
            return this.l.addAll(this.from + index2, c2);
        }

        @Override
        public boolean getBoolean(int index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getBoolean(this.from + index2);
        }

        @Override
        public boolean removeBoolean(int index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeBoolean(this.from + index2);
        }

        @Override
        public boolean set(int index2, boolean k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from, boolean[] a, int offset2, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset2, length);
        }

        @Override
        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
            assert (this.assertRange());
        }

        @Override
        public void addElements(int index2, boolean[] a, int offset2, int length) {
            this.ensureIndex(index2);
            this.l.addElements(this.from + index2, a, offset2, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int index2, boolean[] a, int offset2, int length) {
            this.ensureIndex(index2);
            this.l.setElements(this.from + index2, a, offset2, length);
            assert (this.assertRange());
        }

        @Override
        public BooleanListIterator listIterator(int index2) {
            this.ensureIndex(index2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(index2) : new ParentWrappingIter(this.l.listIterator(index2 + this.from));
        }

        @Override
        public BooleanSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public BooleanList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new BooleanSubList(this, from, to);
        }

        @Override
        public boolean rem(boolean k) {
            int index2 = this.indexOf(k);
            if (index2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeBoolean(this.from + index2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int index2, BooleanCollection c2) {
            this.ensureIndex(index2);
            return super.addAll(index2, c2);
        }

        @Override
        public boolean addAll(int index2, BooleanList l) {
            this.ensureIndex(index2);
            return super.addAll(index2, l);
        }

        private final class RandomAccessIter
        extends BooleanIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int pos) {
                super(0, pos);
            }

            @Override
            protected final boolean get(int i2) {
                return BooleanSubList.this.l.getBoolean(BooleanSubList.this.from + i2);
            }

            @Override
            protected final void add(int i2, boolean k) {
                BooleanSubList.this.add(i2, k);
            }

            @Override
            protected final void set(int i2, boolean k) {
                BooleanSubList.this.set(i2, k);
            }

            @Override
            protected final void remove(int i2) {
                BooleanSubList.this.removeBoolean(i2);
            }

            @Override
            protected final int getMaxPos() {
                return BooleanSubList.this.to - BooleanSubList.this.from;
            }

            @Override
            public void add(boolean k) {
                super.add(k);
                assert (BooleanSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (BooleanSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements BooleanListIterator {
            private BooleanListIterator parent;

            ParentWrappingIter(BooleanListIterator parent2) {
                this.parent = parent2;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - BooleanSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - BooleanSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < BooleanSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= BooleanSubList.this.from;
            }

            @Override
            public boolean nextBoolean() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextBoolean();
            }

            @Override
            public boolean previousBoolean() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousBoolean();
            }

            @Override
            public void add(boolean k) {
                this.parent.add(k);
            }

            @Override
            public void set(boolean k) {
                this.parent.set(k);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }

            @Override
            public int back(int n) {
                if (n < 0) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                int currentPos = this.parent.previousIndex();
                int parentNewPos = currentPos - n;
                if (parentNewPos < BooleanSubList.this.from - 1) {
                    parentNewPos = BooleanSubList.this.from - 1;
                }
                int toSkip = parentNewPos - currentPos;
                return this.parent.back(toSkip);
            }

            @Override
            public int skip(int n) {
                if (n < 0) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                int currentPos = this.parent.nextIndex();
                int parentNewPos = currentPos + n;
                if (parentNewPos > BooleanSubList.this.to) {
                    parentNewPos = BooleanSubList.this.to;
                }
                int toSkip = parentNewPos - currentPos;
                return this.parent.skip(toSkip);
            }
        }
    }

    static final class IndexBasedSpliterator
    extends BooleanSpliterators.LateBindingSizeIndexBasedSpliterator {
        final BooleanList l;

        IndexBasedSpliterator(BooleanList l, int pos) {
            super(pos);
            this.l = l;
        }

        IndexBasedSpliterator(BooleanList l, int pos, int maxPos) {
            super(pos, maxPos);
            this.l = l;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final boolean get(int i2) {
            return this.l.getBoolean(i2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int pos, int maxPos) {
            return new IndexBasedSpliterator(this.l, pos, maxPos);
        }
    }
}

