/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteIterators;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractByteCollection
extends AbstractCollection<Byte>
implements ByteCollection {
    protected AbstractByteCollection() {
    }

    @Override
    public abstract ByteIterator iterator();

    @Override
    public boolean add(byte k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(byte k) {
        ByteIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextByte()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(byte k) {
        ByteIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextByte()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Byte key) {
        return ByteCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return ByteCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return ByteCollection.super.remove(key);
    }

    @Override
    public byte[] toArray(byte[] a) {
        int size = this.size();
        if (a == null) {
            a = new byte[size];
        } else if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        ByteIterators.unwrap(this.iterator(), a);
        return a;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.size();
        if (size == 0) {
            return ByteArrays.EMPTY_ARRAY;
        }
        byte[] a = new byte[size];
        ByteIterators.unwrap(this.iterator(), a);
        return a;
    }

    @Override
    @Deprecated
    public byte[] toByteArray(byte[] a) {
        return this.toArray(a);
    }

    @Override
    public boolean addAll(ByteCollection c2) {
        boolean retVal = false;
        ByteIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextByte())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> c2) {
        if (c2 instanceof ByteCollection) {
            return this.addAll((ByteCollection)c2);
        }
        return super.addAll(c2);
    }

    @Override
    public boolean containsAll(ByteCollection c2) {
        ByteIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextByte())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        if (c2 instanceof ByteCollection) {
            return this.containsAll((ByteCollection)c2);
        }
        return super.containsAll(c2);
    }

    @Override
    public boolean removeAll(ByteCollection c2) {
        boolean retVal = false;
        ByteIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextByte())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        if (c2 instanceof ByteCollection) {
            return this.removeAll((ByteCollection)c2);
        }
        return super.removeAll(c2);
    }

    @Override
    public boolean retainAll(ByteCollection c2) {
        boolean retVal = false;
        ByteIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c2.contains(i2.nextByte())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        if (c2 instanceof ByteCollection) {
            return this.retainAll((ByteCollection)c2);
        }
        return super.retainAll(c2);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        ByteIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            byte k = i2.nextByte();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

