/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

public final class ByteArrays {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final byte[] DEFAULT_EMPTY_ARRAY = new byte[0];
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;
    private static final int MERGESORT_NO_REC = 16;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 1;
    private static final int RADIXSORT_NO_REC = 1024;
    private static final int RADIXSORT_NO_REC_SMALL = 64;
    private static final int PARALLEL_RADIXSORT_NO_FORK = 1024;
    static final int RADIX_SORT_MIN_THRESHOLD = 1000;
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<byte[]> HASH_STRATEGY = new ArrayHashStrategy();

    private ByteArrays() {
    }

    public static byte[] forceCapacity(byte[] array, int length, int preserve) {
        byte[] t = new byte[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static byte[] ensureCapacity(byte[] array, int length) {
        return ByteArrays.ensureCapacity(array, length, array.length);
    }

    public static byte[] ensureCapacity(byte[] array, int length, int preserve) {
        return length > array.length ? ByteArrays.forceCapacity(array, length, preserve) : array;
    }

    public static byte[] grow(byte[] array, int length) {
        return ByteArrays.grow(array, length, array.length);
    }

    public static byte[] grow(byte[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min((long)array.length + (long)(array.length >> 1), 0x7FFFFFF7L), (long)length);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static byte[] trim(byte[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        byte[] t = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static byte[] setLength(byte[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ByteArrays.trim(array, length);
        }
        return ByteArrays.ensureCapacity(array, length);
    }

    public static byte[] copy(byte[] array, int offset2, int length) {
        ByteArrays.ensureOffsetLength(array, offset2, length);
        byte[] a = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(array, offset2, a, 0, length);
        return a;
    }

    public static byte[] copy(byte[] array) {
        return (byte[])array.clone();
    }

    @Deprecated
    public static void fill(byte[] array, byte value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    @Deprecated
    public static void fill(byte[] array, int from, int to, byte value) {
        ByteArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    @Deprecated
    public static boolean equals(byte[] a1, byte[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(byte[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(byte[] a, int offset2, int length) {
        Arrays.ensureOffsetLength(a.length, offset2, length);
    }

    public static void ensureSameLength(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch: " + a.length + " != " + b.length);
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    public static void swap(byte[] x, int a, int b) {
        byte t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(byte[] x, int a, int b, int n) {
        int i2 = 0;
        while (i2 < n) {
            ByteArrays.swap(x, a, b);
            ++i2;
            ++a;
            ++b;
        }
    }

    private static int med3(byte[] x, int a, int b, int c2, ByteComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c2]);
        int bc = comp.compare(x[b], x[c2]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c2 : a)) : (bc > 0 ? b : (ac > 0 ? c2 : a));
    }

    private static void selectionSort(byte[] a, int from, int to, ByteComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            byte u = a[i2];
            a[i2] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(byte[] a, int from, int to, ByteComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            byte t = a[i2];
            int j = i2;
            byte u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(byte[] x, int from, int to, ByteComparator comp) {
        int c2;
        int a;
        int len = to - from;
        if (len < 16) {
            ByteArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ByteArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = ByteArrays.med3(x, m - s, m, m + s, comp);
            n = ByteArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = ByteArrays.med3(x, l, m, n, comp);
        byte v = x[m];
        int b = a = from;
        int d = c2 = to - 1;
        while (true) {
            int comparison;
            if (b <= c2 && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c2 >= b && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, c2, d--);
                }
                --c2;
            }
            if (b > c2) break;
            ByteArrays.swap(x, b++, c2--);
        }
        int s = Math.min(a - from, b - a);
        ByteArrays.swap(x, from, b - s, s);
        s = Math.min(d - c2, to - d - 1);
        ByteArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            ByteArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c2) > 1) {
            ByteArrays.quickSort(x, to - s, to, comp);
        }
    }

    public static void quickSort(byte[] x, ByteComparator comp) {
        ByteArrays.quickSort(x, 0, x.length, comp);
    }

    public static void parallelQuickSort(byte[] x, int from, int to, ByteComparator comp) {
        ForkJoinPool pool = ByteArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            ByteArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(byte[] x, ByteComparator comp) {
        ByteArrays.parallelQuickSort(x, 0, x.length, comp);
    }

    private static int med3(byte[] x, int a, int b, int c2) {
        int ab = Byte.compare(x[a], x[b]);
        int ac = Byte.compare(x[a], x[c2]);
        int bc = Byte.compare(x[b], x[c2]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c2 : a)) : (bc > 0 ? b : (ac > 0 ? c2 : a));
    }

    private static void selectionSort(byte[] a, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (a[j] >= a[m]) continue;
                m = j;
            }
            if (m == i2) continue;
            byte u = a[i2];
            a[i2] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(byte[] a, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            byte t = a[i2];
            int j = i2;
            byte u = a[j - 1];
            while (t < u) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(byte[] x, int from, int to) {
        int c2;
        int a;
        int len = to - from;
        if (len < 16) {
            ByteArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ByteArrays.med3(x, l, l + s, l + 2 * s);
            m = ByteArrays.med3(x, m - s, m, m + s);
            n = ByteArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = ByteArrays.med3(x, l, m, n);
        byte v = x[m];
        int b = a = from;
        int d = c2 = to - 1;
        while (true) {
            int comparison;
            if (b <= c2 && (comparison = Byte.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c2 >= b && (comparison = Byte.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, c2, d--);
                }
                --c2;
            }
            if (b > c2) break;
            ByteArrays.swap(x, b++, c2--);
        }
        int s = Math.min(a - from, b - a);
        ByteArrays.swap(x, from, b - s, s);
        s = Math.min(d - c2, to - d - 1);
        ByteArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            ByteArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c2) > 1) {
            ByteArrays.quickSort(x, to - s, to);
        }
    }

    public static void quickSort(byte[] x) {
        ByteArrays.quickSort(x, 0, x.length);
    }

    public static void parallelQuickSort(byte[] x, int from, int to) {
        ForkJoinPool pool = ByteArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            ByteArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(byte[] x) {
        ByteArrays.parallelQuickSort(x, 0, x.length);
    }

    private static int med3Indirect(int[] perm, byte[] x, int a, int b, int c2) {
        byte aa = x[perm[a]];
        byte bb = x[perm[b]];
        byte cc = x[perm[c2]];
        int ab = Byte.compare(aa, bb);
        int ac = Byte.compare(aa, cc);
        int bc = Byte.compare(bb, cc);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c2 : a)) : (bc > 0 ? b : (ac > 0 ? c2 : a));
    }

    private static void insertionSortIndirect(int[] perm, byte[] a, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j = i2;
            int u = perm[j - 1];
            while (a[t] < a[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void quickSortIndirect(int[] perm, byte[] x, int from, int to) {
        int c2;
        int a;
        int len = to - from;
        if (len < 16) {
            ByteArrays.insertionSortIndirect(perm, x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ByteArrays.med3Indirect(perm, x, l, l + s, l + 2 * s);
            m = ByteArrays.med3Indirect(perm, x, m - s, m, m + s);
            n = ByteArrays.med3Indirect(perm, x, n - 2 * s, n - s, n);
        }
        m = ByteArrays.med3Indirect(perm, x, l, m, n);
        byte v = x[perm[m]];
        int b = a = from;
        int d = c2 = to - 1;
        while (true) {
            int comparison;
            if (b <= c2 && (comparison = Byte.compare(x[perm[b]], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, a++, b);
                }
                ++b;
                continue;
            }
            while (c2 >= b && (comparison = Byte.compare(x[perm[c2]], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, c2, d--);
                }
                --c2;
            }
            if (b > c2) break;
            IntArrays.swap(perm, b++, c2--);
        }
        int s = Math.min(a - from, b - a);
        IntArrays.swap(perm, from, b - s, s);
        s = Math.min(d - c2, to - d - 1);
        IntArrays.swap(perm, b, to - s, s);
        s = b - a;
        if (s > 1) {
            ByteArrays.quickSortIndirect(perm, x, from, from + s);
        }
        if ((s = d - c2) > 1) {
            ByteArrays.quickSortIndirect(perm, x, to - s, to);
        }
    }

    public static void quickSortIndirect(int[] perm, byte[] x) {
        ByteArrays.quickSortIndirect(perm, x, 0, x.length);
    }

    public static void parallelQuickSortIndirect(int[] perm, byte[] x, int from, int to) {
        ForkJoinPool pool = ByteArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            ByteArrays.quickSortIndirect(perm, x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSortIndirect(perm, x, from, to));
        }
    }

    public static void parallelQuickSortIndirect(int[] perm, byte[] x) {
        ByteArrays.parallelQuickSortIndirect(perm, x, 0, x.length);
    }

    public static void stabilize(int[] perm, byte[] x, int from, int to) {
        int curr = from;
        for (int i2 = from + 1; i2 < to; ++i2) {
            if (x[perm[i2]] == x[perm[curr]]) continue;
            if (i2 - curr > 1) {
                IntArrays.parallelQuickSort(perm, curr, i2);
            }
            curr = i2;
        }
        if (to - curr > 1) {
            IntArrays.parallelQuickSort(perm, curr, to);
        }
    }

    public static void stabilize(int[] perm, byte[] x) {
        ByteArrays.stabilize(perm, x, 0, perm.length);
    }

    private static int med3(byte[] x, byte[] y, int a, int b, int c2) {
        int bc;
        int t = Byte.compare(x[a], x[b]);
        int ab = t == 0 ? Byte.compare(y[a], y[b]) : t;
        t = Byte.compare(x[a], x[c2]);
        int ac = t == 0 ? Byte.compare(y[a], y[c2]) : t;
        t = Byte.compare(x[b], x[c2]);
        int n = bc = t == 0 ? Byte.compare(y[b], y[c2]) : t;
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c2 : a)) : (bc > 0 ? b : (ac > 0 ? c2 : a));
    }

    private static void swap(byte[] x, byte[] y, int a, int b) {
        byte t = x[a];
        byte u = y[a];
        x[a] = x[b];
        y[a] = y[b];
        x[b] = t;
        y[b] = u;
    }

    private static void swap(byte[] x, byte[] y, int a, int b, int n) {
        int i2 = 0;
        while (i2 < n) {
            ByteArrays.swap(x, y, a, b);
            ++i2;
            ++a;
            ++b;
        }
    }

    private static void selectionSort(byte[] a, byte[] b, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                int u = Byte.compare(a[j], a[m]);
                if (u >= 0 && (u != 0 || b[j] >= b[m])) continue;
                m = j;
            }
            if (m == i2) continue;
            byte t = a[i2];
            a[i2] = a[m];
            a[m] = t;
            t = b[i2];
            b[i2] = b[m];
            b[m] = t;
        }
    }

    public static void quickSort(byte[] x, byte[] y, int from, int to) {
        int c2;
        int a;
        int len = to - from;
        if (len < 16) {
            ByteArrays.selectionSort(x, y, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ByteArrays.med3(x, y, l, l + s, l + 2 * s);
            m = ByteArrays.med3(x, y, m - s, m, m + s);
            n = ByteArrays.med3(x, y, n - 2 * s, n - s, n);
        }
        m = ByteArrays.med3(x, y, l, m, n);
        byte v = x[m];
        byte w = y[m];
        int b = a = from;
        int d = c2 = to - 1;
        while (true) {
            int t;
            int comparison;
            if (b <= c2 && (comparison = (t = Byte.compare(x[b], v)) == 0 ? Byte.compare(y[b], w) : t) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, y, a++, b);
                }
                ++b;
                continue;
            }
            while (c2 >= b && (comparison = (t = Byte.compare(x[c2], v)) == 0 ? Byte.compare(y[c2], w) : t) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, y, c2, d--);
                }
                --c2;
            }
            if (b > c2) break;
            ByteArrays.swap(x, y, b++, c2--);
        }
        int s = Math.min(a - from, b - a);
        ByteArrays.swap(x, y, from, b - s, s);
        s = Math.min(d - c2, to - d - 1);
        ByteArrays.swap(x, y, b, to - s, s);
        s = b - a;
        if (s > 1) {
            ByteArrays.quickSort(x, y, from, from + s);
        }
        if ((s = d - c2) > 1) {
            ByteArrays.quickSort(x, y, to - s, to);
        }
    }

    public static void quickSort(byte[] x, byte[] y) {
        ByteArrays.ensureSameLength(x, y);
        ByteArrays.quickSort(x, y, 0, x.length);
    }

    public static void parallelQuickSort(byte[] x, byte[] y, int from, int to) {
        ForkJoinPool pool = ByteArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            ByteArrays.quickSort(x, y, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort2(x, y, from, to));
        }
    }

    public static void parallelQuickSort(byte[] x, byte[] y) {
        ByteArrays.ensureSameLength(x, y);
        ByteArrays.parallelQuickSort(x, y, 0, x.length);
    }

    public static void unstableSort(byte[] a, int from, int to) {
        java.util.Arrays.sort(a, from, to);
    }

    public static void unstableSort(byte[] a) {
        ByteArrays.unstableSort(a, 0, a.length);
    }

    public static void unstableSort(byte[] a, int from, int to, ByteComparator comp) {
        ByteArrays.quickSort(a, from, to, comp);
    }

    public static void unstableSort(byte[] a, ByteComparator comp) {
        ByteArrays.unstableSort(a, 0, a.length, comp);
    }

    public static void mergeSort(byte[] a, int from, int to, byte[] supp) {
        int len = to - from;
        if (len < 16) {
            ByteArrays.insertionSort(a, from, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        ByteArrays.mergeSort(supp, from, mid, a);
        ByteArrays.mergeSort(supp, mid, to, a);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a[i2] = q >= to || p < mid && supp[p] <= supp[q] ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(byte[] a, int from, int to) {
        ByteArrays.mergeSort(a, from, to, (byte[])null);
    }

    public static void mergeSort(byte[] a) {
        ByteArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(byte[] a, int from, int to, ByteComparator comp, byte[] supp) {
        int len = to - from;
        if (len < 16) {
            ByteArrays.insertionSort(a, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        ByteArrays.mergeSort(supp, from, mid, comp, a);
        ByteArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a[i2] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(byte[] a, int from, int to, ByteComparator comp) {
        ByteArrays.mergeSort(a, from, to, comp, null);
    }

    public static void mergeSort(byte[] a, ByteComparator comp) {
        ByteArrays.mergeSort(a, 0, a.length, comp);
    }

    public static void stableSort(byte[] a, int from, int to) {
        ByteArrays.unstableSort(a, from, to);
    }

    public static void stableSort(byte[] a) {
        ByteArrays.stableSort(a, 0, a.length);
    }

    public static void stableSort(byte[] a, int from, int to, ByteComparator comp) {
        ByteArrays.mergeSort(a, from, to, comp);
    }

    public static void stableSort(byte[] a, ByteComparator comp) {
        ByteArrays.stableSort(a, 0, a.length, comp);
    }

    public static int binarySearch(byte[] a, int from, int to, byte key) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            byte midVal = a[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(byte[] a, byte key) {
        return ByteArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(byte[] a, int from, int to, byte key, ByteComparator c2) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            byte midVal = a[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(byte[] a, byte key, ByteComparator c2) {
        return ByteArrays.binarySearch(a, 0, a.length, key, c2);
    }

    public static void radixSort(byte[] a) {
        ByteArrays.radixSort(a, 0, a.length);
    }

    public static void radixSort(byte[] a, int from, int to) {
        if (to - from < 1024) {
            ByteArrays.quickSort(a, from, to);
            return;
        }
        boolean maxLevel = false;
        boolean stackSize = true;
        int stackPos = 0;
        int[] offsetStack = new int[1];
        int[] lengthStack = new int[1];
        int[] levelStack = new int[1];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 1 == 0 ? 128 : 0;
            int shift = (0 - level % 1) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = a[i2] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c2 = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c2]) {
                byte t = a[i4];
                c2 = t >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n = c2;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        byte z = t;
                        t = a[d];
                        a[d] = z;
                        c2 = t >>> shift & 0xFF ^ signMask;
                    }
                    a[i4] = t;
                }
                if (level < 0 && count2[c2] > 1) {
                    if (count2[c2] < 1024) {
                        ByteArrays.quickSort(a, i4, i4 + count2[c2]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c2];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c2] = 0;
            }
        }
    }

    public static void parallelRadixSort(byte[] a, int from, int to) {
        ForkJoinPool pool = ByteArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            ByteArrays.quickSort(a, from, to);
            return;
        }
        boolean maxLevel = false;
        LinkedBlockingQueue<Segment> queue2 = new LinkedBlockingQueue<Segment>();
        queue2.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i2 = numberOfThreads;
                        while (i2-- != 0) {
                            queue2.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue2.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 1 == 0 ? 128 : 0;
                    int shift = (0 - level % 1) * 8;
                    int i3 = first2 + length;
                    while (i3-- != first2) {
                        int n = a[i3] >>> shift & 0xFF ^ signMask;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p = first2;
                    for (int i4 = 0; i4 < 256; ++i4) {
                        if (count2[i4] != 0) {
                            lastUsed = i4;
                        }
                        pos[i4] = p += count2[i4];
                    }
                    int end = first2 + length - count2[lastUsed];
                    int c2 = -1;
                    for (int i5 = first2; i5 <= end; i5 += count2[c2]) {
                        byte t = a[i5];
                        c2 = t >>> shift & 0xFF ^ signMask;
                        if (i5 < end) {
                            while (true) {
                                int n = c2;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                int d = n2;
                                if (n2 <= i5) break;
                                byte z = t;
                                t = a[d];
                                a[d] = z;
                                c2 = t >>> shift & 0xFF ^ signMask;
                            }
                            a[i5] = t;
                        }
                        if (level < 0 && count2[c2] > 1) {
                            if (count2[c2] < 1024) {
                                ByteArrays.quickSort(a, i5, i5 + count2[c2]);
                            } else {
                                queueSize.incrementAndGet();
                                queue2.add(new Segment(i5, count2[c2], level + 1));
                            }
                        }
                        count2[c2] = 0;
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(byte[] a) {
        ByteArrays.parallelRadixSort(a, 0, a.length);
    }

    public static void radixSortIndirect(int[] perm, byte[] a, boolean stable) {
        ByteArrays.radixSortIndirect(perm, a, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, byte[] a, int from, int to, boolean stable) {
        int[] support;
        if (to - from < 1024) {
            ByteArrays.quickSortIndirect(perm, a, from, to);
            if (stable) {
                ByteArrays.stabilize(perm, a, from, to);
            }
            return;
        }
        boolean maxLevel = false;
        boolean stackSize = true;
        int stackPos = 0;
        int[] offsetStack = new int[1];
        int[] lengthStack = new int[1];
        int[] levelStack = new int[1];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (stackPos > 0) {
            int i2;
            int p;
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 1 == 0 ? 128 : 0;
            int shift = (0 - level % 1) * 8;
            int i3 = first2 + length;
            while (i3-- != first2) {
                int n = a[perm[i3]] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p = stable ? 0 : first2;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count2[i2];
            }
            if (stable) {
                i2 = first2 + length;
                while (i2-- != first2) {
                    int n2 = a[perm[i2]] >>> shift & 0xFF ^ signMask;
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i2];
                }
                System.arraycopy(support, 0, perm, first2, length);
                p = first2;
                for (i2 = 0; i2 <= lastUsed; ++i2) {
                    if (level < 0 && count2[i2] > 1) {
                        if (count2[i2] < 1024) {
                            ByteArrays.quickSortIndirect(perm, a, p, p + count2[i2]);
                            if (stable) {
                                ByteArrays.stabilize(perm, a, p, p + count2[i2]);
                            }
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count2[i2];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count2[i2];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end = first2 + length - count2[lastUsed];
            int c2 = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c2]) {
                int t = perm[i4];
                c2 = a[t] >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n4 = c2;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i4) break;
                        int z = t;
                        t = perm[d];
                        perm[d] = z;
                        c2 = a[t] >>> shift & 0xFF ^ signMask;
                    }
                    perm[i4] = t;
                }
                if (level < 0 && count2[c2] > 1) {
                    if (count2[c2] < 1024) {
                        ByteArrays.quickSortIndirect(perm, a, i4, i4 + count2[c2]);
                        if (stable) {
                            ByteArrays.stabilize(perm, a, i4, i4 + count2[c2]);
                        }
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c2];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c2] = 0;
            }
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, byte[] a, int from, int to, boolean stable) {
        ForkJoinPool pool = ByteArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            ByteArrays.radixSortIndirect(perm, a, from, to, stable);
            return;
        }
        boolean maxLevel = false;
        LinkedBlockingQueue<Segment> queue2 = new LinkedBlockingQueue<Segment>();
        queue2.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int[] support = stable ? new int[perm.length] : null;
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    int i2;
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i3 = numberOfThreads;
                        while (i3-- != 0) {
                            queue2.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue2.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 1 == 0 ? 128 : 0;
                    int shift = (0 - level % 1) * 8;
                    int i4 = first2 + length;
                    while (i4-- != first2) {
                        int n = a[perm[i4]] >>> shift & 0xFF ^ signMask;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p = first2;
                    for (i2 = 0; i2 < 256; ++i2) {
                        if (count2[i2] != 0) {
                            lastUsed = i2;
                        }
                        pos[i2] = p += count2[i2];
                    }
                    if (stable) {
                        i2 = first2 + length;
                        while (i2-- != first2) {
                            int n = a[perm[i2]] >>> shift & 0xFF ^ signMask;
                            int n2 = pos[n] - 1;
                            pos[n] = n2;
                            support[n2] = perm[i2];
                        }
                        System.arraycopy(support, first2, perm, first2, length);
                        p = first2;
                        for (i2 = 0; i2 <= lastUsed; ++i2) {
                            if (level < 0 && count2[i2] > 1) {
                                if (count2[i2] < 1024) {
                                    ByteArrays.radixSortIndirect(perm, a, p, p + count2[i2], stable);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue2.add(new Segment(p, count2[i2], level + 1));
                                }
                            }
                            p += count2[i2];
                        }
                        java.util.Arrays.fill(count2, 0);
                    } else {
                        int end = first2 + length - count2[lastUsed];
                        int c2 = -1;
                        for (int i5 = first2; i5 <= end; i5 += count2[c2]) {
                            int t = perm[i5];
                            c2 = a[t] >>> shift & 0xFF ^ signMask;
                            if (i5 < end) {
                                while (true) {
                                    int n = c2;
                                    int n3 = pos[n] - 1;
                                    pos[n] = n3;
                                    int d = n3;
                                    if (n3 <= i5) break;
                                    int z = t;
                                    t = perm[d];
                                    perm[d] = z;
                                    c2 = a[t] >>> shift & 0xFF ^ signMask;
                                }
                                perm[i5] = t;
                            }
                            if (level < 0 && count2[c2] > 1) {
                                if (count2[c2] < 1024) {
                                    ByteArrays.radixSortIndirect(perm, a, i5, i5 + count2[c2], stable);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue2.add(new Segment(i5, count2[c2], level + 1));
                                }
                            }
                            count2[c2] = 0;
                        }
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, byte[] a, boolean stable) {
        ByteArrays.parallelRadixSortIndirect(perm, a, 0, a.length, stable);
    }

    public static void radixSort(byte[] a, byte[] b) {
        ByteArrays.ensureSameLength(a, b);
        ByteArrays.radixSort(a, b, 0, a.length);
    }

    public static void radixSort(byte[] a, byte[] b, int from, int to) {
        if (to - from < 1024) {
            ByteArrays.quickSort(a, b, from, to);
            return;
        }
        int layers = 2;
        boolean maxLevel = true;
        int stackSize = 256;
        int stackPos = 0;
        int[] offsetStack = new int[256];
        int[] lengthStack = new int[256];
        int[] levelStack = new int[256];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 1 == 0 ? 128 : 0;
            byte[] k = level < 1 ? a : b;
            int shift = (0 - level % 1) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = k[i2] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c2 = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c2]) {
                byte t = a[i4];
                byte u = b[i4];
                c2 = k[i4] >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n = c2;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        c2 = k[d] >>> shift & 0xFF ^ signMask;
                        byte z = t;
                        t = a[d];
                        a[d] = z;
                        z = u;
                        u = b[d];
                        b[d] = z;
                    }
                    a[i4] = t;
                    b[i4] = u;
                }
                if (level < 1 && count2[c2] > 1) {
                    if (count2[c2] < 1024) {
                        ByteArrays.quickSort(a, b, i4, i4 + count2[c2]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c2];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c2] = 0;
            }
        }
    }

    public static void parallelRadixSort(byte[] a, byte[] b, int from, int to) {
        ForkJoinPool pool = ByteArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            ByteArrays.quickSort(a, b, from, to);
            return;
        }
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        boolean maxLevel = true;
        LinkedBlockingQueue<Segment> queue2 = new LinkedBlockingQueue<Segment>();
        queue2.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i2 = numberOfThreads;
                        while (i2-- != 0) {
                            queue2.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue2.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 1 == 0 ? 128 : 0;
                    byte[] k = level < 1 ? a : b;
                    int shift = (0 - level % 1) * 8;
                    int i3 = first2 + length;
                    while (i3-- != first2) {
                        int n = k[i3] >>> shift & 0xFF ^ signMask;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p = first2;
                    for (int i4 = 0; i4 < 256; ++i4) {
                        if (count2[i4] != 0) {
                            lastUsed = i4;
                        }
                        pos[i4] = p += count2[i4];
                    }
                    int end = first2 + length - count2[lastUsed];
                    int c2 = -1;
                    for (int i5 = first2; i5 <= end; i5 += count2[c2]) {
                        byte t = a[i5];
                        byte u = b[i5];
                        c2 = k[i5] >>> shift & 0xFF ^ signMask;
                        if (i5 < end) {
                            while (true) {
                                int n = c2;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                int d = n2;
                                if (n2 <= i5) break;
                                c2 = k[d] >>> shift & 0xFF ^ signMask;
                                byte z = t;
                                byte w = u;
                                t = a[d];
                                u = b[d];
                                a[d] = z;
                                b[d] = w;
                            }
                            a[i5] = t;
                            b[i5] = u;
                        }
                        if (level < 1 && count2[c2] > 1) {
                            if (count2[c2] < 1024) {
                                ByteArrays.quickSort(a, b, i5, i5 + count2[c2]);
                            } else {
                                queueSize.incrementAndGet();
                                queue2.add(new Segment(i5, count2[c2], level + 1));
                            }
                        }
                        count2[c2] = 0;
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(byte[] a, byte[] b) {
        ByteArrays.ensureSameLength(a, b);
        ByteArrays.parallelRadixSort(a, b, 0, a.length);
    }

    private static void insertionSortIndirect(int[] perm, byte[] a, byte[] b, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j = i2;
            int u = perm[j - 1];
            while (a[t] < a[u] || a[t] == a[u] && b[t] < b[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, byte[] a, byte[] b, boolean stable) {
        ByteArrays.ensureSameLength(a, b);
        ByteArrays.radixSortIndirect(perm, a, b, 0, a.length, stable);
    }

    public static void radixSortIndirect(int[] perm, byte[] a, byte[] b, int from, int to, boolean stable) {
        int[] support;
        if (to - from < 64) {
            ByteArrays.insertionSortIndirect(perm, a, b, from, to);
            return;
        }
        int layers = 2;
        boolean maxLevel = true;
        int stackSize = 256;
        int stackPos = 0;
        int[] offsetStack = new int[256];
        int[] lengthStack = new int[256];
        int[] levelStack = new int[256];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (stackPos > 0) {
            int i2;
            int p;
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 1 == 0 ? 128 : 0;
            byte[] k = level < 1 ? a : b;
            int shift = (0 - level % 1) * 8;
            int i3 = first2 + length;
            while (i3-- != first2) {
                int n = k[perm[i3]] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p = stable ? 0 : first2;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count2[i2];
            }
            if (stable) {
                i2 = first2 + length;
                while (i2-- != first2) {
                    int n2 = k[perm[i2]] >>> shift & 0xFF ^ signMask;
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i2];
                }
                System.arraycopy(support, 0, perm, first2, length);
                p = first2;
                for (i2 = 0; i2 < 256; ++i2) {
                    if (level < 1 && count2[i2] > 1) {
                        if (count2[i2] < 64) {
                            ByteArrays.insertionSortIndirect(perm, a, b, p, p + count2[i2]);
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count2[i2];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count2[i2];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end = first2 + length - count2[lastUsed];
            int c2 = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c2]) {
                int t = perm[i4];
                c2 = k[t] >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n4 = c2;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i4) break;
                        int z = t;
                        t = perm[d];
                        perm[d] = z;
                        c2 = k[t] >>> shift & 0xFF ^ signMask;
                    }
                    perm[i4] = t;
                }
                if (level < 1 && count2[c2] > 1) {
                    if (count2[c2] < 64) {
                        ByteArrays.insertionSortIndirect(perm, a, b, i4, i4 + count2[c2]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c2];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c2] = 0;
            }
        }
    }

    private static void selectionSort(byte[][] a, int from, int to, int level) {
        int layers = a.length;
        int firstLayer = level / 1;
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            block1: for (int j = i2 + 1; j < to; ++j) {
                for (int p = firstLayer; p < layers; ++p) {
                    if (a[p][j] < a[p][m]) {
                        m = j;
                        continue block1;
                    }
                    if (a[p][j] > a[p][m]) continue block1;
                }
            }
            if (m == i2) continue;
            int p = layers;
            while (p-- != 0) {
                byte u = a[p][i2];
                a[p][i2] = a[p][m];
                a[p][m] = u;
            }
        }
    }

    public static void radixSort(byte[][] a) {
        ByteArrays.radixSort(a, 0, a[0].length);
    }

    public static void radixSort(byte[][] a, int from, int to) {
        if (to - from < 64) {
            ByteArrays.selectionSort(a, from, to, 0);
            return;
        }
        int layers = a.length;
        int maxLevel = 1 * layers - 1;
        int p = layers;
        int l = a[0].length;
        while (p-- != 0) {
            if (a[p].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 1 - 1) + 1;
        int stackPos = 0;
        int[] offsetStack = new int[stackSize];
        int[] lengthStack = new int[stackSize];
        int[] levelStack = new int[stackSize];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        byte[] t = new byte[layers];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 1 == 0 ? 128 : 0;
            byte[] k = a[level / 1];
            int shift = (0 - level % 1) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = k[i2] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c2 = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c2]) {
                int p3 = layers;
                while (p3-- != 0) {
                    t[p3] = a[p3][i4];
                }
                c2 = k[i4] >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    block6: while (true) {
                        int n = c2;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        c2 = k[d] >>> shift & 0xFF ^ signMask;
                        p3 = layers;
                        while (true) {
                            if (p3-- == 0) continue block6;
                            byte u = t[p3];
                            t[p3] = a[p3][d];
                            a[p3][d] = u;
                        }
                        break;
                    }
                    p3 = layers;
                    while (p3-- != 0) {
                        a[p3][i4] = t[p3];
                    }
                }
                if (level < maxLevel && count2[c2] > 1) {
                    if (count2[c2] < 64) {
                        ByteArrays.selectionSort(a, i4, i4 + count2[c2], level + 1);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c2];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c2] = 0;
            }
        }
    }

    public static byte[] shuffle(byte[] a, int from, int to, Random random2) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p = random2.nextInt(i2 + 1);
            byte t = a[from + i2];
            a[from + i2] = a[from + p];
            a[from + p] = t;
        }
        return a;
    }

    public static byte[] shuffle(byte[] a, Random random2) {
        int i2 = a.length;
        while (i2-- != 0) {
            int p = random2.nextInt(i2 + 1);
            byte t = a[i2];
            a[i2] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static byte[] reverse(byte[] a) {
        int length = a.length;
        int i2 = length / 2;
        while (i2-- != 0) {
            byte t = a[length - i2 - 1];
            a[length - i2 - 1] = a[i2];
            a[i2] = t;
        }
        return a;
    }

    public static byte[] reverse(byte[] a, int from, int to) {
        int length = to - from;
        int i2 = length / 2;
        while (i2-- != 0) {
            byte t = a[from + length - i2 - 1];
            a[from + length - i2 - 1] = a[from + i2];
            a[from + i2] = t;
        }
        return a;
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final byte[] x;
        private final ByteComparator comp;

        public ForkJoinQuickSortComp(byte[] x, int from, int to, ByteComparator comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c2;
            int a;
            byte[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                ByteArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = ByteArrays.med3(x, l, l + s, l + 2 * s, this.comp);
            m = ByteArrays.med3(x, m - s, m, m + s, this.comp);
            n = ByteArrays.med3(x, n - 2 * s, n - s, n, this.comp);
            m = ByteArrays.med3(x, l, m, n, this.comp);
            byte v = x[m];
            int b = a = this.from;
            int d = c2 = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c2 && (comparison = this.comp.compare(x[b], v)) <= 0) {
                    if (comparison == 0) {
                        ByteArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c2 >= b && (comparison = this.comp.compare(x[c2], v)) >= 0) {
                    if (comparison == 0) {
                        ByteArrays.swap(x, c2, d--);
                    }
                    --c2;
                }
                if (b > c2) break;
                ByteArrays.swap(x, b++, c2--);
            }
            s = Math.min(a - this.from, b - a);
            ByteArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c2, this.to - d - 1);
            ByteArrays.swap(x, b, this.to - s, s);
            s = b - a;
            int t = d - c2;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final byte[] x;

        public ForkJoinQuickSort(byte[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            int c2;
            int a;
            byte[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                ByteArrays.quickSort(x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = ByteArrays.med3(x, l, l + s, l + 2 * s);
            m = ByteArrays.med3(x, m - s, m, m + s);
            n = ByteArrays.med3(x, n - 2 * s, n - s, n);
            m = ByteArrays.med3(x, l, m, n);
            byte v = x[m];
            int b = a = this.from;
            int d = c2 = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c2 && (comparison = Byte.compare(x[b], v)) <= 0) {
                    if (comparison == 0) {
                        ByteArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c2 >= b && (comparison = Byte.compare(x[c2], v)) >= 0) {
                    if (comparison == 0) {
                        ByteArrays.swap(x, c2, d--);
                    }
                    --c2;
                }
                if (b > c2) break;
                ByteArrays.swap(x, b++, c2--);
            }
            s = Math.min(a - this.from, b - a);
            ByteArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c2, this.to - d - 1);
            ByteArrays.swap(x, b, this.to - s, s);
            s = b - a;
            int t = d - c2;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortIndirect
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] perm;
        private final byte[] x;

        public ForkJoinQuickSortIndirect(int[] perm, byte[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.perm = perm;
        }

        @Override
        protected void compute() {
            int c2;
            int a;
            byte[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                ByteArrays.quickSortIndirect(this.perm, x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = ByteArrays.med3Indirect(this.perm, x, l, l + s, l + 2 * s);
            m = ByteArrays.med3Indirect(this.perm, x, m - s, m, m + s);
            n = ByteArrays.med3Indirect(this.perm, x, n - 2 * s, n - s, n);
            m = ByteArrays.med3Indirect(this.perm, x, l, m, n);
            byte v = x[this.perm[m]];
            int b = a = this.from;
            int d = c2 = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c2 && (comparison = Byte.compare(x[this.perm[b]], v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c2 >= b && (comparison = Byte.compare(x[this.perm[c2]], v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, c2, d--);
                    }
                    --c2;
                }
                if (b > c2) break;
                IntArrays.swap(this.perm, b++, c2--);
            }
            s = Math.min(a - this.from, b - a);
            IntArrays.swap(this.perm, this.from, b - s, s);
            s = Math.min(d - c2, this.to - d - 1);
            IntArrays.swap(this.perm, b, this.to - s, s);
            s = b - a;
            int t = d - c2;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s), new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s));
            } else {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSort2
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final byte[] x;
        private final byte[] y;

        public ForkJoinQuickSort2(byte[] x, byte[] y, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.y = y;
        }

        @Override
        protected void compute() {
            int c2;
            int a;
            byte[] x = this.x;
            byte[] y = this.y;
            int len = this.to - this.from;
            if (len < 8192) {
                ByteArrays.quickSort(x, y, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = ByteArrays.med3(x, y, l, l + s, l + 2 * s);
            m = ByteArrays.med3(x, y, m - s, m, m + s);
            n = ByteArrays.med3(x, y, n - 2 * s, n - s, n);
            m = ByteArrays.med3(x, y, l, m, n);
            byte v = x[m];
            byte w = y[m];
            int b = a = this.from;
            int d = c2 = this.to - 1;
            while (true) {
                int t;
                int comparison;
                if (b <= c2 && (comparison = (t = Byte.compare(x[b], v)) == 0 ? Byte.compare(y[b], w) : t) <= 0) {
                    if (comparison == 0) {
                        ByteArrays.swap(x, y, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c2 >= b && (comparison = (t = Byte.compare(x[c2], v)) == 0 ? Byte.compare(y[c2], w) : t) >= 0) {
                    if (comparison == 0) {
                        ByteArrays.swap(x, y, c2, d--);
                    }
                    --c2;
                }
                if (b > c2) break;
                ByteArrays.swap(x, y, b++, c2--);
            }
            s = Math.min(a - this.from, b - a);
            ByteArrays.swap(x, y, this.from, b - s, s);
            s = Math.min(d - c2, this.to - d - 1);
            ByteArrays.swap(x, y, b, this.to - s, s);
            s = b - a;
            int t = d - c2;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s), new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s));
            } else {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<byte[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(byte[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(byte[] a, byte[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

