/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleConsumer;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoublePredicate;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractDoubleCollection
extends AbstractCollection<Double>
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    @Override
    public abstract DoubleIterator iterator();

    @Override
    public boolean add(double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(double k) {
        DoubleIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextDouble()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(double k) {
        DoubleIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextDouble()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Double key) {
        return DoubleCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return DoubleCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return DoubleCollection.super.remove(key);
    }

    @Override
    public double[] toArray(double[] a) {
        int size = this.size();
        if (a == null) {
            a = new double[size];
        } else if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        DoubleIterators.unwrap(this.iterator(), a);
        return a;
    }

    @Override
    public double[] toDoubleArray() {
        int size = this.size();
        if (size == 0) {
            return DoubleArrays.EMPTY_ARRAY;
        }
        double[] a = new double[size];
        DoubleIterators.unwrap(this.iterator(), a);
        return a;
    }

    @Override
    @Deprecated
    public double[] toDoubleArray(double[] a) {
        return this.toArray(a);
    }

    @Override
    public final void forEach(DoubleConsumer action2) {
        DoubleCollection.super.forEach(action2);
    }

    @Override
    public final boolean removeIf(DoublePredicate filter2) {
        return DoubleCollection.super.removeIf(filter2);
    }

    @Override
    public boolean addAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Double> c2) {
        if (c2 instanceof DoubleCollection) {
            return this.addAll((DoubleCollection)c2);
        }
        return super.addAll(c2);
    }

    @Override
    public boolean containsAll(DoubleCollection c2) {
        DoubleIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        if (c2 instanceof DoubleCollection) {
            return this.containsAll((DoubleCollection)c2);
        }
        return super.containsAll(c2);
    }

    @Override
    public boolean removeAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        if (c2 instanceof DoubleCollection) {
            return this.removeAll((DoubleCollection)c2);
        }
        return super.removeAll(c2);
    }

    @Override
    public boolean retainAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c2.contains(i2.nextDouble())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        if (c2 instanceof DoubleCollection) {
            return this.retainAll((DoubleCollection)c2);
        }
        return super.retainAll(c2);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        DoubleIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            double k = i2.nextDouble();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

