/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class FloatComparators {
    public static final FloatComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final FloatComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private FloatComparators() {
    }

    public static FloatComparator oppositeComparator(FloatComparator c2) {
        if (c2 instanceof OppositeComparator) {
            return ((OppositeComparator)c2).comparator;
        }
        return new OppositeComparator(c2);
    }

    public static FloatComparator asFloatComparator(final Comparator<? super Float> c2) {
        if (c2 == null || c2 instanceof FloatComparator) {
            return (FloatComparator)c2;
        }
        return new FloatComparator(){

            @Override
            public int compare(float x, float y) {
                return c2.compare(Float.valueOf(x), Float.valueOf(y));
            }

            @Override
            public int compare(Float x, Float y) {
                return c2.compare(x, y);
            }
        };
    }

    protected static class OppositeComparator
    implements FloatComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        final FloatComparator comparator;

        protected OppositeComparator(FloatComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(float a, float b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final FloatComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements FloatComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(float a, float b) {
            return Float.compare(a, b);
        }

        @Override
        public FloatComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements FloatComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(float a, float b) {
            return -Float.compare(a, b);
        }

        @Override
        public FloatComparator reversed() {
            return NATURAL_COMPARATOR;
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }
}

