/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;

public final class ShortBigArrays {
    public static final short[][] EMPTY_BIG_ARRAY = new short[0][];
    public static final short[][] DEFAULT_EMPTY_BIG_ARRAY = new short[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int QUICKSORT_NO_REC = 7;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 2;
    private static final int RADIXSORT_NO_REC = 1024;

    private ShortBigArrays() {
    }

    @Deprecated
    public static short get(short[][] array, long index2) {
        return array[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    @Deprecated
    public static void set(short[][] array, long index2, short value) {
        array[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    @Deprecated
    public static void swap(short[][] array, long first2, long second2) {
        short t = array[BigArrays.segment(first2)][BigArrays.displacement(first2)];
        array[BigArrays.segment((long)first2)][BigArrays.displacement((long)first2)] = array[BigArrays.segment(second2)][BigArrays.displacement(second2)];
        array[BigArrays.segment((long)second2)][BigArrays.displacement((long)second2)] = t;
    }

    @Deprecated
    public static void add(short[][] array, long index2, short incr) {
        short[] sArray = array[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        sArray[n] = (short)(sArray[n] + incr);
    }

    @Deprecated
    public static void mul(short[][] array, long index2, short factor) {
        short[] sArray = array[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        sArray[n] = (short)(sArray[n] * factor);
    }

    @Deprecated
    public static void incr(short[][] array, long index2) {
        short[] sArray = array[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        sArray[n] = (short)(sArray[n] + 1);
    }

    @Deprecated
    public static void decr(short[][] array, long index2) {
        short[] sArray = array[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        sArray[n] = (short)(sArray[n] - 1);
    }

    @Deprecated
    public static long length(short[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    @Deprecated
    public static void copy(short[][] srcArray, long srcPos, short[][] destArray, long destPos, long length) {
        BigArrays.copy(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyFromBig(short[][] srcArray, long srcPos, short[] destArray, int destPos, int length) {
        BigArrays.copyFromBig(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyToBig(short[] srcArray, int srcPos, short[][] destArray, long destPos, long length) {
        BigArrays.copyToBig(srcArray, srcPos, destArray, destPos, length);
    }

    public static short[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        short[][] base = new short[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new short[0x8000000];
            }
            base[baseLength - 1] = new short[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new short[0x8000000];
            }
        }
        return base;
    }

    @Deprecated
    public static short[][] wrap(short[] array) {
        return BigArrays.wrap(array);
    }

    @Deprecated
    public static short[][] ensureCapacity(short[][] array, long length) {
        return ShortBigArrays.ensureCapacity(array, length, ShortBigArrays.length(array));
    }

    @Deprecated
    public static short[][] forceCapacity(short[][] array, long length, long preserve) {
        return BigArrays.forceCapacity(array, length, preserve);
    }

    @Deprecated
    public static short[][] ensureCapacity(short[][] array, long length, long preserve) {
        return length > ShortBigArrays.length(array) ? ShortBigArrays.forceCapacity(array, length, preserve) : array;
    }

    @Deprecated
    public static short[][] grow(short[][] array, long length) {
        long oldLength = ShortBigArrays.length(array);
        return length > oldLength ? ShortBigArrays.grow(array, length, oldLength) : array;
    }

    @Deprecated
    public static short[][] grow(short[][] array, long length, long preserve) {
        long oldLength = ShortBigArrays.length(array);
        return length > oldLength ? ShortBigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    @Deprecated
    public static short[][] trim(short[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = ShortBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        short[][] base = (short[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = ShortArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    @Deprecated
    public static short[][] setLength(short[][] array, long length) {
        return BigArrays.setLength(array, length);
    }

    @Deprecated
    public static short[][] copy(short[][] array, long offset2, long length) {
        return BigArrays.copy(array, offset2, length);
    }

    @Deprecated
    public static short[][] copy(short[][] array) {
        return BigArrays.copy(array);
    }

    @Deprecated
    public static void fill(short[][] array, short value) {
        int i2 = array.length;
        while (i2-- != 0) {
            Arrays.fill(array[i2], value);
        }
    }

    @Deprecated
    public static void fill(short[][] array, long from, long to, short value) {
        BigArrays.fill(array, from, to, value);
    }

    @Deprecated
    public static boolean equals(short[][] a1, short[][] a2) {
        return BigArrays.equals(a1, a2);
    }

    @Deprecated
    public static String toString(short[][] a) {
        return BigArrays.toString(a);
    }

    @Deprecated
    public static void ensureFromTo(short[][] a, long from, long to) {
        BigArrays.ensureFromTo(ShortBigArrays.length(a), from, to);
    }

    @Deprecated
    public static void ensureOffsetLength(short[][] a, long offset2, long length) {
        BigArrays.ensureOffsetLength(ShortBigArrays.length(a), offset2, length);
    }

    @Deprecated
    public static void ensureSameLength(short[][] a, short[][] b) {
        if (ShortBigArrays.length(a) != ShortBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + ShortBigArrays.length(a) + " != " + ShortBigArrays.length(b));
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    private static void swap(short[][] x, long a, long b, long n) {
        int i2 = 0;
        while ((long)i2 < n) {
            BigArrays.swap(x, a, b);
            ++i2;
            ++a;
            ++b;
        }
    }

    private static long med3(short[][] x, long a, long b, long c2, ShortComparator comp) {
        int ab = comp.compare(BigArrays.get(x, a), BigArrays.get(x, b));
        int ac = comp.compare(BigArrays.get(x, a), BigArrays.get(x, c2));
        int bc = comp.compare(BigArrays.get(x, b), BigArrays.get(x, c2));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c2 : a)) : (bc > 0 ? b : (ac > 0 ? c2 : a));
    }

    private static void selectionSort(short[][] a, long from, long to, ShortComparator comp) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (comp.compare(BigArrays.get(a, j), BigArrays.get(a, m)) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a, i2, m);
        }
    }

    public static void quickSort(short[][] x, long from, long to, ShortComparator comp) {
        long c2;
        long a;
        long len = to - from;
        if (len < 7L) {
            ShortBigArrays.selectionSort(x, from, to, comp);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = ShortBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = ShortBigArrays.med3(x, m - s, m, m + s, comp);
                n = ShortBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = ShortBigArrays.med3(x, l, m, n, comp);
        }
        short v = BigArrays.get(x, m);
        long b = a = from;
        long d = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b <= c2 && (comparison = comp.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c2 >= b && (comparison = comp.compare(BigArrays.get(x, c2), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c2, d--);
                }
                --c2;
            }
            if (b > c2) break;
            BigArrays.swap(x, b++, c2--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        ShortBigArrays.swap(x, from, b - s, s);
        s = Math.min(d - c2, n - d - 1L);
        ShortBigArrays.swap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            ShortBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c2) > 1L) {
            ShortBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(short[][] x, long a, long b, long c2) {
        int ab = Short.compare(BigArrays.get(x, a), BigArrays.get(x, b));
        int ac = Short.compare(BigArrays.get(x, a), BigArrays.get(x, c2));
        int bc = Short.compare(BigArrays.get(x, b), BigArrays.get(x, c2));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c2 : a)) : (bc > 0 ? b : (ac > 0 ? c2 : a));
    }

    private static void selectionSort(short[][] a, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (BigArrays.get(a, j) >= BigArrays.get(a, m)) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a, i2, m);
        }
    }

    public static void quickSort(short[][] x, ShortComparator comp) {
        ShortBigArrays.quickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static void quickSort(short[][] x, long from, long to) {
        long c2;
        long a;
        long len = to - from;
        if (len < 7L) {
            ShortBigArrays.selectionSort(x, from, to);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = ShortBigArrays.med3(x, l, l + s, l + 2L * s);
                m = ShortBigArrays.med3(x, m - s, m, m + s);
                n = ShortBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = ShortBigArrays.med3(x, l, m, n);
        }
        short v = BigArrays.get(x, m);
        long b = a = from;
        long d = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b <= c2 && (comparison = Short.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c2 >= b && (comparison = Short.compare(BigArrays.get(x, c2), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c2, d--);
                }
                --c2;
            }
            if (b > c2) break;
            BigArrays.swap(x, b++, c2--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        ShortBigArrays.swap(x, from, b - s, s);
        s = Math.min(d - c2, n - d - 1L);
        ShortBigArrays.swap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            ShortBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c2) > 1L) {
            ShortBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(short[][] x) {
        ShortBigArrays.quickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(short[][] x, long from, long to) {
        ForkJoinPool pool = ShortBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            ShortBigArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(short[][] x) {
        ShortBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(short[][] x, long from, long to, ShortComparator comp) {
        ForkJoinPool pool = ShortBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            ShortBigArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(short[][] x, ShortComparator comp) {
        ShortBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static long binarySearch(short[][] a, long from, long to, short key) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            short midVal = BigArrays.get(a, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(short[][] a, short key) {
        return ShortBigArrays.binarySearch(a, 0L, BigArrays.length(a), key);
    }

    public static long binarySearch(short[][] a, long from, long to, short key, ShortComparator c2) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            short midVal = BigArrays.get(a, mid);
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(short[][] a, short key, ShortComparator c2) {
        return ShortBigArrays.binarySearch(a, 0L, BigArrays.length(a), key, c2);
    }

    public static void radixSort(short[][] a) {
        ShortBigArrays.radixSort(a, 0L, BigArrays.length(a));
    }

    public static void radixSort(short[][] a, long from, long to) {
        boolean maxLevel = true;
        int stackSize = 256;
        long[] offsetStack = new long[256];
        int offsetPos = 0;
        long[] lengthStack = new long[256];
        int lengthPos = 0;
        int[] levelStack = new int[256];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 2 == 0 ? 128 : 0;
            if (length < 40L) {
                ShortBigArrays.selectionSort(a, first2, first2 + length);
                continue;
            }
            int shift = (1 - level % 2) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(BigArrays.get(a, first2 + i2) >>> shift & 0xFF ^ signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 1 && count2[i3] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p += count2[i3];
            }
            long end = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c2 = -1;
            for (long i4 = 0L; i4 < end; i4 += count2[c2]) {
                short t = BigArrays.get(a, i4 + first2);
                c2 = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c2;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    short z = t;
                    int zz = c2;
                    t = BigArrays.get(a, d + first2);
                    c2 = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(a, d + first2, z);
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a, i4 + first2, t);
                count2[c2] = 0L;
            }
        }
    }

    private static void selectionSort(short[][] a, short[][] b, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (BigArrays.get(a, j) >= BigArrays.get(a, m) && (BigArrays.get(a, j) != BigArrays.get(a, m) || BigArrays.get(b, j) >= BigArrays.get(b, m))) continue;
                m = j;
            }
            if (m == i2) continue;
            short t = BigArrays.get(a, i2);
            BigArrays.set(a, i2, BigArrays.get(a, m));
            BigArrays.set(a, m, t);
            t = BigArrays.get(b, i2);
            BigArrays.set(b, i2, BigArrays.get(b, m));
            BigArrays.set(b, m, t);
        }
    }

    public static void radixSort(short[][] a, short[][] b) {
        ShortBigArrays.radixSort(a, b, 0L, BigArrays.length(a));
    }

    public static void radixSort(short[][] a, short[][] b, long from, long to) {
        int layers = 2;
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 3;
        int stackSize = 766;
        long[] offsetStack = new long[766];
        int offsetPos = 0;
        long[] lengthStack = new long[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 2 == 0 ? 128 : 0;
            if (length < 40L) {
                ShortBigArrays.selectionSort(a, b, first2, first2 + length);
                continue;
            }
            short[][] k = level < 2 ? a : b;
            int shift = (1 - level % 2) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(BigArrays.get(k, first2 + i2) >>> shift & 0xFF ^ signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 3 && count2[i3] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p += count2[i3];
            }
            long end = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c2 = -1;
            for (long i4 = 0L; i4 < end; i4 += count2[c2]) {
                short t = BigArrays.get(a, i4 + first2);
                short u = BigArrays.get(b, i4 + first2);
                c2 = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c2;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    short z = t;
                    int zz = c2;
                    t = BigArrays.get(a, d + first2);
                    BigArrays.set(a, d + first2, z);
                    z = u;
                    u = BigArrays.get(b, d + first2);
                    BigArrays.set(b, d + first2, z);
                    c2 = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a, i4 + first2, t);
                BigArrays.set(b, i4 + first2, u);
                count2[c2] = 0L;
            }
        }
    }

    private static void insertionSortIndirect(long[][] perm, short[][] a, short[][] b, long from, long to) {
        long i2 = from;
        while (++i2 < to) {
            long t = BigArrays.get(perm, i2);
            long j = i2;
            long u = BigArrays.get(perm, j - 1L);
            while (BigArrays.get(a, t) < BigArrays.get(a, u) || BigArrays.get(a, t) == BigArrays.get(a, u) && BigArrays.get(b, t) < BigArrays.get(b, u)) {
                BigArrays.set(perm, j, u);
                if (from == j - 1L) {
                    --j;
                    break;
                }
                u = BigArrays.get(perm, --j - 1L);
            }
            BigArrays.set(perm, j, t);
        }
    }

    public static void radixSortIndirect(long[][] perm, short[][] a, short[][] b, boolean stable) {
        ShortBigArrays.ensureSameLength(a, b);
        ShortBigArrays.radixSortIndirect(perm, a, b, 0L, BigArrays.length(a), stable);
    }

    public static void radixSortIndirect(long[][] perm, short[][] a, short[][] b, long from, long to, boolean stable) {
        long[][] support;
        if (to - from < 1024L) {
            ShortBigArrays.insertionSortIndirect(perm, a, b, from, to);
            return;
        }
        int layers = 2;
        int maxLevel = 3;
        int stackSize = 766;
        int stackPos = 0;
        long[] offsetStack = new long[766];
        long[] lengthStack = new long[766];
        int[] levelStack = new int[766];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        long[][] lArray = support = stable ? LongBigArrays.newBigArray(BigArrays.length(perm)) : null;
        while (stackPos > 0) {
            long first2 = offsetStack[--stackPos];
            long length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 2 == 0 ? 128 : 0;
            short[][] k = level < 2 ? a : b;
            int shift = (1 - level % 2) * 8;
            long i2 = first2 + length;
            while (i2-- != first2) {
                int n = BigArrays.get(k, BigArrays.get(perm, i2)) >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1L;
            }
            int lastUsed = -1;
            long p = stable ? 0L : first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                }
                pos[i3] = p += count2[i3];
            }
            if (stable) {
                long i4 = first2 + length;
                while (i4-- != first2) {
                    int n = BigArrays.get(k, BigArrays.get(perm, i4)) >>> shift & 0xFF ^ signMask;
                    long l = pos[n] - 1L;
                    pos[n] = l;
                    BigArrays.set(support, l, BigArrays.get(perm, i4));
                }
                BigArrays.copy(support, 0L, perm, first2, length);
                p = first2;
                for (int i5 = 0; i5 < 256; ++i5) {
                    if (level < 3 && count2[i5] > 1L) {
                        if (count2[i5] < 1024L) {
                            ShortBigArrays.insertionSortIndirect(perm, a, b, p, p + count2[i5]);
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count2[i5];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count2[i5];
                }
                Arrays.fill(count2, 0L);
                continue;
            }
            long end = first2 + length - count2[lastUsed];
            int c2 = -1;
            for (long i6 = first2; i6 <= end; i6 += count2[c2]) {
                long t = BigArrays.get(perm, i6);
                c2 = BigArrays.get(k, t) >>> shift & 0xFF ^ signMask;
                if (i6 < end) {
                    while (true) {
                        int n = c2;
                        long l = pos[n] - 1L;
                        pos[n] = l;
                        long d = l;
                        if (l <= i6) break;
                        long z = t;
                        t = BigArrays.get(perm, d);
                        BigArrays.set(perm, d, z);
                        c2 = BigArrays.get(k, t) >>> shift & 0xFF ^ signMask;
                    }
                    BigArrays.set(perm, i6, t);
                }
                if (level < 3 && count2[c2] > 1L) {
                    if (count2[c2] < 1024L) {
                        ShortBigArrays.insertionSortIndirect(perm, a, b, i6, i6 + count2[c2]);
                    } else {
                        offsetStack[stackPos] = i6;
                        lengthStack[stackPos] = count2[c2];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c2] = 0L;
            }
        }
    }

    public static short[][] shuffle(short[][] a, long from, long to, Random random2) {
        return BigArrays.shuffle(a, from, to, random2);
    }

    public static short[][] shuffle(short[][] a, Random random2) {
        return BigArrays.shuffle(a, random2);
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final short[][] x;

        public ForkJoinQuickSort(short[][] x, long from, long to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            long c2;
            long a;
            short[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                ShortBigArrays.quickSort(x, this.from, this.to);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = ShortBigArrays.med3(x, l, l + s, l + 2L * s);
            m = ShortBigArrays.med3(x, m - s, m, m + s);
            n = ShortBigArrays.med3(x, n - 2L * s, n - s, n);
            m = ShortBigArrays.med3(x, l, m, n);
            short v = BigArrays.get(x, m);
            long b = a = this.from;
            long d = c2 = this.to - 1L;
            while (true) {
                int comparison;
                if (b <= c2 && (comparison = Short.compare(BigArrays.get(x, b), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c2 >= b && (comparison = Short.compare(BigArrays.get(x, c2), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c2, d--);
                    }
                    --c2;
                }
                if (b > c2) break;
                BigArrays.swap(x, b++, c2--);
            }
            s = Math.min(a - this.from, b - a);
            ShortBigArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c2, this.to - d - 1L);
            ShortBigArrays.swap(x, b, this.to - s, s);
            s = b - a;
            long t = d - c2;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final short[][] x;
        private final ShortComparator comp;

        public ForkJoinQuickSortComp(short[][] x, long from, long to, ShortComparator comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            long c2;
            long a;
            short[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                ShortBigArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = ShortBigArrays.med3(x, l, l + s, l + 2L * s, this.comp);
            m = ShortBigArrays.med3(x, m - s, m, m + s, this.comp);
            n = ShortBigArrays.med3(x, n - 2L * s, n - s, n, this.comp);
            m = ShortBigArrays.med3(x, l, m, n, this.comp);
            short v = BigArrays.get(x, m);
            long b = a = this.from;
            long d = c2 = this.to - 1L;
            while (true) {
                int comparison;
                if (b <= c2 && (comparison = this.comp.compare(BigArrays.get(x, b), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c2 >= b && (comparison = this.comp.compare(BigArrays.get(x, c2), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c2, d--);
                    }
                    --c2;
                }
                if (b > c2) break;
                BigArrays.swap(x, b++, c2--);
            }
            s = Math.min(a - this.from, b - a);
            ShortBigArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c2, this.to - d - 1L);
            ShortBigArrays.swap(x, b, this.to - s, s);
            s = b - a;
            long t = d - c2;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<short[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(short[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(short[][] a, short[][] b) {
            return ShortBigArrays.equals(a, b);
        }
    }
}

