/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.description.method;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlinx.coroutines.repackaged.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.ByteCodeElement;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.method.MethodDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.method.ParameterDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.TypeDefinition;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.TypeDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.TypeList;
import kotlinx.coroutines.repackaged.net.bytebuddy.matcher.ElementMatcher;
import kotlinx.coroutines.repackaged.net.bytebuddy.matcher.FilterableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ParameterList<T extends ParameterDescription>
extends FilterableList<T, ParameterList<T>> {
    public TypeList.Generic asTypeList();

    public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> var1);

    public ParameterList<ParameterDescription.InDefinedShape> asDefined();

    public boolean hasExplicitMetaData();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Empty<S extends ParameterDescription>
    extends FilterableList.Empty<S, ParameterList<S>>
    implements ParameterList<S> {
        @Override
        public boolean hasExplicitMetaData() {
            return true;
        }

        @Override
        public TypeList.Generic asTypeList() {
            return new TypeList.Generic.Empty();
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> matcher) {
            return new ByteCodeElement.Token.TokenList((ByteCodeElement.Token[])new ParameterDescription.Token[0]);
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> asDefined() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSubstituting
    extends AbstractBase<ParameterDescription.InGenericShape> {
        private final MethodDescription.InGenericShape declaringMethod;
        private final List<? extends ParameterDescription> parameterDescriptions;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        public TypeSubstituting(MethodDescription.InGenericShape declaringMethod, List<? extends ParameterDescription> parameterDescriptions, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor2) {
            this.declaringMethod = declaringMethod;
            this.parameterDescriptions = parameterDescriptions;
            this.visitor = visitor2;
        }

        @Override
        public ParameterDescription.InGenericShape get(int index2) {
            return new ParameterDescription.TypeSubstituting(this.declaringMethod, this.parameterDescriptions.get(index2), this.visitor);
        }

        @Override
        public int size() {
            return this.parameterDescriptions.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForTokens
    extends AbstractBase<ParameterDescription.InDefinedShape> {
        private final MethodDescription.InDefinedShape declaringMethod;
        private final List<? extends ParameterDescription.Token> tokens;

        public ForTokens(MethodDescription.InDefinedShape declaringMethod, List<? extends ParameterDescription.Token> tokens) {
            this.declaringMethod = declaringMethod;
            this.tokens = tokens;
        }

        @Override
        public ParameterDescription.InDefinedShape get(int index2) {
            int offset2 = this.declaringMethod.isStatic() ? 0 : 1;
            for (ParameterDescription.Token token : this.tokens.subList(0, index2)) {
                offset2 += token.getType().getStackSize().getSize();
            }
            return new ParameterDescription.Latent(this.declaringMethod, this.tokens.get(index2), index2, offset2);
        }

        @Override
        public int size() {
            return this.tokens.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Explicit<S extends ParameterDescription>
    extends AbstractBase<S> {
        private final List<? extends S> parameterDescriptions;

        public Explicit(S ... parameterDescription) {
            this(Arrays.asList(parameterDescription));
        }

        public Explicit(List<? extends S> parameterDescriptions) {
            this.parameterDescriptions = parameterDescriptions;
        }

        @Override
        public S get(int index2) {
            return (S)((ParameterDescription)this.parameterDescriptions.get(index2));
        }

        @Override
        public int size() {
            return this.parameterDescriptions.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ForTypes
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final MethodDescription.InDefinedShape methodDescription;
            private final List<? extends TypeDefinition> typeDefinitions;

            public ForTypes(MethodDescription.InDefinedShape methodDescription, TypeDefinition ... typeDefinition) {
                this(methodDescription, Arrays.asList(typeDefinition));
            }

            public ForTypes(MethodDescription.InDefinedShape methodDescription, List<? extends TypeDefinition> typeDefinitions) {
                this.methodDescription = methodDescription;
                this.typeDefinitions = typeDefinitions;
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index2) {
                int offset2 = this.methodDescription.isStatic() ? 0 : 1;
                for (int previous = 0; previous < index2; ++previous) {
                    offset2 += this.typeDefinitions.get(previous).getStackSize().getSize();
                }
                return new ParameterDescription.Latent(this.methodDescription, this.typeDefinitions.get(index2).asGenericType(), index2, offset2);
            }

            @Override
            public int size() {
                return this.typeDefinitions.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ForLoadedExecutable<T>
    extends AbstractBase<ParameterDescription.InDefinedShape> {
        private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        protected final T executable;
        protected final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;

        protected ForLoadedExecutable(T executable, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            this.executable = executable;
            this.parameterAnnotationSource = parameterAnnotationSource;
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Constructor<?> constructor) {
            return ForLoadedExecutable.of(constructor, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)new ParameterDescription.ForLoadedParameter.ParameterAnnotationSource.ForLoadedConstructor(constructor));
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            return DISPATCHER.describe(constructor, parameterAnnotationSource);
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Method method2) {
            return ForLoadedExecutable.of(method2, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)new ParameterDescription.ForLoadedParameter.ParameterAnnotationSource.ForLoadedMethod(method2));
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Method method2, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            return DISPATCHER.describe(method2, parameterAnnotationSource);
        }

        @Override
        public int size() {
            return DISPATCHER.getParameterCount(this.executable);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfLegacyVmMethod
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final Method method;
            private final Class<?>[] parameterType;
            private final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;

            protected OfLegacyVmMethod(Method method2, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                this.method = method2;
                this.parameterType = method2.getParameterTypes();
                this.parameterAnnotationSource = parameterAnnotationSource;
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index2) {
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmMethod(this.method, index2, this.parameterType, this.parameterAnnotationSource);
            }

            @Override
            public int size() {
                return this.parameterType.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfLegacyVmConstructor
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final Constructor<?> constructor;
            private final Class<?>[] parameterType;
            private final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;

            protected OfLegacyVmConstructor(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                this.constructor = constructor;
                this.parameterType = constructor.getParameterTypes();
                this.parameterAnnotationSource = parameterAnnotationSource;
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index2) {
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmConstructor(this.constructor, index2, this.parameterType, this.parameterAnnotationSource);
            }

            @Override
            public int size() {
                return this.parameterType.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfMethod
        extends ForLoadedExecutable<Method> {
            protected OfMethod(Method method2, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                super(method2, parameterAnnotationSource);
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index2) {
                return new ParameterDescription.ForLoadedParameter.OfMethod((Method)this.executable, index2, this.parameterAnnotationSource);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfConstructor
        extends ForLoadedExecutable<Constructor<?>> {
            protected OfConstructor(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                super(constructor, parameterAnnotationSource);
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index2) {
                return new ParameterDescription.ForLoadedParameter.OfConstructor((Constructor)this.executable, index2, this.parameterAnnotationSource);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Dispatcher {
            public int getParameterCount(Object var1);

            public ParameterList<ParameterDescription.InDefinedShape> describe(Constructor<?> var1, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource var2);

            public ParameterList<ParameterDescription.InDefinedShape> describe(Method var1, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource var2);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava8CapableVm
            implements Dispatcher {
                private static final Object[] NO_ARGUMENTS = new Object[0];
                private final Method getParameterCount;

                protected ForJava8CapableVm(Method getParameterCount) {
                    this.getParameterCount = getParameterCount;
                }

                @Override
                public int getParameterCount(Object executable) {
                    try {
                        return (Integer)this.getParameterCount.invoke(executable, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getModifiers", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getModifiers", exception.getCause());
                    }
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> describe(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                    return new OfConstructor(constructor, parameterAnnotationSource);
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> describe(Method method2, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                    return new OfMethod(method2, parameterAnnotationSource);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.getParameterCount.equals(((ForJava8CapableVm)object).getParameterCount);
                }

                public int hashCode() {
                    return 17 * 31 + this.getParameterCount.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public int getParameterCount(Object executable) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Executable");
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> describe(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                    return new OfLegacyVmConstructor(constructor, parameterAnnotationSource);
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> describe(Method method2, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                    return new OfLegacyVmMethod(method2, parameterAnnotationSource);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum CreationAction implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Dispatcher run() {
                    try {
                        return new ForJava8CapableVm(Class.forName("java.lang.reflect.Executable").getMethod("getParameterCount", new Class[0]));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase<S extends ParameterDescription>
    extends FilterableList.AbstractBase<S, ParameterList<S>>
    implements ParameterList<S> {
        @Override
        public boolean hasExplicitMetaData() {
            for (ParameterDescription parameterDescription : this) {
                if (parameterDescription.isNamed() && parameterDescription.hasModifiers()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> matcher) {
            ArrayList tokens = new ArrayList(this.size());
            for (ParameterDescription parameterDescription : this) {
                tokens.add(parameterDescription.asToken(matcher));
            }
            return new ByteCodeElement.Token.TokenList<ParameterDescription.Token>(tokens);
        }

        @Override
        public TypeList.Generic asTypeList() {
            ArrayList<TypeDescription.Generic> types = new ArrayList<TypeDescription.Generic>(this.size());
            for (ParameterDescription parameterDescription : this) {
                types.add(parameterDescription.getType());
            }
            return new TypeList.Generic.Explicit(types);
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> asDefined() {
            ArrayList declaredForms = new ArrayList(this.size());
            for (ParameterDescription parameterDescription : this) {
                declaredForms.add(parameterDescription.asDefined());
            }
            return new Explicit<ParameterDescription.InDefinedShape>(declaredForms);
        }

        @Override
        protected ParameterList<S> wrap(List<S> values2) {
            return new Explicit<S>(values2);
        }
    }
}

