/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.assign.primitive;

import kotlinx.coroutines.repackaged.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.TypeDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.Removal;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.StackManipulation;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.assign.Assigner;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.constant.DefaultValue;

@HashCodeAndEqualsPlugin.Enhance
public class VoidAwareAssigner
implements Assigner {
    private final Assigner chained;

    public VoidAwareAssigner(Assigner chained) {
        this.chained = chained;
    }

    public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target2, Assigner.Typing typing) {
        if (source.represents(Void.TYPE) && target2.represents(Void.TYPE)) {
            return StackManipulation.Trivial.INSTANCE;
        }
        if (source.represents(Void.TYPE)) {
            return typing.isDynamic() ? DefaultValue.of(target2) : StackManipulation.Illegal.INSTANCE;
        }
        if (target2.represents(Void.TYPE)) {
            return Removal.of(source);
        }
        return this.chained.assign(source, target2, typing);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.chained.equals(((VoidAwareAssigner)object).chained);
    }

    public int hashCode() {
        return 17 * 31 + this.chained.hashCode();
    }
}

