/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm;

import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.Constants;

public abstract class ModuleVisitor {
    protected final int api;
    protected ModuleVisitor mv;

    public ModuleVisitor(int api) {
        this(api, null);
    }

    public ModuleVisitor(int api, ModuleVisitor moduleVisitor) {
        if (api != 458752 && api != 393216 && api != 327680 && api != 262144 && api != 0x1080000) {
            throw new IllegalArgumentException("Unsupported api " + api);
        }
        if (api == 0x1080000) {
            Constants.checkAsm8Experimental(this);
        }
        this.api = api;
        this.mv = moduleVisitor;
    }

    public void visitMainClass(String mainClass) {
        if (this.mv != null) {
            this.mv.visitMainClass(mainClass);
        }
    }

    public void visitPackage(String packaze) {
        if (this.mv != null) {
            this.mv.visitPackage(packaze);
        }
    }

    public void visitRequire(String module2, int access, String version) {
        if (this.mv != null) {
            this.mv.visitRequire(module2, access, version);
        }
    }

    public void visitExport(String packaze, int access, String ... modules2) {
        if (this.mv != null) {
            this.mv.visitExport(packaze, access, modules2);
        }
    }

    public void visitOpen(String packaze, int access, String ... modules2) {
        if (this.mv != null) {
            this.mv.visitOpen(packaze, access, modules2);
        }
    }

    public void visitUse(String service2) {
        if (this.mv != null) {
            this.mv.visitUse(service2);
        }
    }

    public void visitProvide(String service2, String ... providers) {
        if (this.mv != null) {
            this.mv.visitProvide(service2, providers);
        }
    }

    public void visitEnd() {
        if (this.mv != null) {
            this.mv.visitEnd();
        }
    }
}

