/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.matcher;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlinx.coroutines.repackaged.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.method.MethodDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.method.MethodList;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.TypeDefinition;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.TypeDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.matcher.ElementMatcher;
import kotlinx.coroutines.repackaged.net.bytebuddy.matcher.ElementMatchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class MethodOverrideMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public MethodOverrideMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T target2) {
        HashSet<TypeDescription> duplicates = new HashSet<TypeDescription>();
        for (TypeDefinition typeDefinition : target2.getDeclaringType()) {
            if (!this.matches((MethodDescription)target2, typeDefinition) && !this.matches((MethodDescription)target2, typeDefinition.getInterfaces(), (Set<TypeDescription>)duplicates)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(MethodDescription target2, List<? extends TypeDefinition> typeDefinitions, Set<TypeDescription> duplicates) {
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!duplicates.add(typeDefinition.asErasure()) || !this.matches(target2, typeDefinition) && !this.matches(target2, typeDefinition.getInterfaces(), duplicates)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(MethodDescription target2, TypeDefinition typeDefinition) {
        for (MethodDescription methodDescription : (MethodList)typeDefinition.getDeclaredMethods().filter(ElementMatchers.isVirtual())) {
            if (!methodDescription.asSignatureToken().equals(target2.asSignatureToken())) continue;
            if (!this.matcher.matches(typeDefinition.asGenericType())) break;
            return true;
        }
        return false;
    }

    public String toString() {
        return "isOverriddenFrom(" + this.matcher + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.matcher.equals(((MethodOverrideMatcher)object).matcher);
    }

    public int hashCode() {
        return 17 * 31 + this.matcher.hashCode();
    }
}

