/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.utility.visitor;

import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.Handle;
import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.Label;
import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.MethodVisitor;

public abstract class ExceptionTableSensitiveMethodVisitor
extends MethodVisitor {
    private boolean trigger = true;

    protected ExceptionTableSensitiveMethodVisitor(int api, MethodVisitor methodVisitor) {
        super(api, methodVisitor);
    }

    private void considerEndOfExceptionTable() {
        if (this.trigger) {
            this.trigger = false;
            this.onAfterExceptionTable();
        }
    }

    protected abstract void onAfterExceptionTable();

    public final void visitLabel(Label label2) {
        this.considerEndOfExceptionTable();
        this.onVisitLabel(label2);
    }

    protected void onVisitLabel(Label label2) {
        super.visitLabel(label2);
    }

    public final void visitIntInsn(int opcode, int operand) {
        this.considerEndOfExceptionTable();
        this.onVisitIntInsn(opcode, operand);
    }

    protected void onVisitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
    }

    public final void visitVarInsn(int opcode, int offset2) {
        this.considerEndOfExceptionTable();
        this.onVisitVarInsn(opcode, offset2);
    }

    protected void onVisitVarInsn(int opcode, int offset2) {
        super.visitVarInsn(opcode, offset2);
    }

    public final void visitTypeInsn(int opcode, String type) {
        this.considerEndOfExceptionTable();
        this.onVisitTypeInsn(opcode, type);
    }

    protected void onVisitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
    }

    public final void visitFieldInsn(int opcode, String owner, String name, String descriptor2) {
        this.considerEndOfExceptionTable();
        this.onVisitFieldInsn(opcode, owner, name, descriptor2);
    }

    protected void onVisitFieldInsn(int opcode, String owner, String name, String descriptor2) {
        super.visitFieldInsn(opcode, owner, name, descriptor2);
    }

    public final void visitMethodInsn(int opcode, String owner, String name, String descriptor2) {
        this.considerEndOfExceptionTable();
        this.onVisitMethodInsn(opcode, owner, name, descriptor2);
    }

    @Deprecated
    protected void onVisitMethodInsn(int opcode, String owner, String name, String descriptor2) {
        super.visitMethodInsn(opcode, owner, name, descriptor2);
    }

    public final void visitMethodInsn(int opcode, String owner, String name, String descriptor2, boolean isInterface) {
        this.considerEndOfExceptionTable();
        this.onVisitMethodInsn(opcode, owner, name, descriptor2, isInterface);
    }

    protected void onVisitMethodInsn(int opcode, String owner, String name, String descriptor2, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor2, isInterface);
    }

    public final void visitInvokeDynamicInsn(String name, String descriptor2, Handle handle2, Object ... argument) {
        this.considerEndOfExceptionTable();
        this.onVisitInvokeDynamicInsn(name, descriptor2, handle2, argument);
    }

    protected void onVisitInvokeDynamicInsn(String name, String descriptor2, Handle handle2, Object ... argument) {
        super.visitInvokeDynamicInsn(name, descriptor2, handle2, argument);
    }

    public final void visitJumpInsn(int opcode, Label label2) {
        this.considerEndOfExceptionTable();
        this.onVisitJumpInsn(opcode, label2);
    }

    protected void onVisitJumpInsn(int opcode, Label label2) {
        super.visitJumpInsn(opcode, label2);
    }

    public final void visitLdcInsn(Object constant) {
        this.considerEndOfExceptionTable();
        this.onVisitLdcInsn(constant);
    }

    protected void onVisitLdcInsn(Object constant) {
        super.visitLdcInsn(constant);
    }

    public final void visitIincInsn(int offset2, int increment) {
        this.considerEndOfExceptionTable();
        this.onVisitIincInsn(offset2, increment);
    }

    protected void onVisitIincInsn(int offset2, int increment) {
        super.visitIincInsn(offset2, increment);
    }

    public final void visitTableSwitchInsn(int minimum, int maximum, Label defaultTarget, Label ... label2) {
        this.considerEndOfExceptionTable();
        this.onVisitTableSwitchInsn(minimum, maximum, defaultTarget, label2);
    }

    protected void onVisitTableSwitchInsn(int minimum, int maximum, Label defaultTarget, Label ... label2) {
        super.visitTableSwitchInsn(minimum, maximum, defaultTarget, label2);
    }

    public final void visitLookupSwitchInsn(Label dflt, int[] key, Label[] label2) {
        this.considerEndOfExceptionTable();
        this.onVisitLookupSwitchInsn(dflt, key, label2);
    }

    protected void onVisitLookupSwitchInsn(Label defaultTarget, int[] key, Label[] label2) {
        super.visitLookupSwitchInsn(defaultTarget, key, label2);
    }

    public final void visitMultiANewArrayInsn(String descriptor2, int dimensions) {
        this.considerEndOfExceptionTable();
        this.onVisitMultiANewArrayInsn(descriptor2, dimensions);
    }

    protected void onVisitMultiANewArrayInsn(String descriptor2, int dimensions) {
        super.visitMultiANewArrayInsn(descriptor2, dimensions);
    }

    public final void visitInsn(int opcode) {
        this.considerEndOfExceptionTable();
        this.onVisitInsn(opcode);
    }

    protected void onVisitInsn(int opcode) {
        super.visitInsn(opcode);
    }
}

