/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.util.Objects;
import org.apache.commons.compress.archivers.sevenz.Coders;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;

public class SevenZMethodConfiguration {
    private final SevenZMethod method;
    private final Object options;

    public SevenZMethodConfiguration(SevenZMethod method2) {
        this(method2, null);
    }

    public SevenZMethodConfiguration(SevenZMethod method2, Object options2) {
        this.method = method2;
        this.options = options2;
        if (options2 != null && !Coders.findByMethod(method2).canAcceptOptions(options2)) {
            throw new IllegalArgumentException("The " + (Object)((Object)method2) + " method doesn't support options of type " + options2.getClass());
        }
    }

    public SevenZMethod getMethod() {
        return this.method;
    }

    public Object getOptions() {
        return this.options;
    }

    public int hashCode() {
        return this.method == null ? 0 : this.method.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SevenZMethodConfiguration other = (SevenZMethodConfiguration)obj;
        return Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.options, other.options);
    }
}

