/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.util.Arrays;

public class IntList {
    private int[] array;
    private int firstIndex;
    private int lastIndex;
    private int modCount;

    public IntList() {
        this(10);
    }

    public IntList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.lastIndex = 0;
        this.firstIndex = 0;
        this.array = new int[capacity];
    }

    public boolean add(int object) {
        if (this.lastIndex == this.array.length) {
            this.growAtEnd(1);
        }
        this.array[this.lastIndex++] = object;
        ++this.modCount;
        return true;
    }

    public void add(int location2, int object) {
        int size = this.lastIndex - this.firstIndex;
        if (0 < location2 && location2 < size) {
            if (this.firstIndex == 0 && this.lastIndex == this.array.length) {
                this.growForInsert(location2, 1);
            } else if (location2 < size / 2 && this.firstIndex > 0 || this.lastIndex == this.array.length) {
                System.arraycopy(this.array, this.firstIndex, this.array, --this.firstIndex, location2);
            } else {
                int index2 = location2 + this.firstIndex;
                System.arraycopy(this.array, index2, this.array, index2 + 1, size - location2);
                ++this.lastIndex;
            }
            this.array[location2 + this.firstIndex] = object;
        } else if (location2 == 0) {
            if (this.firstIndex == 0) {
                this.growAtFront(1);
            }
            this.array[--this.firstIndex] = object;
        } else if (location2 == size) {
            if (this.lastIndex == this.array.length) {
                this.growAtEnd(1);
            }
            this.array[this.lastIndex++] = object;
        } else {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
    }

    public void clear() {
        if (this.firstIndex != this.lastIndex) {
            Arrays.fill(this.array, this.firstIndex, this.lastIndex, -1);
            this.lastIndex = 0;
            this.firstIndex = 0;
            ++this.modCount;
        }
    }

    public int get(int location2) {
        if (0 <= location2 && location2 < this.lastIndex - this.firstIndex) {
            return this.array[this.firstIndex + location2];
        }
        throw new IndexOutOfBoundsException("" + location2);
    }

    private void growAtEnd(int required) {
        int size = this.lastIndex - this.firstIndex;
        if (this.firstIndex >= required - (this.array.length - this.lastIndex)) {
            int newLast = this.lastIndex - this.firstIndex;
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, 0, size);
            }
            this.firstIndex = 0;
            this.lastIndex = newLast;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            int[] newArray = new int[size + increment];
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, 0, size);
                this.firstIndex = 0;
                this.lastIndex = size;
            }
            this.array = newArray;
        }
    }

    private void growAtFront(int required) {
        int size = this.lastIndex - this.firstIndex;
        if (this.array.length - this.lastIndex + this.firstIndex >= required) {
            int newFirst = this.array.length - size;
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, size);
            }
            this.firstIndex = newFirst;
            this.lastIndex = this.array.length;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            int[] newArray = new int[size + increment];
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, newArray.length - size, size);
            }
            this.firstIndex = newArray.length - size;
            this.lastIndex = newArray.length;
            this.array = newArray;
        }
    }

    private void growForInsert(int location2, int required) {
        int size = this.lastIndex - this.firstIndex;
        int increment = size / 2;
        if (required > increment) {
            increment = required;
        }
        if (increment < 12) {
            increment = 12;
        }
        int[] newArray = new int[size + increment];
        int newFirst = increment - required;
        System.arraycopy(this.array, location2 + this.firstIndex, newArray, newFirst + location2 + required, size - location2);
        System.arraycopy(this.array, this.firstIndex, newArray, newFirst, location2);
        this.firstIndex = newFirst;
        this.lastIndex = size + increment;
        this.array = newArray;
    }

    public void increment(int location2) {
        if (0 > location2 || location2 >= this.lastIndex - this.firstIndex) {
            throw new IndexOutOfBoundsException("" + location2);
        }
        int n = this.firstIndex + location2;
        this.array[n] = this.array[n] + 1;
    }

    public boolean isEmpty() {
        return this.lastIndex == this.firstIndex;
    }

    public int remove(int location2) {
        int result2;
        int size = this.lastIndex - this.firstIndex;
        if (0 > location2 || location2 >= size) {
            throw new IndexOutOfBoundsException();
        }
        if (location2 == size - 1) {
            result2 = this.array[--this.lastIndex];
            this.array[this.lastIndex] = 0;
        } else if (location2 == 0) {
            result2 = this.array[this.firstIndex];
            this.array[this.firstIndex++] = 0;
        } else {
            int elementIndex = this.firstIndex + location2;
            result2 = this.array[elementIndex];
            if (location2 < size / 2) {
                System.arraycopy(this.array, this.firstIndex, this.array, this.firstIndex + 1, location2);
                this.array[this.firstIndex++] = 0;
            } else {
                System.arraycopy(this.array, elementIndex + 1, this.array, elementIndex, size - location2 - 1);
                this.array[--this.lastIndex] = 0;
            }
        }
        if (this.firstIndex == this.lastIndex) {
            this.lastIndex = 0;
            this.firstIndex = 0;
        }
        ++this.modCount;
        return result2;
    }

    public int size() {
        return this.lastIndex - this.firstIndex;
    }

    public int[] toArray() {
        int size = this.lastIndex - this.firstIndex;
        int[] result2 = new int[size];
        System.arraycopy(this.array, this.firstIndex, result2, 0, size);
        return result2;
    }

    public void addAll(IntList list2) {
        this.growAtEnd(list2.size());
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            this.add(list2.get(i2));
        }
    }
}

