/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.pattern;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.DefaultAllNodeStep;
import org.jaxen.expr.DefaultCommentNodeStep;
import org.jaxen.expr.DefaultFilterExpr;
import org.jaxen.expr.DefaultNameStep;
import org.jaxen.expr.DefaultProcessingInstructionNodeStep;
import org.jaxen.expr.DefaultStep;
import org.jaxen.expr.DefaultTextNodeStep;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.Step;
import org.jaxen.expr.UnionExpr;
import org.jaxen.pattern.LocationPathPattern;
import org.jaxen.pattern.NameTest;
import org.jaxen.pattern.NamespaceTest;
import org.jaxen.pattern.NodeTypeTest;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.TextNodeTest;
import org.jaxen.pattern.UnionPattern;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;

public class PatternParser {
    private static final boolean TRACE = false;
    private static final boolean USE_HANDLER = false;

    public static Pattern parse(String text2) throws JaxenException, SAXPathException {
        XPathReader reader = XPathReaderFactory.createReader();
        JaxenHandler handler2 = new JaxenHandler();
        handler2.setXPathFactory(new DefaultXPathFactory());
        reader.setXPathHandler(handler2);
        reader.parse(text2);
        Pattern pattern = PatternParser.convertExpr(handler2.getXPathExpr().getRootExpr());
        return pattern.simplify();
    }

    protected static Pattern convertExpr(Expr expr) throws JaxenException {
        if (expr instanceof LocationPath) {
            return PatternParser.convertExpr((LocationPath)expr);
        }
        if (expr instanceof FilterExpr) {
            LocationPathPattern answer = new LocationPathPattern();
            answer.addFilter((FilterExpr)expr);
            return answer;
        }
        if (expr instanceof UnionExpr) {
            UnionExpr unionExpr = (UnionExpr)expr;
            Pattern lhs = PatternParser.convertExpr(unionExpr.getLHS());
            Pattern rhs = PatternParser.convertExpr(unionExpr.getRHS());
            return new UnionPattern(lhs, rhs);
        }
        LocationPathPattern answer = new LocationPathPattern();
        answer.addFilter(new DefaultFilterExpr(expr, new PredicateSet()));
        return answer;
    }

    protected static LocationPathPattern convertExpr(LocationPath locationPath) throws JaxenException {
        LocationPathPattern answer = new LocationPathPattern();
        List steps = locationPath.getSteps();
        LocationPathPattern path2 = answer;
        boolean first2 = true;
        ListIterator iter = steps.listIterator(steps.size());
        while (iter.hasPrevious()) {
            Step step2 = (Step)iter.previous();
            if (first2) {
                first2 = false;
                path2 = PatternParser.convertStep(path2, step2);
                continue;
            }
            if (PatternParser.navigationStep(step2)) {
                LocationPathPattern parent2 = new LocationPathPattern();
                int axis = step2.getAxis();
                if (axis == 2 || axis == 12) {
                    path2.setAncestorPattern(parent2);
                } else {
                    path2.setParentPattern(parent2);
                }
                path2 = parent2;
            }
            path2 = PatternParser.convertStep(path2, step2);
        }
        if (locationPath.isAbsolute()) {
            LocationPathPattern parent3 = new LocationPathPattern(NodeTypeTest.DOCUMENT_TEST);
            path2.setParentPattern(parent3);
        }
        return answer;
    }

    protected static LocationPathPattern convertStep(LocationPathPattern path2, Step step2) throws JaxenException {
        if (step2 instanceof DefaultAllNodeStep) {
            int axis = step2.getAxis();
            if (axis == 9) {
                path2.setNodeTest(NodeTypeTest.ATTRIBUTE_TEST);
            } else {
                path2.setNodeTest(NodeTypeTest.ELEMENT_TEST);
            }
        } else if (step2 instanceof DefaultCommentNodeStep) {
            path2.setNodeTest(NodeTypeTest.COMMENT_TEST);
        } else if (step2 instanceof DefaultProcessingInstructionNodeStep) {
            path2.setNodeTest(NodeTypeTest.PROCESSING_INSTRUCTION_TEST);
        } else if (step2 instanceof DefaultTextNodeStep) {
            path2.setNodeTest(TextNodeTest.SINGLETON);
        } else if (step2 instanceof DefaultCommentNodeStep) {
            path2.setNodeTest(NodeTypeTest.COMMENT_TEST);
        } else {
            if (step2 instanceof DefaultNameStep) {
                DefaultNameStep nameStep = (DefaultNameStep)step2;
                String localName = nameStep.getLocalName();
                String prefix = nameStep.getPrefix();
                int axis = nameStep.getAxis();
                short nodeType = 1;
                if (axis == 9) {
                    nodeType = 2;
                }
                if (nameStep.isMatchesAnyName()) {
                    if (prefix.length() == 0 || prefix.equals("*")) {
                        if (axis == 9) {
                            path2.setNodeTest(NodeTypeTest.ATTRIBUTE_TEST);
                        } else {
                            path2.setNodeTest(NodeTypeTest.ELEMENT_TEST);
                        }
                    } else {
                        path2.setNodeTest(new NamespaceTest(prefix, nodeType));
                    }
                } else {
                    path2.setNodeTest(new NameTest(localName, nodeType));
                }
                return PatternParser.convertDefaultStep(path2, nameStep);
            }
            if (step2 instanceof DefaultStep) {
                return PatternParser.convertDefaultStep(path2, (DefaultStep)step2);
            }
            throw new JaxenException("Cannot convert: " + step2 + " to a Pattern");
        }
        return path2;
    }

    protected static LocationPathPattern convertDefaultStep(LocationPathPattern path2, DefaultStep step2) throws JaxenException {
        List predicates = step2.getPredicates();
        if (!predicates.isEmpty()) {
            DefaultFilterExpr filter2 = new DefaultFilterExpr(new PredicateSet());
            Iterator iter = predicates.iterator();
            while (iter.hasNext()) {
                filter2.addPredicate((Predicate)iter.next());
            }
            path2.addFilter(filter2);
        }
        return path2;
    }

    protected static boolean navigationStep(Step step2) {
        if (step2 instanceof DefaultNameStep) {
            return true;
        }
        if (step2.getClass().equals(DefaultStep.class)) {
            return !step2.getPredicates().isEmpty();
        }
        return true;
    }
}

