/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.jdom.Content;
import org.jdom.filter2.AndFilter;
import org.jdom.filter2.Filter;
import org.jdom.filter2.NegateFilter;
import org.jdom.filter2.OrFilter;

public abstract class AbstractFilter<T>
implements Filter<T> {
    @Override
    public final boolean matches(Object content2) {
        return this.filter(content2) != null;
    }

    @Override
    public List<T> filter(List<?> content2) {
        if (content2 == null) {
            return Collections.emptyList();
        }
        if (content2 instanceof RandomAccess) {
            int size = content2.size();
            ArrayList result2 = new ArrayList(size);
            for (int i2 = 0; i2 < size; ++i2) {
                Object c2 = this.filter(content2.get(i2));
                if (c2 == null) continue;
                result2.add(c2);
            }
            return result2.isEmpty() ? Collections.emptyList() : result2;
        }
        ArrayList result3 = new ArrayList();
        for (Object o : content2) {
            Object c3 = this.filter(o);
            if (c3 == null) continue;
            result3.add(c3);
        }
        return result3.isEmpty() ? Collections.emptyList() : result3;
    }

    @Override
    public final Filter<?> negate() {
        if (this instanceof NegateFilter) {
            return ((NegateFilter)this).getBaseFilter();
        }
        return new NegateFilter(this);
    }

    @Override
    public final Filter<? extends Content> or(Filter<?> filter2) {
        return new OrFilter(this, filter2);
    }

    @Override
    public final Filter<T> and(Filter<?> filter2) {
        return new AndFilter(filter2, this);
    }

    @Override
    public <R> Filter<R> refine(Filter<R> filter2) {
        return new AndFilter<R>(this, filter2);
    }
}

