/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input.sax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.AttributeType;
import org.jdom.CDATA;
import org.jdom.DefaultJDOMFactory;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.input.sax.TextBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DTDHandler {
    private final JDOMFactory factory;
    private final List<Namespace> declaredNamespaces = new ArrayList<Namespace>(32);
    private final StringBuilder internalSubset = new StringBuilder();
    private final TextBuffer textBuffer = new TextBuffer();
    private final Map<String, String[]> externalEntities = new HashMap<String, String[]>();
    private Document currentDocument = null;
    private Element currentElement = null;
    private Locator currentLocator = null;
    private boolean atRoot = true;
    private boolean inDTD = false;
    private boolean inInternalSubset = false;
    private boolean previousCDATA = false;
    private boolean inCDATA = false;
    private boolean expand = true;
    private boolean suppress = false;
    private int entityDepth = 0;
    private boolean ignoringWhite = false;
    private boolean ignoringBoundaryWhite = false;
    private int lastline = 0;
    private int lastcol = 0;

    public SAXHandler(JDOMFactory factory2) {
        this.factory = factory2 != null ? factory2 : new DefaultJDOMFactory();
        this.reset();
    }

    private void resetSubCLass() {
    }

    protected void pushElement(Element element) {
        if (this.atRoot) {
            this.currentDocument.setRootElement(element);
            this.atRoot = false;
        } else {
            this.factory.addContent(this.currentElement, element);
        }
        this.currentElement = element;
    }

    public final void reset() {
        this.currentLocator = null;
        this.currentDocument = this.factory.document(null);
        this.currentElement = null;
        this.atRoot = true;
        this.inDTD = false;
        this.inInternalSubset = false;
        this.previousCDATA = false;
        this.inCDATA = false;
        this.suppress = false;
        this.entityDepth = 0;
        this.declaredNamespaces.clear();
        this.internalSubset.setLength(0);
        this.textBuffer.clear();
        this.externalEntities.clear();
        this.resetSubCLass();
    }

    public Document getDocument() {
        return this.currentDocument;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public void setExpandEntities(boolean expand) {
        this.expand = expand;
    }

    boolean getExpandEntities() {
        return this.expand;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        this.ignoringWhite = ignoringWhite;
    }

    public void setIgnoringBoundaryWhitespace(boolean ignoringBoundaryWhite) {
        this.ignoringBoundaryWhite = ignoringBoundaryWhite;
    }

    boolean getIgnoringBoundaryWhitespace() {
        return this.ignoringBoundaryWhite;
    }

    boolean getIgnoringElementContentWhitespace() {
        return this.ignoringWhite;
    }

    @Override
    public void startDocument() {
        if (this.currentLocator != null) {
            this.currentDocument.setBaseURI(this.currentLocator.getSystemId());
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicID, String systemID) {
        this.externalEntities.put(name, new String[]{publicID, systemID});
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ").append(name);
        this.appendExternalId(publicID, systemID);
        this.internalSubset.append(">\n");
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ATTLIST ").append(eName).append(' ').append(aName).append(' ').append(type).append(' ');
        if (valueDefault != null) {
            this.internalSubset.append(valueDefault);
        } else {
            this.internalSubset.append('\"').append(value).append('\"');
        }
        if (valueDefault != null && valueDefault.equals("#FIXED")) {
            this.internalSubset.append(" \"").append(value).append('\"');
        }
        this.internalSubset.append(">\n");
    }

    @Override
    public void elementDecl(String name, String model2) {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ELEMENT ").append(name).append(' ').append(model2).append(">\n");
    }

    @Override
    public void internalEntityDecl(String name, String value) {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ");
        if (name.startsWith("%")) {
            this.internalSubset.append("% ").append(name.substring(1));
        } else {
            this.internalSubset.append(name);
        }
        this.internalSubset.append(" \"").append(value).append("\">\n");
    }

    @Override
    public void processingInstruction(String target2, String data2) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (name.startsWith("%")) {
            return;
        }
        this.flushCharacters();
        EntityRef er = this.currentLocator == null ? this.factory.entityRef(name) : this.factory.entityRef(this.currentLocator.getLineNumber(), this.currentLocator.getColumnNumber(), name);
        this.factory.addContent(this.getCurrentElement(), er);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.suppress) {
            return;
        }
        Namespace ns = Namespace.getNamespace(prefix, uri);
        this.declaredNamespaces.add(ns);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element element;
        if (this.suppress) {
            return;
        }
        String prefix = "";
        if (!"".equals(qName)) {
            int colon = qName.indexOf(58);
            if (colon > 0) {
                prefix = qName.substring(0, colon);
            }
            if (localName == null || localName.isEmpty()) {
                localName = qName.substring(colon + 1);
            }
        }
        Namespace namespace = Namespace.getNamespace(prefix, namespaceURI);
        Element element2 = element = this.currentLocator == null ? this.factory.element(localName, namespace) : this.factory.element(this.currentLocator.getLineNumber(), this.currentLocator.getColumnNumber(), localName, namespace);
        if (this.declaredNamespaces.size() > 0) {
            this.transferNamespaces(element);
        }
        this.flushCharacters();
        if (this.atRoot) {
            this.factory.setRoot(this.currentDocument, element);
            this.atRoot = false;
        } else {
            this.factory.addContent(this.getCurrentElement(), element);
        }
        this.currentElement = element;
        int len = atts.getLength();
        for (int i2 = 0; i2 < len; ++i2) {
            boolean specified;
            String attPrefix = "";
            String attLocalName = atts.getLocalName(i2);
            String attQName = atts.getQName(i2);
            boolean bl = specified = !(atts instanceof Attributes2) || ((Attributes2)atts).isSpecified(i2);
            if (!attQName.isEmpty()) {
                if (attQName.startsWith("xmlns:") || attQName.equals("xmlns")) continue;
                int attColon = attQName.indexOf(58);
                if (attColon > 0) {
                    attPrefix = attQName.substring(0, attColon);
                }
                if ("".equals(attLocalName)) {
                    attLocalName = attQName.substring(attColon + 1);
                }
            }
            AttributeType attType = AttributeType.getAttributeType(atts.getType(i2));
            String attValue = atts.getValue(i2);
            String attURI = atts.getURI(i2);
            if ("xmlns".equals(attLocalName) || "xmlns".equals(attPrefix) || "http://www.w3.org/2000/xmlns/".equals(attURI)) continue;
            if (!"".equals(attURI) && attPrefix.isEmpty()) {
                HashMap<String, Namespace> tmpmap = new HashMap<String, Namespace>();
                for (Namespace nss : element.getNamespacesInScope()) {
                    if (nss.getPrefix().length() > 0 && nss.getURI().equals(attURI)) {
                        attPrefix = nss.getPrefix();
                        break;
                    }
                    tmpmap.put(nss.getPrefix(), nss);
                }
                if (attPrefix.isEmpty()) {
                    int cnt = 0;
                    String base = "attns";
                    String pfx = "attns" + cnt;
                    while (tmpmap.containsKey(pfx)) {
                        pfx = "attns" + ++cnt;
                    }
                    attPrefix = pfx;
                }
            }
            Namespace attNs = Namespace.getNamespace(attPrefix, attURI);
            Attribute attribute = this.factory.attribute(attLocalName, attValue, attType, attNs);
            if (!specified) {
                attribute.setSpecified(false);
            }
            this.factory.setAttribute(element, attribute);
        }
    }

    private void transferNamespaces(Element element) {
        for (Namespace ns : this.declaredNamespaces) {
            if (ns == element.getNamespace()) continue;
            element.addNamespaceDeclaration(ns);
        }
        this.declaredNamespaces.clear();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.suppress || length == 0 && !this.inCDATA) {
            return;
        }
        if (this.previousCDATA != this.inCDATA) {
            this.flushCharacters();
        }
        this.textBuffer.append(ch, start, length);
        if (this.currentLocator != null) {
            this.lastline = this.currentLocator.getLineNumber();
            this.lastcol = this.currentLocator.getColumnNumber();
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.ignoringWhite) {
            this.characters(ch, start, length);
        }
    }

    protected void flushCharacters() throws SAXException {
        if (this.ignoringBoundaryWhite) {
            if (!this.textBuffer.isAllWhitespace()) {
                this.flushCharacters(this.textBuffer.toString());
            }
        } else {
            this.flushCharacters(this.textBuffer.toString());
        }
        this.textBuffer.clear();
    }

    private void flushCharacters(String data2) throws SAXException {
        if (data2.length() == 0 && !this.inCDATA) {
            this.previousCDATA = this.inCDATA;
            return;
        }
        if (this.previousCDATA) {
            CDATA cdata = this.currentLocator == null ? this.factory.cdata(data2) : this.factory.cdata(this.lastline, this.lastcol, data2);
            this.factory.addContent(this.getCurrentElement(), cdata);
        } else if (data2.length() != 0) {
            Text text2 = this.currentLocator == null ? this.factory.text(data2) : this.factory.text(this.lastline, this.lastcol, data2);
            this.factory.addContent(this.getCurrentElement(), text2);
        }
        this.previousCDATA = this.inCDATA;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        if (!this.atRoot) {
            Parent p = this.currentElement.getParent();
            if (p instanceof Document) {
                this.atRoot = true;
            } else {
                this.currentElement = (Element)p;
            }
        } else {
            throw new SAXException("Ill-formed XML document (missing opening tag for " + localName + ")");
        }
    }

    @Override
    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        this.flushCharacters();
        DocType doctype = this.currentLocator == null ? this.factory.docType(name, publicID, systemID) : this.factory.docType(this.currentLocator.getLineNumber(), this.currentLocator.getColumnNumber(), name, publicID, systemID);
        this.factory.addContent(this.currentDocument, doctype);
        this.inDTD = true;
        this.inInternalSubset = true;
    }

    @Override
    public void endDTD() {
        this.currentDocument.getDocType().setInternalSubset(this.internalSubset.toString());
        this.inDTD = false;
        this.inInternalSubset = false;
    }

    @Override
    public void startEntity(String name) throws SAXException {
        ++this.entityDepth;
        if (this.expand || this.entityDepth > 1) {
            return;
        }
        if (name.equals("[dtd]")) {
            this.inInternalSubset = false;
            return;
        }
        if (!(this.inDTD || name.equals("amp") || name.equals("lt") || name.equals("gt") || name.equals("apos") || name.equals("quot"))) {
            String pub = null;
            String sys = null;
            String[] ids = this.externalEntities.get(name);
            if (ids != null) {
                pub = ids[0];
                sys = ids[1];
            }
            if (!this.atRoot) {
                this.flushCharacters();
                EntityRef entity = this.currentLocator == null ? this.factory.entityRef(name, pub, sys) : this.factory.entityRef(this.currentLocator.getLineNumber(), this.currentLocator.getColumnNumber(), name, pub, sys);
                this.factory.addContent(this.getCurrentElement(), entity);
            }
            this.suppress = true;
        }
    }

    @Override
    public void endEntity(String name) {
        --this.entityDepth;
        if (this.entityDepth == 0) {
            this.suppress = false;
        }
        if (name.equals("[dtd]")) {
            this.inInternalSubset = true;
        }
    }

    @Override
    public void startCDATA() {
        if (this.suppress) {
            return;
        }
        this.inCDATA = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.suppress) {
            return;
        }
        this.previousCDATA = true;
        this.flushCharacters();
        this.previousCDATA = false;
        this.inCDATA = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void notationDecl(String name, String publicID, String systemID) {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!NOTATION ").append(name);
        this.appendExternalId(publicID, systemID);
        this.internalSubset.append(">\n");
    }

    @Override
    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) {
        if (!this.inInternalSubset) {
            return;
        }
        this.internalSubset.append("  <!ENTITY ").append(name);
        this.appendExternalId(publicID, systemID);
        this.internalSubset.append(" NDATA ").append(notationName);
        this.internalSubset.append(">\n");
    }

    private void appendExternalId(String publicID, String systemID) {
        if (publicID != null) {
            this.internalSubset.append(" PUBLIC \"").append(publicID).append('\"');
        }
        if (systemID != null) {
            if (publicID == null) {
                this.internalSubset.append(" SYSTEM ");
            } else {
                this.internalSubset.append(' ');
            }
            this.internalSubset.append('\"').append(systemID).append('\"');
        }
    }

    public Element getCurrentElement() throws SAXException {
        if (this.currentElement == null) {
            throw new SAXException("Ill-formed XML document (multiple root elements detected)");
        }
        return this.currentElement;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.currentLocator = locator;
    }
}

