/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalDataException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.EscapeStrategy;
import org.jdom.output.Format;
import org.jdom.output.support.XMLOutputProcessor;
import org.jdom.output.support.XmlOutputProcessorImpl;

@Deprecated
public class XMLOutputter
implements Cloneable {
    public static final XMLOutputProcessor DEFAULT_PROCESSOR = new XmlOutputProcessorImpl();
    private Format userFormat;
    private static final Format preserveFormat = Format.getRawFormat();
    protected Format currentFormat;
    private boolean escapeOutput;

    public XMLOutputter() {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
    }

    public XMLOutputter(Format format) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
        this.currentFormat = this.userFormat = format.clone();
    }

    public XMLOutputter(XMLOutputter that) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
        this.currentFormat = this.userFormat = that.userFormat.clone();
    }

    public void setFormat(Format newFormat) {
        this.currentFormat = this.userFormat = newFormat.clone();
    }

    public Format getFormat() {
        return this.userFormat.clone();
    }

    public void output(Document doc, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doc, writer);
    }

    public void output(DocType doctype, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doctype, writer);
    }

    public void output(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(element, writer);
    }

    public void output(List list2, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(list2, writer);
    }

    public void output(CDATA cdata, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(cdata, writer);
    }

    public void output(Text text2, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(text2, writer);
    }

    public void output(Comment comment, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(comment, writer);
    }

    public void output(EntityRef entity, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(entity, writer);
    }

    private Writer makeWriter(OutputStream out) throws UnsupportedEncodingException {
        return XMLOutputter.makeWriter(out, this.userFormat.encoding);
    }

    private static Writer makeWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        if ("UTF-8".equals(enc)) {
            enc = "UTF8";
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), enc));
    }

    public void output(Document doc, Writer out) throws IOException {
        this.printDeclaration(out, this.userFormat.encoding);
        List<Content> content2 = doc.getContent();
        int size = content2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Content obj = content2.get(i2);
            if (obj instanceof Element) {
                this.printElement(out, doc.getRootElement(), 0, XMLOutputter.createNamespaceStack());
            } else if (obj instanceof DocType) {
                this.printDocType(out, doc.getDocType());
                this.writeLineSeparator(out);
            }
            this.newline(out);
            this.indent(out, 0);
        }
        this.writeLineSeparator(out);
        out.flush();
    }

    private void writeLineSeparator(Writer out) throws IOException {
        if (this.currentFormat.lineSeparator != null) {
            out.write(this.currentFormat.lineSeparator);
        }
    }

    public void output(DocType doctype, Writer out) throws IOException {
        this.printDocType(out, doctype);
        out.flush();
    }

    public void output(Element element, Writer out) throws IOException {
        this.printElement(out, element, 0, XMLOutputter.createNamespaceStack());
        out.flush();
    }

    public void outputElementContent(Element element, Writer out) throws IOException {
        List<Content> content2 = element.getContent();
        this.printContentRange(out, content2, 0, content2.size(), 0, XMLOutputter.createNamespaceStack());
        out.flush();
    }

    public void output(List list2, Writer out) throws IOException {
        this.printContentRange(out, list2, 0, list2.size(), 0, XMLOutputter.createNamespaceStack());
        out.flush();
    }

    public void output(CDATA cdata, Writer out) throws IOException {
        this.printCDATA(out, cdata);
        out.flush();
    }

    public void output(Text text2, Writer out) throws IOException {
        this.printText(out, text2);
        out.flush();
    }

    public void output(Comment comment, Writer out) throws IOException {
        XMLOutputter.printComment(out, comment);
        out.flush();
    }

    public void output(ProcessingInstruction pi, Writer out) throws IOException {
    }

    public void output(EntityRef entity, Writer out) throws IOException {
        this.printEntityRef(out, entity);
        out.flush();
    }

    public String outputString(Document doc) {
        StringWriter out = new StringWriter();
        try {
            this.output(doc, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(DocType doctype) {
        StringWriter out = new StringWriter();
        try {
            this.output(doctype, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Element element) {
        StringWriter out = new StringWriter();
        try {
            this.output(element, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(List list2) {
        StringWriter out = new StringWriter();
        try {
            this.output(list2, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(CDATA cdata) {
        StringWriter out = new StringWriter();
        try {
            this.output(cdata, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Text text2) {
        StringWriter out = new StringWriter();
        try {
            this.output(text2, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(EntityRef entity) {
        StringWriter out = new StringWriter();
        try {
            this.output(entity, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    private void printDeclaration(Writer out, String encoding) throws IOException {
        if (!this.userFormat.omitDeclaration) {
            out.write("<?xml version=\"1.0\"");
            if (!this.userFormat.omitEncoding) {
                out.write(" encoding=\"" + encoding + "\"");
            }
            out.write("?>");
            this.writeLineSeparator(out);
        }
    }

    private void printDocType(Writer out, DocType docType) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        out.write("<!DOCTYPE ");
        out.write(docType.getElementName());
        if (publicID != null) {
            out.write(" PUBLIC \"");
            out.write(publicID);
            out.write("\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                out.write(" SYSTEM");
            }
            out.write(" \"");
            out.write(systemID);
            out.write("\"");
        }
        if (internalSubset != null && !internalSubset.isEmpty()) {
            out.write(" [");
            this.writeLineSeparator(out);
            out.write(docType.getInternalSubset());
            out.write("]");
        }
        out.write(">");
    }

    private static void printComment(Writer out, Comment comment) throws IOException {
        out.write("<!--");
        out.write(comment.getText());
        out.write("-->");
    }

    private void printEntityRef(Writer out, EntityRef entity) throws IOException {
        out.write("&");
        out.write(entity.getName());
        out.write(";");
    }

    private void printCDATA(Writer out, CDATA cdata) throws IOException {
        String str = this.currentFormat.mode == Format.TextMode.NORMALIZE ? cdata.getTextNormalize() : (this.currentFormat.mode == Format.TextMode.TRIM ? cdata.getText().trim() : cdata.getText());
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    protected void printText(Writer out, Text text2) throws IOException {
        String str = this.currentFormat.mode == Format.TextMode.NORMALIZE ? text2.getTextNormalize() : (this.currentFormat.mode == Format.TextMode.TRIM ? text2.getText().trim() : text2.getText());
        out.write(this.escapeElementEntities(str));
    }

    private void printString(Writer out, String str) throws IOException {
        if (this.currentFormat.mode == Format.TextMode.NORMALIZE) {
            str = Text.normalizeString(str);
        } else if (this.currentFormat.mode == Format.TextMode.TRIM) {
            str = str.trim();
        }
        out.write(this.escapeElementEntities(str));
    }

    private void printElement(Writer out, Element element, int level, NamespaceStack namespaces) throws IOException {
        int size;
        int start;
        List<Attribute> attributes = element.getAttributes();
        List<Content> content2 = element.getContent();
        String space = null;
        if (attributes != null) {
            space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
        }
        Format previousFormat = this.currentFormat;
        if ("default".equals(space)) {
            this.currentFormat = this.userFormat;
        } else if ("preserve".equals(space)) {
            this.currentFormat = preserveFormat;
        }
        out.write("<");
        XMLOutputter.printQualifiedName(out, element);
        int previouslyDeclaredNamespaces = namespaces.size();
        this.printElementNamespace(out, element, namespaces);
        this.printAdditionalNamespaces(out, element, namespaces);
        if (attributes != null) {
            this.printAttributes(out, attributes, namespaces);
        }
        if ((start = this.skipLeadingWhite(content2, 0)) >= (size = content2.size())) {
            if (this.currentFormat.expandEmptyElements) {
                out.write("></");
                XMLOutputter.printQualifiedName(out, element);
                out.write(">");
            } else {
                out.write(" />");
            }
        } else {
            out.write(">");
            if (XMLOutputter.nextNonText(content2, start) < size) {
                this.newline(out);
                this.printContentRange(out, content2, start, size, level + 1, namespaces);
                this.newline(out);
                this.indent(out, level);
            } else {
                this.printTextRange(out, content2, start, size);
            }
            out.write("</");
            XMLOutputter.printQualifiedName(out, element);
            out.write(">");
        }
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            namespaces.pop();
        }
        this.currentFormat = previousFormat;
    }

    private void printContentRange(Writer out, List content2, int start, int end, int level, NamespaceStack namespaces) throws IOException {
        int index2 = start;
        while (index2 < end) {
            boolean firstNode = index2 == start;
            Object next2 = content2.get(index2);
            if (next2 instanceof Text || next2 instanceof EntityRef) {
                int first2 = this.skipLeadingWhite(content2, index2);
                if (first2 >= (index2 = XMLOutputter.nextNonText(content2, first2))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(out, content2, first2, index2);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            if (next2 instanceof Element) {
                this.printElement(out, (Element)next2, level, namespaces);
            }
            ++index2;
        }
    }

    private void printTextRange(Writer out, List content2, int start, int end) throws IOException {
        int size;
        String previous = null;
        if ((start = this.skipLeadingWhite(content2, start)) < (size = content2.size())) {
            end = this.skipTrailingWhite(content2, end);
            for (int i2 = start; i2 < end; ++i2) {
                String next2;
                Object node2 = content2.get(i2);
                if (node2 instanceof Text) {
                    next2 = ((Text)node2).getText();
                } else if (node2 instanceof EntityRef) {
                    next2 = "&" + ((EntityRef)node2).getValue() + ";";
                } else {
                    throw new IllegalStateException("Should see only CDATA, Text, or EntityRef");
                }
                if (next2 == null || next2.isEmpty()) continue;
                if (previous != null && (this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) && (XMLOutputter.endsWithWhite(previous) || XMLOutputter.startsWithWhite(next2))) {
                    out.write(" ");
                }
                if (node2 instanceof CDATA) {
                    this.printCDATA(out, (CDATA)node2);
                } else if (node2 instanceof EntityRef) {
                    this.printEntityRef(out, (EntityRef)node2);
                } else {
                    this.printString(out, next2);
                }
                previous = next2;
            }
        }
    }

    private void printNamespace(Writer out, Namespace ns, NamespaceStack namespaces) throws IOException {
        String prefix = ns.getPrefix();
        String uri = ns.getURI();
        if (uri.equals(namespaces.getURI(prefix))) {
            return;
        }
        out.write(" xmlns");
        if (!prefix.isEmpty()) {
            out.write(":");
            out.write(prefix);
        }
        out.write("=\"");
        out.write(this.escapeAttributeEntities(uri));
        out.write("\"");
        namespaces.push(ns);
    }

    private void printAttributes(Writer out, List<? extends Attribute> attributes, NamespaceStack namespaces) throws IOException {
        for (int i2 = 0; i2 < attributes.size(); ++i2) {
            Attribute attribute = attributes.get(i2);
            Namespace ns = attribute.getNamespace();
            if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                this.printNamespace(out, ns, namespaces);
            }
            out.write(" ");
            XMLOutputter.printQualifiedName(out, attribute);
            out.write("=");
            out.write("\"");
            out.write(this.escapeAttributeEntities(attribute.getValue()));
            out.write("\"");
        }
    }

    private void printElementNamespace(Writer out, Element element, NamespaceStack namespaces) throws IOException {
        Namespace ns = element.getNamespace();
        if (ns == Namespace.XML_NAMESPACE) {
            return;
        }
        if (ns != Namespace.NO_NAMESPACE || namespaces.getURI("") != null) {
            this.printNamespace(out, ns, namespaces);
        }
    }

    private void printAdditionalNamespaces(Writer out, Element element, NamespaceStack namespaces) throws IOException {
        List<Namespace> list2 = element.getAdditionalNamespaces();
        if (list2 != null) {
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Namespace additional = list2.get(i2);
                this.printNamespace(out, additional, namespaces);
            }
        }
    }

    private void newline(Writer out) throws IOException {
        if (this.currentFormat.indent != null) {
            this.writeLineSeparator(out);
        }
    }

    private void indent(Writer out, int level) throws IOException {
        if (this.currentFormat.indent == null || this.currentFormat.indent.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < level; ++i2) {
            out.write(this.currentFormat.indent);
        }
    }

    private int skipLeadingWhite(List content2, int start) {
        int index2;
        if (start < 0) {
            start = 0;
        }
        int size = content2.size();
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (index2 = start; index2 < size; ++index2) {
                if (XMLOutputter.isAllWhitespace(content2.get(index2))) continue;
                return index2;
            }
        }
        return index2;
    }

    private int skipTrailingWhite(List content2, int start) {
        int index2;
        int size = content2.size();
        if (start > size) {
            start = size;
        }
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (index2 = start; index2 >= 0 && XMLOutputter.isAllWhitespace(content2.get(index2 - 1)); --index2) {
            }
        }
        return index2;
    }

    private static int nextNonText(List content2, int start) {
        if (start < 0) {
            start = 0;
        }
        int size = content2.size();
        for (int index2 = start; index2 < size; ++index2) {
            Object node2 = content2.get(index2);
            if (node2 instanceof Text || node2 instanceof EntityRef) continue;
            return index2;
        }
        return size;
    }

    private static boolean isAllWhitespace(Object obj) {
        String str;
        if (obj instanceof String) {
            str = (String)obj;
        } else if (obj instanceof Text) {
            str = ((Text)obj).getText();
        } else {
            if (obj instanceof EntityRef) {
                return false;
            }
            return false;
        }
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (Verifier.isXMLWhitespace(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean startsWithWhite(String str) {
        return str != null && str.length() > 0 && Verifier.isXMLWhitespace(str.charAt(0));
    }

    private static boolean endsWithWhite(String str) {
        return str != null && str.length() > 0 && Verifier.isXMLWhitespace(str.charAt(str.length() - 1));
    }

    public String escapeAttributeEntities(String str) {
        EscapeStrategy strategy = this.currentFormat.escapeStrategy;
        StringBuilder buffer = null;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String entity;
            int ch = str.charAt(i2);
            int pos = i2++;
            switch (ch) {
                case 60: {
                    entity = "&lt;";
                    break;
                }
                case 62: {
                    entity = "&gt;";
                    break;
                }
                case 34: {
                    entity = "&quot;";
                    break;
                }
                case 38: {
                    entity = "&amp;";
                    break;
                }
                case 13: {
                    entity = "&#xD;";
                    break;
                }
                case 9: {
                    entity = "&#x9;";
                    break;
                }
                case 10: {
                    entity = "&#xA;";
                    break;
                }
                default: {
                    if (strategy.shouldEscape((char)ch)) {
                        if (Verifier.isHighSurrogate((char)ch)) {
                            if (i2 < str.length()) {
                                char low = str.charAt(i2);
                                if (!Verifier.isLowSurrogate(low)) {
                                    throw new IllegalDataException("Could not decode surrogate pair 0x" + Integer.toHexString(ch) + " / 0x" + Integer.toHexString(low));
                                }
                                ch = Verifier.decodeSurrogatePair((char)ch, low);
                            } else {
                                throw new IllegalDataException("Surrogate pair 0x" + Integer.toHexString(ch) + " truncated");
                            }
                        }
                        entity = "&#x" + Integer.toHexString(ch) + ";";
                        break;
                    }
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str, 0, pos);
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append((char)ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public String escapeElementEntities(String str) {
        if (!this.escapeOutput) {
            return str;
        }
        EscapeStrategy strategy = this.currentFormat.escapeStrategy;
        StringBuilder buffer = null;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String entity;
            int ch = str.charAt(i2);
            int pos = i2++;
            switch (ch) {
                case 60: {
                    entity = "&lt;";
                    break;
                }
                case 62: {
                    entity = "&gt;";
                    break;
                }
                case 38: {
                    entity = "&amp;";
                    break;
                }
                case 13: {
                    entity = "&#xD;";
                    break;
                }
                case 10: {
                    entity = this.currentFormat.lineSeparator;
                    break;
                }
                default: {
                    if (strategy.shouldEscape((char)ch)) {
                        if (Verifier.isHighSurrogate((char)ch)) {
                            if (i2 < str.length()) {
                                char low = str.charAt(i2);
                                if (!Verifier.isLowSurrogate(low)) {
                                    throw new IllegalDataException("Could not decode surrogate pair 0x" + Integer.toHexString(ch) + " / 0x" + Integer.toHexString(low));
                                }
                                ch = Verifier.decodeSurrogatePair((char)ch, low);
                            } else {
                                throw new IllegalDataException("Surrogate pair 0x" + Integer.toHexString(ch) + " truncated");
                            }
                        }
                        entity = "&#x" + Integer.toHexString(ch) + ";";
                        break;
                    }
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str, 0, pos);
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append((char)ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.userFormat.lineSeparator != null) {
            block5: for (int i2 = 0; i2 < this.userFormat.lineSeparator.length(); ++i2) {
                char ch = this.userFormat.lineSeparator.charAt(i2);
                switch (ch) {
                    case '\r': {
                        buffer.append("\\r");
                        continue block5;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        continue block5;
                    }
                    case '\t': {
                        buffer.append("\\t");
                        continue block5;
                    }
                    default: {
                        buffer.append("[").append((int)ch).append("]");
                    }
                }
            }
        } else {
            buffer.append("null");
        }
        return "XMLOutputter[omitDeclaration = " + this.userFormat.omitDeclaration + ", encoding = " + this.userFormat.encoding + ", omitEncoding = " + this.userFormat.omitEncoding + ", indent = '" + this.userFormat.indent + "', expandEmptyElements = " + this.userFormat.expandEmptyElements + ", lineSeparator = '" + buffer + "', textMode = " + (Object)((Object)this.userFormat.mode) + "]";
    }

    private static NamespaceStack createNamespaceStack() {
        return new NamespaceStack();
    }

    private static void printQualifiedName(Writer out, Element e) throws IOException {
        if (e.getNamespace().getPrefix().length() == 0) {
            out.write(e.getName());
        } else {
            out.write(e.getNamespace().getPrefix());
            out.write(58);
            out.write(e.getName());
        }
    }

    private static void printQualifiedName(Writer out, Attribute a) throws IOException {
        String prefix = a.getNamespace().getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            out.write(prefix);
            out.write(58);
            out.write(a.getName());
        } else {
            out.write(a.getName());
        }
    }

    protected static final class NamespaceStack
    extends org.jdom.output.NamespaceStack {
        protected NamespaceStack() {
        }
    }
}

