/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.support.AbstractOutputProcessor;
import org.jdom.output.support.DOMOutputProcessor;
import org.jdom.output.support.FormatStack;
import org.jdom.output.support.Walker;
import org.jdom.util.NamespaceStack;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

public abstract class AbstractDOMOutputProcessor
extends AbstractOutputProcessor
implements DOMOutputProcessor {
    private static String getXmlnsTagFor(Namespace ns) {
        String attrName = "xmlns";
        if (!ns.getPrefix().isEmpty()) {
            attrName = attrName + ":";
            attrName = attrName + ns.getPrefix();
        }
        return attrName;
    }

    @Override
    public org.w3c.dom.Document process(org.w3c.dom.Document basedoc, Format format, Document doc) {
        return this.printDocument(new FormatStack(format), new NamespaceStack(), basedoc, doc);
    }

    @Override
    public org.w3c.dom.Element process(org.w3c.dom.Document basedoc, Format format, Element element) {
        return this.printElement(new FormatStack(format), new NamespaceStack(), basedoc, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Node> process(org.w3c.dom.Document basedoc, Format format, List<? extends Content> list2) {
        ArrayList<Node> ret = new ArrayList<Node>(list2.size());
        FormatStack formatStack = new FormatStack(format);
        NamespaceStack namespaceStack = new NamespaceStack();
        for (Content content2 : list2) {
            formatStack.push();
            try {
                Node node2 = this.helperContentDispatcher(formatStack, namespaceStack, basedoc, content2);
                if (node2 == null) continue;
                ret.add(node2);
            }
            finally {
                formatStack.pop();
            }
        }
        return ret;
    }

    @Override
    public CDATASection process(org.w3c.dom.Document document, Format format, CDATA cdata) {
        FormatStack formatStack = new FormatStack(format);
        List<CDATA> list2 = Collections.singletonList(cdata);
        Walker walker = this.buildWalker(formatStack, list2, false);
        if (walker.hasNext()) {
            Content c2 = walker.next();
            if (c2 == null) {
                return AbstractDOMOutputProcessor.printCDATA(document, new CDATA(walker.text()));
            }
            if (c2.getCType() == Content.CType.CDATA) {
                return AbstractDOMOutputProcessor.printCDATA(document, (CDATA)c2);
            }
        }
        return null;
    }

    @Override
    public org.w3c.dom.Text process(org.w3c.dom.Document document, Format format, Text text2) {
        FormatStack formatStack = new FormatStack(format);
        List<Text> list2 = Collections.singletonList(text2);
        Walker walker = this.buildWalker(formatStack, list2, false);
        if (walker.hasNext()) {
            Content c2 = walker.next();
            if (c2 == null) {
                return this.printText(document, new Text(walker.text()));
            }
            if (c2.getCType() == Content.CType.Text) {
                return this.printText(document, (Text)c2);
            }
        }
        return null;
    }

    @Override
    public org.w3c.dom.Comment process(org.w3c.dom.Document document, Format format, Comment comment) {
        return AbstractDOMOutputProcessor.printComment(document, comment);
    }

    @Override
    public org.w3c.dom.ProcessingInstruction process(org.w3c.dom.Document document, Format format, ProcessingInstruction pi) {
        return AbstractDOMOutputProcessor.printProcessingInstruction(document, pi);
    }

    @Override
    public EntityReference process(org.w3c.dom.Document basedoc, Format format, EntityRef entity) {
        return AbstractDOMOutputProcessor.printEntityRef(basedoc, entity);
    }

    @Override
    public Attr process(org.w3c.dom.Document basedoc, Format format, Attribute attribute) {
        return AbstractDOMOutputProcessor.printAttribute(basedoc, attribute);
    }

    protected org.w3c.dom.Document printDocument(FormatStack fstack, NamespaceStack nstack, org.w3c.dom.Document basedoc, Document doc) {
        int sz;
        if (!fstack.isOmitDeclaration()) {
            basedoc.setXmlVersion("1.0");
        }
        if ((sz = doc.getContentSize()) > 0) {
            for (int i2 = 0; i2 < sz; ++i2) {
                Content c2 = doc.getContent(i2);
                Node n = null;
                switch (c2.getCType()) {
                    case Comment: {
                        n = AbstractDOMOutputProcessor.printComment(basedoc, (Comment)c2);
                        break;
                    }
                    case DocType: {
                        break;
                    }
                    case Element: {
                        n = this.printElement(fstack, nstack, basedoc, (Element)c2);
                        break;
                    }
                    case ProcessingInstruction: {
                        n = AbstractDOMOutputProcessor.printProcessingInstruction(basedoc, (ProcessingInstruction)c2);
                        break;
                    }
                }
                if (n == null) continue;
                basedoc.appendChild(n);
            }
        }
        return basedoc;
    }

    private static org.w3c.dom.ProcessingInstruction printProcessingInstruction(org.w3c.dom.Document basedoc, ProcessingInstruction pi) {
        String target2 = pi.getTarget();
        String rawData = pi.getData();
        if (rawData == null || rawData.trim().length() == 0) {
            rawData = "";
        }
        return basedoc.createProcessingInstruction(target2, rawData);
    }

    private static org.w3c.dom.Comment printComment(org.w3c.dom.Document basedoc, Comment comment) {
        return basedoc.createComment(comment.getText());
    }

    private static EntityReference printEntityRef(org.w3c.dom.Document basedoc, EntityRef entity) {
        return basedoc.createEntityReference(entity.getName());
    }

    private static CDATASection printCDATA(org.w3c.dom.Document basedoc, CDATA cdata) {
        return basedoc.createCDATASection(cdata.getText());
    }

    protected org.w3c.dom.Text printText(org.w3c.dom.Document basedoc, Text text2) {
        return basedoc.createTextNode(text2.getText());
    }

    private static Attr printAttribute(org.w3c.dom.Document basedoc, Attribute attribute) {
        Attr attr = basedoc.createAttributeNS(attribute.getNamespaceURI(), attribute.getQualifiedName());
        attr.setValue(attribute.getValue());
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.w3c.dom.Element printElement(FormatStack fstack, NamespaceStack nstack, org.w3c.dom.Document basedoc, Element element) {
        nstack.push(element);
        try {
            List<Content> content2;
            Format.TextMode textmode = fstack.getTextMode();
            String space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
            if ("default".equals(space)) {
                textmode = fstack.getDefaultMode();
            } else if ("preserve".equals(space)) {
                textmode = Format.TextMode.PRESERVE;
            }
            org.w3c.dom.Element ret = basedoc.createElementNS(element.getNamespaceURI(), element.getQualifiedName());
            for (Namespace ns : nstack.addedForward()) {
                if (ns == Namespace.XML_NAMESPACE) continue;
                ret.setAttributeNS("http://www.w3.org/2000/xmlns/", AbstractDOMOutputProcessor.getXmlnsTagFor(ns), ns.getURI());
            }
            if (element.hasAttributes()) {
                for (Attribute att : element.getAttributes()) {
                    Attr a = AbstractDOMOutputProcessor.printAttribute(basedoc, att);
                    ret.setAttributeNodeNS(a);
                }
            }
            if (!(content2 = element.getContent()).isEmpty()) {
                fstack.push();
                try {
                    org.w3c.dom.Text n;
                    fstack.setTextMode(textmode);
                    Walker walker = this.buildWalker(fstack, content2, false);
                    if (!walker.isAllText() && fstack.getPadBetween() != null) {
                        n = basedoc.createTextNode(fstack.getPadBetween());
                        ret.appendChild(n);
                    }
                    this.printContent(fstack, nstack, basedoc, ret, walker);
                    if (!walker.isAllText() && fstack.getPadLast() != null) {
                        n = basedoc.createTextNode(fstack.getPadLast());
                        ret.appendChild(n);
                    }
                }
                finally {
                    fstack.pop();
                }
            }
            org.w3c.dom.Element element2 = ret;
            return element2;
        }
        finally {
            nstack.pop();
        }
    }

    private void printContent(FormatStack fstack, NamespaceStack nstack, org.w3c.dom.Document basedoc, Node target2, Walker walker) {
        while (walker.hasNext()) {
            Node n;
            Content c2 = walker.next();
            if (c2 == null) {
                String text2 = walker.text();
                n = walker.isCDATA() ? AbstractDOMOutputProcessor.printCDATA(basedoc, new CDATA(text2)) : this.printText(basedoc, new Text(text2));
            } else {
                n = this.helperContentDispatcher(fstack, nstack, basedoc, c2);
            }
            if (n == null) continue;
            target2.appendChild(n);
        }
    }

    private Node helperContentDispatcher(FormatStack fstack, NamespaceStack nstack, org.w3c.dom.Document basedoc, Content content2) {
        switch (content2.getCType()) {
            case CDATA: {
                return AbstractDOMOutputProcessor.printCDATA(basedoc, (CDATA)content2);
            }
            case Comment: {
                return AbstractDOMOutputProcessor.printComment(basedoc, (Comment)content2);
            }
            case Element: {
                return this.printElement(fstack, nstack, basedoc, (Element)content2);
            }
            case EntityRef: {
                return AbstractDOMOutputProcessor.printEntityRef(basedoc, (EntityRef)content2);
            }
            case ProcessingInstruction: {
                return AbstractDOMOutputProcessor.printProcessingInstruction(basedoc, (ProcessingInstruction)content2);
            }
            case Text: {
                return this.printText(basedoc, (Text)content2);
            }
            case DocType: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected Content " + (Object)((Object)content2.getCType()));
    }
}

