/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.xpath.jaxen;

import java.util.HashMap;
import java.util.List;
import org.jaxen.NamespaceContext;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.xpath.jaxen.JDOMCoreNavigator;
import org.jdom.xpath.jaxen.NamespaceContainer;

final class JDOMNavigator
extends JDOMCoreNavigator
implements NamespaceContext {
    private static final long serialVersionUID = 200L;
    private final HashMap<String, String> nsFromContext = new HashMap();
    private final HashMap<String, String> nsFromUser = new HashMap();

    JDOMNavigator() {
    }

    @Override
    void reset() {
        super.reset();
        this.nsFromContext.clear();
    }

    void setContext(Object node2) {
        this.nsFromContext.clear();
        List<Namespace> nsl = null;
        if (node2 instanceof Element) {
            nsl = ((Element)node2).getNamespacesInScope();
        } else if (node2 instanceof NamespaceContainer) {
            nsl = ((NamespaceContainer)node2).getParentElement().getNamespacesInScope();
        }
        if (nsl != null) {
            for (Namespace ns : nsl) {
                this.nsFromContext.put(ns.getPrefix(), ns.getURI());
            }
        }
    }

    void includeNamespace(Namespace namespace) {
        this.nsFromUser.put(namespace.getPrefix(), namespace.getURI());
    }

    @Override
    public String translateNamespacePrefixToUri(String prefix) {
        if (prefix == null) {
            return null;
        }
        String uri = this.nsFromUser.get(prefix);
        if (uri != null) {
            return uri;
        }
        return this.nsFromContext.get(prefix);
    }
}

