/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.xxh3;

import java.nio.ByteOrder;
import org.jetbrains.xxh3.Access;

final class CharSequenceAccess {
    static final Access<CharSequence> INSTANCE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? LittleEndianCharSequenceAccess.INSTANCE : BigEndianCharSequenceAccess.INSTANCE;

    CharSequenceAccess() {
    }

    private static final class LittleEndianCharSequenceAccess
    extends BaseCharSequenceAccess {
        static final BaseCharSequenceAccess INSTANCE = new LittleEndianCharSequenceAccess();

        private LittleEndianCharSequenceAccess() {
        }

        @Override
        public long i64(CharSequence input, int offset2) {
            return LittleEndianCharSequenceAccess.getLong(input, offset2, 0, 1, 2, 3, 4, 0);
        }

        @Override
        public long u32(CharSequence input, int offset2) {
            return LittleEndianCharSequenceAccess.getUnsignedInt(input, offset2, 0, 1, 2, 0);
        }

        @Override
        public int i8(CharSequence input, int offset2) {
            return LittleEndianCharSequenceAccess.getByte(input, offset2, (offset2 & 1) << 3);
        }
    }

    private static abstract class BaseCharSequenceAccess
    extends Access<CharSequence> {
        private static int ix(long offset2) {
            return (int)(offset2 >> 1);
        }

        protected static long getLong(CharSequence input, long offset2, int char0Off, int char1Off, int char2Off, int char3Off, int char4Off, int delta) {
            int base = BaseCharSequenceAccess.ix(offset2);
            if (0 == ((int)offset2 & 1)) {
                long char0 = input.charAt(base + char0Off);
                long char1 = input.charAt(base + char1Off);
                long char2 = input.charAt(base + char2Off);
                long char3 = input.charAt(base + char3Off);
                return char0 | char1 << 16 | char2 << 32 | char3 << 48;
            }
            long char0 = input.charAt(base + char0Off + delta) >>> 8;
            long char1 = input.charAt(base + char1Off + delta);
            long char2 = input.charAt(base + char2Off + delta);
            long char3 = input.charAt(base + char3Off + delta);
            long char4 = input.charAt(base + char4Off);
            return char0 | char1 << 8 | char2 << 24 | char3 << 40 | char4 << 56;
        }

        protected static long getUnsignedInt(CharSequence input, int offset2, int char0Off, int char1Off, int char2Off, int delta) {
            int base = BaseCharSequenceAccess.ix(offset2);
            if (0 == (offset2 & 1)) {
                long char0 = input.charAt(base + char0Off);
                long char1 = input.charAt(base + char1Off);
                return char0 | char1 << 16;
            }
            long char0 = input.charAt(base + char0Off + delta) >>> 8;
            long char1 = input.charAt(base + char1Off + delta);
            long char2 = input.charAt(base + char2Off) & 0xFF;
            return char0 | char1 << 8 | char2 << 24;
        }

        protected static int getByte(CharSequence input, int offset2, int shift) {
            return input.charAt(BaseCharSequenceAccess.ix(offset2)) >> shift;
        }

        private BaseCharSequenceAccess() {
        }

        @Override
        public int i32(CharSequence input, int offset2) {
            return (int)this.u32(input, offset2);
        }
    }

    private static final class BigEndianCharSequenceAccess
    extends BaseCharSequenceAccess {
        static final BaseCharSequenceAccess INSTANCE = new BigEndianCharSequenceAccess();

        private BigEndianCharSequenceAccess() {
        }

        @Override
        public long i64(CharSequence input, int offset2) {
            return BigEndianCharSequenceAccess.getLong(input, offset2, 3, 2, 1, 0, 0, 1);
        }

        @Override
        public long u32(CharSequence input, int offset2) {
            return BigEndianCharSequenceAccess.getUnsignedInt(input, offset2, 1, 0, 0, 1);
        }

        @Override
        public int i8(CharSequence input, int offset2) {
            return BigEndianCharSequenceAccess.getByte(input, offset2, (offset2 & 1 ^ 1) << 3);
        }
    }
}

