/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.gradle;

import app.cash.sqldelight.core.SqlDelightCompilationUnit;
import app.cash.sqldelight.core.SqlDelightDatabaseProperties;
import app.cash.sqldelight.core.SqlDelightEnvironment;
import app.cash.sqldelight.core.SqlDelightSourceFolder;
import app.cash.sqldelight.core.lang.MigrationFile;
import app.cash.sqldelight.core.lang.SqlDelightQueriesFile;
import app.cash.sqldelight.core.lang.util.TreeUtilKt;
import app.cash.sqldelight.dialect.api.SqlDelightDialect;
import app.cash.sqldelight.gradle.DriverInitializer;
import app.cash.sqldelight.gradle.SqlDelightCompilationUnitImpl;
import app.cash.sqldelight.gradle.SqlDelightDatabasePropertiesImpl;
import app.cash.sqldelight.gradle.SqlDelightWorkerTask;
import app.cash.sqldelight.gradle.VerifyMigrationTaskKt;
import app.cash.sqlite.migrations.CatalogDatabase;
import app.cash.sqlite.migrations.DatabaseDiff;
import app.cash.sqlite.migrations.FindDatabaseFilesKt;
import app.cash.sqlite.migrations.ObjectDifferDatabaseComparator;
import com.alecstrong.sql.psi.core.SqlFileBase;
import com.alecstrong.sql.psi.core.psi.SqlStmt;
import com.alecstrong.sql.psi.core.psi.SqlStmtList;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002()B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0002\b$J\b\u0010\u0019\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020'H\u0017R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000e8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u00148gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\bR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lapp/cash/sqldelight/gradle/VerifyMigrationTask;", "Lapp/cash/sqldelight/gradle/SqlDelightWorkerTask;", "<init>", "()V", "projectName", "Lorg/gradle/api/provider/Property;", "", "getProjectName", "()Lorg/gradle/api/provider/Property;", "workingDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getWorkingDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "properties", "Lapp/cash/sqldelight/gradle/SqlDelightDatabasePropertiesImpl;", "getProperties", "()Lapp/cash/sqldelight/gradle/SqlDelightDatabasePropertiesImpl;", "setProperties", "(Lapp/cash/sqldelight/gradle/SqlDelightDatabasePropertiesImpl;)V", "compilationUnit", "Lapp/cash/sqldelight/gradle/SqlDelightCompilationUnitImpl;", "getCompilationUnit", "()Lapp/cash/sqldelight/gradle/SqlDelightCompilationUnitImpl;", "setCompilationUnit", "(Lapp/cash/sqldelight/gradle/SqlDelightCompilationUnitImpl;)V", "verifyMigrations", "", "getVerifyMigrations", "verifyDefinitions", "getVerifyDefinitions", "driverProperties", "Lorg/gradle/api/provider/MapProperty;", "getDriverProperties", "()Lorg/gradle/api/provider/MapProperty;", "getDummyOutputFile", "Ljava/io/File;", "getDummyOutputFile$sqldelight_gradle_plugin", "", "getSource", "Lorg/gradle/api/file/FileTree;", "VerifyMigrationWorkParameters", "VerifyMigrationAction", "sqldelight-gradle-plugin"})
public abstract class VerifyMigrationTask
extends SqlDelightWorkerTask {
    @Input
    @NotNull
    public abstract Property<String> getProjectName();

    @Internal
    @NotNull
    public abstract DirectoryProperty getWorkingDirectory();

    @Nested
    @NotNull
    public abstract SqlDelightDatabasePropertiesImpl getProperties();

    public abstract void setProperties(@NotNull SqlDelightDatabasePropertiesImpl var1);

    @Nested
    @NotNull
    public abstract SqlDelightCompilationUnitImpl getCompilationUnit();

    public abstract void setCompilationUnit(@NotNull SqlDelightCompilationUnitImpl var1);

    @Input
    @NotNull
    public abstract Property<Boolean> getVerifyMigrations();

    @Input
    @NotNull
    public abstract Property<Boolean> getVerifyDefinitions();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDriverProperties();

    @OutputFile
    @NotNull
    public final File getDummyOutputFile$sqldelight_gradle_plugin() {
        return new File(this.getTemporaryDir(), "success.txt");
    }

    @TaskAction
    public final void verifyMigrations() {
        WorkQueue workQueue = this.workQueue$sqldelight_gradle_plugin();
        workQueue.submit(VerifyMigrationAction.class, arg_0 -> VerifyMigrationTask.verifyMigrations$lambda$1(arg_0 -> VerifyMigrationTask.verifyMigrations$lambda$0(this, arg_0), arg_0));
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public FileTree getSource() {
        FileTree fileTree = super.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSource(...)");
        return fileTree;
    }

    private static final Unit verifyMigrations$lambda$0(VerifyMigrationTask this$0, VerifyMigrationWorkParameters it) {
        it.getWorkingDirectory().set((Provider)this$0.getWorkingDirectory());
        it.getProjectName().set((Provider)this$0.getProjectName());
        it.getProperties().set((Object)this$0.getProperties());
        it.getVerifyMigrations().set((Provider)this$0.getVerifyMigrations());
        it.getCompilationUnit().set((Object)this$0.getCompilationUnit());
        it.getVerifyDefinitions().set((Provider)this$0.getVerifyDefinitions());
        it.getDriverProperties().set((Provider)this$0.getDriverProperties());
        it.getOutputFile().set(this$0.getDummyOutputFile$sqldelight_gradle_plugin());
        return Unit.INSTANCE;
    }

    private static final void verifyMigrations$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0002R\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lapp/cash/sqldelight/gradle/VerifyMigrationTask$VerifyMigrationAction;", "Lorg/gradle/workers/WorkAction;", "Lapp/cash/sqldelight/gradle/VerifyMigrationTask$VerifyMigrationWorkParameters;", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "Lorg/gradle/api/logging/Logger;", "sourceFolders", "", "Ljava/io/File;", "getSourceFolders", "()Ljava/util/List;", "environment", "Lapp/cash/sqldelight/core/SqlDelightEnvironment;", "getEnvironment", "()Lapp/cash/sqldelight/core/SqlDelightEnvironment;", "environment$delegate", "Lkotlin/Lazy;", "execute", "", "createCurrentDb", "Lapp/cash/sqlite/migrations/CatalogDatabase;", "checkMigration", "dbFile", "currentDb", "createActualDb", "checkForGaps", "sqldelight-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nVerifyMigrationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifyMigrationTask.kt\napp/cash/sqldelight/gradle/VerifyMigrationTask$VerifyMigrationAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,223:1\n1557#2:224\n1628#2,3:225\n774#2:231\n865#2,2:232\n1863#2,2:236\n1317#3,2:228\n1#4:230\n1088#5,2:234\n*S KotlinDebug\n*F\n+ 1 VerifyMigrationTask.kt\napp/cash/sqldelight/gradle/VerifyMigrationTask$VerifyMigrationAction\n*L\n99#1:224\n99#1:225,3\n103#1:231\n103#1:232,2\n181#1:236,2\n129#1:228,2\n177#1:234,2\n*E\n"})
    public static abstract class VerifyMigrationAction
    implements WorkAction<VerifyMigrationWorkParameters> {
        private final Logger logger = Logging.getLogger(VerifyMigrationTask.class);
        @NotNull
        private final Lazy environment$delegate = LazyKt.lazy(() -> VerifyMigrationAction.environment_delegate$lambda$2(this));

        /*
         * WARNING - void declaration
         */
        private final List<File> getSourceFolders() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((SqlDelightCompilationUnit)((VerifyMigrationWorkParameters)this.getParameters()).getCompilationUnit().get()).getSourceFolders();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SqlDelightSourceFolder sqlDelightSourceFolder = (SqlDelightSourceFolder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFolder());
            }
            return (List)destination$iv$iv;
        }

        private final SqlDelightEnvironment getEnvironment() {
            Lazy lazy = this.environment$delegate;
            return (SqlDelightEnvironment)((Object)lazy.getValue());
        }

        public void execute() {
            ServiceLoader<DriverInitializer> serviceLoader = ServiceLoader.load(DriverInitializer.class);
            Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
            DriverInitializer driverInitializer = (DriverInitializer)CollectionsKt.firstOrNull((Iterable)serviceLoader);
            if (driverInitializer != null) {
                Object object = ((VerifyMigrationWorkParameters)this.getParameters()).getProperties().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                driverInitializer.execute((SqlDelightDatabaseProperties)object, VerifyMigrationTaskKt.toProperties(((VerifyMigrationWorkParameters)this.getParameters()).getDriverProperties()));
            }
            if (!this.getEnvironment().getDialect().isSqlite()) {
                return;
            }
            File file = ((Directory)((VerifyMigrationWorkParameters)this.getParameters()).getWorkingDirectory().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            FilesKt.deleteRecursively((File)file);
            CatalogDatabase catalog = this.createCurrentDb();
            Sequence databaseFiles = FindDatabaseFilesKt.findDatabaseFiles((Sequence)CollectionsKt.asSequence((Iterable)this.getSourceFolders()));
            if (!((Boolean)((VerifyMigrationWorkParameters)this.getParameters()).getVerifyMigrations().get() == false || SequencesKt.count((Sequence)databaseFiles) > 0)) {
                boolean $i$a$-check-VerifyMigrationTask$VerifyMigrationAction$execute$22 = false;
                String $i$a$-check-VerifyMigrationTask$VerifyMigrationAction$execute$22 = "Verifying a migration requires a database file to be present. To generate one, use the generate schema Gradle task for your database. A quick way to find the task name(s) is to run `gradle :module:tasks | grep generate`.";
                throw new IllegalStateException($i$a$-check-VerifyMigrationTask$VerifyMigrationAction$execute$22.toString());
            }
            Sequence $this$forEach$iv = databaseFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File dbFile = (File)element$iv;
                boolean bl = false;
                this.checkMigration(dbFile, catalog);
            }
            this.checkForGaps();
            ((RegularFile)((VerifyMigrationWorkParameters)this.getParameters()).getOutputFile().get()).getAsFile().createNewFile();
        }

        private final CatalogDatabase createCurrentDb() {
            ArrayList sourceFiles = new ArrayList();
            this.getEnvironment().forSqlFileBases((Function1<? super SqlFileBase, Unit>)((Function1)arg_0 -> VerifyMigrationAction.createCurrentDb$lambda$5(sourceFiles, arg_0)));
            ArrayList initStatements = new ArrayList();
            TreeUtilKt.forInitializationStatements((Collection)sourceFiles, (boolean)this.getEnvironment().getDialect().getAllowsReferenceCycles(), arg_0 -> VerifyMigrationAction.createCurrentDb$lambda$6(initStatements, arg_0));
            return CatalogDatabase.Companion.withInitStatements((List)initStatements);
        }

        private final void checkMigration(File dbFile, CatalogDatabase currentDb) {
            CatalogDatabase actualCatalog = this.createActualDb(dbFile);
            ObjectDifferDatabaseComparator databaseComparator = new ObjectDifferDatabaseComparator((Boolean)((VerifyMigrationWorkParameters)this.getParameters()).getVerifyDefinitions().get() == false, arg_0 -> VerifyMigrationAction.checkMigration$lambda$7(this, arg_0));
            DatabaseDiff diff = databaseComparator.compare(currentDb, actualCatalog);
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            Appendable p0 = stringBuilder;
            boolean bl2 = false;
            boolean $i$f$checkMigration$lambda$8$stub_for_inlining = false;
            diff.printTo(p0);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String diffReport = string;
            if (!(((CharSequence)diffReport).length() == 0)) {
                boolean bl3 = false;
                String string2 = "Error migrating from " + dbFile.getName() + ", fresh database looks different from migration database:\n" + diffReport;
                throw new IllegalStateException(string2.toString());
            }
        }

        private final CatalogDatabase createActualDb(File dbFile) {
            CatalogDatabase catalogDatabase;
            int version = Integer.parseInt(FilesKt.getNameWithoutExtension((File)dbFile));
            File copy = FilesKt.copyTo$default((File)dbFile, (File)new File(((Directory)((VerifyMigrationWorkParameters)this.getParameters()).getWorkingDirectory().get()).getAsFile(), dbFile.getName()), (boolean)false, (int)0, (int)6, null);
            ArrayList initStatements = new ArrayList();
            this.getEnvironment().forMigrationFiles((Function1<? super MigrationFile, Unit>)((Function1)arg_0 -> VerifyMigrationAction.createActualDb$lambda$13(version, initStatements, arg_0)));
            String string = copy.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            CatalogDatabase it = catalogDatabase = CatalogDatabase.Companion.fromFile(string, (List)initStatements);
            boolean bl = false;
            copy.delete();
            return catalogDatabase;
        }

        private final void checkForGaps() {
            Ref.ObjectRef lastMigrationVersion = new Ref.ObjectRef();
            this.getEnvironment().forMigrationFiles((Function1<? super MigrationFile, Unit>)((Function1)arg_0 -> VerifyMigrationAction.checkForGaps$lambda$16(lastMigrationVersion, arg_0)));
        }

        /*
         * WARNING - void declaration
         */
        private static final SqlDelightEnvironment environment_delegate$lambda$2(VerifyMigrationAction this$0) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this$0.getSourceFolders();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            List list2 = CollectionsKt.emptyList();
            Object object = ((VerifyMigrationWorkParameters)this$0.getParameters()).getProjectName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String string = (String)object;
            Object object2 = ((VerifyMigrationWorkParameters)this$0.getParameters()).getProperties().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            iterable = (SqlDelightDatabaseProperties)object2;
            Object object3 = ((VerifyMigrationWorkParameters)this$0.getParameters()).getVerifyMigrations().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            boolean bl = (Boolean)object3;
            Object object4 = ((VerifyMigrationWorkParameters)this$0.getParameters()).getCompilationUnit().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            SqlDelightCompilationUnit sqlDelightCompilationUnit = (SqlDelightCompilationUnit)object4;
            ServiceLoader<SqlDelightDialect> serviceLoader = ServiceLoader.load(SqlDelightDialect.class);
            Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
            Object object5 = CollectionsKt.first((Iterable)serviceLoader);
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"first(...)");
            SqlDelightDialect sqlDelightDialect = (SqlDelightDialect)object5;
            return new SqlDelightEnvironment((SqlDelightDatabaseProperties)iterable, sqlDelightCompilationUnit, bl, sqlDelightDialect, string, list, list2);
        }

        private static final Unit createCurrentDb$lambda$5(ArrayList $sourceFiles, SqlFileBase file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (file instanceof SqlDelightQueriesFile) {
                $sourceFiles.add(file);
            }
            return Unit.INSTANCE;
        }

        private static final Unit createCurrentDb$lambda$6(ArrayList $initStatements, String sqlText) {
            Intrinsics.checkNotNullParameter((Object)sqlText, (String)"sqlText");
            $initStatements.add(new CatalogDatabase.InitStatement(sqlText, "Error compiling " + sqlText));
            return Unit.INSTANCE;
        }

        private static final Unit checkMigration$lambda$7(VerifyMigrationAction this$0, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.logger.debug(it);
            return Unit.INSTANCE;
        }

        private static final Unit createActualDb$lambda$13(int $version, ArrayList $initStatements, MigrationFile file) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                CharSequence $this$any$iv = string;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    boolean bl3 = '0' <= it ? it < ':' : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) {
                boolean $i$a$-check-VerifyMigrationTask$VerifyMigrationAction$createActualDb$1$32 = false;
                String $i$a$-check-VerifyMigrationTask$VerifyMigrationAction$createActualDb$1$32 = "Migration files must have an integer value somewhere in their filename but " + file.getName() + " does not.";
                throw new IllegalStateException($i$a$-check-VerifyMigrationTask$VerifyMigrationAction$createActualDb$1$32.toString());
            }
            if ((long)$version > file.getVersion()) {
                return Unit.INSTANCE;
            }
            SqlStmtList sqlStmtList = file.getSqlStmtList();
            Intrinsics.checkNotNull((Object)sqlStmtList);
            List list = sqlStmtList.getStmtList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStmtList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlStmt it = (SqlStmt)element$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it);
                $initStatements.add(new CatalogDatabase.InitStatement(TreeUtilKt.rawSqlText$default((PsiElement)((PsiElement)it), null, (int)1, null), "Error compiling " + file.getName()));
            }
            return Unit.INSTANCE;
        }

        private static final Unit checkForGaps$lambda$16(Ref.ObjectRef $lastMigrationVersion, MigrationFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            long actual = it.getVersion();
            Long l = (Long)$lastMigrationVersion.element;
            long expected = l != null ? l + 1L : actual;
            if (!(actual == expected)) {
                boolean bl = false;
                String string = "Gap in migrations detected. Expected migration " + expected + ", got " + actual + ".";
                throw new IllegalStateException(string.toString());
            }
            $lastMigrationVersion.element = actual;
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u001e\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lapp/cash/sqldelight/gradle/VerifyMigrationTask$VerifyMigrationWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "workingDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getWorkingDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "projectName", "Lorg/gradle/api/provider/Property;", "", "getProjectName", "()Lorg/gradle/api/provider/Property;", "properties", "Lapp/cash/sqldelight/core/SqlDelightDatabaseProperties;", "getProperties", "compilationUnit", "Lapp/cash/sqldelight/core/SqlDelightCompilationUnit;", "getCompilationUnit", "verifyMigrations", "", "getVerifyMigrations", "verifyDefinitions", "getVerifyDefinitions", "driverProperties", "Lorg/gradle/api/provider/MapProperty;", "getDriverProperties", "()Lorg/gradle/api/provider/MapProperty;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "sqldelight-gradle-plugin"})
    public static interface VerifyMigrationWorkParameters
    extends WorkParameters {
        @NotNull
        public DirectoryProperty getWorkingDirectory();

        @NotNull
        public Property<String> getProjectName();

        @NotNull
        public Property<SqlDelightDatabaseProperties> getProperties();

        @NotNull
        public Property<SqlDelightCompilationUnit> getCompilationUnit();

        @NotNull
        public Property<Boolean> getVerifyMigrations();

        @NotNull
        public Property<Boolean> getVerifyDefinitions();

        @NotNull
        public MapProperty<String, String> getDriverProperties();

        @NotNull
        public RegularFileProperty getOutputFile();
    }
}

