/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.gradle.android;

import app.cash.sqldelight.VersionKt;
import com.android.build.gradle.BaseExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0004"}, d2={"packageName", "", "Lorg/gradle/api/Project;", "sqliteVersion", "sqldelight-gradle-plugin"})
public final class PackageNameKt {
    @NotNull
    public static final String packageName(@NotNull Project $this$packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$packageName, (String)"<this>");
        BaseExtension androidExtension = (BaseExtension)$this$packageName.getExtensions().getByType(BaseExtension.class);
        String string = androidExtension.getNamespace();
        if (string == null) {
            throw new GradleException("SqlDelight requires a package name to be set. This can be done via the android namespace:\n\nandroid {\n  namespace \"com.example.mypackage\"\n}\n\nor the sqldelight configuration:\n\nsqldelight {\n  MyDatabase {\n    packageName = \"com.example.mypackage\"\n  }\n}");
        }
        return string;
    }

    @Nullable
    public static final String sqliteVersion(@NotNull Project $this$sqliteVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$sqliteVersion, (String)"<this>");
        BaseExtension androidExtension = (BaseExtension)$this$sqliteVersion.getExtensions().getByType(BaseExtension.class);
        Integer n = androidExtension.getDefaultConfig().getMinSdk();
        if (n == null) {
            return null;
        }
        int minSdk = n;
        if (minSdk >= 34) {
            return "app.cash.sqldelight:sqlite-3-38-dialect:" + VersionKt.getVERSION();
        }
        if (minSdk >= 31) {
            return "app.cash.sqldelight:sqlite-3-30-dialect:" + VersionKt.getVERSION();
        }
        if (minSdk >= 30) {
            return "app.cash.sqldelight:sqlite-3-25-dialect:" + VersionKt.getVERSION();
        }
        return "app.cash.sqldelight:sqlite-3-18-dialect:" + VersionKt.getVERSION();
    }
}

