/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.gradle.squash;

import app.cash.sqldelight.core.SqlDelightCompilationUnit;
import app.cash.sqldelight.core.SqlDelightDatabaseProperties;
import app.cash.sqldelight.core.SqlDelightEnvironment;
import app.cash.sqldelight.core.SqlDelightSourceFolder;
import app.cash.sqldelight.core.lang.MigrationFile;
import app.cash.sqldelight.core.lang.MigrationLanguage;
import app.cash.sqldelight.core.psi.SqlDelightImportStmt;
import app.cash.sqldelight.core.psi.SqlDelightImportStmtList;
import app.cash.sqldelight.dialect.api.MigrationSquasher;
import app.cash.sqldelight.dialect.api.SqlDelightDialect;
import app.cash.sqldelight.gradle.SqlDelightCompilationUnitImpl;
import app.cash.sqldelight.gradle.SqlDelightDatabasePropertiesImpl;
import app.cash.sqldelight.gradle.SqlDelightWorkerTask;
import app.cash.sqldelight.gradle.squash.AnsiSqlMigrationSquasher;
import com.alecstrong.sql.psi.core.SqlFileBase;
import com.alecstrong.sql.psi.core.psi.SqlStmt;
import com.alecstrong.sql.psi.core.psi.SqlStmtList;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0017R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\n8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u00108gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lapp/cash/sqldelight/gradle/squash/MigrationSquashTask;", "Lapp/cash/sqldelight/gradle/SqlDelightWorkerTask;", "<init>", "()V", "projectName", "Lorg/gradle/api/provider/Property;", "", "getProjectName", "()Lorg/gradle/api/provider/Property;", "properties", "Lapp/cash/sqldelight/gradle/SqlDelightDatabasePropertiesImpl;", "getProperties", "()Lapp/cash/sqldelight/gradle/SqlDelightDatabasePropertiesImpl;", "setProperties", "(Lapp/cash/sqldelight/gradle/SqlDelightDatabasePropertiesImpl;)V", "compilationUnit", "Lapp/cash/sqldelight/gradle/SqlDelightCompilationUnitImpl;", "getCompilationUnit", "()Lapp/cash/sqldelight/gradle/SqlDelightCompilationUnitImpl;", "setCompilationUnit", "(Lapp/cash/sqldelight/gradle/SqlDelightCompilationUnitImpl;)V", "generateSquashedMigrationFile", "", "getSource", "Lorg/gradle/api/file/FileTree;", "GenerateSchemaWorkParameters", "GenerateMigration", "sqldelight-gradle-plugin"})
public abstract class MigrationSquashTask
extends SqlDelightWorkerTask {
    @Input
    @NotNull
    public abstract Property<String> getProjectName();

    @Nested
    @NotNull
    public abstract SqlDelightDatabasePropertiesImpl getProperties();

    public abstract void setProperties(@NotNull SqlDelightDatabasePropertiesImpl var1);

    @Nested
    @NotNull
    public abstract SqlDelightCompilationUnitImpl getCompilationUnit();

    public abstract void setCompilationUnit(@NotNull SqlDelightCompilationUnitImpl var1);

    @TaskAction
    public final void generateSquashedMigrationFile() {
        this.workQueue$sqldelight_gradle_plugin().submit(GenerateMigration.class, arg_0 -> MigrationSquashTask.generateSquashedMigrationFile$lambda$1(arg_0 -> MigrationSquashTask.generateSquashedMigrationFile$lambda$0(this, arg_0), arg_0));
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public FileTree getSource() {
        FileTree fileTree = super.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSource(...)");
        return fileTree;
    }

    private static final Unit generateSquashedMigrationFile$lambda$0(MigrationSquashTask this$0, GenerateSchemaWorkParameters it) {
        it.getModuleName().set((Provider)this$0.getProjectName());
        it.getProperties().set((Object)this$0.getProperties());
        it.getCompilationUnit().set((Object)this$0.getCompilationUnit());
        return Unit.INSTANCE;
    }

    private static final void generateSquashedMigrationFile$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lapp/cash/sqldelight/gradle/squash/MigrationSquashTask$GenerateMigration;", "Lorg/gradle/workers/WorkAction;", "Lapp/cash/sqldelight/gradle/squash/MigrationSquashTask$GenerateSchemaWorkParameters;", "<init>", "()V", "sourceFolders", "", "Ljava/io/File;", "getSourceFolders", "()Ljava/util/List;", "execute", "", "sqldelight-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nMigrationSquashTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationSquashTask.kt\napp/cash/sqldelight/gradle/squash/MigrationSquashTask$GenerateMigration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,121:1\n1557#2:122\n1628#2,3:123\n774#2:126\n865#2,2:127\n1863#2,2:140\n1863#2,2:142\n4135#3,11:129\n*S KotlinDebug\n*F\n+ 1 MigrationSquashTask.kt\napp/cash/sqldelight/gradle/squash/MigrationSquashTask$GenerateMigration\n*L\n62#1:122\n62#1:123,3\n67#1:126\n67#1:127,2\n99#1:140,2\n103#1:142,2\n98#1:129,11\n*E\n"})
    public static abstract class GenerateMigration
    implements WorkAction<GenerateSchemaWorkParameters> {
        /*
         * WARNING - void declaration
         */
        private final List<File> getSourceFolders() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((SqlDelightCompilationUnit)((GenerateSchemaWorkParameters)this.getParameters()).getCompilationUnit().get()).getSourceFolders();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SqlDelightSourceFolder sqlDelightSourceFolder = (SqlDelightSourceFolder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFolder());
            }
            return (List)destination$iv$iv;
        }

        public void execute() {
            File file;
            SqlDelightDatabaseProperties $this$filterTo$iv$iv;
            SqlDelightDatabaseProperties properties = (SqlDelightDatabaseProperties)((GenerateSchemaWorkParameters)this.getParameters()).getProperties().get();
            Iterable $this$filter$iv = this.getSourceFolders();
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            $this$filter$iv = CollectionsKt.emptyList();
            Object object = ((GenerateSchemaWorkParameters)this.getParameters()).getModuleName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String $i$f$filter22 = (String)object;
            Intrinsics.checkNotNull((Object)properties);
            $this$filterTo$iv$iv = properties;
            Object object2 = ((GenerateSchemaWorkParameters)this.getParameters()).getCompilationUnit().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            destination$iv$iv = (SqlDelightCompilationUnit)object2;
            ServiceLoader<SqlDelightDialect> serviceLoader = ServiceLoader.load(SqlDelightDialect.class);
            Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
            Object object3 = CollectionsKt.first((Iterable)serviceLoader);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"first(...)");
            SqlDelightDialect $i$f$filterTo22 = (SqlDelightDialect)object3;
            SqlDelightEnvironment environment = new SqlDelightEnvironment($this$filterTo$iv$iv, (SqlDelightCompilationUnit)destination$iv$iv, false, $i$f$filterTo22, $i$f$filter22, list, (List<? extends File>)$this$filter$iv);
            Function1 fileFromText = arg_0 -> GenerateMigration.execute$lambda$2(environment, arg_0);
            AnsiSqlMigrationSquasher ansiSquasher = new AnsiSqlMigrationSquasher((Function1<? super String, ? extends SqlFileBase>)fileFromText);
            MigrationSquasher squasher = environment.getDialect().migrationSquasher((MigrationSquasher)ansiSquasher);
            ansiSquasher.setSquasher$sqldelight_gradle_plugin(squasher);
            LinkedHashSet imports = new LinkedHashSet();
            Ref.ObjectRef newMigrations = new Ref.ObjectRef();
            newMigrations.element = fileFromText.invoke((Object)"");
            Ref.LongRef topVersion = new Ref.LongRef();
            Ref.ObjectRef migrationDirectory = new Ref.ObjectRef();
            environment.forMigrationFiles((Function1<? super MigrationFile, Unit>)((Function1)arg_0 -> GenerateMigration.execute$lambda$5(topVersion, migrationDirectory, imports, newMigrations, fileFromText, squasher, arg_0)));
            String text = ((SqlFileBase)newMigrations.element).getText();
            if (!((Collection)imports).isEmpty()) {
                text = StringsKt.trimMargin$default((String)("\n          |" + CollectionsKt.joinToString$default((Iterable)imports, (CharSequence)"\n", null, null, (int)0, null, GenerateMigration::execute$lambda$6, (int)30, null) + "\n          |\n          |" + text + "\n        "), null, (int)1, null);
            }
            if (migrationDirectory.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"migrationDirectory");
                file = null;
            } else {
                file = (File)migrationDirectory.element;
            }
            File file2 = new File(file, "_" + topVersion.element + ".sqm");
            String string = text;
            Intrinsics.checkNotNull((Object)string);
            FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
        }

        private static final SqlFileBase execute$lambda$2(SqlDelightEnvironment $environment, String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            PsiFile psiFile = PsiFileFactory.getInstance((Project)((Project)$environment.getProject())).createFileFromText((Language)MigrationLanguage.INSTANCE, (CharSequence)text);
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.alecstrong.sql.psi.core.SqlFileBase");
            return (SqlFileBase)psiFile;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit execute$lambda$5(Ref.LongRef $topVersion, Ref.ObjectRef $migrationDirectory, LinkedHashSet $imports, Ref.ObjectRef $newMigrations, Function1 $fileFromText, MigrationSquasher $squasher, MigrationFile migrationFile) {
            block7: {
                Object object;
                List migrations;
                List list;
                List list2;
                PsiElement[] psiElementArray;
                SqlStmtList sqlStmtList;
                Intrinsics.checkNotNullParameter((Object)migrationFile, (String)"migrationFile");
                if (migrationFile.getVersion() > $topVersion.element) {
                    $topVersion.element = migrationFile.getVersion();
                    VirtualFile virtualFile = migrationFile.getVirtualFile();
                    Intrinsics.checkNotNull((Object)virtualFile);
                    $migrationDirectory.element = new File(virtualFile.getParent().getPath());
                }
                if ((sqlStmtList = migrationFile.getSqlStmtList()) != null && (psiElementArray = sqlStmtList.getChildren()) != null) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterator $this$filterIsInstance$iv;
                    PsiElement[] psiElementArray2 = psiElementArray;
                    boolean $i$f$filterIsInstance = false;
                    void var13_14 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof SqlDelightImportStmtList)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list2 = (SqlDelightImportStmtList)CollectionsKt.single((List)((List)destination$iv$iv));
                } else {
                    list2 = null;
                }
                if ((list = (migrations = list2)) != null && (list = list.getImportStmtList()) != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlDelightImportStmt it = (SqlDelightImportStmt)element$iv;
                        boolean bl = false;
                        $imports.add(it.getJavaType().getText());
                    }
                }
                if ((object = migrationFile.getSqlStmtList()) == null || (object = object.getStmtList()) == null) break block7;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlStmt it = (SqlStmt)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    $newMigrations.element = $fileFromText.invoke((Object)$squasher.squish(it, (SqlFileBase)$newMigrations.element));
                }
            }
            return Unit.INSTANCE;
        }

        private static final CharSequence execute$lambda$6(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "import " + it + ";";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lapp/cash/sqldelight/gradle/squash/MigrationSquashTask$GenerateSchemaWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "moduleName", "Lorg/gradle/api/provider/Property;", "", "getModuleName", "()Lorg/gradle/api/provider/Property;", "properties", "Lapp/cash/sqldelight/core/SqlDelightDatabaseProperties;", "getProperties", "compilationUnit", "Lapp/cash/sqldelight/core/SqlDelightCompilationUnit;", "getCompilationUnit", "sqldelight-gradle-plugin"})
    public static interface GenerateSchemaWorkParameters
    extends WorkParameters {
        @NotNull
        public Property<String> getModuleName();

        @NotNull
        public Property<SqlDelightDatabaseProperties> getProperties();

        @NotNull
        public Property<SqlDelightCompilationUnit> getCompilationUnit();
    }
}

